/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.List;
import java.util.Map;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.OneOperandInstr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInstr
extends OneOperandInstr {
    Label[] labels;
    Operand[] variables;
    Label endLabel;
    Label elseLabel;

    public CaseInstr(Variable result, Operand arg2, Label endLabel) {
        super(Operation.CASE, result, arg2);
        this.endLabel = endLabel;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels.toArray(new Label[labels.size()]);
    }

    public void setVariables(List<Operand> variables) {
        this.variables = variables.toArray(new Operand[variables.size()]);
    }

    public void setElse(Label elseLabel) {
        this.elseLabel = elseLabel;
    }

    @Override
    public String toString() {
        return "\t" + this.result + " = CASE(" + this.argument + ", ELSE: " + this.elseLabel + ")";
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap) {
        super.simplifyOperands(valueMap);
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i] = this.variables[i].getSimplifiedOperand(valueMap);
        }
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        throw new RuntimeException("Not implemented yet!");
    }
}

