/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.dataflow.analyses;

import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jruby.compiler.ir.IRClosure;
import org.jruby.compiler.ir.IRExecutionScope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.dataflow.FlowGraphNode;
import org.jruby.compiler.ir.dataflow.analyses.BindingLoadPlacementProblem;
import org.jruby.compiler.ir.instructions.CallInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.LoadFromBindingInstr;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;
import org.jruby.compiler.ir.representations.CFG;

public class BindingLoadPlacementNode
extends FlowGraphNode {
    Set<Variable> _inReqdLoads;
    Set<Variable> _outReqdLoads;

    public BindingLoadPlacementNode(DataFlowProblem prob, BasicBlock n) {
        super(prob, n);
    }

    public void init() {
        this._inReqdLoads = new HashSet<Variable>();
        this._outReqdLoads = new HashSet<Variable>();
    }

    public void buildDataFlowVars(Instr i) {
        BindingLoadPlacementProblem blp = (BindingLoadPlacementProblem)this._prob;
        for (Variable v : i.getUsedVariables()) {
            if (!(v instanceof LocalVariable)) continue;
            blp.recordUsedVar(v);
        }
        Variable v = i.getResult();
        if (v != null && v instanceof LocalVariable) {
            blp.recordDefVar(v);
        }
    }

    public void initSolnForNode() {
        if (this._bb == this._prob.getCFG().getExitBB()) {
            this._inReqdLoads = ((BindingLoadPlacementProblem)this._prob).getLoadsOnScopeExit();
        }
    }

    public void compute_MEET(CFG.CFG_Edge edge, FlowGraphNode pred2) {
        BindingLoadPlacementNode n = (BindingLoadPlacementNode)pred2;
        this._inReqdLoads.addAll(n._outReqdLoads);
    }

    public boolean applyTransferFunction() {
        BindingLoadPlacementProblem blp = (BindingLoadPlacementProblem)this._prob;
        HashSet<Variable> reqdLoads = new HashSet<Variable>(this._inReqdLoads);
        List<Instr> instrs = this._bb.getInstrs();
        ListIterator<Instr> it = instrs.listIterator(instrs.size());
        while (it.hasPrevious()) {
            Instr i = it.previous();
            if (i.operation == Operation.BINDING_STORE) continue;
            Variable r = i.getResult();
            if (r != null) {
                reqdLoads.remove(r);
            }
            if (i instanceof CallInstr) {
                CallInstr call2 = (CallInstr)i;
                Operand o = call2.getClosureArg();
                if (o != null && o instanceof MetaObject) {
                    IRClosure cl = (IRClosure)((MetaObject)o).scope;
                    CFG cl_cfg = cl.getCFG();
                    BindingLoadPlacementProblem cl_blp = new BindingLoadPlacementProblem();
                    cl_blp.initLoadsOnScopeExit(reqdLoads);
                    cl_blp.setup(cl_cfg);
                    cl_blp.compute_MOP_Solution();
                    cl_cfg.setDataFlowSolution(cl_blp.getName(), cl_blp);
                    if (call2.requiresBinding()) {
                        reqdLoads.clear();
                    }
                    HashSet<Variable> newReqdLoads = new HashSet<Variable>(reqdLoads);
                    for (Variable v : reqdLoads) {
                        if (!cl_blp.scopeDefinesVariable(v)) continue;
                        newReqdLoads.remove(v);
                    }
                    reqdLoads = newReqdLoads;
                } else if (call2.requiresBinding()) {
                    reqdLoads.clear();
                }
            }
            for (Variable x : i.getUsedVariables()) {
                if (!(x instanceof LocalVariable)) continue;
                reqdLoads.add(x);
            }
        }
        if (this._bb == this._prob.getCFG().getEntryBB()) {
            reqdLoads.clear();
        }
        if (((Object)this._outReqdLoads).equals(reqdLoads)) {
            return false;
        }
        this._outReqdLoads = reqdLoads;
        return true;
    }

    public String toString() {
        return "";
    }

    public void addLoads() {
        BindingLoadPlacementProblem blp = (BindingLoadPlacementProblem)this._prob;
        IRExecutionScope s = blp.getCFG().getScope();
        List<Instr> instrs = this._bb.getInstrs();
        ListIterator<Instr> it = instrs.listIterator(instrs.size());
        HashSet<Variable> reqdLoads = new HashSet<Variable>(this._inReqdLoads);
        while (it.hasPrevious()) {
            Instr i = it.previous();
            if (i.operation == Operation.BINDING_STORE) continue;
            Variable r = i.getResult();
            if (r != null) {
                reqdLoads.remove(r);
            }
            if (i instanceof CallInstr) {
                CallInstr call2 = (CallInstr)i;
                Operand o = call2.getClosureArg();
                if (o != null && o instanceof MetaObject) {
                    CFG cl_cfg = ((IRClosure)((MetaObject)o).scope).getCFG();
                    BindingLoadPlacementProblem cl_blp = (BindingLoadPlacementProblem)cl_cfg.getDataFlowSolution(blp.getName());
                    HashSet<Variable> newReqdLoads = new HashSet<Variable>(reqdLoads);
                    it.next();
                    for (Variable v : reqdLoads) {
                        if (!cl_blp.scopeDefinesVariable(v)) continue;
                        it.add(new LoadFromBindingInstr(v, s, v.getName()));
                        it.previous();
                        newReqdLoads.remove(v);
                    }
                    it.previous();
                    reqdLoads = newReqdLoads;
                    ((BindingLoadPlacementProblem)cl_cfg.getDataFlowSolution(blp.getName())).addLoads();
                } else if (call2.requiresBinding()) {
                    it.next();
                    for (Variable v : reqdLoads) {
                        it.add(new LoadFromBindingInstr(v, s, v.getName()));
                        it.previous();
                    }
                    it.previous();
                    reqdLoads.clear();
                }
            }
            for (Variable x : i.getUsedVariables()) {
                if (!(x instanceof LocalVariable)) continue;
                reqdLoads.add(x);
            }
        }
        if (s instanceof IRClosure && this._bb == this._prob.getCFG().getEntryBB()) {
            for (Variable v : reqdLoads) {
                if (!blp.scopeUsesVariable(v)) continue;
                it.add(new LoadFromBindingInstr(v, s, v.getName()));
            }
        }
    }
}

