/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewlineNode
extends Node {
    private final Node nextNode;

    public NewlineNode(ISourcePosition position, Node nextNode) {
        super(position);
        assert (nextNode != null) : "nextNode is not null";
        this.nextNode = nextNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.NEWLINENODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitNewlineNode(this);
    }

    public Node getNextNode() {
        return this.nextNode;
    }

    @Override
    public List<Node> childNodes() {
        return NewlineNode.createList(this.nextNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        ISourcePosition position = this.getPosition();
        context.setFileAndLine(position);
        if (runtime2.hasEventHooks()) {
            ASTInterpreter.callTraceFunction(runtime2, context, RubyEvent.LINE);
        }
        return this.nextNode.interpret(runtime2, context, self, aBlock);
    }

    @Override
    public String definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return this.nextNode.definition(runtime2, context, self, aBlock);
    }
}

