/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.ast.DNode;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class DRegexpNode
extends DNode
implements ILiteralNode {
    private final int options;
    private final boolean once;
    private RubyRegexp onceRegexp;
    private boolean is19;

    public DRegexpNode(ISourcePosition position, int options2, boolean once) {
        this(position, options2, once, false);
    }

    public DRegexpNode(ISourcePosition position, int options2, boolean once, boolean is19) {
        super(position, (Encoding)null);
        this.once = once;
        this.options = options2;
        this.is19 = is19;
    }

    public NodeType getNodeType() {
        return NodeType.DREGEXPNODE;
    }

    protected RubyString allocateString(Ruby runtime2) {
        return runtime2.newString(new ByteList());
    }

    public boolean is19() {
        return this.is19;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitDRegxNode(this);
    }

    public boolean getOnce() {
        return this.once;
    }

    public int getOptions() {
        return this.options;
    }

    public RubyRegexp getOnceRegexp() {
        return this.onceRegexp;
    }

    public void setOnceRegexp(RubyRegexp regexp2) {
        if (this.once && this.onceRegexp == null) {
            this.onceRegexp = regexp2;
        }
    }

    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.once && this.onceRegexp != null) {
            return this.onceRegexp;
        }
        RubyString string2 = (RubyString)super.interpret(runtime2, context, self, aBlock);
        RubyRegexp regexp2 = RubyRegexp.newDRegexp(runtime2, string2, this.options);
        if (this.once) {
            this.setOnceRegexp(regexp2);
        }
        return regexp2;
    }
}

