/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.addons.IOJavaAddons;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.Stream;

@JRubyClass(name={"StringIO"})
public class RubyStringIO
extends RubyObject {
    StringIOData data = new StringIOData();
    private static ObjectAllocator STRINGIO_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyStringIO(runtime2, klass);
        }
    };
    public static final ByteList NEWLINE = ByteList.create("\n");

    public static RubyClass createStringIOClass(Ruby runtime2) {
        RubyClass stringIOClass = runtime2.defineClass("StringIO", runtime2.fastGetClass("Data"), STRINGIO_ALLOCATOR);
        stringIOClass.defineAnnotatedMethods(RubyStringIO.class);
        stringIOClass.includeModule(runtime2.getEnumerable());
        if (runtime2.getObject().isConstantDefined("Java")) {
            stringIOClass.defineAnnotatedMethods(IOJavaAddons.AnyIO.class);
        }
        return stringIOClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(optional=2, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyStringIO strio;
        IRubyObject val = strio = (RubyStringIO)((RubyClass)recv2).newInstance(context, args2, Block.NULL_BLOCK);
        if (block.isGiven()) {
            try {
                val = block.yield(context, strio);
                Object var7_6 = null;
                strio.doFinalize();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                strio.doFinalize();
                throw throwable;
            }
        }
        return val;
    }

    protected RubyStringIO(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    private void initializeModes(Object modeArgument) {
        try {
            this.data.modes = modeArgument == null ? new ModeFlags(RubyIO.getIOModesIntFromString(this.getRuntime(), "r+")) : (modeArgument instanceof Long ? new ModeFlags((Long)modeArgument) : new ModeFlags(RubyIO.getIOModesIntFromString(this.getRuntime(), (String)modeArgument)));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.setupModes();
    }

    @JRubyMethod(optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block unusedBlock) {
        Object modeArgument = null;
        switch (args2.length) {
            case 0: {
                this.data.internal = RubyString.newEmptyString(this.getRuntime());
                modeArgument = "r+";
                break;
            }
            case 1: {
                this.data.internal = args2[0].convertToString();
                modeArgument = this.data.internal.isFrozen() ? "r" : "r+";
                break;
            }
            case 2: {
                this.data.internal = args2[0].convertToString();
                modeArgument = args2[1] instanceof RubyFixnum ? Long.valueOf(RubyFixnum.fix2long(args2[1])) : args2[1].convertToString().toString();
            }
        }
        this.initializeModes(modeArgument);
        if (this.data.modes.isWritable() && this.data.internal.isFrozen()) {
            throw this.getRuntime().newErrnoEACCESError("Permission denied");
        }
        if (this.data.modes.isTruncate()) {
            this.data.internal.modifyCheck();
            this.data.internal.empty();
        }
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject other) {
        RubyStringIO otherIO = (RubyStringIO)TypeConverter.convertToType(other, this.getRuntime().fastGetClass("StringIO"), "to_strio");
        if (this == otherIO) {
            return this;
        }
        this.data = otherIO.data;
        if (otherIO.isTaint()) {
            this.setTaint(true);
        }
        return this;
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject append(ThreadContext context, IRubyObject arg2) {
        this.writeInternal(context, arg2);
        return this;
    }

    @JRubyMethod
    public IRubyObject binmode() {
        return this;
    }

    @JRubyMethod
    public IRubyObject close() {
        this.checkInitialized();
        this.checkOpen();
        this.data.closedRead = true;
        this.data.closedWrite = true;
        return this.getRuntime().getNil();
    }

    private void doFinalize() {
        this.data.closedRead = true;
        this.data.closedWrite = true;
        this.data.internal = null;
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject closed_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.data.closedRead && this.data.closedWrite);
    }

    @JRubyMethod
    public IRubyObject close_read() {
        this.checkReadable();
        this.data.closedRead = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"closed_read?"})
    public IRubyObject closed_read_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.data.closedRead);
    }

    @JRubyMethod
    public IRubyObject close_write() {
        this.checkWritable();
        this.data.closedWrite = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"closed_write?"})
    public IRubyObject closed_write_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.data.closedWrite);
    }

    public IRubyObject eachInternal(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject line = this.getsOnly(context, args2);
        while (!line.isNil()) {
            block.yield(context, line);
            line = this.getsOnly(context, args2);
        }
        return this;
    }

    @JRubyMethod(name={"each"}, optional=1, writes={FrameField.LASTLINE})
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? this.eachInternal(context, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "each", args2);
    }

    @JRubyMethod(optional=1)
    public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? this.eachInternal(context, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "each_line", args2);
    }

    @JRubyMethod(optional=1)
    public IRubyObject lines(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? this.each(context, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "lines", args2);
    }

    public IRubyObject each_byte(ThreadContext context, Block block) {
        this.checkReadable();
        Ruby runtime2 = context.getRuntime();
        ByteList bytes2 = this.data.internal.getByteList();
        while (this.data.pos < (long)bytes2.length()) {
            block.yield(context, runtime2.newFixnum(bytes2.get((int)this.data.pos++) & 0xFF));
        }
        return this;
    }

    @JRubyMethod(name={"each_byte"})
    public IRubyObject each_byte19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_byte(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_byte");
    }

    @JRubyMethod
    public IRubyObject bytes(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_byte(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "bytes");
    }

    public IRubyObject each_charInternal(ThreadContext context, Block block) {
        this.checkReadable();
        Ruby runtime2 = context.getRuntime();
        ByteList bytes2 = this.data.internal.getByteList();
        int len = bytes2.getRealSize();
        while (this.data.pos < (long)len) {
            int pos2 = (int)this.data.pos;
            byte c = bytes2.getUnsafeBytes()[bytes2.getBegin() + pos2];
            int n = runtime2.getKCode().getEncoding().length(c);
            if (len < pos2 + n) {
                n = len - pos2;
            }
            this.data.pos += (long)n;
            block.yield(context, this.data.internal.substr19(runtime2, pos2, n));
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_char(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charInternal(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_char");
    }

    @JRubyMethod
    public IRubyObject chars(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charInternal(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "chars");
    }

    @JRubyMethod(name={"eof", "eof?"})
    public IRubyObject eof() {
        return this.getRuntime().newBoolean(this.isEOF());
    }

    private boolean isEOF() {
        return this.data.pos >= (long)this.data.internal.getByteList().length() || this.data.eof;
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl() {
        throw this.getRuntime().newNotImplementedError("fcntl not implemented");
    }

    @JRubyMethod(name={"fileno"})
    public IRubyObject fileno() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"flush"})
    public IRubyObject flush() {
        return this;
    }

    @JRubyMethod(name={"fsync"})
    public IRubyObject fsync() {
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"getc", "getbyte"})
    public IRubyObject getc() {
        this.checkReadable();
        if (this.data.pos >= (long)this.data.internal.getByteList().length()) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.data.internal.getByteList().get((int)this.data.pos++) & 0xFF);
    }

    private IRubyObject internalGets(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (this.data.pos < (long)this.data.internal.getByteList().getRealSize() && !this.data.eof) {
            ByteList add3;
            int ix;
            ByteList sep;
            boolean isParagraph = false;
            if (args2.length > 0) {
                if (args2[0].isNil()) {
                    ByteList buf = this.data.internal.getByteList().makeShared((int)this.data.pos, this.data.internal.getByteList().getRealSize() - (int)this.data.pos);
                    this.data.pos += (long)buf.getRealSize();
                    return RubyString.newString(runtime2, buf);
                }
                sep = args2[0].convertToString().getByteList();
                if (sep.getRealSize() == 0) {
                    isParagraph = true;
                    sep = Stream.PARAGRAPH_SEPARATOR;
                }
            } else {
                sep = ((RubyString)runtime2.getGlobalVariables().get("$/")).getByteList();
            }
            ByteList ss = this.data.internal.getByteList();
            if (isParagraph) {
                this.swallowLF(ss);
                if (this.data.pos == (long)ss.getRealSize()) {
                    return runtime2.getNil();
                }
            }
            if (-1 == (ix = ss.indexOf(sep, (int)this.data.pos))) {
                ix = this.data.internal.getByteList().getRealSize();
                add3 = ByteList.EMPTY_BYTELIST;
            } else {
                add3 = sep;
            }
            ByteList line = new ByteList(ix - (int)this.data.pos + add3.length());
            line.append(this.data.internal.getByteList(), (int)this.data.pos, ix - (int)this.data.pos);
            line.append(add3);
            this.data.pos = ix + add3.getRealSize();
            ++this.data.lineno;
            return RubyString.newString(runtime2, line);
        }
        return runtime2.getNil();
    }

    private void swallowLF(ByteList list2) {
        while (this.data.pos < (long)list2.getRealSize() && list2.get((int)this.data.pos) == 10) {
            ++this.data.pos;
        }
    }

    @JRubyMethod(name={"gets"}, optional=1, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext context, IRubyObject[] args2) {
        IRubyObject result = this.getsOnly(context, args2);
        context.getCurrentScope().setLastLine(result);
        return result;
    }

    public IRubyObject getsOnly(ThreadContext context, IRubyObject[] args2) {
        this.checkReadable();
        return this.internalGets(context, args2);
    }

    @JRubyMethod(name={"tty?", "isatty"})
    public IRubyObject isatty() {
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"length", "size"})
    public IRubyObject length() {
        this.checkFinalized();
        return this.getRuntime().newFixnum(this.data.internal.getByteList().length());
    }

    @JRubyMethod(name={"lineno"})
    public IRubyObject lineno() {
        return this.getRuntime().newFixnum(this.data.lineno);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public IRubyObject set_lineno(IRubyObject arg2) {
        this.data.lineno = RubyNumeric.fix2int(arg2);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"path"})
    public IRubyObject path() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pid"})
    public IRubyObject pid() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pos", "tell"})
    public IRubyObject pos() {
        return this.getRuntime().newFixnum(this.data.pos);
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject arg2) {
        this.data.pos = RubyNumeric.fix2int(arg2);
        if (this.data.pos < 0L) {
            throw this.getRuntime().newErrnoEINVALError("Invalid argument");
        }
        if (this.data.pos < (long)this.data.internal.getByteList().length()) {
            this.data.eof = false;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"print"}, rest=true)
    public IRubyObject print(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (args2.length != 0) {
            int j = args2.length;
            for (int i = 0; i < j; ++i) {
                this.append(context, args2[i]);
            }
        } else {
            IRubyObject arg2 = runtime2.getGlobalVariables().get("$_");
            this.append(context, arg2.isNil() ? runtime2.newString("nil") : arg2);
        }
        IRubyObject sep = runtime2.getGlobalVariables().get("$\\");
        if (!sep.isNil()) {
            this.append(context, sep);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args2) {
        this.append(context, RubyKernel.sprintf(context, this, args2));
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"putc"}, required=1)
    public IRubyObject putc(IRubyObject obj) {
        this.checkWritable();
        byte c = RubyNumeric.num2chr(obj);
        this.checkFrozen();
        this.data.internal.modify();
        ByteList bytes2 = this.data.internal.getByteList();
        if (this.data.modes.isAppendable()) {
            this.data.pos = bytes2.length();
            bytes2.append(c);
        } else {
            if (this.data.pos >= (long)bytes2.length()) {
                bytes2.length((int)this.data.pos + 1);
            }
            bytes2.set((int)this.data.pos, c);
            ++this.data.pos;
        }
        return obj;
    }

    /*
     * Enabled aggressive block sorting
     */
    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
        this.checkWritable();
        if (args2.length == 0) {
            this.callMethod(context, "write", (IRubyObject)RubyString.newStringShared(this.getRuntime(), NEWLINE));
            return this.getRuntime().getNil();
        }
        int i = 0;
        while (true) {
            block8: {
                RubyString line;
                block5: {
                    block6: {
                        RubyArray arr;
                        block7: {
                            block4: {
                                if (i >= args2.length) {
                                    return this.getRuntime().getNil();
                                }
                                if (!args2[i].isNil()) break block4;
                                line = this.getRuntime().newString("nil");
                                break block5;
                            }
                            IRubyObject tmp = args2[i].checkArrayType();
                            if (tmp.isNil()) break block6;
                            arr = (RubyArray)tmp;
                            if (!this.getRuntime().isInspecting(arr)) break block7;
                            line = this.getRuntime().newString("[...]");
                            break block5;
                        }
                        this.inspectPuts(context, arr);
                        break block8;
                    }
                    line = args2[i] instanceof RubyString ? (RubyString)args2[i] : args2[i].asString();
                }
                this.callMethod(context, "write", (IRubyObject)line);
                if (!line.getByteList().endsWith(NEWLINE)) {
                    this.callMethod(context, "write", (IRubyObject)RubyString.newStringShared(this.getRuntime(), NEWLINE));
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject inspectPuts(ThreadContext context, RubyArray array) {
        try {
            this.getRuntime().registerInspecting(array);
            IRubyObject iRubyObject = this.puts(context, array.toJavaArray());
            Object var5_4 = null;
            this.getRuntime().unregisterInspecting(array);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.getRuntime().unregisterInspecting(array);
            throw throwable;
        }
    }

    @JRubyMethod(name={"read"}, optional=2)
    public IRubyObject read(IRubyObject[] args2) {
        this.checkReadable();
        ByteList buf = null;
        int length2 = 0;
        int oldLength = 0;
        RubyString originalString = null;
        switch (args2.length) {
            case 2: {
                originalString = args2[1].convertToString();
                originalString.modify();
                buf = originalString.getByteList();
            }
            case 1: {
                if (!args2[0].isNil()) {
                    oldLength = length2 = RubyNumeric.fix2int(args2[0]);
                    if (length2 < 0) {
                        throw this.getRuntime().newArgumentError("negative length " + length2 + " given");
                    }
                    if (length2 > 0 && this.data.pos >= (long)this.data.internal.getByteList().length()) {
                        this.data.eof = true;
                        if (buf != null) {
                            buf.setRealSize(0);
                        }
                        return this.getRuntime().getNil();
                    }
                    if (!this.data.eof) break;
                    if (buf != null) {
                        buf.setRealSize(0);
                    }
                    return this.getRuntime().getNil();
                }
            }
            case 0: {
                oldLength = -1;
                length2 = this.data.internal.getByteList().length();
                if ((long)length2 <= this.data.pos) {
                    this.data.eof = true;
                    if (buf == null) {
                        buf = new ByteList();
                    } else {
                        buf.setRealSize(0);
                    }
                    return this.getRuntime().newString(buf);
                }
                length2 = (int)((long)length2 - this.data.pos);
                break;
            }
            default: {
                this.getRuntime().newArgumentError(args2.length, 0);
            }
        }
        if (buf == null) {
            int internalLength = this.data.internal.getByteList().length();
            if (internalLength > 0) {
                if ((long)internalLength >= this.data.pos + (long)length2) {
                    buf = new ByteList(this.data.internal.getByteList(), (int)this.data.pos, length2);
                } else {
                    int rest2 = (int)((long)this.data.internal.getByteList().length() - this.data.pos);
                    if (length2 > rest2) {
                        length2 = rest2;
                    }
                    buf = new ByteList(this.data.internal.getByteList(), (int)this.data.pos, length2);
                }
            }
        } else {
            byte[] target;
            int rest3 = (int)((long)this.data.internal.getByteList().length() - this.data.pos);
            if (length2 > rest3) {
                length2 = rest3;
            }
            if ((target = buf.getUnsafeBytes()).length > length2) {
                System.arraycopy(this.data.internal.getByteList().getUnsafeBytes(), (int)this.data.pos, target, 0, length2);
                buf.setBegin(0);
                buf.setRealSize(length2);
            } else {
                target = new byte[length2];
                System.arraycopy(this.data.internal.getByteList().getUnsafeBytes(), (int)this.data.pos, target, 0, length2);
                buf.setBegin(0);
                buf.setRealSize(length2);
                buf.setUnsafeBytes(target);
            }
        }
        if (buf == null) {
            if (!this.data.eof) {
                buf = new ByteList();
            }
            length2 = 0;
        } else {
            length2 = buf.length();
            this.data.pos += (long)length2;
        }
        if (oldLength < 0 || oldLength > length2) {
            this.data.eof = true;
        }
        return originalString != null ? originalString : this.getRuntime().newString(buf);
    }

    @JRubyMethod(name={"readchar", "readbyte"})
    public IRubyObject readchar() {
        IRubyObject c = this.getc();
        if (c.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod(name={"readline"}, optional=1, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context, IRubyObject[] args2) {
        IRubyObject line = this.gets(context, args2);
        if (line.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readlines"}, optional=1)
    public IRubyObject readlines(ThreadContext context, IRubyObject[] arg2) {
        IRubyObject line;
        this.checkReadable();
        ArrayList<IRubyObject> lns = new ArrayList<IRubyObject>();
        while (!this.isEOF() && !(line = this.internalGets(context, arg2)).isNil()) {
            lns.add(line);
        }
        return this.getRuntime().newArray(lns);
    }

    @JRubyMethod(name={"reopen"}, required=0, optional=2)
    public IRubyObject reopen(IRubyObject[] args2) {
        if (args2.length == 1 && !(args2[0] instanceof RubyString)) {
            return this.initialize_copy(args2[0]);
        }
        this.doRewind();
        this.data.closedRead = false;
        this.data.closedWrite = false;
        return this.initialize(args2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind() {
        this.doRewind();
        return RubyFixnum.zero(this.getRuntime());
    }

    private void doRewind() {
        this.data.pos = 0L;
        this.data.eof = false;
        this.data.lineno = 0;
    }

    @JRubyMethod(required=1, optional=1)
    public IRubyObject seek(IRubyObject[] args2) {
        this.checkOpen();
        this.checkFinalized();
        long amount = RubyNumeric.num2long(args2[0]);
        int whence = 0;
        long newPosition = this.data.pos;
        if (args2.length > 1 && !args2[0].isNil()) {
            whence = RubyNumeric.fix2int(args2[1]);
        }
        if (whence == 1) {
            newPosition += amount;
        } else if (whence == 2) {
            newPosition = (long)this.data.internal.getByteList().length() + amount;
        } else if (whence == 0) {
            newPosition = amount;
        } else {
            throw this.getRuntime().newErrnoEINVALError("invalid whence");
        }
        if (newPosition < 0L) {
            throw this.getRuntime().newErrnoEINVALError("invalid seek value");
        }
        this.data.pos = newPosition;
        this.data.eof = false;
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"string="}, required=1)
    public IRubyObject set_string(IRubyObject arg2) {
        return this.reopen(new IRubyObject[]{arg2.convertToString()});
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject set_sync(IRubyObject args2) {
        return args2;
    }

    @JRubyMethod(name={"string"})
    public IRubyObject string() {
        if (this.data.internal == null) {
            return this.getRuntime().getNil();
        }
        return this.data.internal;
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"sysread"}, optional=2)
    public IRubyObject sysread(IRubyObject[] args2) {
        IRubyObject obj = this.read(args2);
        if (this.isEOF() && obj.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return obj;
    }

    @JRubyMethod(name={"truncate"}, required=1)
    public IRubyObject truncate(IRubyObject arg2) {
        this.checkWritable();
        int len = RubyFixnum.fix2int(arg2);
        if (len < 0) {
            throw this.getRuntime().newErrnoEINVALError("negative legnth");
        }
        this.data.internal.modify();
        ByteList buf = this.data.internal.getByteList();
        if (len < buf.length()) {
            Arrays.fill(buf.getUnsafeBytes(), len, buf.length(), (byte)0);
        }
        buf.length(len);
        return arg2;
    }

    @JRubyMethod(name={"ungetc"}, required=1)
    public IRubyObject ungetc(IRubyObject arg2) {
        this.checkReadable();
        int c = RubyNumeric.num2int(arg2);
        if (this.data.pos == 0L) {
            return this.getRuntime().getNil();
        }
        this.data.internal.modify();
        --this.data.pos;
        ByteList bytes2 = this.data.internal.getByteList();
        if ((long)bytes2.length() <= this.data.pos) {
            bytes2.length((int)this.data.pos + 1);
        }
        bytes2.set((int)this.data.pos, c);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"write", "syswrite"}, required=1)
    public IRubyObject write(ThreadContext context, IRubyObject arg2) {
        return context.getRuntime().newFixnum(this.writeInternal(context, arg2));
    }

    private int writeInternal(ThreadContext context, IRubyObject arg2) {
        this.checkWritable();
        this.checkFrozen();
        RubyString val = arg2.asString();
        this.data.internal.modify();
        if (this.data.modes.isAppendable()) {
            this.data.internal.getByteList().append(val.getByteList());
            this.data.pos = this.data.internal.getByteList().length();
        } else {
            int left = this.data.internal.getByteList().length() - (int)this.data.pos;
            this.data.internal.getByteList().replace((int)this.data.pos, Math.min(val.getByteList().length(), left), val.getByteList());
            this.data.pos += (long)val.getByteList().length();
        }
        if (val.isTaint()) {
            this.data.internal.setTaint(true);
        }
        return val.getByteList().length();
    }

    protected void checkFrozen() {
        this.checkInitialized();
        if (this.data.internal.isFrozen()) {
            throw this.getRuntime().newIOError("not modifiable string");
        }
    }

    private void checkReadable() {
        this.checkInitialized();
        if (this.data.closedRead || !this.data.modes.isReadable()) {
            throw this.getRuntime().newIOError("not opened for reading");
        }
    }

    private void checkWritable() {
        this.checkInitialized();
        if (this.data.closedWrite || !this.data.modes.isWritable()) {
            throw this.getRuntime().newIOError("not opened for writing");
        }
    }

    private void checkInitialized() {
        if (this.data.modes == null) {
            throw this.getRuntime().newIOError("uninitialized stream");
        }
    }

    private void checkFinalized() {
        if (this.data.internal == null) {
            throw this.getRuntime().newIOError("not opened");
        }
    }

    private void checkOpen() {
        if (this.data.closedRead && this.data.closedWrite) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    private void setupModes() {
        this.data.closedWrite = false;
        this.data.closedRead = false;
        if (this.data.modes.isReadOnly()) {
            this.data.closedWrite = true;
        }
        if (!this.data.modes.isReadable()) {
            this.data.closedRead = true;
        }
    }

    static class StringIOData {
        long pos = 0L;
        int lineno = 0;
        boolean eof = false;
        boolean closedRead = false;
        boolean closedWrite = false;
        ModeFlags modes;
        RubyString internal;

        StringIOData() {
        }
    }
}

