/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.RubyThread;
import org.jruby.RubyThreadGroup;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyRunnable
implements Runnable {
    private Ruby runtime;
    private RubyProc proc;
    private IRubyObject[] arguments;
    private RubyThread rubyThread;
    private Frame[] currentFrames;
    private Thread javaThread;
    private static boolean warnedAboutTC = false;

    public RubyRunnable(RubyThread rubyThread, IRubyObject[] args2, Frame[] frames, Block currentBlock) {
        this.rubyThread = rubyThread;
        this.runtime = rubyThread.getRuntime();
        this.proc = this.runtime.newProc(Block.Type.THREAD, currentBlock);
        this.currentFrames = frames;
        this.arguments = args2;
    }

    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    public Thread getJavaThread() {
        return this.javaThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block21: {
            ClassLoader oldContextClassLoader;
            ThreadContext context;
            block20: {
                this.javaThread = Thread.currentThread();
                context = this.runtime.getThreadService().registerNewThread(this.rubyThread);
                oldContextClassLoader = null;
                try {
                    oldContextClassLoader = this.javaThread.getContextClassLoader();
                    this.javaThread.setContextClassLoader(this.runtime.getJRubyClassLoader());
                }
                catch (SecurityException se) {
                    if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block20;
                    System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                }
            }
            context.preRunThread(this.currentFrames);
            try {
                IRubyObject result = this.proc.call(context, this.arguments);
                this.rubyThread.cleanTerminate(result);
                Object var5_9 = null;
                this.rubyThread.beDead();
                this.runtime.getThreadService().setCritical(false);
                this.runtime.getThreadService().unregisterThread(this.rubyThread);
                ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                try {
                    this.javaThread.setContextClassLoader(oldContextClassLoader);
                }
                catch (SecurityException se) {
                    if (!warnedAboutTC && this.runtime.getInstanceConfig().isVerbose()) {
                        System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                    }
                    break block21;
                }
                {
                    catch (JumpException.ReturnJump rj) {
                        this.rubyThread.exceptionRaised(this.runtime.newThreadError("return can't jump across threads"));
                        Object var5_10 = null;
                        this.rubyThread.beDead();
                        this.runtime.getThreadService().setCritical(false);
                        this.runtime.getThreadService().unregisterThread(this.rubyThread);
                        ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                        try {
                            this.javaThread.setContextClassLoader(oldContextClassLoader);
                        }
                        catch (SecurityException se) {
                            if (!warnedAboutTC && this.runtime.getInstanceConfig().isVerbose()) {
                                System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                            }
                            break block21;
                        }
                    }
                    catch (RaiseException e) {
                        this.rubyThread.exceptionRaised(e);
                        Object var5_11 = null;
                        this.rubyThread.beDead();
                        this.runtime.getThreadService().setCritical(false);
                        this.runtime.getThreadService().unregisterThread(this.rubyThread);
                        ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                        try {
                            this.javaThread.setContextClassLoader(oldContextClassLoader);
                        }
                        catch (SecurityException se) {
                            if (!warnedAboutTC && this.runtime.getInstanceConfig().isVerbose()) {
                                System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                            }
                            break block21;
                        }
                    }
                    catch (MainExitException mee) {
                        this.runtime.getThreadService().getMainThread().kill();
                        Object var5_12 = null;
                        this.rubyThread.beDead();
                        this.runtime.getThreadService().setCritical(false);
                        this.runtime.getThreadService().unregisterThread(this.rubyThread);
                        ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                        try {
                            this.javaThread.setContextClassLoader(oldContextClassLoader);
                        }
                        catch (SecurityException se) {
                            if (!warnedAboutTC && this.runtime.getInstanceConfig().isVerbose()) {
                                System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                            }
                            break block21;
                        }
                    }
                }
                catch (Throwable throwable) {
                    block22: {
                        Object var5_13 = null;
                        this.rubyThread.beDead();
                        this.runtime.getThreadService().setCritical(false);
                        this.runtime.getThreadService().unregisterThread(this.rubyThread);
                        ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                        try {
                            this.javaThread.setContextClassLoader(oldContextClassLoader);
                        }
                        catch (SecurityException se) {
                            if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block22;
                            System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                        }
                    }
                    throw throwable;
                }
            }
            catch (ThreadKill threadKill) {
                // empty catch block
            }
        }
    }
}

