/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import org.jruby.CompatVersion;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNoArgNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPreOneArgNode;
import org.jruby.ast.ArgsPreTwoArgNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.AttrAssignOneArgNode;
import org.jruby.ast.AttrAssignThreeArgNode;
import org.jruby.ast.AttrAssignTwoArgNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.BlockArg18Node;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.CallManyArgsBlockNode;
import org.jruby.ast.CallManyArgsBlockPassNode;
import org.jruby.ast.CallManyArgsNode;
import org.jruby.ast.CallNoArgBlockNode;
import org.jruby.ast.CallNoArgBlockPassNode;
import org.jruby.ast.CallNoArgNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CallOneArgBlockNode;
import org.jruby.ast.CallOneArgBlockPassNode;
import org.jruby.ast.CallOneArgFixnumNode;
import org.jruby.ast.CallOneArgNode;
import org.jruby.ast.CallSpecialArgBlockNode;
import org.jruby.ast.CallSpecialArgBlockPassNode;
import org.jruby.ast.CallSpecialArgNode;
import org.jruby.ast.CallThreeArgBlockNode;
import org.jruby.ast.CallThreeArgBlockPassNode;
import org.jruby.ast.CallThreeArgNode;
import org.jruby.ast.CallTwoArgBlockNode;
import org.jruby.ast.CallTwoArgBlockPassNode;
import org.jruby.ast.CallTwoArgNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2ConstNode;
import org.jruby.ast.Colon2ImplicitNode;
import org.jruby.ast.Colon2MethodNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EncodingNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallManyArgsBlockNode;
import org.jruby.ast.FCallManyArgsBlockPassNode;
import org.jruby.ast.FCallManyArgsNode;
import org.jruby.ast.FCallNoArgBlockNode;
import org.jruby.ast.FCallNoArgBlockPassNode;
import org.jruby.ast.FCallNoArgNode;
import org.jruby.ast.FCallOneArgBlockNode;
import org.jruby.ast.FCallOneArgBlockPassNode;
import org.jruby.ast.FCallOneArgNode;
import org.jruby.ast.FCallSpecialArgBlockNode;
import org.jruby.ast.FCallSpecialArgBlockPassNode;
import org.jruby.ast.FCallSpecialArgNode;
import org.jruby.ast.FCallThreeArgBlockNode;
import org.jruby.ast.FCallThreeArgBlockPassNode;
import org.jruby.ast.FCallThreeArgNode;
import org.jruby.ast.FCallTwoArgBlockNode;
import org.jruby.ast.FCallTwoArgBlockPassNode;
import org.jruby.ast.FCallTwoArgNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FileNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OpElementOneArgAndAsgnNode;
import org.jruby.ast.OpElementOneArgAsgnNode;
import org.jruby.ast.OpElementOneArgOrAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhenOneArgNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.YieldOneNode;
import org.jruby.ast.YieldThreeNode;
import org.jruby.ast.YieldTwoNode;
import org.jruby.ast.ZYieldNode;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.types.INameNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.RubyParserResult;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.util.ByteList;
import org.jruby.util.IdUtil;

public class ParserSupport {
    protected StaticScope currentScope;
    protected RubyYaccLexer lexer;
    private int inSingleton;
    private boolean inDefinition;
    protected IRubyWarnings warnings;
    private ParserConfiguration configuration;
    private RubyParserResult result;

    public void reset() {
        this.inSingleton = 0;
        this.inDefinition = false;
    }

    public void allowDubyExtension(ISourcePosition position) {
        if (!this.configuration.isDubyExtensionsEnabled()) {
            throw new SyntaxException(SyntaxException.PID.DUBY_EXTENSIONS_OFF, position, this.lexer.getCurrentLine(), "Duby extensions not configured", new Object[0]);
        }
    }

    public StaticScope getCurrentScope() {
        return this.currentScope;
    }

    public ParserConfiguration getConfiguration() {
        return this.configuration;
    }

    public void popCurrentScope() {
        this.currentScope = this.currentScope.getEnclosingScope();
    }

    public void pushBlockScope() {
        this.currentScope = new BlockStaticScope(this.currentScope);
    }

    public void pushLocalScope() {
        this.currentScope = new LocalStaticScope(this.currentScope);
    }

    public Node arg_concat(ISourcePosition position, Node node1, Node node2) {
        return node2 == null ? node1 : new ArgsCatNode(position, node1, node2);
    }

    public Node arg_blk_pass(Node firstNode, BlockPassNode secondNode) {
        if (secondNode != null) {
            secondNode.setArgsNode(firstNode);
            return secondNode;
        }
        return firstNode;
    }

    public Node gettable2(Node node) {
        switch (node.getNodeType()) {
            case DASGNNODE: 
            case LOCALASGNNODE: {
                return this.currentScope.declare(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case CONSTDECLNODE: {
                return new ConstNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case INSTASGNNODE: {
                return new InstVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case CLASSVARDECLNODE: 
            case CLASSVARASGNNODE: {
                return new ClassVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case GLOBALASGNNODE: {
                return new GlobalVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
        }
        this.getterIdentifierError(node.getPosition(), ((INameNode)((Object)node)).getName());
        return null;
    }

    public Node gettable(Token token) {
        switch (token.getType()) {
            case 286: {
                return new SelfNode(token.getPosition());
            }
            case 287: {
                return new NilNode(token.getPosition());
            }
            case 288: {
                return new TrueNode(token.getPosition());
            }
            case 289: {
                return new FalseNode(token.getPosition());
            }
            case 303: {
                return new FileNode(token.getPosition(), ByteList.create(token.getPosition().getFile()));
            }
            case 302: {
                return new FixnumNode(token.getPosition(), token.getPosition().getStartLine() + 1);
            }
            case 304: {
                return new EncodingNode(token.getPosition());
            }
            case 306: {
                return this.currentScope.declare(token.getPosition(), (String)token.getValue());
            }
            case 310: {
                return new ConstNode(token.getPosition(), (String)token.getValue());
            }
            case 309: {
                return new InstVarNode(token.getPosition(), (String)token.getValue());
            }
            case 311: {
                return new ClassVarNode(token.getPosition(), (String)token.getValue());
            }
            case 308: {
                return new GlobalVarNode(token.getPosition(), (String)token.getValue());
            }
        }
        this.getterIdentifierError(token.getPosition(), (String)token.getValue());
        return null;
    }

    protected void getterIdentifierError(ISourcePosition position, String identifier) {
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, position, this.lexer.getCurrentLine(), "identifier " + identifier + " is not valid", identifier);
    }

    public AssignableNode assignable(Token lhs, Node value2) {
        this.checkExpression(value2);
        switch (lhs.getType()) {
            case 286: {
                throw new SyntaxException(SyntaxException.PID.CANNOT_CHANGE_SELF, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't change the value of self", new Object[0]);
            }
            case 287: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to nil", "nil");
            }
            case 288: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to true", "true");
            }
            case 289: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to false", "false");
            }
            case 303: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to __FILE__", "__FILE__");
            }
            case 302: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to __LINE__", "__LINE__");
            }
            case 306: {
                return this.currentScope.assign(lhs.getPosition(), (String)lhs.getValue(), this.makeNullNil(value2));
            }
            case 310: {
                if (this.isInDef() || this.isInSingle()) {
                    throw new SyntaxException(SyntaxException.PID.DYNAMIC_CONSTANT_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "dynamic constant assignment", new Object[0]);
                }
                return new ConstDeclNode(lhs.getPosition(), (String)lhs.getValue(), null, value2);
            }
            case 309: {
                return new InstAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value2);
            }
            case 311: {
                if (this.isInDef() || this.isInSingle()) {
                    return new ClassVarAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value2);
                }
                return new ClassVarDeclNode(lhs.getPosition(), (String)lhs.getValue(), value2);
            }
            case 308: {
                return new GlobalAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value2);
            }
        }
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, lhs.getPosition(), this.lexer.getCurrentLine(), "identifier " + (String)lhs.getValue() + " is not valid", lhs.getValue());
    }

    public Node newline_node(Node node, ISourcePosition position) {
        if (node == null) {
            return null;
        }
        return node instanceof NewlineNode ? node : new NewlineNode(position, node);
    }

    public Node addRootNode(Node topOfAST, ISourcePosition position) {
        ISourcePosition iSourcePosition = position = topOfAST != null ? topOfAST.getPosition() : position;
        if (this.result.getBeginNodes().size() == 0) {
            if (topOfAST == null) {
                topOfAST = NilImplicitNode.NIL;
            }
            return new RootNode(position, this.result.getScope(), topOfAST);
        }
        BlockNode newTopOfAST = new BlockNode(position);
        for (Node beginNode : this.result.getBeginNodes()) {
            this.appendToBlock(newTopOfAST, beginNode);
        }
        if (topOfAST != null) {
            newTopOfAST.add(topOfAST);
        }
        return new RootNode(position, this.result.getScope(), newTopOfAST);
    }

    public Node appendToBlock(Node head, Node tail) {
        if (tail == null) {
            return head;
        }
        if (head == null) {
            return tail;
        }
        if (!this.configuration.hasExtraPositionInformation()) {
            head = this.compactNewlines(head);
        }
        if (!(head instanceof BlockNode)) {
            head = new BlockNode(head.getPosition()).add(head);
        }
        if (this.warnings.isVerbose() && this.isBreakStatement(((ListNode)head).getLast())) {
            this.warnings.warning(IRubyWarnings.ID.STATEMENT_NOT_REACHED, tail.getPosition(), "Statement not reached.", new Object[0]);
        }
        ((ListNode)head).addAll(tail);
        return head;
    }

    public Node getOperatorCallNode(Node firstNode, String operator) {
        this.checkExpression(firstNode);
        return new CallNoArgNode(firstNode.getPosition(), firstNode, operator);
    }

    public Node getOperatorCallNode(Node firstNode, String operator, Node secondNode) {
        return this.getOperatorCallNode(firstNode, operator, secondNode, null);
    }

    public Node getOperatorCallNode(Node firstNode, String operator, Node secondNode, ISourcePosition defaultPosition) {
        if (defaultPosition != null) {
            firstNode = this.checkForNilNode(firstNode, defaultPosition);
            secondNode = this.checkForNilNode(secondNode, defaultPosition);
        }
        this.checkExpression(firstNode);
        this.checkExpression(secondNode);
        return this.new_call_one_arg(firstNode.getPosition(), firstNode, operator, secondNode);
    }

    public Node getMatchNode(Node firstNode, Node secondNode) {
        if (firstNode instanceof DRegexpNode || firstNode instanceof RegexpNode) {
            return new Match2Node(firstNode.getPosition(), firstNode, secondNode);
        }
        if (secondNode instanceof DRegexpNode || secondNode instanceof RegexpNode) {
            return new Match3Node(firstNode.getPosition(), secondNode, firstNode);
        }
        return this.getOperatorCallNode(firstNode, "=~", secondNode);
    }

    public Node aryset(Node receiver2, Node index2) {
        this.checkExpression(receiver2);
        return this.new_attrassign(receiver2.getPosition(), receiver2, "[]=", index2);
    }

    public Node attrset(Node receiver2, String name2) {
        this.checkExpression(receiver2);
        return this.new_attrassign(receiver2.getPosition(), receiver2, name2 + "=", null);
    }

    public void backrefAssignError(Node node) {
        if (node instanceof NthRefNode) {
            String varName = "$" + ((NthRefNode)node).getMatchNumber();
            throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, node.getPosition(), "Can't set variable " + varName + '.', varName, new Object[0]);
        }
        if (node instanceof BackRefNode) {
            String varName = "$" + ((BackRefNode)node).getType();
            throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, node.getPosition(), "Can't set variable " + varName + '.', varName, new Object[0]);
        }
    }

    public Node arg_add(ISourcePosition position, Node node1, Node node2) {
        if (node1 == null) {
            if (node2 == null) {
                return new ArrayNode(position, NilImplicitNode.NIL);
            }
            return new ArrayNode(node2.getPosition(), node2);
        }
        if (node1 instanceof ArrayNode) {
            return ((ArrayNode)node1).add(node2);
        }
        return new ArgsPushNode(position, node1, node2);
    }

    public Node node_assign(Node lhs, Node rhs) {
        if (lhs == null) {
            return null;
        }
        Node newNode = lhs;
        this.checkExpression(rhs);
        if (lhs instanceof AssignableNode) {
            ((AssignableNode)lhs).setValueNode(rhs);
        } else if (lhs instanceof IArgumentNode) {
            IArgumentNode invokableNode = (IArgumentNode)((Object)lhs);
            return invokableNode.setArgsNode(this.arg_add(lhs.getPosition(), invokableNode.getArgsNode(), rhs));
        }
        return newNode;
    }

    public Node ret_args(Node node, ISourcePosition position) {
        if (node != null) {
            if (node instanceof BlockPassNode) {
                throw new SyntaxException(SyntaxException.PID.DYNAMIC_CONSTANT_ASSIGNMENT, position, this.lexer.getCurrentLine(), "Dynamic constant assignment.", new Object[0]);
            }
            if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
                node = ((ArrayNode)node).get(0);
            } else if (node instanceof SplatNode) {
                node = this.newSValueNode(position, node);
            }
        }
        return node;
    }

    public boolean isBreakStatement(Node node) {
        block4: while (true) {
            if (node == null) {
                return false;
            }
            switch (node.getNodeType()) {
                case NEWLINENODE: {
                    node = ((NewlineNode)node).getNextNode();
                    continue block4;
                }
                case BREAKNODE: 
                case NEXTNODE: 
                case REDONODE: 
                case RETRYNODE: 
                case RETURNNODE: {
                    return true;
                }
            }
            break;
        }
        return false;
    }

    public void warnUnlessEOption(IRubyWarnings.ID id2, Node node, String message2) {
        if (!this.configuration.isInlineSource()) {
            this.warnings.warn(id2, node.getPosition(), message2, new Object[0]);
        }
    }

    public void warningUnlessEOption(IRubyWarnings.ID id2, Node node, String message2) {
        if (this.warnings.isVerbose() && !this.configuration.isInlineSource()) {
            this.warnings.warning(id2, node.getPosition(), message2, new Object[0]);
        }
    }

    private Node compactNewlines(Node head) {
        Node nextNode;
        while (head instanceof NewlineNode && (nextNode = ((NewlineNode)head).getNextNode()) instanceof NewlineNode) {
            head = nextNode;
        }
        return head;
    }

    public boolean checkExpression(Node node) {
        boolean conditional = false;
        block9: while (node != null) {
            switch (node.getNodeType()) {
                case DEFNNODE: 
                case DEFSNODE: {
                    this.warnings.warning(IRubyWarnings.ID.VOID_VALUE_EXPRESSION, node.getPosition(), "void value expression", new Object[0]);
                    return false;
                }
                case BREAKNODE: 
                case NEXTNODE: 
                case REDONODE: 
                case RETRYNODE: 
                case RETURNNODE: {
                    if (!conditional) {
                        throw new SyntaxException(SyntaxException.PID.VOID_VALUE_EXPRESSION, node.getPosition(), this.lexer.getCurrentLine(), "void value expression", new Object[0]);
                    }
                    return false;
                }
                case BLOCKNODE: {
                    node = ((BlockNode)node).getLast();
                    continue block9;
                }
                case BEGINNODE: {
                    node = ((BeginNode)node).getBodyNode();
                    continue block9;
                }
                case IFNODE: {
                    if (!this.checkExpression(((IfNode)node).getThenBody())) {
                        return false;
                    }
                    node = ((IfNode)node).getElseBody();
                    continue block9;
                }
                case ANDNODE: 
                case ORNODE: {
                    conditional = true;
                    node = ((BinaryOperatorNode)((Object)node)).getSecondNode();
                    continue block9;
                }
                case NEWLINENODE: {
                    node = ((NewlineNode)node).getNextNode();
                    continue block9;
                }
            }
            return true;
        }
        return true;
    }

    public boolean isLiteral(Node node) {
        return node != null && (node instanceof FixnumNode || node instanceof BignumNode || node instanceof FloatNode || node instanceof SymbolNode || node instanceof RegexpNode && (((RegexpNode)node).getOptions() & 0xFFFFFF7F) == 0);
    }

    private void handleUselessWarn(Node node, String useless) {
        this.warnings.warn(IRubyWarnings.ID.USELESS_EXPRESSION, node.getPosition(), "Useless use of " + useless + " in void context.", useless);
    }

    public void checkUselessStatement(Node node) {
        if (!this.warnings.isVerbose()) {
            return;
        }
        block11: while (true) {
            if (node == null) {
                return;
            }
            switch (node.getNodeType()) {
                case NEWLINENODE: {
                    node = ((NewlineNode)node).getNextNode();
                    continue block11;
                }
                case CALLNODE: {
                    String name2 = ((CallNode)node).getName();
                    if (name2 == "+" || name2 == "-" || name2 == "*" || name2 == "/" || name2 == "%" || name2 == "**" || name2 == "+@" || name2 == "-@" || name2 == "|" || name2 == "^" || name2 == "&" || name2 == "<=>" || name2 == ">" || name2 == ">=" || name2 == "<" || name2 == "<=" || name2 == "==" || name2 == "!=") {
                        this.handleUselessWarn(node, name2);
                    }
                    return;
                }
                case BACKREFNODE: 
                case DVARNODE: 
                case GLOBALVARNODE: 
                case LOCALVARNODE: 
                case NTHREFNODE: 
                case CLASSVARNODE: 
                case INSTVARNODE: {
                    this.handleUselessWarn(node, "a variable");
                    return;
                }
                case BIGNUMNODE: 
                case DREGEXPNODE: 
                case DSTRNODE: 
                case DSYMBOLNODE: 
                case FIXNUMNODE: 
                case FLOATNODE: 
                case REGEXPNODE: 
                case STRNODE: 
                case SYMBOLNODE: {
                    this.handleUselessWarn(node, "a literal");
                    return;
                }
                case DOTNODE: {
                    this.handleUselessWarn(node, ((DotNode)node).isExclusive() ? "..." : "..");
                    return;
                }
                case DEFINEDNODE: {
                    this.handleUselessWarn(node, "defined?");
                    return;
                }
                case FALSENODE: {
                    this.handleUselessWarn(node, "false");
                    return;
                }
                case NILNODE: {
                    this.handleUselessWarn(node, "nil");
                    return;
                }
                case TRUENODE: {
                    this.handleUselessWarn(node, "true");
                    return;
                }
            }
            break;
        }
    }

    public void checkUselessStatements(BlockNode blockNode) {
        if (this.warnings.isVerbose()) {
            Node lastNode = blockNode.getLast();
            for (int i = 0; i < blockNode.size(); ++i) {
                Node currentNode = blockNode.get(i);
                if (lastNode == currentNode) continue;
                this.checkUselessStatement(currentNode);
            }
        }
    }

    private boolean checkAssignmentInCondition(Node node) {
        if (node instanceof MultipleAsgnNode) {
            throw new SyntaxException(SyntaxException.PID.MULTIPLE_ASSIGNMENT_IN_CONDITIONAL, node.getPosition(), this.lexer.getCurrentLine(), "Multiple assignment in conditional.", new Object[0]);
        }
        if (node instanceof LocalAsgnNode || node instanceof DAsgnNode || node instanceof GlobalAsgnNode || node instanceof InstAsgnNode) {
            Node valueNode = ((AssignableNode)node).getValueNode();
            if (valueNode instanceof ILiteralNode || valueNode instanceof NilNode || valueNode instanceof TrueNode || valueNode instanceof FalseNode) {
                this.warnings.warn(IRubyWarnings.ID.ASSIGNMENT_IN_CONDITIONAL, node.getPosition(), "Found '=' in conditional, should be '=='.", new Object[0]);
            }
            return true;
        }
        return false;
    }

    protected Node makeNullNil(Node node) {
        return node == null ? NilImplicitNode.NIL : node;
    }

    private Node cond0(Node node) {
        this.checkAssignmentInCondition(node);
        Node leftNode = null;
        Node rightNode = null;
        switch (node.getNodeType()) {
            case DREGEXPNODE: {
                ISourcePosition position = node.getPosition();
                return new Match2Node(position, node, new GlobalVarNode(position, "$_"));
            }
            case ANDNODE: {
                leftNode = this.cond0(((AndNode)node).getFirstNode());
                rightNode = this.cond0(((AndNode)node).getSecondNode());
                return new AndNode(node.getPosition(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case ORNODE: {
                leftNode = this.cond0(((OrNode)node).getFirstNode());
                rightNode = this.cond0(((OrNode)node).getSecondNode());
                return new OrNode(node.getPosition(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case DOTNODE: {
                DotNode dotNode = (DotNode)node;
                if (dotNode.isLiteral()) {
                    return node;
                }
                String label = String.valueOf("FLIP" + node.hashCode());
                this.currentScope.getLocalScope().addVariable(label);
                int slot = this.currentScope.isDefined(label);
                return new FlipNode(node.getPosition(), this.getFlipConditionNode(((DotNode)node).getBeginNode()), this.getFlipConditionNode(((DotNode)node).getEndNode()), dotNode.isExclusive(), slot);
            }
            case REGEXPNODE: {
                this.warningUnlessEOption(IRubyWarnings.ID.REGEXP_LITERAL_IN_CONDITION, node, "regex literal in condition");
                return new MatchNode(node.getPosition(), node);
            }
        }
        return node;
    }

    public Node getConditionNode(Node node) {
        if (node == null) {
            return NilImplicitNode.NIL;
        }
        if (node instanceof NewlineNode) {
            return new NewlineNode(node.getPosition(), this.cond0(((NewlineNode)node).getNextNode()));
        }
        return this.cond0(node);
    }

    private Node getFlipConditionNode(Node node) {
        if (!this.configuration.isInlineSource()) {
            return node;
        }
        if ((node = this.getConditionNode(node)) instanceof NewlineNode) {
            return ((NewlineNode)node).getNextNode();
        }
        if (node instanceof FixnumNode) {
            this.warnUnlessEOption(IRubyWarnings.ID.LITERAL_IN_CONDITIONAL_RANGE, node, "integer literal in conditional range");
            return this.getOperatorCallNode(node, "==", new GlobalVarNode(node.getPosition(), "$."));
        }
        return node;
    }

    public SValueNode newSValueNode(ISourcePosition position, Node node) {
        return new SValueNode(position, node);
    }

    public SplatNode newSplatNode(ISourcePosition position, Node node) {
        return new SplatNode(position, this.makeNullNil(node));
    }

    public ArrayNode newArrayNode(ISourcePosition position, Node firstNode) {
        return new ArrayNode(position, this.makeNullNil(firstNode));
    }

    public ISourcePosition position(ISourcePositionHolder one, ISourcePositionHolder two) {
        return one == null ? two.getPosition() : one.getPosition();
    }

    public AndNode newAndNode(ISourcePosition position, Node left, Node right) {
        this.checkExpression(left);
        if (left == null && right == null) {
            return new AndNode(position, this.makeNullNil(left), this.makeNullNil(right));
        }
        return new AndNode(this.position(left, right), this.makeNullNil(left), this.makeNullNil(right));
    }

    public OrNode newOrNode(ISourcePosition position, Node left, Node right) {
        this.checkExpression(left);
        if (left == null && right == null) {
            return new OrNode(position, this.makeNullNil(left), this.makeNullNil(right));
        }
        return new OrNode(this.position(left, right), this.makeNullNil(left), this.makeNullNil(right));
    }

    public CaseNode newCaseNode(ISourcePosition position, Node expression, Node firstWhenNode) {
        ArrayNode cases = new ArrayNode(firstWhenNode != null ? firstWhenNode.getPosition() : position);
        CaseNode caseNode = new CaseNode(position, expression, cases);
        Node current2 = firstWhenNode;
        while (current2 != null) {
            if (current2 instanceof WhenOneArgNode) {
                cases.add(current2);
            } else if (current2 instanceof WhenNode) {
                this.simplifyMultipleArgumentWhenNodes((WhenNode)current2, cases);
            } else {
                caseNode.setElseNode(current2);
                break;
            }
            current2 = ((WhenNode)current2).getNextCase();
        }
        return caseNode;
    }

    private void simplifyMultipleArgumentWhenNodes(WhenNode sourceWhen, ArrayNode cases) {
        Node expressionNodes = sourceWhen.getExpressionNodes();
        if (expressionNodes instanceof SplatNode || expressionNodes instanceof ArgsCatNode) {
            cases.add(sourceWhen);
            return;
        }
        if (expressionNodes instanceof ListNode) {
            ListNode list2 = (ListNode)expressionNodes;
            ISourcePosition position = sourceWhen.getPosition();
            Node bodyNode = sourceWhen.getBodyNode();
            for (int i = 0; i < list2.size(); ++i) {
                Node expression = list2.get(i);
                if (expression instanceof SplatNode || expression instanceof ArgsCatNode) {
                    cases.add(new WhenNode(position, expression, bodyNode, null));
                    continue;
                }
                cases.add(new WhenOneArgNode(position, expression, bodyNode, null));
            }
        } else {
            cases.add(sourceWhen);
        }
    }

    public WhenNode newWhenNode(ISourcePosition position, Node expressionNodes, Node bodyNode, Node nextCase) {
        Node element;
        if (bodyNode == null) {
            bodyNode = NilImplicitNode.NIL;
        }
        if (expressionNodes instanceof SplatNode || expressionNodes instanceof ArgsCatNode) {
            return new WhenNode(position, expressionNodes, bodyNode, nextCase);
        }
        ListNode list2 = (ListNode)expressionNodes;
        if (list2.size() == 1 && !((element = list2.get(0)) instanceof SplatNode)) {
            return new WhenOneArgNode(position, element, bodyNode, nextCase);
        }
        return new WhenNode(position, expressionNodes, bodyNode, nextCase);
    }

    public Node getReturnArgsNode(Node node) {
        if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
            return ((ListNode)node).get(0);
        }
        if (node instanceof BlockPassNode) {
            throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, node.getPosition(), this.lexer.getCurrentLine(), "Block argument should not be given.", new Object[0]);
        }
        return node;
    }

    public Node new_opElementAsgnNode(ISourcePosition position, Node receiverNode, String operatorName, Node argsNode, Node valueNode) {
        ArrayNode array;
        if (argsNode instanceof ArrayNode && (array = (ArrayNode)argsNode).size() == 1) {
            if (operatorName.equals("||")) {
                return new OpElementOneArgOrAsgnNode(position, receiverNode, operatorName, array, valueNode);
            }
            if (operatorName.equals("&&")) {
                return new OpElementOneArgAndAsgnNode(position, receiverNode, operatorName, array, valueNode);
            }
            return new OpElementOneArgAsgnNode(position, receiverNode, operatorName, array, valueNode);
        }
        return new OpElementAsgnNode(position, receiverNode, operatorName, argsNode, valueNode);
    }

    public Node new_attrassign(ISourcePosition position, Node receiver2, String name2, Node args2) {
        if (!(args2 instanceof ArrayNode)) {
            return new AttrAssignNode(position, receiver2, name2, args2);
        }
        ArrayNode argsNode = (ArrayNode)args2;
        switch (argsNode.size()) {
            case 1: {
                return new AttrAssignOneArgNode(position, receiver2, name2, argsNode);
            }
            case 2: {
                return new AttrAssignTwoArgNode(position, receiver2, name2, argsNode);
            }
            case 3: {
                return new AttrAssignThreeArgNode(position, receiver2, name2, argsNode);
            }
        }
        return new AttrAssignNode(position, receiver2, name2, argsNode);
    }

    private Node new_call_noargs(Node receiver2, Token name2, IterNode iter) {
        ISourcePosition position = this.position(receiver2, name2);
        if (receiver2 == null) {
            receiver2 = NilImplicitNode.NIL;
        }
        if (iter != null) {
            return new CallNoArgBlockNode(position, receiver2, (String)name2.getValue(), iter);
        }
        return new CallNoArgNode(position, receiver2, (String)name2.getValue());
    }

    private Node new_call_complexargs(Node receiver2, Token name2, Node args2, Node iter) {
        if (args2 instanceof BlockPassNode) {
            if (iter != null) {
                throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_AND_BLOCK_GIVEN, iter.getPosition(), this.lexer.getCurrentLine(), "Both block arg and actual block given.", new Object[0]);
            }
            return this.new_call_blockpass(receiver2, name2, (BlockPassNode)args2);
        }
        if (iter != null) {
            return new CallSpecialArgBlockNode(this.position(receiver2, args2), receiver2, (String)name2.getValue(), args2, (IterNode)iter);
        }
        return new CallSpecialArgNode(this.position(receiver2, args2), receiver2, (String)name2.getValue(), args2);
    }

    private Node new_call_blockpass(Node receiver2, Token operation, BlockPassNode blockPass) {
        ISourcePosition position = this.position(receiver2, blockPass);
        String name2 = (String)operation.getValue();
        Node args2 = blockPass.getArgsNode();
        if (args2 == null) {
            return new CallNoArgBlockPassNode(position, receiver2, name2, args2, blockPass);
        }
        if (!(args2 instanceof ArrayNode)) {
            return new CallSpecialArgBlockPassNode(position, receiver2, name2, args2, blockPass);
        }
        switch (((ArrayNode)args2).size()) {
            case 0: {
                return new CallNoArgBlockPassNode(position, receiver2, name2, args2, blockPass);
            }
            case 1: {
                return new CallOneArgBlockPassNode(position, receiver2, name2, (ArrayNode)args2, blockPass);
            }
            case 2: {
                return new CallTwoArgBlockPassNode(position, receiver2, name2, (ArrayNode)args2, blockPass);
            }
            case 3: {
                return new CallThreeArgBlockPassNode(position, receiver2, name2, (ArrayNode)args2, blockPass);
            }
        }
        return new CallManyArgsBlockPassNode(position, receiver2, name2, args2, blockPass);
    }

    private boolean isNumericOperator(String name2) {
        if (name2.length() == 1) {
            switch (name2.charAt(0)) {
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case '<': 
                case '>': {
                    return true;
                }
            }
        } else if (name2.length() == 2) {
            switch (name2.charAt(0)) {
                case '<': 
                case '=': 
                case '>': {
                    switch (name2.charAt(1)) {
                        case '<': 
                        case '=': {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private Node new_call_one_arg(ISourcePosition position, Node receiver2, String name2, Node first2) {
        if (first2 instanceof FixnumNode && this.isNumericOperator(name2)) {
            return new CallOneArgFixnumNode(position, receiver2, name2, new ArrayNode(position, first2));
        }
        return new CallOneArgNode(position, receiver2, name2, new ArrayNode(position, first2));
    }

    public Node new_call(Node receiver2, Token name2, Node argsNode, Node iter) {
        if (argsNode == null) {
            return this.new_call_noargs(receiver2, name2, (IterNode)iter);
        }
        if (!(argsNode instanceof ArrayNode)) {
            return this.new_call_complexargs(receiver2, name2, argsNode, iter);
        }
        ArrayNode args2 = (ArrayNode)argsNode;
        switch (args2.size()) {
            case 0: {
                if (iter != null) {
                    return new CallNoArgBlockNode(this.position(receiver2, args2), receiver2, (String)name2.getValue(), (Node)args2, (IterNode)iter);
                }
                return new CallNoArgNode(this.position(receiver2, args2), receiver2, args2, (String)name2.getValue());
            }
            case 1: {
                if (iter != null) {
                    return new CallOneArgBlockNode(this.position(receiver2, args2), receiver2, (String)name2.getValue(), args2, (IterNode)iter);
                }
                return new CallOneArgNode(this.position(receiver2, args2), receiver2, (String)name2.getValue(), args2);
            }
            case 2: {
                if (iter != null) {
                    return new CallTwoArgBlockNode(this.position(receiver2, args2), receiver2, (String)name2.getValue(), args2, (IterNode)iter);
                }
                return new CallTwoArgNode(this.position(receiver2, args2), receiver2, (String)name2.getValue(), args2);
            }
            case 3: {
                if (iter != null) {
                    return new CallThreeArgBlockNode(this.position(receiver2, args2), receiver2, (String)name2.getValue(), args2, (IterNode)iter);
                }
                return new CallThreeArgNode(this.position(receiver2, args2), receiver2, (String)name2.getValue(), args2);
            }
        }
        if (iter != null) {
            return new CallManyArgsBlockNode(this.position(receiver2, args2), receiver2, (String)name2.getValue(), (Node)args2, (IterNode)iter);
        }
        return new CallManyArgsNode(this.position(receiver2, args2), receiver2, (String)name2.getValue(), args2);
    }

    public Node new_aref(Node receiver2, Token name2, Node argsNode) {
        ArrayNode args2;
        if (argsNode instanceof ArrayNode && (args2 = (ArrayNode)argsNode).size() == 1 && args2.get(0) instanceof FixnumNode) {
            return new CallOneArgFixnumNode(this.position(receiver2, args2), receiver2, "[]", args2);
        }
        return this.new_call(receiver2, name2, argsNode, null);
    }

    public Colon2Node new_colon2(ISourcePosition position, Node leftNode, String name2) {
        if (IdUtil.isConstant(name2)) {
            if (leftNode == null) {
                return new Colon2ImplicitNode(position, name2);
            }
            return new Colon2ConstNode(position, leftNode, name2);
        }
        return new Colon2MethodNode(position, leftNode, name2);
    }

    public Colon3Node new_colon3(ISourcePosition position, String name2) {
        return new Colon3Node(position, name2);
    }

    private Node new_fcall_noargs(Token operation, IterNode iter) {
        if (iter != null) {
            return new FCallNoArgBlockNode(operation.getPosition(), (String)operation.getValue(), iter);
        }
        return new FCallNoArgNode(operation.getPosition(), (String)operation.getValue());
    }

    private Node new_fcall_simpleargs(Token operation, ArrayNode args2, Node iter) {
        String name2 = (String)operation.getValue();
        ISourcePosition position = this.position(operation, args2);
        switch (args2.size()) {
            case 0: {
                if (iter != null) {
                    return new FCallNoArgBlockNode(position, name2, (Node)args2, (IterNode)iter);
                }
                return new FCallNoArgNode(position, args2, name2);
            }
            case 1: {
                if (iter != null) {
                    return new FCallOneArgBlockNode(position, name2, args2, (IterNode)iter);
                }
                return new FCallOneArgNode(position, name2, args2);
            }
            case 2: {
                if (iter != null) {
                    return new FCallTwoArgBlockNode(position, name2, args2, (IterNode)iter);
                }
                return new FCallTwoArgNode(position, name2, args2);
            }
            case 3: {
                if (iter != null) {
                    return new FCallThreeArgBlockNode(position, name2, args2, (IterNode)iter);
                }
                return new FCallThreeArgNode(position, name2, args2);
            }
        }
        if (iter != null) {
            return new FCallManyArgsBlockNode(position, name2, (Node)args2, (IterNode)iter);
        }
        return new FCallManyArgsNode(position, name2, args2);
    }

    private Node new_fcall_blockpass(Token operation, BlockPassNode blockPass) {
        ISourcePosition position = this.position(operation, blockPass);
        String name2 = (String)operation.getValue();
        Node args2 = blockPass.getArgsNode();
        if (args2 == null) {
            return new FCallNoArgBlockPassNode(position, name2, args2, blockPass);
        }
        if (!(args2 instanceof ArrayNode)) {
            return new FCallSpecialArgBlockPassNode(position, name2, args2, blockPass);
        }
        switch (((ArrayNode)args2).size()) {
            case 0: {
                return new FCallNoArgBlockPassNode(position, name2, args2, blockPass);
            }
            case 1: {
                return new FCallOneArgBlockPassNode(position, name2, (ArrayNode)args2, blockPass);
            }
            case 2: {
                return new FCallTwoArgBlockPassNode(position, name2, (ArrayNode)args2, blockPass);
            }
            case 3: {
                return new FCallThreeArgBlockPassNode(position, name2, (ArrayNode)args2, blockPass);
            }
        }
        return new FCallManyArgsBlockPassNode(position, name2, args2, blockPass);
    }

    public Node new_fcall(Token operation, Node args2, Node iter) {
        if (args2 == null) {
            return this.new_fcall_noargs(operation, (IterNode)iter);
        }
        if (args2 instanceof ArrayNode) {
            return this.new_fcall_simpleargs(operation, (ArrayNode)args2, iter);
        }
        if (args2 instanceof BlockPassNode) {
            if (iter == null) {
                return this.new_fcall_blockpass(operation, (BlockPassNode)args2);
            }
            throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_AND_BLOCK_GIVEN, iter.getPosition(), this.lexer.getCurrentLine(), "Both block arg and actual block given.", new Object[0]);
        }
        if (iter != null) {
            new FCallSpecialArgBlockNode(this.position(operation, args2), (String)operation.getValue(), args2, (IterNode)iter);
        }
        return new FCallSpecialArgNode(this.position(operation, args2), (String)operation.getValue(), args2);
    }

    public Node new_super(Node args2, Token operation) {
        if (args2 != null && args2 instanceof BlockPassNode) {
            return new SuperNode(this.position(operation, args2), ((BlockPassNode)args2).getArgsNode(), args2);
        }
        return new SuperNode(operation.getPosition(), args2);
    }

    public void initTopLocalVariables() {
        DynamicScope scope = this.configuration.getScope();
        this.currentScope = scope.getStaticScope();
        this.result.setScope(scope);
    }

    public boolean isInSingle() {
        return this.inSingleton != 0;
    }

    public void setInSingle(int inSingle) {
        this.inSingleton = inSingle;
    }

    public boolean isInDef() {
        return this.inDefinition;
    }

    public void setInDef(boolean inDef) {
        this.inDefinition = inDef;
    }

    public int getInSingle() {
        return this.inSingleton;
    }

    public RubyParserResult getResult() {
        return this.result;
    }

    public void setResult(RubyParserResult result) {
        this.result = result;
    }

    public void setConfiguration(ParserConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setWarnings(IRubyWarnings warnings) {
        this.warnings = warnings;
    }

    public void setLexer(RubyYaccLexer lexer) {
        this.lexer = lexer;
    }

    public Node literal_concat(ISourcePosition position, Node head, Node tail) {
        if (head == null) {
            return tail;
        }
        if (tail == null) {
            return head;
        }
        if (head instanceof EvStrNode) {
            head = new DStrNode(head.getPosition()).add(head);
        }
        if (tail instanceof StrNode) {
            if (head instanceof StrNode) {
                return new StrNode(head.getPosition(), (StrNode)head, (StrNode)tail);
            }
            head.setPosition(head.getPosition());
            return ((ListNode)head).add(tail);
        }
        if (tail instanceof DStrNode) {
            if (head instanceof StrNode) {
                ((DStrNode)tail).prepend(head);
                return tail;
            }
            return ((ListNode)head).addAll(tail);
        }
        if (head instanceof StrNode) {
            head = ((StrNode)head).getValue().length() == 0 ? new DStrNode(head.getPosition()) : new DStrNode(head.getPosition()).add(head);
        }
        return ((DStrNode)head).add(tail);
    }

    public Node newEvStrNode(ISourcePosition position, Node node) {
        Node head = node;
        while (node != null) {
            if (node instanceof StrNode || node instanceof DStrNode || node instanceof EvStrNode) {
                return node;
            }
            if (!(node instanceof NewlineNode)) break;
            node = ((NewlineNode)node).getNextNode();
        }
        return new EvStrNode(position, head);
    }

    public IterNode new_iter(ISourcePosition position, Node vars, StaticScope scope, Node body) {
        if (vars != null && vars instanceof BlockPassNode) {
            BlockPassNode blockPass = (BlockPassNode)vars;
            return new IterNode(position, blockPass.getArgsNode(), blockPass, scope, body);
        }
        return new IterNode(position, vars, null, scope, body);
    }

    public Node new_yield(ISourcePosition position, Node node) {
        boolean state = true;
        if (node != null) {
            if (node instanceof BlockPassNode) {
                throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, node.getPosition(), this.lexer.getCurrentLine(), "Block argument should not be given.", new Object[0]);
            }
            if (node instanceof ArrayNode && this.configuration.getVersion() == CompatVersion.RUBY1_8 && ((ArrayNode)node).size() == 1) {
                node = ((ArrayNode)node).get(0);
                state = false;
            }
            if (node != null && node instanceof SplatNode) {
                state = true;
            }
        } else {
            return new ZYieldNode(position);
        }
        if (state && node instanceof ArrayNode) {
            ArrayNode args2 = (ArrayNode)node;
            switch (args2.size()) {
                case 0: {
                    return new ZYieldNode(position);
                }
                case 1: {
                    return new YieldOneNode(position, args2);
                }
                case 2: {
                    return new YieldTwoNode(position, args2);
                }
                case 3: {
                    return new YieldThreeNode(position, args2);
                }
            }
        }
        if (node instanceof FixnumNode) {
            return new YieldOneNode(position, (FixnumNode)node);
        }
        return new YieldNode(position, node, state);
    }

    public Node negateInteger(Node integerNode) {
        if (integerNode instanceof FixnumNode) {
            FixnumNode fixnumNode = (FixnumNode)integerNode;
            fixnumNode.setValue(-fixnumNode.getValue());
            return fixnumNode;
        }
        if (integerNode instanceof BignumNode) {
            BignumNode bignumNode = (BignumNode)integerNode;
            bignumNode.setValue(bignumNode.getValue().negate());
        }
        return integerNode;
    }

    public FloatNode negateFloat(FloatNode floatNode) {
        floatNode.setValue(-floatNode.getValue());
        return floatNode;
    }

    public ISourcePosition createEmptyArgsNodePosition(ISourcePosition pos2) {
        return pos2;
    }

    public Node unwrapNewlineNode(Node node) {
        if (node instanceof NewlineNode) {
            return ((NewlineNode)node).getNextNode();
        }
        return node;
    }

    private Node checkForNilNode(Node node, ISourcePosition defaultPosition) {
        return node == null ? new NilNode(defaultPosition) : node;
    }

    public ArgumentNode getRestArgNode(Token token) {
        int index2 = (Integer)token.getValue();
        if (index2 < 0) {
            return null;
        }
        String name2 = this.getCurrentScope().getLocalScope().getVariables()[index2];
        return new ArgumentNode(token.getPosition(), name2);
    }

    public Node new_args(ISourcePosition position, ListNode pre, ListNode optional, RestArgNode rest2, ListNode post, BlockArgNode block) {
        if (optional == null && rest2 == null && post == null && block == null) {
            if (pre == null || pre.size() == 0) {
                return new ArgsNoArgNode(position);
            }
            if (pre.size() == 1) {
                return new ArgsPreOneArgNode(position, pre);
            }
            if (pre.size() == 2) {
                return new ArgsPreTwoArgNode(position, pre);
            }
        }
        return new ArgsNode(position, pre, optional, rest2, post, block);
    }

    public Node newAlias(ISourcePosition position, Node newNode, Node oldNode) {
        return new AliasNode(position, newNode, oldNode);
    }

    public Node newUndef(ISourcePosition position, Node nameNode) {
        return new UndefNode(position, nameNode);
    }

    public BlockArg18Node newBlockArg18(ISourcePosition position, Node blockValue, Node args2) {
        return new BlockArg18Node(position, blockValue, args2);
    }

    public BlockArgNode newBlockArg(ISourcePosition position, Token nameToken) {
        String identifier = (String)nameToken.getValue();
        if (this.getCurrentScope().getLocalScope().isDefined(identifier) >= 0) {
            throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, position, this.lexer.getCurrentLine(), "duplicate block argument name", new Object[0]);
        }
        return new BlockArgNode(position, this.getCurrentScope().getLocalScope().addVariable(identifier), identifier);
    }

    public void yyerror(String message2) {
        throw new SyntaxException(SyntaxException.PID.GRAMMAR_ERROR, this.lexer.getPosition(), this.lexer.getCurrentLine(), message2, new Object[0]);
    }

    public void yyerror(String message2, String[] expected, String found) {
        String text = message2 + ", unexpected " + found + "\n";
        throw new SyntaxException(SyntaxException.PID.GRAMMAR_ERROR, this.lexer.getPosition(), this.lexer.getCurrentLine(), text, found);
    }

    public ISourcePosition getPosition(ISourcePositionHolder start2) {
        return start2 != null ? this.lexer.getPosition(start2.getPosition()) : this.lexer.getPosition();
    }

    public void warn(IRubyWarnings.ID id2, ISourcePosition position, String message2, Object ... data) {
        this.warnings.warn(id2, position, message2, data);
    }

    public void warning(IRubyWarnings.ID id2, ISourcePosition position, String message2, Object ... data) {
        if (this.warnings.isVerbose()) {
            this.warnings.warning(id2, position, message2, data);
        }
    }

    public boolean is_local_id(Token identifier) {
        String name2 = (String)identifier.getValue();
        return this.getCurrentScope().getLocalScope().isDefined(name2) < 0;
    }

    public ListNode list_append(Node list2, Node item) {
        if (list2 == null) {
            return new ArrayNode(item.getPosition(), item);
        }
        if (!(list2 instanceof ListNode)) {
            return new ArrayNode(list2.getPosition(), list2).add(item);
        }
        return ((ListNode)list2).add(item);
    }

    public Node new_bv(Token identifier) {
        if (!this.is_local_id(identifier)) {
            this.getterIdentifierError(identifier.getPosition(), (String)identifier.getValue());
        }
        this.shadowing_lvar(identifier);
        this.arg_var(identifier);
        return null;
    }

    public int arg_var(Token identifier) {
        return this.getCurrentScope().addVariableThisScope((String)identifier.getValue());
    }

    public void shadowing_lvar(Token identifier) {
        String name2 = (String)identifier.getValue();
        if (this.getCurrentScope().isDefined(name2) > 0 && this.warnings.isVerbose()) {
            this.warnings.warning(IRubyWarnings.ID.STATEMENT_NOT_REACHED, identifier.getPosition(), "shadowing outer local variable - " + name2, new Object[0]);
        }
    }

    public ListNode list_concat(Node first2, Node second) {
        if (first2 instanceof ListNode) {
            if (second instanceof ListNode) {
                return ((ListNode)first2).addAll((ListNode)second);
            }
            return ((ListNode)first2).addAll(second);
        }
        return new ArrayNode(first2.getPosition(), first2).add(second);
    }

    public Node splat_array(Node node) {
        if (node instanceof SplatNode) {
            node = ((SplatNode)node).getValue();
        }
        if (node instanceof ArrayNode) {
            return node;
        }
        return null;
    }

    public Node arg_append(Node node1, Node node2) {
        if (node1 == null) {
            return new ArrayNode(node2.getPosition(), node2);
        }
        if (node1 instanceof ListNode) {
            return ((ListNode)node1).add(node2);
        }
        if (node1 instanceof BlockPassNode) {
            return this.arg_append(((BlockPassNode)node1).getBodyNode(), node2);
        }
        if (node1 instanceof ArgsPushNode) {
            ArgsPushNode pushNode = (ArgsPushNode)node1;
            Node body = pushNode.getSecondNode();
            return new ArgsCatNode(pushNode.getPosition(), pushNode.getFirstNode(), new ArrayNode(body.getPosition(), body).add(node2));
        }
        return new ArgsPushNode(this.position(node1, node2), node1, node2);
    }
}

