/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.dataflow.analyses;

import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jruby.compiler.ir.IR_Closure;
import org.jruby.compiler.ir.IR_ExecutionScope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.dataflow.FlowGraphNode;
import org.jruby.compiler.ir.dataflow.analyses.FrameLoadPlacementProblem;
import org.jruby.compiler.ir.instructions.CallInstruction;
import org.jruby.compiler.ir.instructions.IR_Instr;
import org.jruby.compiler.ir.instructions.LOAD_FROM_FRAME_Instr;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.SelfVariable;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;
import org.jruby.compiler.ir.representations.CFG;

public class FrameLoadPlacementNode
extends FlowGraphNode {
    Set<Variable> _inReqdLoads;
    Set<Variable> _outReqdLoads;

    public FrameLoadPlacementNode(DataFlowProblem prob, BasicBlock n) {
        super(prob, n);
    }

    public void init() {
        this._inReqdLoads = new HashSet<Variable>();
        this._outReqdLoads = new HashSet<Variable>();
    }

    public void buildDataFlowVars(IR_Instr i) {
        FrameLoadPlacementProblem flp = (FrameLoadPlacementProblem)this._prob;
        for (Variable v : i.getUsedVariables()) {
            if (!(v instanceof LocalVariable) && !(v instanceof SelfVariable)) continue;
            flp.recordUsedVar(v);
        }
        Variable v = i.getResult();
        if (v != null && (v instanceof LocalVariable || v instanceof SelfVariable)) {
            flp.recordDefVar(v);
        }
    }

    public void initSolnForNode() {
        if (this._bb == this._prob.getCFG().getExitBB()) {
            this._inReqdLoads = ((FrameLoadPlacementProblem)this._prob).getLoadsOnScopeExit();
        }
    }

    public void compute_MEET(CFG.CFG_Edge edge, FlowGraphNode pred2) {
        FrameLoadPlacementNode n = (FrameLoadPlacementNode)pred2;
        this._inReqdLoads.addAll(n._outReqdLoads);
    }

    public boolean applyTransferFunction() {
        FrameLoadPlacementProblem flp = (FrameLoadPlacementProblem)this._prob;
        HashSet<Variable> reqdLoads = new HashSet<Variable>(this._inReqdLoads);
        List<IR_Instr> instrs = this._bb.getInstrs();
        ListIterator<IR_Instr> it = instrs.listIterator(instrs.size());
        while (it.hasPrevious()) {
            IR_Instr i = it.previous();
            if (i._op == Operation.FRAME_STORE) continue;
            Variable r = i.getResult();
            if (r != null) {
                reqdLoads.remove(r);
            }
            if (i instanceof CallInstruction) {
                CallInstruction call2 = (CallInstruction)i;
                Operand o = call2.getClosureArg();
                if (o != null && o instanceof MetaObject) {
                    IR_Closure cl = (IR_Closure)((MetaObject)o)._scope;
                    CFG cl_cfg = cl.getCFG();
                    FrameLoadPlacementProblem cl_flp = new FrameLoadPlacementProblem();
                    cl_flp.initLoadsOnScopeExit(reqdLoads);
                    cl_flp.setup(cl_cfg);
                    cl_flp.compute_MOP_Solution();
                    cl_cfg.setDataFlowSolution(cl_flp.getName(), cl_flp);
                    HashSet<Variable> newReqdLoads = new HashSet<Variable>(reqdLoads);
                    for (Variable v : reqdLoads) {
                        if (!cl_flp.scopeDefinesVariable(v)) continue;
                        newReqdLoads.remove(v);
                    }
                    reqdLoads = newReqdLoads;
                } else if (call2.requiresFrame()) {
                    reqdLoads.clear();
                }
            }
            for (Variable x : i.getUsedVariables()) {
                if (!(x instanceof LocalVariable) && !(x instanceof SelfVariable)) continue;
                reqdLoads.add(x);
            }
        }
        if (this._bb == this._prob.getCFG().getEntryBB()) {
            reqdLoads.clear();
        }
        if (((Object)this._outReqdLoads).equals(reqdLoads)) {
            return false;
        }
        this._outReqdLoads = reqdLoads;
        return true;
    }

    public String toString() {
        return "";
    }

    public void addLoads() {
        FrameLoadPlacementProblem flp = (FrameLoadPlacementProblem)this._prob;
        IR_ExecutionScope s = flp.getCFG().getScope();
        List<IR_Instr> instrs = this._bb.getInstrs();
        ListIterator<IR_Instr> it = instrs.listIterator(instrs.size());
        HashSet<Variable> reqdLoads = new HashSet<Variable>(this._inReqdLoads);
        while (it.hasPrevious()) {
            IR_Instr i = it.previous();
            if (i._op == Operation.FRAME_STORE) continue;
            Variable r = i.getResult();
            if (r != null) {
                reqdLoads.remove(r);
            }
            if (i instanceof CallInstruction) {
                CallInstruction call2 = (CallInstruction)i;
                Operand o = call2.getClosureArg();
                if (o != null && o instanceof MetaObject) {
                    CFG cl_cfg = ((IR_Closure)((MetaObject)o)._scope).getCFG();
                    FrameLoadPlacementProblem cl_flp = (FrameLoadPlacementProblem)cl_cfg.getDataFlowSolution(flp.getName());
                    HashSet<Variable> newReqdLoads = new HashSet<Variable>(reqdLoads);
                    it.next();
                    for (Variable v : reqdLoads) {
                        if (!cl_flp.scopeDefinesVariable(v)) continue;
                        it.add(new LOAD_FROM_FRAME_Instr(v, s, v.getName()));
                        it.previous();
                        newReqdLoads.remove(v);
                    }
                    it.previous();
                    reqdLoads = newReqdLoads;
                    ((FrameLoadPlacementProblem)cl_cfg.getDataFlowSolution(flp.getName())).addLoads();
                } else if (call2.requiresFrame()) {
                    it.next();
                    for (Variable v : reqdLoads) {
                        it.add(new LOAD_FROM_FRAME_Instr(v, s, v.getName()));
                        it.previous();
                    }
                    it.previous();
                    reqdLoads.clear();
                }
            }
            for (Variable x : i.getUsedVariables()) {
                if (!(x instanceof LocalVariable) && !(x instanceof SelfVariable)) continue;
                reqdLoads.add(x);
            }
        }
        if (s instanceof IR_Closure && this._bb == this._prob.getCFG().getEntryBB()) {
            for (Variable v : reqdLoads) {
                if (!flp.scopeUsesVariable(v)) continue;
                it.add(new LOAD_FROM_FRAME_Instr(v, s, v.getName()));
            }
        }
    }
}

