/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;

@JRubyClass(name={"Proc"})
public class RubyProc
extends RubyObject
implements DataType {
    private Block block = Block.NULL_BLOCK;
    private Block.Type type;
    private String file;
    private int line;
    private static ObjectAllocator PROC_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            RubyProc instance = RubyProc.newProc(runtime2, Block.Type.PROC);
            instance.setMetaClass(klass);
            return instance;
        }
    };

    public RubyProc(Ruby runtime2, RubyClass rubyClass, Block.Type type2) {
        super(runtime2, rubyClass);
        this.type = type2;
    }

    public static RubyClass createProcClass(Ruby runtime2) {
        RubyClass procClass = runtime2.defineClass("Proc", runtime2.getObject(), PROC_ALLOCATOR);
        runtime2.setProc(procClass);
        procClass.index = 33;
        procClass.setReifiedClass(RubyProc.class);
        procClass.defineAnnotatedMethods(RubyProc.class);
        return procClass;
    }

    public Block getBlock() {
        return this.block;
    }

    public static RubyProc newProc(Ruby runtime2, Block.Type type2) {
        return new RubyProc(runtime2, runtime2.getProc(), type2);
    }

    public static RubyProc newProc(Ruby runtime2, Block block, Block.Type type2) {
        RubyProc proc2 = new RubyProc(runtime2, runtime2.getProc(), type2);
        proc2.callInit(NULL_ARRAY, block);
        return proc2;
    }

    @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            block = context.getPreviousFrame().getBlock();
        }
        if (block.isGiven() && block.getProcObject() != null) {
            return block.getProcObject();
        }
        IRubyObject obj = ((RubyClass)recv2).allocate();
        obj.callMethod(context, "initialize", args2, block);
        return obj;
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block procBlock) {
        if (!procBlock.isGiven()) {
            throw this.getRuntime().newArgumentError("tried to create Proc object without a block");
        }
        if (this.type != Block.Type.LAMBDA || procBlock == null) {
            // empty if block
        }
        this.block = procBlock.cloneBlock();
        if (this.type == Block.Type.THREAD) {
            StaticScope oldScope = this.block.getBody().getStaticScope();
            BlockStaticScope newScope = new BlockStaticScope(oldScope.getEnclosingScope(), oldScope.getVariables());
            newScope.setBackrefLastlineScope(true);
            newScope.setPreviousCRefScope(oldScope.getPreviousCRefScope());
            newScope.setModule(oldScope.getModule());
            this.block.getBody().setStaticScope(newScope);
        }
        this.block.type = this.type;
        this.block.setProcObject(this);
        this.file = context.getFile();
        this.line = context.getLine();
        return this;
    }

    @JRubyMethod(name={"clone"})
    public IRubyObject rbClone() {
        RubyProc newProc = new RubyProc(this.getRuntime(), this.getRuntime().getProc(), this.type);
        newProc.block = this.getBlock();
        newProc.file = this.file;
        newProc.line = this.line;
        return newProc;
    }

    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        RubyProc newProc = new RubyProc(this.getRuntime(), this.getRuntime().getProc(), this.type);
        newProc.block = this.getBlock();
        newProc.file = this.file;
        newProc.line = this.line;
        return newProc;
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(IRubyObject other) {
        if (!(other instanceof RubyProc)) {
            return this.getRuntime().getFalse();
        }
        if (this == other || this.block.equals(((RubyProc)other).block)) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return RubyString.newString(this.getRuntime(), "#<Proc:0x" + Integer.toString(this.block.hashCode(), 16) + "@" + this.file + ":" + (this.line + 1) + ">");
    }

    @JRubyMethod(name={"binding"})
    public IRubyObject binding() {
        return this.getRuntime().newBinding(this.block.getBinding());
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.call(context, args2, null, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2) {
        return this.call(context, args2, null, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject call19(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.call(context, args2, null, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, IRubyObject self, Block passedBlock) {
        assert (args2 != null);
        Block newBlock = this.block.cloneBlock();
        int jumpTarget = newBlock.getBinding().getFrame().getJumpTarget();
        try {
            if (self != null) {
                newBlock.getBinding().setSelf(self);
            }
            return newBlock.call(context, args2, passedBlock);
        }
        catch (JumpException.BreakJump bj) {
            return this.handleBreakJump(this.getRuntime(), newBlock, bj, jumpTarget);
        }
        catch (JumpException.ReturnJump rj) {
            return this.handleReturnJump(context, rj, jumpTarget);
        }
        catch (JumpException.RetryJump rj) {
            return this.handleRetryJump(this.getRuntime(), rj);
        }
    }

    private IRubyObject handleBreakJump(Ruby runtime2, Block newBlock, JumpException.BreakJump bj, int jumpTarget) {
        switch (newBlock.type) {
            case LAMBDA: {
                if (bj.getTarget() == jumpTarget) {
                    return (IRubyObject)bj.getValue();
                }
                throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, (IRubyObject)bj.getValue(), "unexpected break");
            }
            case PROC: {
                if (newBlock.isEscaped()) {
                    throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, (IRubyObject)bj.getValue(), "break from proc-closure");
                }
                throw bj;
            }
        }
        throw bj;
    }

    private IRubyObject handleReturnJump(ThreadContext context, JumpException.ReturnJump rj, int jumpTarget) {
        int target = rj.getTarget();
        Ruby runtime2 = context.getRuntime();
        if (target == jumpTarget && this.block.type == Block.Type.LAMBDA) {
            return (IRubyObject)rj.getValue();
        }
        if (this.type == Block.Type.THREAD) {
            throw runtime2.newThreadError("return can't jump across threads");
        }
        if (target == jumpTarget && !context.isJumpTargetAlive(target, 1)) {
            throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.RETURN, (IRubyObject)rj.getValue(), "unexpected return");
        }
        throw rj;
    }

    private IRubyObject handleRetryJump(Ruby runtime2, JumpException.RetryJump rj) {
        throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.RETRY, (IRubyObject)rj.getValue(), "retry not supported outside rescue");
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.block.arity().getValue());
    }

    @JRubyMethod(name={"to_proc"})
    public RubyProc to_proc() {
        return this;
    }
}

