/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Main;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.util.FieldAccess;
import org.jruby.ext.posix.util.Platform;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.libraries.RbConfigLibrary;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.io.ModeFlags;

public class ShellLauncher {
    private static final boolean DEBUG = false;
    private static final String PATH_ENV = "PATH";
    private static final String HOME_ENV = "HOME";
    private static final String[] DEFAULT_PATH = new String[]{"/usr/local/bin", "/usr/ucb", "/usr/bin", "/bin"};
    private static final String[] WINDOWS_EXE_SUFFIXES = new String[]{".exe", ".com", ".bat", ".cmd"};
    private static final String[] WINDOWS_INTERNAL_CMDS = new String[]{"assoc", "break", "call", "cd", "chcp", "chdir", "cls", "color", "copy", "ctty", "date", "del", "dir", "echo", "endlocal", "erase", "exit", "for", "ftype", "goto", "if", "lfnfor", "lh", "lock", "md", "mkdir", "move", "path", "pause", "popd", "prompt", "pushd", "rd", "rem", "ren", "rename", "rmdir", "set", "setlocal", "shift", "start", "time", "title", "truename", "type", "unlock", "ver", "verify", "vol"};
    private static final Pattern SHELL_METACHARACTER_PATTERN = Pattern.compile("[*?{}\\[\\]<>()~&|$;'`\\\\\"\\n]");
    private static final Pattern WIN_ENVVAR_PATTERN = Pattern.compile("%\\w+%");
    private static final Class UNIXProcess;
    private static final Field UNIXProcess_pid;
    private static final Class ProcessImpl;
    private static final Field ProcessImpl_handle;
    private static final PidGetter PID_GETTER;

    private static String[] getCurrentEnv(Ruby runtime2) {
        RubyHash hash2 = (RubyHash)runtime2.getObject().fastGetConstant("ENV");
        String[] ret = new String[hash2.size()];
        int i = 0;
        for (Map.Entry e : hash2.directEntrySet()) {
            ret[i] = e.getKey().toString() + "=" + e.getValue().toString();
            ++i;
        }
        return ret;
    }

    private static boolean filenameIsPathSearchable(String fname, boolean forExec) {
        boolean isSearchable = true;
        if (fname.startsWith("/") || fname.startsWith("./") || fname.startsWith("../") || forExec && fname.indexOf("/") != -1) {
            isSearchable = false;
        }
        if (Platform.IS_WINDOWS && (fname.startsWith("\\") || fname.startsWith(".\\") || fname.startsWith("..\\") || fname.length() > 2 && fname.startsWith(":", 1) || forExec && fname.indexOf("\\") != -1)) {
            isSearchable = false;
        }
        return isSearchable;
    }

    private static File tryFile(Ruby runtime2, String fdir, String fname) {
        File pathFile = fdir == null ? new File(fname) : new File(fdir, fname);
        if (!pathFile.isAbsolute()) {
            pathFile = new File(runtime2.getCurrentDirectory(), pathFile.getPath());
        }
        ShellLauncher.log(runtime2, "Trying file " + pathFile);
        if (pathFile.exists()) {
            return pathFile;
        }
        return null;
    }

    private static boolean withExeSuffix(String fname) {
        String lowerCaseFname = fname.toLowerCase();
        for (String suffix : WINDOWS_EXE_SUFFIXES) {
            if (!lowerCaseFname.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private static File isValidFile(Ruby runtime2, String fdir, String fname, boolean isExec) {
        File validFile = null;
        if (isExec && Platform.IS_WINDOWS) {
            if (ShellLauncher.withExeSuffix(fname)) {
                validFile = ShellLauncher.tryFile(runtime2, fdir, fname);
            } else {
                for (String suffix : WINDOWS_EXE_SUFFIXES) {
                    validFile = ShellLauncher.tryFile(runtime2, fdir, fname + suffix);
                    if (validFile == null) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            File pathFile = ShellLauncher.tryFile(runtime2, fdir, fname);
            if (pathFile != null) {
                if (isExec) {
                    if (!pathFile.isDirectory()) {
                        String pathFileStr = pathFile.getAbsolutePath();
                        POSIX posix = runtime2.getPosix();
                        if (posix.stat(pathFileStr).isExecutable()) {
                            validFile = pathFile;
                        }
                    }
                } else {
                    validFile = pathFile;
                }
            }
        }
        return validFile;
    }

    private static File isValidFile(Ruby runtime2, String fname, boolean isExec) {
        String fdir = null;
        return ShellLauncher.isValidFile(runtime2, fdir, fname, isExec);
    }

    private static File findPathFile(Ruby runtime2, String fname, String[] path2, boolean isExec) {
        File pathFile = null;
        boolean doPathSearch = ShellLauncher.filenameIsPathSearchable(fname, isExec);
        if (doPathSearch) {
            String fdir;
            String pathSeparator = System.getProperty("path.separator");
            String[] arr$ = path2;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (pathFile = ShellLauncher.isValidFile(runtime2, fdir = arr$[i$], fname, isExec)) == null; ++i$) {
            }
        } else {
            pathFile = ShellLauncher.isValidFile(runtime2, fname, isExec);
        }
        return pathFile;
    }

    private static File findPathExecutable(Ruby runtime2, String fname) {
        String path2 = System.getenv(PATH_ENV);
        String[] pathNodes = null;
        if (path2 == null) {
            pathNodes = DEFAULT_PATH;
        } else {
            String pathSeparator = System.getProperty("path.separator");
            if (Platform.IS_WINDOWS) {
                path2 = "." + pathSeparator + path2;
            }
            pathNodes = path2.split(pathSeparator);
        }
        return ShellLauncher.findPathFile(runtime2, fname, pathNodes, true);
    }

    public static int runAndWait(Ruby runtime2, IRubyObject[] rawArgs) {
        return ShellLauncher.runAndWait(runtime2, rawArgs, runtime2.getOutputStream());
    }

    public static long runWithoutWait(Ruby runtime2, IRubyObject[] rawArgs) {
        return ShellLauncher.runWithoutWait(runtime2, rawArgs, runtime2.getOutputStream());
    }

    public static int execAndWait(Ruby runtime2, IRubyObject[] rawArgs) {
        File pwd = new File(runtime2.getCurrentDirectory());
        LaunchConfig cfg = new LaunchConfig(runtime2, rawArgs, true);
        if (cfg.shouldRunInProcess()) {
            ShellLauncher.log(runtime2, "ExecAndWait in-process");
            try {
                ScriptThreadProcess ipScript = new ScriptThreadProcess(runtime2, cfg.getExecArgs(), ShellLauncher.getCurrentEnv(runtime2), pwd, false);
                ipScript.start();
                return ipScript.waitFor();
            }
            catch (IOException e) {
                throw runtime2.newIOErrorFromException(e);
            }
            catch (InterruptedException e) {
                throw runtime2.newThreadError("unexpected interrupt");
            }
        }
        return ShellLauncher.runAndWait(runtime2, rawArgs);
    }

    public static int runAndWait(Ruby runtime2, IRubyObject[] rawArgs, OutputStream output) {
        return ShellLauncher.runAndWait(runtime2, rawArgs, output, true);
    }

    public static int runAndWait(Ruby runtime2, IRubyObject[] rawArgs, OutputStream output, boolean doExecutableSearch) {
        PrintStream error2 = runtime2.getErrorStream();
        InputStream input = runtime2.getInputStream();
        try {
            Process aProcess = ShellLauncher.run(runtime2, rawArgs, doExecutableSearch);
            ShellLauncher.handleStreams(runtime2, aProcess, input, output, error2);
            return aProcess.waitFor();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw runtime2.newThreadError("unexpected interrupt");
        }
    }

    public static long runWithoutWait(Ruby runtime2, IRubyObject[] rawArgs, OutputStream output) {
        try {
            POpenProcess aProcess = new POpenProcess(ShellLauncher.popenShared(runtime2, rawArgs));
            return ShellLauncher.getPidFromProcess(aProcess);
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
    }

    public static long getPidFromProcess(Process process) {
        if (process instanceof ScriptThreadProcess) {
            return process.hashCode();
        }
        if (process instanceof POpenProcess) {
            return ShellLauncher.reflectPidFromProcess(((POpenProcess)process).getChild());
        }
        return ShellLauncher.reflectPidFromProcess(process);
    }

    public static long reflectPidFromProcess(Process process) {
        return PID_GETTER.getPid(process);
    }

    public static Process run(Ruby runtime2, IRubyObject string2) throws IOException {
        return ShellLauncher.run(runtime2, new IRubyObject[]{string2}, false);
    }

    public static POpenProcess popen(Ruby runtime2, IRubyObject string2, ModeFlags modes) throws IOException {
        return new POpenProcess(ShellLauncher.popenShared(runtime2, new IRubyObject[]{string2}), runtime2, modes);
    }

    public static POpenProcess popen3(Ruby runtime2, IRubyObject[] strings) throws IOException {
        return new POpenProcess(ShellLauncher.popenShared(runtime2, strings));
    }

    private static Process popenShared(Ruby runtime2, IRubyObject[] strings) throws IOException {
        String shell = ShellLauncher.getShell(runtime2);
        Process childProcess = null;
        File pwd = new File(runtime2.getCurrentDirectory());
        try {
            if (strings.length == 1) {
                String[] argArray = new String[]{shell, shell.endsWith("sh") ? "-c" : "/c", strings[0].asJavaString()};
                childProcess = Runtime.getRuntime().exec(argArray, ShellLauncher.getCurrentEnv(runtime2), pwd);
            } else {
                String[] args2 = ShellLauncher.parseCommandLine(runtime2.getCurrentContext(), runtime2, strings);
                childProcess = Runtime.getRuntime().exec(args2, ShellLauncher.getCurrentEnv(runtime2), pwd);
            }
        }
        catch (SecurityException se) {
            throw runtime2.newSecurityError(se.getLocalizedMessage());
        }
        return childProcess;
    }

    public static OutputStream unwrapBufferedStream(OutputStream filteredStream) {
        if (RubyInstanceConfig.NO_UNWRAP_PROCESS_STREAMS) {
            return filteredStream;
        }
        while (filteredStream instanceof FilterOutputStream) {
            try {
                filteredStream = (OutputStream)FieldAccess.getProtectedFieldValue(FilterOutputStream.class, "out", filteredStream);
            }
            catch (Exception e) {
                break;
            }
        }
        return filteredStream;
    }

    public static InputStream unwrapBufferedStream(InputStream filteredStream) {
        if (RubyInstanceConfig.NO_UNWRAP_PROCESS_STREAMS) {
            return filteredStream;
        }
        while (filteredStream instanceof FilterInputStream) {
            try {
                filteredStream = (InputStream)FieldAccess.getProtectedFieldValue(FilterInputStream.class, "in", filteredStream);
            }
            catch (Exception e) {
                break;
            }
        }
        return filteredStream;
    }

    public static Process run(Ruby runtime2, IRubyObject[] rawArgs, boolean doExecutableSearch) throws IOException {
        Process aProcess = null;
        File pwd = new File(runtime2.getCurrentDirectory());
        LaunchConfig cfg = new LaunchConfig(runtime2, rawArgs, doExecutableSearch);
        try {
            if (cfg.shouldRunInProcess()) {
                ShellLauncher.log(runtime2, "Launching in-process");
                ScriptThreadProcess ipScript = new ScriptThreadProcess(runtime2, cfg.getExecArgs(), ShellLauncher.getCurrentEnv(runtime2), pwd);
                ipScript.start();
                return ipScript;
            }
            if (cfg.shouldRunInShell()) {
                ShellLauncher.log(runtime2, "Launching with shell");
                cfg.verifyExecutableForShell();
                aProcess = Runtime.getRuntime().exec(cfg.getExecArgs(), ShellLauncher.getCurrentEnv(runtime2), pwd);
            } else {
                ShellLauncher.log(runtime2, "Launching directly (no shell)");
                cfg.verifyExecutableForDirect();
                aProcess = Runtime.getRuntime().exec(cfg.getExecArgs(), ShellLauncher.getCurrentEnv(runtime2), pwd);
            }
        }
        catch (SecurityException se) {
            throw runtime2.newSecurityError(se.getLocalizedMessage());
        }
        return aProcess;
    }

    private static void handleStreams(Ruby runtime2, Process p2, InputStream in, OutputStream out, OutputStream err) throws IOException {
        InputStream pOut = p2.getInputStream();
        InputStream pErr = p2.getErrorStream();
        OutputStream pIn = p2.getOutputStream();
        StreamPumper t1 = new StreamPumper(runtime2, pOut, out, false, Pumper.Slave.IN, p2);
        StreamPumper t2 = new StreamPumper(runtime2, pErr, err, false, Pumper.Slave.IN, p2);
        StreamPumper t3 = new StreamPumper(runtime2, in, pIn, true, Pumper.Slave.OUT, p2);
        t1.start();
        t2.start();
        t3.start();
        try {
            t1.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        try {
            t2.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        t3.quit();
        try {
            err.flush();
        }
        catch (IOException io2) {
            // empty catch block
        }
        try {
            out.flush();
        }
        catch (IOException io3) {
            // empty catch block
        }
        try {
            pIn.close();
        }
        catch (IOException io4) {
            // empty catch block
        }
        try {
            pOut.close();
        }
        catch (IOException io5) {
            // empty catch block
        }
        try {
            pErr.close();
        }
        catch (IOException io6) {
            // empty catch block
        }
        try {
            t3.interrupt();
        }
        catch (SecurityException se) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] parseCommandLine(ThreadContext context, Ruby runtime2, IRubyObject[] rawArgs) {
        String[] args2;
        if (rawArgs.length == 1) {
            LoadService loadService = runtime2.getLoadService();
            synchronized (loadService) {
                runtime2.getLoadService().require("jruby/path_helper");
            }
            RubyModule pathHelper = runtime2.getClassFromPath("JRuby::PathHelper");
            RubyArray parts = (RubyArray)RuntimeHelpers.invoke(context, (IRubyObject)pathHelper, "smart_split_command", rawArgs);
            args2 = new String[parts.getLength()];
            for (int i = 0; i < parts.getLength(); ++i) {
                args2[i] = parts.entry(i).toString();
            }
        } else {
            args2 = new String[rawArgs.length];
            for (int i = 0; i < rawArgs.length; ++i) {
                args2[i] = rawArgs[i].toString();
            }
        }
        return args2;
    }

    private static String getShell(Ruby runtime2) {
        return RbConfigLibrary.jrubyShell();
    }

    static void log(Ruby runtime2, String msg) {
        if (RubyInstanceConfig.DEBUG_LAUNCHING) {
            runtime2.getErr().println("ShellLauncher: " + msg);
        }
    }

    static {
        PidGetter pg = new PidGetter(){

            public long getPid(Process process) {
                return process.hashCode();
            }
        };
        Class<?> up = null;
        Field pid2 = null;
        try {
            up = Class.forName("java.lang.UNIXProcess");
            pid2 = up.getDeclaredField("pid");
            pid2.setAccessible(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        UNIXProcess = up;
        UNIXProcess_pid = pid2;
        Class<?> pi = null;
        Field handle = null;
        try {
            pi = Class.forName("java.lang.ProcessImpl");
            handle = pi.getDeclaredField("handle");
            handle.setAccessible(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        ProcessImpl = pi;
        ProcessImpl_handle = handle;
        pg = UNIXProcess_pid != null ? (ProcessImpl_handle != null ? new PidGetter(){

            public long getPid(Process process) {
                try {
                    if (UNIXProcess.isInstance(process)) {
                        return ((Integer)UNIXProcess_pid.get(process)).intValue();
                    }
                    if (ProcessImpl.isInstance(process)) {
                        return (Long)ProcessImpl_handle.get(process);
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return process.hashCode();
            }
        } : new PidGetter(){

            public long getPid(Process process) {
                try {
                    if (UNIXProcess.isInstance(process)) {
                        return ((Integer)UNIXProcess_pid.get(process)).intValue();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return process.hashCode();
            }
        }) : (ProcessImpl_handle != null ? new PidGetter(){

            public long getPid(Process process) {
                try {
                    if (ProcessImpl.isInstance(process)) {
                        return (Long)ProcessImpl_handle.get(process);
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return process.hashCode();
            }
        } : new PidGetter(){

            public long getPid(Process process) {
                return process.hashCode();
            }
        });
        PID_GETTER = pg;
    }

    private static class ChannelPumper
    extends Thread
    implements Pumper {
        private final FileChannel inChannel;
        private final FileChannel outChannel;
        private final Pumper.Slave slave;
        private final Object sync;
        private volatile boolean quit;
        private final Ruby runtime;

        ChannelPumper(Ruby runtime2, FileChannel inChannel, FileChannel outChannel, Pumper.Slave slave, Object sync2) {
            this.inChannel = inChannel;
            this.outChannel = outChannel;
            this.slave = slave;
            this.sync = sync2;
            this.runtime = runtime2;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.runtime.getCurrentContext().setEventHooksEnabled(false);
            ByteBuffer buf = ByteBuffer.allocateDirect(1024);
            buf.clear();
            try {
                while (!this.quit && this.inChannel.isOpen() && this.outChannel.isOpen()) {
                    int read2 = this.inChannel.read(buf);
                    if (read2 == -1) {
                        break;
                    }
                    buf.flip();
                    this.outChannel.write(buf);
                    buf.clear();
                }
            }
            catch (Exception exception2) {
                Object object = this.sync;
                synchronized (object) {
                    switch (this.slave) {
                        case OUT: {
                            try {
                                this.outChannel.close();
                            }
                            catch (IOException ioe) {}
                            break;
                        }
                        case IN: {
                            try {
                                this.inChannel.close();
                                break;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            finally {
                Object read2 = this.sync;
                synchronized (read2) {
                    switch (this.slave) {
                        case OUT: {
                            try {
                                this.outChannel.close();
                            }
                            catch (IOException ioe) {}
                            break;
                        }
                        case IN: {
                            try {
                                this.inChannel.close();
                                break;
                            }
                            catch (IOException ioe) {}
                        }
                    }
                }
            }
        }

        public void quit() {
            this.interrupt();
            this.quit = true;
        }
    }

    private static class StreamPumper
    extends Thread
    implements Pumper {
        private final InputStream in;
        private final OutputStream out;
        private final boolean onlyIfAvailable;
        private final Object waitLock = new Object();
        private final Object sync;
        private final Pumper.Slave slave;
        private volatile boolean quit;
        private final Ruby runtime;

        StreamPumper(Ruby runtime2, InputStream in, OutputStream out, boolean avail, Pumper.Slave slave, Object sync2) {
            this.in = ShellLauncher.unwrapBufferedStream(in);
            this.out = ShellLauncher.unwrapBufferedStream(out);
            this.onlyIfAvailable = avail;
            this.slave = slave;
            this.sync = sync2;
            this.runtime = runtime2;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block30: {
                Object object;
                this.runtime.getCurrentContext().setEventHooksEnabled(false);
                byte[] buf = new byte[1024];
                boolean hasReadSomething = false;
                try {
                    while (!this.quit) {
                        int numRead;
                        if (this.onlyIfAvailable && !hasReadSomething) {
                            if (this.in.available() == 0) {
                                object = this.waitLock;
                                synchronized (object) {
                                    this.waitLock.wait(10L);
                                    continue;
                                }
                            }
                            hasReadSomething = true;
                        }
                        if ((numRead = this.in.read(buf)) == -1) {
                            break;
                        }
                        this.out.write(buf, 0, numRead);
                    }
                }
                catch (Exception exception2) {
                    if (!this.onlyIfAvailable) break block30;
                    Object object2 = this.sync;
                    synchronized (object2) {
                        if (this.slave == Pumper.Slave.OUT) {
                            try {
                                this.out.close();
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                    }
                }
                finally {
                    if (this.onlyIfAvailable) {
                        object = this.sync;
                        synchronized (object) {
                            if (this.slave == Pumper.Slave.OUT) {
                                try {
                                    this.out.close();
                                }
                                catch (IOException ioe) {}
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            this.quit = true;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notify();
            }
        }
    }

    private static interface Pumper
    extends Runnable {
        public void start();

        public void quit();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Slave {
            IN,
            OUT;

        }
    }

    private static class LaunchConfig {
        private Ruby runtime;
        private boolean doExecutableSearch;
        private IRubyObject[] rawArgs;
        private String shell;
        private String[] args;
        private String[] execArgs;
        private boolean cmdBuiltin = false;
        private String executable;
        private File executableFile;

        LaunchConfig(Ruby runtime2, IRubyObject[] rawArgs, boolean doExecutableSearch) {
            this.runtime = runtime2;
            this.rawArgs = rawArgs;
            this.doExecutableSearch = doExecutableSearch;
            this.shell = ShellLauncher.getShell(runtime2);
            this.args = ShellLauncher.parseCommandLine(runtime2.getCurrentContext(), runtime2, rawArgs);
        }

        private boolean shouldRunInProcess() {
            int startIndex;
            String[] slashDelimitedTokens;
            String finalToken;
            boolean inProc;
            if (!this.runtime.getInstanceConfig().isRunRubyInProcess()) {
                return false;
            }
            for (int i = 0; i < this.args.length; ++i) {
                String c = this.args[i];
                if (c.trim().length() == 0) continue;
                char[] firstLast = new char[]{c.charAt(0), c.charAt(c.length() - 1)};
                block5: for (int j = 0; j < firstLast.length; ++j) {
                    switch (firstLast[j]) {
                        case '\n': 
                        case '\"': 
                        case '$': 
                        case '&': 
                        case '\'': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case ';': 
                        case '<': 
                        case '>': 
                        case '?': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '`': 
                        case '{': 
                        case '|': 
                        case '}': 
                        case '~': {
                            return false;
                        }
                        case '2': {
                            if (c.length() <= 1 || c.charAt(1) != '>') continue block5;
                            return false;
                        }
                    }
                }
            }
            String command = this.args[0];
            if (Platform.IS_WINDOWS) {
                command = command.toLowerCase();
            }
            boolean bl = inProc = (finalToken = (slashDelimitedTokens = command.split("[/\\\\]"))[slashDelimitedTokens.length - 1]).endsWith("ruby") || Platform.IS_WINDOWS && finalToken.endsWith("ruby.exe") || finalToken.endsWith(".rb") || finalToken.endsWith("irb");
            if (!inProc) {
                return false;
            }
            int n = startIndex = command.endsWith(".rb") ? 0 : 1;
            if (command.trim().endsWith("irb")) {
                startIndex = 0;
                this.args[0] = this.runtime.getJRubyHome() + File.separator + "bin" + File.separator + "jirb";
            }
            this.execArgs = new String[this.args.length - startIndex];
            System.arraycopy(this.args, startIndex, this.execArgs, 0, this.execArgs.length);
            return true;
        }

        private boolean shouldRunInShell() {
            if (this.rawArgs.length != 1) {
                return false;
            }
            if (!Platform.IS_WINDOWS) {
                return true;
            }
            if (this.shell == null) {
                return false;
            }
            for (String arg2 : this.args) {
                if (LaunchConfig.shouldVerifyPathExecutable(arg2.trim())) continue;
                return true;
            }
            this.executable = this.args[0].trim();
            this.executableFile = ShellLauncher.findPathExecutable(this.runtime, this.executable);
            if (this.executableFile != null) {
                ShellLauncher.log(this.runtime, "Got it: " + this.executableFile);
                return false;
            }
            ShellLauncher.log(this.runtime, "Didn't find executable: " + this.executable);
            if (this.isCmdBuiltin(this.executable)) {
                this.cmdBuiltin = true;
                return true;
            }
            return false;
        }

        private void verifyExecutableForShell() {
            String cmdline = this.rawArgs[0].toString().trim();
            if (this.doExecutableSearch && LaunchConfig.shouldVerifyPathExecutable(cmdline) && !this.cmdBuiltin) {
                this.verifyExecutable();
            }
            this.execArgs = new String[3];
            this.execArgs[0] = this.shell;
            this.execArgs[1] = this.shell.endsWith("sh") ? "-c" : "/c";
            this.execArgs[2] = Platform.IS_WINDOWS ? "\"" + cmdline + "\"" : cmdline;
        }

        private void verifyExecutableForDirect() {
            this.verifyExecutable();
            this.execArgs = this.args;
            try {
                this.execArgs[0] = this.executableFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void verifyExecutable() {
            if (this.executableFile == null) {
                if (this.executable == null) {
                    this.executable = this.args[0].trim();
                }
                this.executableFile = ShellLauncher.findPathExecutable(this.runtime, this.executable);
            }
            if (this.executableFile == null) {
                throw this.runtime.newErrnoENOENTError(this.executable);
            }
        }

        private String[] getExecArgs() {
            return this.execArgs;
        }

        private static boolean isBatch(File f) {
            String path2 = f.getPath();
            return path2.endsWith(".bat") || path2.endsWith(".cmd");
        }

        private boolean isCmdBuiltin(String cmd) {
            int idx;
            if (!this.shell.endsWith("sh") && (idx = Arrays.binarySearch(WINDOWS_INTERNAL_CMDS, cmd.toLowerCase())) >= 0) {
                ShellLauncher.log(this.runtime, "Found Windows shell's built-in command: " + cmd);
                return true;
            }
            return false;
        }

        private static boolean hasRedirection(String cmdline) {
            if (Platform.IS_WINDOWS) {
                char quote2 = '\u0000';
                int idx = 0;
                block6: while (idx < cmdline.length()) {
                    char ptr = cmdline.charAt(idx);
                    switch (ptr) {
                        case '\"': 
                        case '\'': {
                            if (quote2 == '\u0000') {
                                quote2 = ptr;
                            } else if (quote2 == ptr) {
                                quote2 = '\u0000';
                            }
                            ++idx;
                            continue block6;
                        }
                        case '\n': 
                        case '<': 
                        case '>': 
                        case '|': {
                            if (quote2 == '\u0000') {
                                return true;
                            }
                            ++idx;
                            continue block6;
                        }
                        case '%': {
                            Matcher envVarMatcher = WIN_ENVVAR_PATTERN.matcher(cmdline.substring(idx));
                            if (envVarMatcher.find()) {
                                return true;
                            }
                            ++idx;
                            continue block6;
                        }
                        case '\\': {
                            ++idx;
                        }
                    }
                    ++idx;
                }
                return false;
            }
            Matcher metaMatcher = SHELL_METACHARACTER_PATTERN.matcher(cmdline);
            return metaMatcher.find();
        }

        private static boolean shouldVerifyPathExecutable(String cmdline) {
            boolean verifyPathExecutable = true;
            if (LaunchConfig.hasRedirection(cmdline)) {
                return false;
            }
            return verifyPathExecutable;
        }
    }

    public static class POpenProcess
    extends Process {
        private final Process child;
        private InputStream realInput;
        private OutputStream realOutput;
        private InputStream realInerr;
        private InputStream input;
        private OutputStream output;
        private InputStream inerr;
        private FileChannel inputChannel;
        private FileChannel outputChannel;
        private FileChannel inerrChannel;
        private Pumper inputPumper;
        private Pumper inerrPumper;
        private Pumper outputPumper;

        public POpenProcess(Process child, Ruby runtime2, ModeFlags modes) {
            this.child = child;
            if (modes.isWritable()) {
                this.prepareOutput(child);
            } else {
                try {
                    child.getOutputStream().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (modes.isReadable()) {
                this.prepareInput(child);
            } else {
                this.pumpInput(child, runtime2);
            }
            this.pumpInerr(child, runtime2);
        }

        public POpenProcess(Process child) {
            this.child = child;
            this.prepareOutput(child);
            this.prepareInput(child);
            this.prepareInerr(child);
        }

        public OutputStream getOutputStream() {
            return this.output;
        }

        public InputStream getInputStream() {
            return this.input;
        }

        public InputStream getErrorStream() {
            return this.inerr;
        }

        public FileChannel getInput() {
            return this.inputChannel;
        }

        public FileChannel getOutput() {
            return this.outputChannel;
        }

        public FileChannel getError() {
            return this.inerrChannel;
        }

        public boolean hasOutput() {
            return this.output != null || this.outputChannel != null;
        }

        public Process getChild() {
            return this.child;
        }

        public int waitFor() throws InterruptedException {
            if (this.outputPumper == null) {
                try {
                    if (this.output != null) {
                        this.output.close();
                    }
                }
                catch (IOException ioe) {}
            } else {
                this.outputPumper.quit();
            }
            int result = this.child.waitFor();
            return result;
        }

        public int exitValue() {
            return this.child.exitValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            try {
                if (this.input != null) {
                    this.input.close();
                }
                if (this.inerr != null) {
                    this.inerr.close();
                }
                if (this.output != null) {
                    this.output.close();
                }
                if (this.inputChannel != null) {
                    this.inputChannel.close();
                }
                if (this.inerrChannel != null) {
                    this.inerrChannel.close();
                }
                if (this.outputChannel != null) {
                    this.outputChannel.close();
                }
                POpenProcess pOpenProcess = this;
                synchronized (pOpenProcess) {
                    Pumper pumper;
                    RubyIO.obliterateProcess(this.child);
                    if (this.inputPumper != null) {
                        pumper = this.inputPumper;
                        synchronized (pumper) {
                            this.inputPumper.quit();
                        }
                    }
                    if (this.inerrPumper != null) {
                        pumper = this.inerrPumper;
                        synchronized (pumper) {
                            this.inerrPumper.quit();
                        }
                    }
                    if (this.outputPumper != null) {
                        pumper = this.outputPumper;
                        synchronized (pumper) {
                            this.outputPumper.quit();
                        }
                    }
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        private void prepareInput(Process child) {
            this.realInput = child.getInputStream();
            this.input = ShellLauncher.unwrapBufferedStream(this.realInput);
            this.inputChannel = this.input instanceof FileInputStream ? ((FileInputStream)this.input).getChannel() : null;
            this.inputPumper = null;
        }

        private void prepareInerr(Process child) {
            this.realInerr = child.getErrorStream();
            this.inerr = ShellLauncher.unwrapBufferedStream(this.realInerr);
            this.inerrChannel = this.inerr instanceof FileInputStream ? ((FileInputStream)this.inerr).getChannel() : null;
            this.inerrPumper = null;
        }

        private void prepareOutput(Process child) {
            this.realOutput = child.getOutputStream();
            this.output = ShellLauncher.unwrapBufferedStream(this.realOutput);
            this.outputChannel = this.output instanceof FileOutputStream ? ((FileOutputStream)this.output).getChannel() : null;
            this.outputPumper = null;
        }

        private void pumpInput(Process child, Ruby runtime2) {
            InputStream childIn = ShellLauncher.unwrapBufferedStream(child.getInputStream());
            FileChannel childInChannel = null;
            if (childIn instanceof FileInputStream) {
                childInChannel = ((FileInputStream)childIn).getChannel();
            }
            OutputStream parentOut = ShellLauncher.unwrapBufferedStream(runtime2.getOut());
            FileChannel parentOutChannel = null;
            if (parentOut instanceof FileOutputStream) {
                parentOutChannel = ((FileOutputStream)parentOut).getChannel();
            }
            this.inputPumper = childInChannel != null && parentOutChannel != null ? new ChannelPumper(runtime2, childInChannel, parentOutChannel, Pumper.Slave.IN, this) : new StreamPumper(runtime2, childIn, parentOut, false, Pumper.Slave.IN, this);
            this.inputPumper.start();
            this.input = null;
            this.inputChannel = null;
        }

        private void pumpInerr(Process child, Ruby runtime2) {
            InputStream childIn = ShellLauncher.unwrapBufferedStream(child.getErrorStream());
            FileChannel childInChannel = null;
            if (childIn instanceof FileInputStream) {
                childInChannel = ((FileInputStream)childIn).getChannel();
            }
            OutputStream parentOut = ShellLauncher.unwrapBufferedStream(runtime2.getOut());
            FileChannel parentOutChannel = null;
            if (parentOut instanceof FileOutputStream) {
                parentOutChannel = ((FileOutputStream)parentOut).getChannel();
            }
            this.inerrPumper = childInChannel != null && parentOutChannel != null ? new ChannelPumper(runtime2, childInChannel, parentOutChannel, Pumper.Slave.IN, this) : new StreamPumper(runtime2, childIn, parentOut, false, Pumper.Slave.IN, this);
            this.inerrPumper.start();
            this.inerr = null;
            this.inerrChannel = null;
        }
    }

    private static interface PidGetter {
        public long getPid(Process var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScriptThreadProcess
    extends Process
    implements Runnable {
        private final String[] argArray;
        private final String[] env;
        private final File pwd;
        private final boolean pipedStreams;
        private final PipedInputStream processOutput;
        private final PipedInputStream processError;
        private final PipedOutputStream processInput;
        private RubyInstanceConfig config;
        private Thread processThread;
        private int result;
        private Ruby parentRuntime;

        public ScriptThreadProcess(Ruby parentRuntime, String[] argArray, String[] env, File dir) {
            this(parentRuntime, argArray, env, dir, true);
        }

        public ScriptThreadProcess(Ruby parentRuntime, String[] argArray, String[] env, File dir, boolean pipedStreams) {
            this.parentRuntime = parentRuntime;
            this.argArray = argArray;
            this.env = env;
            this.pwd = dir;
            this.pipedStreams = pipedStreams;
            if (pipedStreams) {
                this.processOutput = new PipedInputStream();
                this.processError = new PipedInputStream();
                this.processInput = new PipedOutputStream();
            } else {
                this.processError = null;
                this.processOutput = null;
                this.processInput = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.result = new Main(this.config).run(this.argArray).getStatus();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(this.config.getError());
                this.result = -1;
            }
            finally {
                this.config.getOutput().close();
                this.config.getError().close();
                try {
                    this.config.getInput().close();
                }
                catch (IOException ioe) {}
            }
        }

        private Map<String, String> environmentMap(String[] env) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = 0; i < env.length; ++i) {
                String[] kv = env[i].split("=", 2);
                m.put(kv[0], kv[1]);
            }
            return m;
        }

        public void start() throws IOException {
            this.config = new RubyInstanceConfig(this.parentRuntime.getInstanceConfig()){
                {
                    this.setEnvironment(ScriptThreadProcess.this.environmentMap(ScriptThreadProcess.this.env));
                    this.setCurrentDirectory(ScriptThreadProcess.this.pwd.toString());
                }
            };
            if (this.pipedStreams) {
                this.config.setInput(new PipedInputStream(this.processInput));
                this.config.setOutput(new PrintStream(new PipedOutputStream(this.processOutput)));
                this.config.setError(new PrintStream(new PipedOutputStream(this.processError)));
            }
            String procName = "piped";
            if (this.argArray.length > 0) {
                procName = this.argArray[0];
            }
            this.processThread = new Thread((Runnable)this, "ScriptThreadProcess: " + procName);
            this.processThread.setDaemon(true);
            this.processThread.start();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.processInput;
        }

        @Override
        public InputStream getInputStream() {
            return this.processOutput;
        }

        @Override
        public InputStream getErrorStream() {
            return this.processError;
        }

        @Override
        public int waitFor() throws InterruptedException {
            this.processThread.join();
            return this.result;
        }

        @Override
        public int exitValue() {
            return this.result;
        }

        @Override
        public void destroy() {
            if (this.pipedStreams) {
                this.closeStreams();
            }
            this.processThread.interrupt();
        }

        private void closeStreams() {
            try {
                this.processInput.close();
            }
            catch (IOException io2) {
                // empty catch block
            }
            try {
                this.processOutput.close();
            }
            catch (IOException io3) {
                // empty catch block
            }
            try {
                this.processError.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

