/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.util.HandleFactory;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Java::JavaMethod"})
public class JavaMethod
extends JavaCallable {
    private static final boolean USE_HANDLES = RubyInstanceConfig.USE_GENERATED_HANDLES;
    private static final boolean HANDLE_DEBUG = false;
    private final Method method;
    private final HandleFactory.Handle handle;
    private final JavaUtil.JavaConverter returnConverter;

    public Object getValue() {
        return this.method;
    }

    public static RubyClass createJavaMethodClass(Ruby runtime2, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaMethod", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaAccessibleObject.registerRubyMethods(runtime2, result);
        JavaCallable.registerRubyMethods(runtime2, result);
        result.defineAnnotatedMethods(JavaMethod.class);
        return result;
    }

    public JavaMethod(Ruby runtime2, Method method2) {
        super(runtime2, runtime2.getJavaSupport().getJavaMethodClass(), method2.getParameterTypes());
        this.method = method2;
        boolean methodIsPublic = Modifier.isPublic(method2.getModifiers());
        boolean classIsPublic = Modifier.isPublic(method2.getDeclaringClass().getModifiers());
        if (methodIsPublic && !classIsPublic) {
            Method newMethod = method2;
            block6: for (Class<?> newClass = method2.getDeclaringClass(); newClass != null; newClass = newClass.getSuperclass()) {
                try {
                    newMethod = newClass.getMethod(method2.getName(), method2.getParameterTypes());
                    if (Modifier.isPublic(newMethod.getDeclaringClass().getModifiers())) {
                        break;
                    }
                }
                catch (NoSuchMethodException nsme) {
                    // empty catch block
                }
                for (Class<?> ifc : newClass.getInterfaces()) {
                    try {
                        newMethod = ifc.getMethod(method2.getName(), method2.getParameterTypes());
                        break block6;
                    }
                    catch (NoSuchMethodException nsme) {
                    }
                }
                newMethod = null;
            }
            if (newMethod != null) {
                method2 = newMethod;
                methodIsPublic = Modifier.isPublic(method2.getModifiers());
                classIsPublic = Modifier.isPublic(method2.getDeclaringClass().getModifiers());
            }
        }
        HandleFactory.Handle tmpHandle = null;
        try {
            tmpHandle = USE_HANDLES && methodIsPublic && classIsPublic && runtime2.getJRubyClassLoader().loadClass(method2.getDeclaringClass().getCanonicalName()) == method2.getDeclaringClass() ? HandleFactory.createHandle(runtime2.getJRubyClassLoader(), method2) : null;
        }
        catch (ClassNotFoundException cnfe) {
            tmpHandle = null;
        }
        if (tmpHandle == null) {
            // empty if block
        }
        this.handle = tmpHandle;
        if (methodIsPublic && !Modifier.isPublic(method2.getDeclaringClass().getModifiers())) {
            this.accessibleObject().setAccessible(true);
        }
        this.returnConverter = JavaUtil.getJavaConverter(method2.getReturnType());
    }

    public static JavaMethod create(Ruby runtime2, Method method2) {
        return new JavaMethod(runtime2, method2);
    }

    public static JavaMethod create(Ruby runtime2, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        try {
            Method method2 = javaClass.getMethod(methodName, argumentTypes);
            return JavaMethod.create(runtime2, method2);
        }
        catch (NoSuchMethodException e) {
            throw runtime2.newNameError("undefined method '" + methodName + "' for class '" + javaClass.getName() + "'", methodName);
        }
    }

    public static JavaMethod createDeclared(Ruby runtime2, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        try {
            return JavaMethod.create(runtime2, javaClass.getDeclaredMethod(methodName, argumentTypes));
        }
        catch (NoSuchMethodException e) {
            throw runtime2.newNameError("undefined method '" + methodName + "' for class '" + javaClass.getName() + "'", methodName);
        }
    }

    public static JavaMethod getMatchingDeclaredMethod(Ruby runtime2, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        try {
            return JavaMethod.create(runtime2, javaClass.getDeclaredMethod(methodName, argumentTypes));
        }
        catch (NoSuchMethodException e) {
            block2: for (Method method2 : javaClass.getDeclaredMethods()) {
                if (!method2.getName().equals(methodName)) continue;
                Class<?>[] targetTypes = method2.getParameterTypes();
                if (targetTypes.length == 0 && argumentTypes.length == 0) {
                    return JavaMethod.create(runtime2, method2);
                }
                for (int i = 0; i < argumentTypes.length; ++i) {
                    if (i >= targetTypes.length || !targetTypes[i].isAssignableFrom(argumentTypes[i])) continue block2;
                }
                return JavaMethod.create(runtime2, method2);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaMethod && this.method == ((JavaMethod)other).method;
    }

    @Override
    public int hashCode() {
        return this.method.hashCode();
    }

    @Override
    @JRubyMethod
    public RubyString name() {
        return this.getRuntime().newString(this.method.getName());
    }

    @Override
    public int getArity() {
        return this.parameterTypes.length;
    }

    @Override
    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.method.getModifiers()));
    }

    @JRubyMethod(name={"final?"})
    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.method.getModifiers()));
    }

    @JRubyMethod(rest=true)
    public IRubyObject invoke(IRubyObject[] args2) {
        this.checkArity(args2.length - 1);
        Object[] arguments = new Object[args2.length - 1];
        this.convertArguments(args2, arguments, 1);
        IRubyObject invokee = args2[0];
        if (invokee.isNil()) {
            return this.invokeWithExceptionHandling(this.method, null, arguments);
        }
        Object javaInvokee = null;
        if (!this.isStatic()) {
            JavaProxyClass jpc;
            JavaProxyMethod jpm;
            javaInvokee = JavaUtil.unwrapJavaObject(this.getRuntime(), invokee, "invokee not a java object").getValue();
            if (!this.method.getDeclaringClass().isInstance(javaInvokee)) {
                throw this.getRuntime().newTypeError("invokee not instance of method's class (got" + javaInvokee.getClass().getName() + " wanted " + this.method.getDeclaringClass().getName() + ")");
            }
            if (javaInvokee instanceof InternalJavaProxy && !Modifier.isFinal(this.method.getModifiers()) && (jpm = (jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass()).getMethod(this.method.getName(), this.parameterTypes)) != null && jpm.hasSuperImplementation()) {
                return this.invokeWithExceptionHandling(jpm.getSuperMethod(), javaInvokee, arguments);
            }
        }
        return this.invokeWithExceptionHandling(this.method, javaInvokee, arguments);
    }

    @JRubyMethod(rest=true)
    public IRubyObject invoke_static(IRubyObject[] args2) {
        this.checkArity(args2.length);
        Object[] arguments = new Object[args2.length];
        System.arraycopy(args2, 0, arguments, 0, arguments.length);
        this.convertArguments(args2, arguments, 0);
        return this.invokeWithExceptionHandling(this.method, null, arguments);
    }

    @JRubyMethod
    public IRubyObject return_type() {
        Class<?> klass = this.method.getReturnType();
        if (klass.equals(Void.TYPE)) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), klass);
    }

    @JRubyMethod
    public IRubyObject type_parameters() {
        return Java.getInstance(this.getRuntime(), this.method.getTypeParameters());
    }

    public IRubyObject invokeDirect(Object javaInvokee, Object[] args2) {
        this.checkArity(args2.length);
        this.checkInstanceof(javaInvokee);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(javaInvokee, args2);
        }
        return this.invokeDirectWithExceptionHandling(this.method, javaInvokee, args2);
    }

    public IRubyObject invokeDirect(Object javaInvokee) {
        this.checkArity(0);
        this.checkInstanceof(javaInvokee);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(javaInvokee);
        }
        return this.invokeDirectWithExceptionHandling(this.method, javaInvokee);
    }

    public IRubyObject invokeDirect(Object javaInvokee, Object arg0) {
        this.checkArity(1);
        this.checkInstanceof(javaInvokee);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(javaInvokee, arg0);
        }
        return this.invokeDirectWithExceptionHandling(this.method, javaInvokee, arg0);
    }

    public IRubyObject invokeDirect(Object javaInvokee, Object arg0, Object arg1) {
        this.checkArity(2);
        this.checkInstanceof(javaInvokee);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(javaInvokee, arg0, arg1);
        }
        return this.invokeDirectWithExceptionHandling(this.method, javaInvokee, arg0, arg1);
    }

    public IRubyObject invokeDirect(Object javaInvokee, Object arg0, Object arg1, Object arg2) {
        this.checkArity(3);
        this.checkInstanceof(javaInvokee);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(javaInvokee, arg0, arg1, arg2);
        }
        return this.invokeDirectWithExceptionHandling(this.method, javaInvokee, arg0, arg1, arg2);
    }

    public IRubyObject invokeDirect(Object javaInvokee, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.checkArity(4);
        this.checkInstanceof(javaInvokee);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(javaInvokee, arg0, arg1, arg2, arg3);
        }
        return this.invokeDirectWithExceptionHandling(this.method, javaInvokee, arg0, arg1, arg2, arg3);
    }

    public IRubyObject invokeStaticDirect(Object[] args2) {
        this.checkArity(args2.length);
        return this.invokeDirectWithExceptionHandling(this.method, (Object)null, args2);
    }

    public IRubyObject invokeStaticDirect() {
        this.checkArity(0);
        return this.invokeDirectWithExceptionHandling(this.method, null);
    }

    public IRubyObject invokeStaticDirect(Object arg0) {
        this.checkArity(1);
        return this.invokeDirectWithExceptionHandling(this.method, null, arg0);
    }

    public IRubyObject invokeStaticDirect(Object arg0, Object arg1) {
        this.checkArity(2);
        return this.invokeDirectWithExceptionHandling(this.method, null, arg0, arg1);
    }

    public IRubyObject invokeStaticDirect(Object arg0, Object arg1, Object arg2) {
        this.checkArity(3);
        return this.invokeDirectWithExceptionHandling(this.method, null, arg0, arg1, arg2);
    }

    public IRubyObject invokeStaticDirect(Object arg0, Object arg1, Object arg2, Object arg3) {
        this.checkArity(4);
        return this.invokeDirectWithExceptionHandling(this.method, null, arg0, arg1, arg2, arg3);
    }

    private void checkInstanceof(Object javaInvokee) throws RaiseException {
        if (!this.method.getDeclaringClass().isInstance(javaInvokee)) {
            throw this.getRuntime().newTypeError("invokee not instance of method's class (got" + javaInvokee.getClass().getName() + " wanted " + this.method.getDeclaringClass().getName() + ")");
        }
    }

    private IRubyObject invokeWithExceptionHandling(Method method2, Object javaInvokee, Object[] arguments) {
        try {
            Object result = this.handle != null ? this.handle.invoke(javaInvokee, arguments) : method2.invoke(javaInvokee, arguments);
            return this.returnConverter.convert(this.getRuntime(), result);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(method2, iae, arguments);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(method2, iae);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(ite, method2);
        }
        catch (Throwable t) {
            return this.handleThrowable(t, method2);
        }
    }

    private IRubyObject invokeDirectSuperWithExceptionHandling(Method method2, Object javaInvokee, Object ... arguments) {
        try {
            Object result = method2.invoke(javaInvokee, arguments);
            return this.convertReturn(result);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(method2, iae, arguments);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(method2, iae);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(ite, method2);
        }
        catch (Throwable t) {
            return this.handleThrowable(t, method2);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(Method method2, Object javaInvokee, Object[] arguments) {
        try {
            Object result = this.handle != null ? this.handle.invoke(javaInvokee, arguments) : method2.invoke(javaInvokee, arguments);
            return this.convertReturn(result);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(method2, iae, arguments);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(method2, iae);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(ite, method2);
        }
        catch (Throwable t) {
            return this.handleThrowable(t, method2);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(Method method2, Object javaInvokee) {
        try {
            Object result = this.handle != null ? this.handle.invoke(javaInvokee) : method2.invoke(javaInvokee, new Object[0]);
            return this.convertReturn(result);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(method2, iae, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(method2, iae);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(ite, method2);
        }
        catch (Throwable t) {
            return this.handleThrowable(t, method2);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(Method method2, Object javaInvokee, Object arg0) {
        try {
            Object result = this.handle != null ? this.handle.invoke(javaInvokee, arg0) : method2.invoke(javaInvokee, arg0);
            return this.convertReturn(result);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(method2, iae, arg0);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(method2, iae);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(ite, method2);
        }
        catch (Throwable t) {
            return this.handleThrowable(t, method2);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(Method method2, Object javaInvokee, Object arg0, Object arg1) {
        try {
            Object result = this.handle != null ? this.handle.invoke(javaInvokee, arg0, arg1) : method2.invoke(javaInvokee, arg0, arg1);
            return this.convertReturn(result);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(method2, iae, arg0, arg1);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(method2, iae);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(ite, method2);
        }
        catch (Throwable t) {
            return this.handleThrowable(t, method2);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(Method method2, Object javaInvokee, Object arg0, Object arg1, Object arg2) {
        try {
            Object result = this.handle != null ? this.handle.invoke(javaInvokee, arg0, arg1, arg2) : method2.invoke(javaInvokee, arg0, arg1, arg2);
            return this.convertReturn(result);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(method2, iae, arg0, arg1, arg2);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(method2, iae);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(ite, method2);
        }
        catch (Throwable t) {
            return this.handleThrowable(t, method2);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(Method method2, Object javaInvokee, Object arg0, Object arg1, Object arg2, Object arg3) {
        try {
            Object result = this.handle != null ? this.handle.invoke(javaInvokee, arg0, arg1, arg2, arg3) : method2.invoke(javaInvokee, arg0, arg1, arg2, arg3);
            return this.convertReturn(result);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(method2, iae, arg0, arg1, arg2, arg3);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(method2, iae);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(ite, method2);
        }
        catch (Throwable t) {
            return this.handleThrowable(t, method2);
        }
    }

    private IRubyObject convertReturn(Object result) {
        if (result != null && result.getClass() != this.method.getReturnType()) {
            return JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), result);
        }
        return JavaUtil.convertJavaToUsableRubyObjectWithConverter(this.getRuntime(), result, this.returnConverter);
    }

    private IRubyObject handleIllegalAccessEx(Method method2, IllegalAccessException iae) throws RaiseException {
        throw this.getRuntime().newTypeError("illegal access on '" + method2.getName() + "': " + iae.getMessage());
    }

    private IRubyObject handlelIllegalArgumentEx(Method method2, IllegalArgumentException iae, Object ... arguments) throws RaiseException {
        throw this.getRuntime().newTypeError("for method " + method2.getDeclaringClass().getSimpleName() + "." + method2.getName() + " expected " + this.argument_types().inspect() + "; got: " + JavaMethod.dumpArgTypes(arguments) + "; error: " + iae.getMessage());
    }

    private void convertArguments(IRubyObject[] argsIn, Object[] argsOut, int from) {
        Class[] types = this.parameterTypes;
        int i = argsOut.length;
        while (--i >= 0) {
            argsOut[i] = argsIn[i + from].toJava(types[i]);
        }
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.method.getExceptionTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    @Override
    public Type[] getGenericExceptionTypes() {
        return this.method.getGenericExceptionTypes();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.method.getParameterAnnotations();
    }

    @Override
    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    @Override
    protected String nameOnInspection() {
        return "#<" + this.getType().toString() + "/" + this.method.getName() + "(";
    }

    public RubyBoolean static_p() {
        return this.getRuntime().newBoolean(this.isStatic());
    }

    public RubyBoolean bridge_p() {
        return this.getRuntime().newBoolean(this.method.isBridge());
    }

    private boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public int getModifiers() {
        return this.method.getModifiers();
    }

    @Override
    public String toGenericString() {
        return this.method.toGenericString();
    }

    @Override
    protected AccessibleObject accessibleObject() {
        return this.method;
    }

    private boolean mightBeProxy(Object javaInvokee) {
        return javaInvokee instanceof InternalJavaProxy && !Modifier.isFinal(this.method.getModifiers());
    }

    private IRubyObject tryProxyInvocation(Object javaInvokee, Object ... args2) {
        JavaProxyClass jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(jpm.getSuperMethod(), javaInvokee, args2);
        }
        return this.invokeDirectWithExceptionHandling(this.method, javaInvokee, args2);
    }

    private IRubyObject tryProxyInvocation(Object javaInvokee) {
        JavaProxyClass jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(jpm.getSuperMethod(), javaInvokee, new Object[0]);
        }
        return this.invokeDirectWithExceptionHandling(this.method, javaInvokee);
    }

    private IRubyObject tryProxyInvocation(Object javaInvokee, Object arg0) {
        JavaProxyClass jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(jpm.getSuperMethod(), javaInvokee, arg0);
        }
        return this.invokeDirectWithExceptionHandling(this.method, javaInvokee, arg0);
    }

    private IRubyObject tryProxyInvocation(Object javaInvokee, Object arg0, Object arg1) {
        JavaProxyClass jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(jpm.getSuperMethod(), javaInvokee, arg0, arg1);
        }
        return this.invokeDirectWithExceptionHandling(this.method, javaInvokee, arg0, arg1);
    }

    private IRubyObject tryProxyInvocation(Object javaInvokee, Object arg0, Object arg1, Object arg2) {
        JavaProxyClass jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(jpm.getSuperMethod(), javaInvokee, arg0, arg1, arg2);
        }
        return this.invokeDirectWithExceptionHandling(this.method, javaInvokee, arg0, arg1, arg2);
    }

    private IRubyObject tryProxyInvocation(Object javaInvokee, Object arg0, Object arg1, Object arg2, Object arg3) {
        JavaProxyClass jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(jpm.getSuperMethod(), javaInvokee, arg0, arg1, arg2, arg3);
        }
        return this.invokeDirectWithExceptionHandling(this.method, javaInvokee, arg0, arg1, arg2, arg3);
    }

    public static RaiseException newMethodNotFoundError(Ruby runtime2, Class target, String prettyName, String simpleName) {
        return runtime2.newNameError("java method not found: " + target.getName() + "." + prettyName, simpleName);
    }

    public static RaiseException newArgSizeMismatchError(Ruby runtime2, Class ... argTypes) {
        return runtime2.newArgumentError("argument count mismatch for method signature " + CodegenUtils.prettyParams(argTypes));
    }
}

