/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jruby.objectweb.asm.AnnotationVisitor;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.MethodVisitor;
import org.jruby.CompatVersion;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.codegen.RealClassGenerator;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.collections.WeakHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Class"}, parent="Module")
public class RubyClass
extends RubyModule {
    public static final ObjectAllocator CLASS_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            RubyClass clazz = new RubyClass(runtime2);
            clazz.allocator = ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR;
            return clazz;
        }
    };
    private volatile int accessorCount = 0;
    private volatile VariableAccessor objectIdAccessor = VariableAccessor.DUMMY_ACCESSOR;
    protected static final ObjectMarshal DEFAULT_OBJECT_MARSHAL = new ObjectMarshal(){

        public void marshalTo(Ruby runtime2, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
            IRubyObject object = (IRubyObject)obj;
            marshalStream.registerLinkTarget(object);
            marshalStream.dumpVariables(object.getVariableList());
        }

        public Object unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            IRubyObject result = type2.allocate();
            unmarshalStream.registerLinkTarget(result);
            unmarshalStream.defaultVariablesUnmarshal(result);
            return result;
        }
    };
    protected final Ruby runtime;
    private ObjectAllocator allocator;
    protected ObjectMarshal marshal;
    private Set<RubyClass> subclasses;
    public static final int CS_IDX_INITIALIZE = 0;
    public static final String[] CS_NAMES = new String[]{"initialize"};
    private final CallSite[] baseCallSites = new CallSite[CS_NAMES.length];
    private CallSite[] extraCallSites;
    private Class reifiedClass;
    private Map<String, VariableAccessor> variableAccessors;
    private volatile boolean hasObjectID;
    private Map<String, List<Map<Class, Map<String, Object>>>> parameterAnnotations;
    private Map<String, Map<Class, Map<String, Object>>> methodAnnotations;
    private Map<String, Class[]> methodSignatures;
    private Map<Class, Map<String, Object>> classAnnotations;

    public static void createClassClass(Ruby runtime2, RubyClass classClass) {
        classClass.index = 13;
        classClass.setReifiedClass(RubyClass.class);
        classClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyClass;
            }
        };
        classClass.undefineMethod("module_function");
        classClass.undefineMethod("append_features");
        classClass.undefineMethod("extend_object");
        classClass.defineAnnotatedMethods(RubyClass.class);
        classClass.addMethod("new", new SpecificArityNew(classClass, Visibility.PUBLIC));
    }

    public ObjectAllocator getAllocator() {
        return this.allocator;
    }

    public void setAllocator(ObjectAllocator allocator) {
        this.allocator = allocator;
    }

    public void setClassAllocator(final Class cls) {
        this.allocator = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                try {
                    return (IRubyObject)cls.newInstance();
                }
                catch (InstantiationException ie) {
                    throw runtime2.newTypeError("could not allocate " + cls + " with default constructor:\n" + ie);
                }
                catch (IllegalAccessException iae) {
                    throw runtime2.newSecurityError("could not allocate " + cls + " due to inaccessible default constructor:\n" + iae);
                }
            }
        };
        this.reifiedClass = cls;
    }

    public void setRubyClassAllocator(final Class cls) {
        try {
            final Constructor constructor2 = cls.getConstructor(Ruby.class, RubyClass.class);
            this.allocator = new ObjectAllocator(){

                public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                    try {
                        return (IRubyObject)constructor2.newInstance(runtime2, klazz);
                    }
                    catch (InvocationTargetException ite) {
                        throw runtime2.newTypeError("could not allocate " + cls + " with (Ruby, RubyClass) constructor:\n" + ite);
                    }
                    catch (InstantiationException ie) {
                        throw runtime2.newTypeError("could not allocate " + cls + " with (Ruby, RubyClass) constructor:\n" + ie);
                    }
                    catch (IllegalAccessException iae) {
                        throw runtime2.newSecurityError("could not allocate " + cls + " due to inaccessible (Ruby, RubyClass) constructor:\n" + iae);
                    }
                }
            };
            this.reifiedClass = cls;
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    public void setRubyStaticAllocator(final Class cls) {
        try {
            final Method method2 = cls.getDeclaredMethod("__allocate__", Ruby.class, RubyClass.class);
            this.allocator = new ObjectAllocator(){

                public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                    try {
                        return (IRubyObject)method2.invoke(null, runtime2, klazz);
                    }
                    catch (InvocationTargetException ite) {
                        throw runtime2.newTypeError("could not allocate " + cls + " with (Ruby, RubyClass) constructor:\n" + ite);
                    }
                    catch (IllegalAccessException iae) {
                        throw runtime2.newSecurityError("could not allocate " + cls + " due to inaccessible (Ruby, RubyClass) constructor:\n" + iae);
                    }
                }
            };
            this.reifiedClass = cls;
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    @JRubyMethod(name={"allocate"})
    public IRubyObject allocate() {
        if (!(this.superClass != null || this.runtime.is1_9() && this == this.runtime.getBasicObject())) {
            throw this.runtime.newTypeError("can't instantiate uninitialized class");
        }
        IRubyObject obj = this.allocator.allocate(this.runtime, this);
        if (obj.getMetaClass().getRealClass() != this.getRealClass()) {
            throw this.runtime.newTypeError("wrong instance allocation");
        }
        return obj;
    }

    public CallSite[] getBaseCallSites() {
        return this.baseCallSites;
    }

    public CallSite[] getExtraCallSites() {
        return this.extraCallSites;
    }

    public Map<String, VariableAccessor> getVariableAccessorsForRead() {
        return this.variableAccessors;
    }

    public synchronized Map<String, VariableAccessor> getVariableAccessorsForWrite() {
        if (this.variableAccessors == Collections.EMPTY_MAP) {
            this.variableAccessors = new Hashtable<String, VariableAccessor>(1);
        }
        return this.variableAccessors;
    }

    private final synchronized VariableAccessor allocateVariableAccessor() {
        return new VariableAccessor(this.accessorCount++, this.id);
    }

    public synchronized VariableAccessor getVariableAccessorForWrite(String name2) {
        Map<String, VariableAccessor> myVariableAccessors = this.getVariableAccessorsForWrite();
        VariableAccessor ivarAccessor = myVariableAccessors.get(name2);
        if (ivarAccessor == null) {
            ivarAccessor = this.allocateVariableAccessor();
            myVariableAccessors.put(name2, ivarAccessor);
        }
        return ivarAccessor;
    }

    public VariableAccessor getVariableAccessorForRead(String name2) {
        VariableAccessor accessor = this.getVariableAccessorsForRead().get(name2);
        if (accessor == null) {
            accessor = VariableAccessor.DUMMY_ACCESSOR;
        }
        return accessor;
    }

    public synchronized VariableAccessor getObjectIdAccessorForWrite() {
        if (this.objectIdAccessor == VariableAccessor.DUMMY_ACCESSOR) {
            this.objectIdAccessor = this.allocateVariableAccessor();
        }
        return this.objectIdAccessor;
    }

    public VariableAccessor getObjectIdAccessorForRead() {
        return this.objectIdAccessor;
    }

    public int getVariableTableSize() {
        return this.variableAccessors.size();
    }

    public int getVariableTableSizeWithObjectId() {
        return this.variableAccessors.size() + (this.objectIdAccessor == VariableAccessor.DUMMY_ACCESSOR ? 0 : 1);
    }

    public Map<String, VariableAccessor> getVariableTableCopy() {
        return new HashMap<String, VariableAccessor>(this.getVariableAccessorsForRead());
    }

    @Override
    public int getNativeTypeIndex() {
        return 13;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    public static RubyClass createBootstrapClass(Ruby runtime2, String name2, RubyClass superClass, ObjectAllocator allocator) {
        RubyClass obj;
        if (superClass == null) {
            obj = new RubyClass(runtime2);
            obj.marshal = DEFAULT_OBJECT_MARSHAL;
        } else {
            obj = new RubyClass(runtime2, superClass);
        }
        obj.setAllocator(allocator);
        obj.setBaseName(name2);
        return obj;
    }

    protected RubyClass(Ruby runtime2, RubyClass superClass, boolean objectSpace) {
        super(runtime2, runtime2.getClassClass(), objectSpace);
        for (int i = 0; i < CS_NAMES.length; ++i) {
            this.baseCallSites[i] = MethodIndex.getFunctionalCallSite(CS_NAMES[i]);
        }
        this.variableAccessors = Collections.EMPTY_MAP;
        this.hasObjectID = false;
        this.runtime = runtime2;
        this.setSuperClass(superClass);
    }

    protected RubyClass(Ruby runtime2, RubyClass superClass, RubyModule.Generation generation, boolean objectSpace) {
        super(runtime2, runtime2.getClassClass(), generation, objectSpace);
        for (int i = 0; i < CS_NAMES.length; ++i) {
            this.baseCallSites[i] = MethodIndex.getFunctionalCallSite(CS_NAMES[i]);
        }
        this.variableAccessors = Collections.EMPTY_MAP;
        this.hasObjectID = false;
        this.runtime = runtime2;
        this.setSuperClass(superClass);
    }

    protected RubyClass(Ruby runtime2) {
        super(runtime2, runtime2.getClassClass());
        for (int i = 0; i < CS_NAMES.length; ++i) {
            this.baseCallSites[i] = MethodIndex.getFunctionalCallSite(CS_NAMES[i]);
        }
        this.variableAccessors = Collections.EMPTY_MAP;
        this.hasObjectID = false;
        this.runtime = runtime2;
        this.index = 13;
    }

    protected RubyClass(Ruby runtime2, RubyClass superClazz) {
        this(runtime2);
        this.setSuperClass(superClazz);
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        this.allocator = superClazz.allocator;
        this.infectBy(this.superClass);
    }

    protected RubyClass(Ruby runtime2, RubyClass superClazz, CallSite[] extraCallSites) {
        this(runtime2);
        this.setSuperClass(superClazz);
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        this.extraCallSites = extraCallSites;
        this.infectBy(this.superClass);
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass) {
        if (superClass == runtime2.getClassClass()) {
            throw runtime2.newTypeError("can't make subclass of Class");
        }
        if (superClass.isSingleton()) {
            throw runtime2.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(runtime2, superClass);
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass, CallSite[] extraCallSites) {
        if (superClass == runtime2.getClassClass()) {
            throw runtime2.newTypeError("can't make subclass of Class");
        }
        if (superClass.isSingleton()) {
            throw runtime2.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(runtime2, superClass, extraCallSites);
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass, String name2, ObjectAllocator allocator, RubyModule parent, boolean setParent) {
        RubyClass clazz = RubyClass.newClass(runtime2, superClass);
        clazz.setBaseName(name2);
        clazz.setAllocator(allocator);
        clazz.makeMetaClass(superClass.getMetaClass());
        if (setParent) {
            clazz.setParent(parent);
        }
        parent.setConstant(name2, clazz);
        clazz.inherit(superClass);
        return clazz;
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass, String name2, ObjectAllocator allocator, RubyModule parent, boolean setParent, CallSite[] extraCallSites) {
        RubyClass clazz = RubyClass.newClass(runtime2, superClass, extraCallSites);
        clazz.setBaseName(name2);
        clazz.setAllocator(allocator);
        clazz.makeMetaClass(superClass.getMetaClass());
        if (setParent) {
            clazz.setParent(parent);
        }
        parent.setConstant(name2, clazz);
        clazz.inherit(superClass);
        return clazz;
    }

    @Override
    public RubyClass makeMetaClass(RubyClass superClass) {
        if (this.isSingleton()) {
            MetaClass klass = new MetaClass(this.runtime, superClass, this);
            this.setMetaClass(klass);
            klass.setMetaClass(klass);
            klass.setSuperClass(this.getSuperClass().getRealClass().getMetaClass());
            return klass;
        }
        return super.makeMetaClass(superClass);
    }

    @Deprecated
    public IRubyObject invoke(ThreadContext context, IRubyObject self, int methodIndex, String name2, IRubyObject[] args2, CallType callType, Block block) {
        return this.invoke(context, self, name2, args2, callType, block);
    }

    public boolean notVisibleAndNotMethodMissing(DynamicMethod method2, String name2, IRubyObject caller, CallType callType) {
        return !method2.isCallableFrom(caller, callType) && !name2.equals("method_missing");
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, CallType callType, Block block) {
        IRubyObject caller;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, callType, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, Block block) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.FUNCTIONAL, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2, CallType callType, Block block) {
        IRubyObject caller;
        assert (args2 != null);
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, callType, args2, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, args2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2, Block block) {
        assert (args2 != null);
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.FUNCTIONAL, args2, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, args2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg2, CallType callType, Block block) {
        IRubyObject caller;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, callType, arg2, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg2, Block block) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg2, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, CallType callType, Block block) {
        IRubyObject caller;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, callType, arg0, arg1, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg0, arg1, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg0, arg1, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, CallType callType, Block block) {
        IRubyObject caller;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, callType, arg0, arg1, arg2, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg0, arg1, arg2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, arg2, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg0, arg1, arg2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, CallType callType) {
        IRubyObject caller;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, callType, Block.NULL_BLOCK);
        }
        return method2.call(context, self, this, name2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method2.call(context, self, this, name2);
    }

    public IRubyObject finvokeChecked(ThreadContext context, IRubyObject self, String name2) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (method2.isUndefined()) {
            DynamicMethod methodMissing = this.searchMethod("method_missing");
            if (methodMissing.isUndefined() || methodMissing == context.getRuntime().getDefaultMethodMissing()) {
                return null;
            }
            try {
                return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.FUNCTIONAL, Block.NULL_BLOCK);
            }
            catch (RaiseException e) {
                if (context.getRuntime().getNoMethodError().isInstance(e.getException())) {
                    if (self.respondsTo(name2)) {
                        throw e;
                    }
                    return null;
                }
                throw e;
            }
        }
        return method2.call(context, self, this, name2);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2, CallType callType) {
        IRubyObject caller;
        assert (args2 != null);
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, callType, args2, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, args2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2) {
        assert (args2 != null);
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.FUNCTIONAL, args2, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, args2);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg2, CallType callType) {
        IRubyObject caller;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, callType, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg2) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg2);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, CallType callType) {
        IRubyObject caller;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, callType, arg0, arg1, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg0, arg1);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg0, arg1);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, CallType callType) {
        IRubyObject caller;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, callType, arg0, arg1, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg0, arg1, arg2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg0, arg1, arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpReifiedClass(String dumpDir, String javaPath, byte[] classBytes) {
        if (dumpDir != null) {
            if (dumpDir.equals("")) {
                dumpDir = ".";
            }
            FileOutputStream classStream = null;
            try {
                File classFile = new File(dumpDir, javaPath + ".class");
                classFile.getParentFile().mkdirs();
                classStream = new FileOutputStream(classFile);
                classStream.write(classBytes);
            }
            catch (IOException io2) {
                this.getRuntime().getWarnings().warn("unable to dump class file: " + io2.getMessage());
            }
            finally {
                if (classStream != null) {
                    try {
                        classStream.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
    }

    private void generateMethodAnnotations(Map<Class, Map<String, Object>> methodAnnos, SkinnyMethodAdapter m, List<Map<Class, Map<String, Object>>> parameterAnnos) {
        if (methodAnnos != null && methodAnnos.size() != 0) {
            for (Map.Entry<Class, Map<String, Object>> entry : methodAnnos.entrySet()) {
                m.visitAnnotationWithFields(CodegenUtils.ci(entry.getKey()), true, entry.getValue());
            }
        }
        if (parameterAnnos != null && parameterAnnos.size() != 0) {
            for (int i = 0; i < parameterAnnos.size(); ++i) {
                Map<Class, Map<String, Object>> annos = parameterAnnos.get(i);
                if (annos == null || annos.size() == 0) continue;
                for (Map.Entry<Class, Map<String, Object>> entry : annos.entrySet()) {
                    m.visitParameterAnnotationWithFields(i, CodegenUtils.ci(entry.getKey()), true, entry.getValue());
                }
            }
        }
    }

    private boolean shouldCallMethodMissing(DynamicMethod method2) {
        return method2.isUndefined();
    }

    private boolean shouldCallMethodMissing(DynamicMethod method2, String name2, IRubyObject caller, CallType callType) {
        return method2.isUndefined() || this.notVisibleAndNotMethodMissing(method2, name2, caller, callType);
    }

    public IRubyObject invokeInherited(ThreadContext context, IRubyObject self, IRubyObject subclass) {
        DynamicMethod method2 = this.getMetaClass().searchMethod("inherited");
        if (method2.isUndefined()) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), "inherited", CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this.getMetaClass(), "inherited", subclass, Block.NULL_BLOCK);
    }

    public IRubyObject newInstance(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, (IRubyObject)this, obj, args2, block);
        return obj;
    }

    @JRubyMethod(name={"initialize"}, compat=CompatVersion.RUBY1_8, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        this.checkNotInitialized();
        return this.initializeCommon(this.runtime.getObject(), block, false);
    }

    @JRubyMethod(name={"initialize"}, compat=CompatVersion.RUBY1_8, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject superObject, Block block) {
        this.checkNotInitialized();
        RubyClass.checkInheritable(superObject);
        return this.initializeCommon((RubyClass)superObject, block, false);
    }

    @JRubyMethod(name={"initialize"}, compat=CompatVersion.RUBY1_9, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize19(ThreadContext context, Block block) {
        this.checkNotInitialized();
        return this.initializeCommon(this.runtime.getObject(), block, true);
    }

    @JRubyMethod(name={"initialize"}, compat=CompatVersion.RUBY1_9, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize19(ThreadContext context, IRubyObject superObject, Block block) {
        this.checkNotInitialized();
        RubyClass.checkInheritable(superObject);
        return this.initializeCommon((RubyClass)superObject, block, true);
    }

    private IRubyObject initializeCommon(RubyClass superClazz, Block block, boolean callInheritBeforeSuper) {
        this.setSuperClass(superClazz);
        this.allocator = superClazz.allocator;
        this.makeMetaClass(superClazz.getMetaClass());
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        if (callInheritBeforeSuper) {
            this.inherit(superClazz);
            super.initialize(block);
        } else {
            super.initialize(block);
            this.inherit(superClazz);
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        this.checkNotInitialized();
        if (original instanceof MetaClass) {
            throw this.runtime.newTypeError("can't copy singleton class");
        }
        super.initialize_copy(original);
        this.allocator = ((RubyClass)original).allocator;
        return this;
    }

    protected void setModuleSuperClass(RubyClass superClass) {
        if (this.superClass != null) {
            this.superClass.removeSubclass(this);
        }
        superClass.addSubclass(this);
        this.setSuperClass(superClass);
    }

    public Collection subclasses(boolean includeDescendants) {
        Set<RubyClass> mySubclasses = this.subclasses;
        if (mySubclasses != null) {
            ArrayList<RubyClass> mine = new ArrayList<RubyClass>(mySubclasses);
            if (includeDescendants) {
                for (RubyClass i : mySubclasses) {
                    mine.addAll(i.subclasses(includeDescendants));
                }
            }
            return mine;
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addSubclass(RubyClass subclass) {
        Object object = this.runtime.getHierarchyLock();
        synchronized (object) {
            Set<RubyClass> oldSubclasses = this.subclasses;
            if (oldSubclasses == null) {
                this.subclasses = oldSubclasses = new WeakHashSet<RubyClass>(4);
            }
            oldSubclasses.add(subclass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeSubclass(RubyClass subclass) {
        Object object = this.runtime.getHierarchyLock();
        synchronized (object) {
            Set<RubyClass> oldSubclasses = this.subclasses;
            if (oldSubclasses == null) {
                return;
            }
            oldSubclasses.remove(subclass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void replaceSubclass(RubyClass subclass, RubyClass newSubclass) {
        Object object = this.runtime.getHierarchyLock();
        synchronized (object) {
            Set<RubyClass> oldSubclasses = this.subclasses;
            if (oldSubclasses == null) {
                return;
            }
            oldSubclasses.remove(subclass);
            oldSubclasses.add(newSubclass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void becomeSynchronized() {
        Object object = this.getRuntime().getHierarchyLock();
        synchronized (object) {
            super.becomeSynchronized();
            Set<RubyClass> mySubclasses = this.subclasses;
            if (mySubclasses != null) {
                for (RubyClass subclass : mySubclasses) {
                    subclass.becomeSynchronized();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateCacheDescendants() {
        super.invalidateCacheDescendants();
        Object object = this.runtime.getHierarchyLock();
        synchronized (object) {
            Set<RubyClass> mySubclasses = this.subclasses;
            if (mySubclasses != null) {
                for (RubyClass subclass : mySubclasses) {
                    subclass.invalidateCacheDescendants();
                }
            }
        }
    }

    public Ruby getClassRuntime() {
        return this.runtime;
    }

    public RubyClass getRealClass() {
        return this;
    }

    @JRubyMethod(name={"inherited"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject inherited(ThreadContext context, IRubyObject arg2) {
        return this.runtime.getNil();
    }

    public void inherit(RubyClass superClazz) {
        if (superClazz == null) {
            superClazz = this.runtime.getObject();
        }
        superClazz.invokeInherited(this.runtime.getCurrentContext(), superClazz, this);
    }

    @JRubyMethod(name={"superclass"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject superclass(ThreadContext context) {
        RubyClass superClazz = this.superClass;
        if (superClazz == null) {
            throw this.runtime.newTypeError("uninitialized class");
        }
        if (this.isSingleton()) {
            superClazz = this.metaClass;
        }
        while (superClazz != null && superClazz.isIncluded()) {
            superClazz = superClazz.superClass;
        }
        return superClazz != null ? superClazz : this.runtime.getNil();
    }

    @JRubyMethod(name={"superclass"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject superclass19(ThreadContext context) {
        RubyClass superClazz = this.superClass;
        if (superClazz == null) {
            if (this.metaClass == this.runtime.getBasicObject().getMetaClass()) {
                return this.runtime.getNil();
            }
            throw this.runtime.newTypeError("uninitialized class");
        }
        while (superClazz != null && superClazz.isIncluded()) {
            superClazz = superClazz.superClass;
        }
        return superClazz != null ? superClazz : this.runtime.getNil();
    }

    private void checkNotInitialized() {
        if (this.superClass != null || this.runtime.is1_9() && this == this.runtime.getBasicObject()) {
            throw this.runtime.newTypeError("already initialized class");
        }
    }

    public static void checkInheritable(IRubyObject superClass) {
        if (!(superClass instanceof RubyClass)) {
            throw superClass.getRuntime().newTypeError("superclass must be a Class (" + superClass.getMetaClass() + " given)");
        }
        if (((RubyClass)superClass).isSingleton()) {
            throw superClass.getRuntime().newTypeError("can't make subclass of virtual class");
        }
    }

    public final ObjectMarshal getMarshal() {
        return this.marshal;
    }

    public final void setMarshal(ObjectMarshal marshal) {
        this.marshal = marshal;
    }

    public final void marshal(Object obj, MarshalStream marshalStream) throws IOException {
        this.getMarshal().marshalTo(this.runtime, obj, this, marshalStream);
    }

    public final Object unmarshal(UnmarshalStream unmarshalStream) throws IOException {
        return this.getMarshal().unmarshalFrom(this.runtime, this, unmarshalStream);
    }

    public static void marshalTo(RubyClass clazz, MarshalStream output) throws IOException {
        output.registerLinkTarget(clazz);
        output.writeString(MarshalStream.getPathFromClass(clazz));
    }

    public static RubyClass unmarshalFrom(UnmarshalStream input) throws IOException {
        String name2 = RubyString.byteListToString(input.unmarshalString());
        RubyClass result = UnmarshalStream.getClassFromPath(input.getRuntime(), name2);
        input.registerLinkTarget(result);
        return result;
    }

    public synchronized void reify() {
        this.reify(null);
    }

    public synchronized void reify(String classDumpDir) {
        Class reifiedParent = RubyObject.class;
        String name2 = this.getBaseName() == null ? "Anonymous" + this.id : this.getName();
        String javaName = "ruby." + name2.replaceAll("::", ".");
        String javaPath = "ruby/" + name2.replaceAll("::", "/");
        JRubyClassLoader parentCL = this.runtime.getJRubyClassLoader();
        if (this.superClass.reifiedClass != null) {
            reifiedParent = this.superClass.reifiedClass;
        }
        Class[] interfaces2 = Java.getInterfacesFromRubyClass(this);
        String[] interfaceNames = new String[interfaces2.length];
        for (int i = 0; i < interfaces2.length; ++i) {
            interfaceNames[i] = CodegenUtils.p(interfaces2[i]);
        }
        ClassWriter cw = new ClassWriter(3);
        cw.visit(RubyInstanceConfig.JAVA_VERSION, 33, javaPath, null, CodegenUtils.p(reifiedParent), interfaceNames);
        if (this.classAnnotations != null && this.classAnnotations.size() != 0) {
            for (Map.Entry<Class, Map<String, Object>> entry : this.classAnnotations.entrySet()) {
                Class annoType = entry.getKey();
                Map<String, Object> fields2 = entry.getValue();
                AnnotationVisitor av = cw.visitAnnotation(CodegenUtils.ci(annoType), true);
                CodegenUtils.visitAnnotationFields(av, fields2);
                av.visitEnd();
            }
        }
        cw.visitField(10, "ruby", CodegenUtils.ci(Ruby.class), null, null);
        cw.visitField(10, "rubyClass", CodegenUtils.ci(RubyClass.class), null, null);
        SkinnyMethodAdapter m = new SkinnyMethodAdapter(cw.visitMethod(9, "clinit", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class), null, null));
        m.start();
        m.aload(0);
        m.putstatic(javaPath, "ruby", CodegenUtils.ci(Ruby.class));
        m.aload(1);
        m.putstatic(javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
        m.voidreturn();
        m.end();
        MethodVisitor mv = cw.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class), null, null);
        m = new SkinnyMethodAdapter(mv);
        m.aload(0);
        m.aload(1);
        m.aload(2);
        m.invokespecial(CodegenUtils.p(reifiedParent), "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class));
        m.voidreturn();
        m.end();
        mv = cw.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null);
        m = new SkinnyMethodAdapter(mv);
        m.aload(0);
        m.getstatic(javaPath, "ruby", CodegenUtils.ci(Ruby.class));
        m.getstatic(javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
        m.invokespecial(CodegenUtils.p(reifiedParent), "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class));
        m.voidreturn();
        m.end();
        mv = cw.visitMethod(1, "toJava", CodegenUtils.sig(Object.class, Class.class), null, null);
        m = new SkinnyMethodAdapter(mv);
        m.aload(0);
        m.areturn();
        m.end();
        for (Map.Entry<String, DynamicMethod> methodEntry : this.getMethods().entrySet()) {
            String methodName = methodEntry.getKey();
            String javaMethodName = JavaNameMangler.mangleStringForCleanJavaIdentifier(methodName);
            Map<Class, Map<String, Object>> methodAnnos = this.getMethodAnnotations().get(methodName);
            List<Map<Class, Map<String, Object>>> parameterAnnos = this.getParameterAnnotations().get(methodName);
            Class[] methodSignature = this.getMethodSignatures().get(methodName);
            if (methodSignature == null) {
                switch (methodEntry.getValue().getArity().getValue()) {
                    case 0: {
                        mv = cw.visitMethod(129, javaMethodName, CodegenUtils.sig(IRubyObject.class, new Class[0]), null, null);
                        m = new SkinnyMethodAdapter(mv);
                        this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                        m.aload(0);
                        m.ldc(methodName);
                        m.invokevirtual(javaPath, "callMethod", CodegenUtils.sig(IRubyObject.class, String.class));
                        break;
                    }
                    default: {
                        mv = cw.visitMethod(129, javaMethodName, CodegenUtils.sig(IRubyObject.class, IRubyObject[].class), null, null);
                        m = new SkinnyMethodAdapter(mv);
                        this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                        m.aload(0);
                        m.ldc(methodName);
                        m.aload(1);
                        m.invokevirtual(javaPath, "callMethod", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject[].class));
                    }
                }
                m.areturn();
            } else {
                Class[] params2 = new Class[methodSignature.length - 1];
                System.arraycopy(methodSignature, 1, params2, 0, params2.length);
                int baseIndex = 1;
                for (Class paramType : params2) {
                    if (paramType == Double.TYPE || paramType == Long.TYPE) {
                        baseIndex += 2;
                        continue;
                    }
                    ++baseIndex;
                }
                int rubyIndex = baseIndex;
                mv = cw.visitMethod(129, javaMethodName, CodegenUtils.sig(methodSignature[0], params2), null, null);
                m = new SkinnyMethodAdapter(mv);
                this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                m.getstatic(javaPath, "ruby", CodegenUtils.ci(Ruby.class));
                m.astore(rubyIndex);
                m.aload(0);
                m.ldc(methodName);
                RealClassGenerator.coerceArgumentsToRuby(m, params2, rubyIndex);
                m.invokevirtual(javaPath, "callMethod", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject[].class));
                RealClassGenerator.coerceResultAndReturn(m, methodSignature[0]);
            }
            m.end();
        }
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        this.dumpReifiedClass(classDumpDir, javaPath, classBytes);
        Class<?> result = parentCL.defineClass(javaName, classBytes);
        try {
            Method clinit = result.getDeclaredMethod("clinit", Ruby.class, RubyClass.class);
            clinit.invoke(null, this.runtime, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setClassAllocator(result);
        this.reifiedClass = result;
    }

    public void setReifiedClass(Class newReifiedClass) {
        this.reifiedClass = newReifiedClass;
    }

    public Class getReifiedClass() {
        return this.reifiedClass;
    }

    public Map<String, List<Map<Class, Map<String, Object>>>> getParameterAnnotations() {
        if (this.parameterAnnotations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.parameterAnnotations;
    }

    public synchronized void addParameterAnnotation(String method2, int i, Class annoClass, Map<String, Object> value2) {
        List<Map<Class, Map<String, Object>>> paramList;
        if (this.parameterAnnotations == null) {
            this.parameterAnnotations = new Hashtable<String, List<Map<Class, Map<String, Object>>>>();
        }
        if ((paramList = this.parameterAnnotations.get(method2)) == null) {
            paramList = new ArrayList<Map<Class, Map<String, Object>>>(i + 1);
            this.parameterAnnotations.put(method2, paramList);
        }
        if (paramList.size() < i + 1) {
            for (int j = paramList.size(); j < i + 1; ++j) {
                paramList.add(null);
            }
        }
        if (annoClass != null && value2 != null) {
            Map<Class, Map<String, Object>> annos = paramList.get(i);
            if (annos == null) {
                annos = new HashMap<Class, Map<String, Object>>();
                paramList.set(i, annos);
            }
            annos.put(annoClass, value2);
        } else {
            paramList.set(i, null);
        }
    }

    public Map<String, Map<Class, Map<String, Object>>> getMethodAnnotations() {
        if (this.methodAnnotations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.methodAnnotations;
    }

    public synchronized void addMethodAnnotation(String methodName, Class annotation2, Map fields2) {
        Map<Class, Map<String, Object>> annos;
        if (this.methodAnnotations == null) {
            this.methodAnnotations = new Hashtable<String, Map<Class, Map<String, Object>>>();
        }
        if ((annos = this.methodAnnotations.get(methodName)) == null) {
            annos = new Hashtable<Class, Map<String, Object>>();
            this.methodAnnotations.put(methodName, annos);
        }
        annos.put(annotation2, fields2);
    }

    public Map<String, Class[]> getMethodSignatures() {
        if (this.methodSignatures == null) {
            return Collections.EMPTY_MAP;
        }
        return this.methodSignatures;
    }

    public synchronized void addMethodSignature(String methodName, Class[] types) {
        if (this.methodSignatures == null) {
            this.methodSignatures = new Hashtable<String, Class[]>();
        }
        this.methodSignatures.put(methodName, types);
    }

    public Map<Class, Map<String, Object>> getClassAnnotations() {
        if (this.classAnnotations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.classAnnotations;
    }

    public synchronized void addClassAnnotation(Class annotation2, Map fields2) {
        if (this.classAnnotations == null) {
            this.classAnnotations = new Hashtable<Class, Map<String, Object>>();
        }
        this.classAnnotations.put(annotation2, fields2);
    }

    @Override
    public Object toJava(Class klass) {
        Class returnClass = null;
        if (klass == Class.class) {
            if (this.respondsTo("java_class")) {
                return this.callMethod("java_class").toJava(klass);
            }
            for (RubyClass current2 = this; current2 != null; current2 = current2.getSuperClass()) {
                returnClass = current2.getReifiedClass();
                if (returnClass == null) continue;
                return returnClass;
            }
        }
        if (klass.isAssignableFrom(RubyClass.class)) {
            return this;
        }
        throw this.getRuntime().newTypeError("cannot convert instance of " + this.getClass() + " to " + klass);
    }

    public boolean hasObjectID() {
        return this.hasObjectID;
    }

    public static class SpecificArityNew
    extends JavaMethod {
        public SpecificArityNew(RubyModule implClass, Visibility visibility) {
            super(implClass, visibility);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            this.preBacktraceOnly(context, name2);
            try {
                RubyClass cls = (RubyClass)self;
                IRubyObject obj = cls.allocate();
                cls.baseCallSites[0].call(context, self, obj, args2, block);
                IRubyObject iRubyObject = obj;
                return iRubyObject;
            }
            finally {
                SpecificArityNew.postBacktraceOnly(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
            this.preBacktraceOnly(context, name2);
            try {
                RubyClass cls = (RubyClass)self;
                IRubyObject obj = cls.allocate();
                cls.baseCallSites[0].call(context, self, obj, block);
                IRubyObject iRubyObject = obj;
                return iRubyObject;
            }
            finally {
                SpecificArityNew.postBacktraceOnly(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
            this.preBacktraceOnly(context, name2);
            try {
                RubyClass cls = (RubyClass)self;
                IRubyObject obj = cls.allocate();
                cls.baseCallSites[0].call(context, self, obj, arg0, block);
                IRubyObject iRubyObject = obj;
                return iRubyObject;
            }
            finally {
                SpecificArityNew.postBacktraceOnly(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
            this.preBacktraceOnly(context, name2);
            try {
                RubyClass cls = (RubyClass)self;
                IRubyObject obj = cls.allocate();
                cls.baseCallSites[0].call(context, self, obj, arg0, arg1, block);
                IRubyObject iRubyObject = obj;
                return iRubyObject;
            }
            finally {
                SpecificArityNew.postBacktraceOnly(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            this.preBacktraceOnly(context, name2);
            try {
                RubyClass cls = (RubyClass)self;
                IRubyObject obj = cls.allocate();
                cls.baseCallSites[0].call(context, self, obj, arg0, arg1, arg2, block);
                IRubyObject iRubyObject = obj;
                return iRubyObject;
            }
            finally {
                SpecificArityNew.postBacktraceOnly(context);
            }
        }
    }

    public static class VariableAccessor {
        private int index;
        private final int classId;
        public static final VariableAccessor DUMMY_ACCESSOR = new VariableAccessor(-1, -1);

        public VariableAccessor(int index2, int classId) {
            this.index = index2;
            this.classId = classId;
        }

        public int getClassId() {
            return this.classId;
        }

        public int getIndex() {
            return this.index;
        }

        public Object get(Object object) {
            return ((IRubyObject)object).getVariable(this.index);
        }

        public void set(Object object, Object value2) {
            ((IRubyObject)object).setVariable(this.index, value2);
        }
    }
}

