/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.CaseFoldCodeItem;
import org.jcodings.Encoding;
import org.joni.MinMaxLen;
import org.joni.OptAnchorInfo;

final class OptMapInfo {
    final MinMaxLen mmd = new MinMaxLen();
    final OptAnchorInfo anchor = new OptAnchorInfo();
    int value;
    final byte[] map = new byte[256];
    private static final int z = 32768;
    static final short[] ByteValTable = new short[]{5, 1, 1, 1, 1, 1, 1, 1, 1, 10, 10, 1, 1, 10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 12, 4, 7, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 6, 5, 5, 5, 5, 6, 6, 6, 6, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 1};

    OptMapInfo() {
    }

    void clear() {
        this.mmd.clear();
        this.anchor.clear();
        this.value = 0;
        for (int i = 0; i < this.map.length; ++i) {
            this.map[i] = 0;
        }
    }

    void copy(OptMapInfo optMapInfo) {
        this.mmd.copy(optMapInfo.mmd);
        this.anchor.copy(optMapInfo.anchor);
        this.value = optMapInfo.value;
        System.arraycopy(optMapInfo.map, 0, this.map, 0, optMapInfo.map.length);
    }

    void addChar(byte by, Encoding encoding2) {
        int n = by & 0xFF;
        if (this.map[n] == 0) {
            this.map[n] = 1;
            this.value += OptMapInfo.positionValue(encoding2, n);
        }
    }

    void addCharAmb(byte[] byArray, int n, int n2, Encoding encoding2, int n3) {
        this.addChar(byArray[n], encoding2);
        CaseFoldCodeItem[] caseFoldCodeItemArray = encoding2.caseFoldCodesByString(n3 &= 0xBFFFFFFF, byArray, n, n2);
        byte[] byArray2 = new byte[7];
        for (int i = 0; i < caseFoldCodeItemArray.length; ++i) {
            encoding2.codeToMbc(caseFoldCodeItemArray[i].code[0], byArray2, 0);
            this.addChar(byArray2[0], encoding2);
        }
    }

    void select(OptMapInfo optMapInfo) {
        if (optMapInfo.value == 0) {
            return;
        }
        if (this.value == 0) {
            this.copy(optMapInfo);
            return;
        }
        int n = 32768 / this.value;
        int n2 = 32768 / optMapInfo.value;
        if (this.mmd.compareDistanceValue(optMapInfo.mmd, n, n2) > 0) {
            this.copy(optMapInfo);
        }
    }

    void altMerge(OptMapInfo optMapInfo, Encoding encoding2) {
        if (this.value == 0) {
            return;
        }
        if (optMapInfo.value == 0 || this.mmd.max < optMapInfo.mmd.max) {
            this.clear();
            return;
        }
        this.mmd.altMerge(optMapInfo.mmd);
        int n = 0;
        for (int i = 0; i < 256; ++i) {
            if (optMapInfo.map[i] != 0) {
                this.map[i] = 1;
            }
            if (this.map[i] == 0) continue;
            n += OptMapInfo.positionValue(encoding2, i);
        }
        this.value = n;
        this.anchor.altMerge(optMapInfo.anchor);
    }

    static int positionValue(Encoding encoding2, int n) {
        if (n < ByteValTable.length) {
            if (n == 0 && encoding2.minLength() > 1) {
                return 20;
            }
            return ByteValTable[n];
        }
        return 4;
    }
}

