/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.joni.Analyser;
import org.joni.BitStatus;
import org.joni.CodeRangeBuffer;
import org.joni.Compiler;
import org.joni.MatcherFactory;
import org.joni.Option;
import org.joni.ast.AnchorNode;
import org.joni.ast.BackRefNode;
import org.joni.ast.CClassNode;
import org.joni.ast.CTypeNode;
import org.joni.ast.CallNode;
import org.joni.ast.ConsAltNode;
import org.joni.ast.EncloseNode;
import org.joni.ast.Node;
import org.joni.ast.QuantifierNode;
import org.joni.ast.StringNode;

final class ArrayCompiler
extends Compiler {
    private static final int REPEAT_RANGE_ALLOC = 8;
    private static final int QUANTIFIER_EXPAND_LIMIT_SIZE = 50;

    ArrayCompiler(Analyser analyser) {
        super(analyser);
    }

    protected final void prepare() {
        this.regex.code = new int[(this.analyser.stop - this.analyser.p) * 2 + 1];
        this.regex.codeLength = 0;
    }

    protected final void finish() {
        this.addOpcode(1);
        this.addOpcode(0);
        if (this.analyser.env.unsetAddrList != null) {
            this.analyser.env.unsetAddrList.fix(this.regex);
            this.analyser.env.unsetAddrList = null;
        }
        this.regex.factory = MatcherFactory.DEFAULT;
    }

    protected void compileAltNode(ConsAltNode consAltNode) {
        ConsAltNode consAltNode2 = consAltNode;
        int n = 0;
        do {
            n += this.compileLengthTree(consAltNode2.car);
            if (consAltNode2.cdr == null) continue;
            n += 4;
        } while ((consAltNode2 = consAltNode2.cdr) != null);
        int n2 = this.regex.codeLength + n;
        consAltNode2 = consAltNode;
        do {
            n = this.compileLengthTree(consAltNode2.car);
            if (consAltNode2.cdr != null) {
                this.addOpcodeRelAddr(56, n + 2);
            }
            this.compileTree(consAltNode2.car);
            if (consAltNode2.cdr == null) continue;
            n = n2 - (this.regex.codeLength + 2);
            this.addOpcodeRelAddr(55, n);
        } while ((consAltNode2 = consAltNode2.cdr) != null);
    }

    private boolean isNeedStrLenOpExact(int n) {
        return n == 7 || n == 11 || n == 12 || n == 13 || n == 15 || n == 106;
    }

    private int selectStrOpcode(int n, int n2, boolean bl) {
        int n3;
        if (bl) {
            switch (n2) {
                case 1: {
                    n3 = this.enc.toLowerCaseTable() != null ? 105 : 14;
                    break;
                }
                default: {
                    n3 = this.enc.toLowerCaseTable() != null ? 106 : 15;
                    break;
                }
            }
        } else {
            block3 : switch (n) {
                case 1: {
                    switch (n2) {
                        case 1: {
                            n3 = 2;
                            break block3;
                        }
                        case 2: {
                            n3 = 3;
                            break block3;
                        }
                        case 3: {
                            n3 = 4;
                            break block3;
                        }
                        case 4: {
                            n3 = 5;
                            break block3;
                        }
                        case 5: {
                            n3 = 6;
                            break block3;
                        }
                    }
                    n3 = 7;
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 1: {
                            n3 = 8;
                            break block3;
                        }
                        case 2: {
                            n3 = 9;
                            break block3;
                        }
                        case 3: {
                            n3 = 10;
                            break block3;
                        }
                    }
                    n3 = 11;
                    break;
                }
                case 3: {
                    n3 = 12;
                }
                default: {
                    n3 = 13;
                }
            }
        }
        return n3;
    }

    private void compileTreeEmptyCheck(Node node, int n) {
        int n2 = this.regex.numNullCheck;
        if (n != 0) {
            this.addOpcode(66);
            this.addMemNum(this.regex.numNullCheck);
            ++this.regex.numNullCheck;
        }
        this.compileTree(node);
        if (n != 0) {
            switch (n) {
                case 1: {
                    this.addOpcode(67);
                    break;
                }
                case 2: {
                    this.addOpcode(68);
                    break;
                }
                case 3: {
                    this.addOpcode(69);
                }
            }
            this.addMemNum(n2);
        }
    }

    private int addCompileStringlength(byte[] byArray, int n, int n2, int n3, boolean bl) {
        int n4 = this.selectStrOpcode(n2, n3, bl);
        int n5 = 1;
        if (n4 == 13) {
            ++n5;
        }
        if (this.isNeedStrLenOpExact(n4)) {
            ++n5;
        }
        return n5 += n2 * n3;
    }

    protected final void addCompileString(byte[] byArray, int n, int n2, int n3, boolean bl) {
        int n4 = this.selectStrOpcode(n2, n3, bl);
        this.addOpcode(n4);
        if (n4 == 13) {
            this.addLength(n2);
        }
        if (this.isNeedStrLenOpExact(n4)) {
            if (n4 == 15 || n4 == 106) {
                this.addLength(n2 * n3);
            } else {
                this.addLength(n3);
            }
        }
        this.addBytes(byArray, n, n2 * n3);
    }

    private int compileLengthStringNode(Node node) {
        int n;
        int n2;
        StringNode stringNode = (StringNode)node;
        if (stringNode.length() <= 0) {
            return 0;
        }
        boolean bl = stringNode.isAmbig();
        int n3 = n2 = stringNode.p;
        int n4 = stringNode.end;
        byte[] byArray = stringNode.bytes;
        int n5 = this.enc.length(byArray, n3, n4);
        n3 += n5;
        int n6 = 1;
        int n7 = 0;
        while (n3 < n4) {
            n = this.enc.length(byArray, n3, n4);
            if (n == n5) {
                ++n6;
            } else {
                int n8 = this.addCompileStringlength(byArray, n2, n5, n6, bl);
                n7 += n8;
                n2 = n3;
                n6 = 1;
                n5 = n;
            }
            n3 += n;
        }
        n = this.addCompileStringlength(byArray, n2, n5, n6, bl);
        return n7 += n;
    }

    private int compileLengthStringRawNode(StringNode stringNode) {
        if (stringNode.length() <= 0) {
            return 0;
        }
        return this.addCompileStringlength(stringNode.bytes, stringNode.p, 1, stringNode.length(), false);
    }

    private void addMultiByteCClass(CodeRangeBuffer codeRangeBuffer) {
        this.addLength(codeRangeBuffer.used);
        this.addInts(codeRangeBuffer.p, codeRangeBuffer.used);
    }

    private int compileLengthCClassNode(CClassNode cClassNode) {
        int n;
        if (cClassNode.isShare()) {
            return 2;
        }
        if (cClassNode.mbuf == null) {
            n = 9;
        } else {
            n = this.enc.minLength() > 1 || cClassNode.bs.isEmpty() ? 1 : 9;
            n += 1 + cClassNode.mbuf.used;
        }
        return n;
    }

    protected void compileCClassNode(CClassNode cClassNode) {
        if (cClassNode.isShare()) {
            this.addOpcode(22);
            this.addPointer(cClassNode);
            return;
        }
        if (cClassNode.mbuf == null) {
            if (cClassNode.isNot()) {
                this.addOpcode(this.enc.isSingleByte() ? 97 : 19);
            } else {
                this.addOpcode(this.enc.isSingleByte() ? 96 : 16);
            }
            this.addInts(cClassNode.bs.bits, 8);
        } else if (this.enc.minLength() > 1 || cClassNode.bs.isEmpty()) {
            if (cClassNode.isNot()) {
                this.addOpcode(20);
            } else {
                this.addOpcode(17);
            }
            this.addMultiByteCClass(cClassNode.mbuf);
        } else {
            if (cClassNode.isNot()) {
                this.addOpcode(21);
            } else {
                this.addOpcode(18);
            }
            this.addInts(cClassNode.bs.bits, 8);
            this.addMultiByteCClass(cClassNode.mbuf);
        }
    }

    protected void compileCTypeNode(CTypeNode cTypeNode) {
        int n;
        CTypeNode cTypeNode2 = cTypeNode;
        switch (cTypeNode2.ctype) {
            case 12: {
                if (cTypeNode2.not) {
                    n = this.enc.isSingleByte() ? 99 : 30;
                    break;
                }
                n = this.enc.isSingleByte() ? 98 : 29;
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
                return;
            }
        }
        this.addOpcode(n);
    }

    protected void compileAnyCharNode() {
        if (Option.isMultiline(this.regex.options)) {
            this.addOpcode(this.enc.isSingleByte() ? 89 : 24);
        } else {
            this.addOpcode(this.enc.isSingleByte() ? 88 : 23);
        }
    }

    protected void compileCallNode(CallNode callNode) {
        this.addOpcode(79);
        callNode.unsetAddrList.add(this.regex.codeLength, callNode.target);
        this.addAbsAddr(0);
    }

    protected void compileBackrefNode(BackRefNode backRefNode) {
        BackRefNode backRefNode2 = backRefNode;
        if (backRefNode2.isNestLevel()) {
            this.addOpcode(47);
            this.addOption(this.regex.options & 1);
            this.addLength(backRefNode2.nestLevel);
            this.addLength(backRefNode2.backNum);
            for (int i = backRefNode2.backNum - 1; i >= 0; --i) {
                this.addMemNum(backRefNode2.back[i]);
            }
            return;
        }
        if (backRefNode2.backNum == 1) {
            if (Option.isIgnoreCase(this.regex.options)) {
                this.addOpcode(44);
                this.addMemNum(backRefNode2.back[0]);
            } else {
                switch (backRefNode2.back[0]) {
                    case 1: {
                        this.addOpcode(41);
                        break;
                    }
                    case 2: {
                        this.addOpcode(42);
                        break;
                    }
                    default: {
                        this.addOpcode(43);
                        this.addOpcode(backRefNode2.back[0]);
                        break;
                    }
                }
            }
        } else {
            if (Option.isIgnoreCase(this.regex.options)) {
                this.addOpcode(46);
            } else {
                this.addOpcode(45);
            }
            this.addLength(backRefNode2.backNum);
            for (int i = backRefNode2.backNum - 1; i >= 0; --i) {
                this.addMemNum(backRefNode2.back[i]);
            }
        }
    }

    private void entryRepeatRange(int n, int n2, int n3) {
        if (this.regex.repeatRangeLo == null) {
            this.regex.repeatRangeLo = new int[8];
            this.regex.repeatRangeHi = new int[8];
        } else if (n >= this.regex.repeatRangeLo.length) {
            int[] nArray = new int[this.regex.repeatRangeLo.length + 8];
            System.arraycopy(this.regex.repeatRangeLo, 0, nArray, 0, this.regex.repeatRangeLo.length);
            this.regex.repeatRangeLo = nArray;
            nArray = new int[this.regex.repeatRangeHi.length + 8];
            System.arraycopy(this.regex.repeatRangeHi, 0, nArray, 0, this.regex.repeatRangeHi.length);
            this.regex.repeatRangeHi = nArray;
        }
        this.regex.repeatRangeLo[n] = n2;
        this.regex.repeatRangeHi[n] = QuantifierNode.isRepeatInfinite(n3) ? Integer.MAX_VALUE : n3;
    }

    private void compileRangeRepeatNode(QuantifierNode quantifierNode, int n, int n2) {
        int n3 = this.regex.numRepeat;
        this.addOpcode(quantifierNode.greedy ? 60 : 61);
        this.addMemNum(n3);
        ++this.regex.numRepeat;
        this.addRelAddr(n + 2);
        this.entryRepeatRange(n3, quantifierNode.lower, quantifierNode.upper);
        this.compileTreeEmptyCheck(quantifierNode.target, n2);
        if (this.regex.numCall > 0 || quantifierNode.isInRepeat()) {
            this.addOpcode(quantifierNode.greedy ? 64 : 65);
        } else {
            this.addOpcode(quantifierNode.greedy ? 62 : 63);
        }
        this.addMemNum(n3);
    }

    private static boolean cknOn(int n) {
        return n > 0;
    }

    private int compileCECLengthQuantifierNode(QuantifierNode quantifierNode) {
        int n;
        int n2;
        boolean bl = QuantifierNode.isRepeatInfinite(quantifierNode.upper);
        int n3 = quantifierNode.targetEmptyInfo;
        int n4 = this.compileLengthTree(quantifierNode.target);
        int n5 = this.regex.numCombExpCheck > 0 ? quantifierNode.combExpCheckNum : 0;
        int n6 = n2 = ArrayCompiler.cknOn(n5) ? 1 : 0;
        if (quantifierNode.target.getType() == 3 && quantifierNode.greedy && bl) {
            if (quantifierNode.nextHeadExact != null && !ArrayCompiler.cknOn(n5)) {
                return 2 + n4 * quantifierNode.lower + n2;
            }
            return 1 + n4 * quantifierNode.lower + n2;
        }
        int n7 = n3 != 0 ? n4 + 4 : n4;
        if (bl && quantifierNode.lower <= 1) {
            if (quantifierNode.greedy) {
                n = quantifierNode.lower == 1 ? 2 : 0;
                n += 2 + n2 + n7 + 2;
            } else {
                n = quantifierNode.lower == 0 ? 2 : 0;
                n += n7 + 2 + n2;
            }
        } else if (quantifierNode.upper == 0) {
            n = quantifierNode.isRefered ? 2 + n4 : 0;
        } else if (quantifierNode.upper == 1 && quantifierNode.greedy) {
            n = quantifierNode.lower == 0 ? (ArrayCompiler.cknOn(n5) ? 3 + n4 : 2 + n4) : n4;
        } else if (!quantifierNode.greedy && quantifierNode.upper == 1 && quantifierNode.lower == 0) {
            n = 2 + n2 + 2 + n4;
        } else {
            n = 2 + n7 + 1 + 1 + 1;
            if (ArrayCompiler.cknOn(n5)) {
                n += 2;
            }
        }
        return n;
    }

    protected void compileCECQuantifierNode(QuantifierNode quantifierNode) {
        int n;
        boolean bl = QuantifierNode.isRepeatInfinite(quantifierNode.upper);
        int n2 = quantifierNode.targetEmptyInfo;
        int n3 = this.compileLengthTree(quantifierNode.target);
        int n4 = n = this.regex.numCombExpCheck > 0 ? quantifierNode.combExpCheckNum : 0;
        if (quantifierNode.isAnyCharStar()) {
            this.compileTreeNTimes(quantifierNode.target, quantifierNode.lower);
            if (quantifierNode.nextHeadExact != null && !ArrayCompiler.cknOn(n)) {
                if (Option.isMultiline(this.regex.options)) {
                    this.addOpcode(this.enc.isSingleByte() ? 93 : 28);
                } else {
                    this.addOpcode(this.enc.isSingleByte() ? 92 : 27);
                }
                if (ArrayCompiler.cknOn(n)) {
                    this.addStateCheckNum(n);
                }
                StringNode stringNode = (StringNode)quantifierNode.nextHeadExact;
                this.addBytes(stringNode.bytes, stringNode.p, 1);
                return;
            }
            if (Option.isMultiline(this.regex.options)) {
                if (ArrayCompiler.cknOn(n)) {
                    this.addOpcode(this.enc.isSingleByte() ? 95 : 85);
                } else {
                    this.addOpcode(this.enc.isSingleByte() ? 91 : 26);
                }
            } else if (ArrayCompiler.cknOn(n)) {
                this.addOpcode(this.enc.isSingleByte() ? 94 : 84);
            } else {
                this.addOpcode(this.enc.isSingleByte() ? 90 : 25);
            }
            if (ArrayCompiler.cknOn(n)) {
                this.addStateCheckNum(n);
            }
            return;
        }
        int n5 = n2 != 0 ? n3 + 4 : n3;
        if (bl && quantifierNode.lower <= 1) {
            if (quantifierNode.greedy) {
                if (quantifierNode.lower == 1) {
                    this.addOpcodeRelAddr(55, ArrayCompiler.cknOn(n) ? 3 : 2);
                }
                if (ArrayCompiler.cknOn(n)) {
                    this.addOpcode(81);
                    this.addStateCheckNum(n);
                    this.addRelAddr(n5 + 2);
                } else {
                    this.addOpcodeRelAddr(56, n5 + 2);
                }
                this.compileTreeEmptyCheck(quantifierNode.target, n2);
                this.addOpcodeRelAddr(55, -(n5 + 2 + (ArrayCompiler.cknOn(n) ? 3 : 2)));
            } else {
                if (quantifierNode.lower == 0) {
                    this.addOpcodeRelAddr(55, n5);
                }
                this.compileTreeEmptyCheck(quantifierNode.target, n2);
                if (ArrayCompiler.cknOn(n)) {
                    this.addOpcode(82);
                    this.addStateCheckNum(n);
                    this.addRelAddr(-(n5 + 3));
                } else {
                    this.addOpcodeRelAddr(56, -(n5 + 2));
                }
            }
        } else if (quantifierNode.upper == 0) {
            if (quantifierNode.isRefered) {
                this.addOpcodeRelAddr(55, n3);
                this.compileTree(quantifierNode.target);
            }
        } else if (quantifierNode.upper == 1 && quantifierNode.greedy) {
            if (quantifierNode.lower == 0) {
                if (ArrayCompiler.cknOn(n)) {
                    this.addOpcode(81);
                    this.addStateCheckNum(n);
                    this.addRelAddr(n3);
                } else {
                    this.addOpcodeRelAddr(56, n3);
                }
            }
            this.compileTree(quantifierNode.target);
        } else if (!quantifierNode.greedy && quantifierNode.upper == 1 && quantifierNode.lower == 0) {
            if (ArrayCompiler.cknOn(n)) {
                this.addOpcode(81);
                this.addStateCheckNum(n);
                this.addRelAddr(2);
            } else {
                this.addOpcodeRelAddr(56, 2);
            }
            this.addOpcodeRelAddr(55, n3);
            this.compileTree(quantifierNode.target);
        } else {
            this.compileRangeRepeatNode(quantifierNode, n5, n2);
            if (ArrayCompiler.cknOn(n)) {
                this.addOpcode(83);
                this.addStateCheckNum(n);
            }
        }
    }

    private int compileNonCECLengthQuantifierNode(QuantifierNode quantifierNode) {
        int n;
        boolean bl = QuantifierNode.isRepeatInfinite(quantifierNode.upper);
        int n2 = quantifierNode.targetEmptyInfo;
        int n3 = this.compileLengthTree(quantifierNode.target);
        if (quantifierNode.target.getType() == 3 && quantifierNode.greedy && bl) {
            if (quantifierNode.nextHeadExact != null) {
                return 2 + n3 * quantifierNode.lower;
            }
            return 1 + n3 * quantifierNode.lower;
        }
        int n4 = 0;
        n4 = n2 != 0 ? n3 + 4 : n3;
        if (bl && (quantifierNode.lower <= 1 || n3 * quantifierNode.lower <= 50)) {
            n = quantifierNode.lower == 1 && n3 > 50 ? 2 : n3 * quantifierNode.lower;
            n = quantifierNode.greedy ? (quantifierNode.headExact != null ? (n += 3 + n4 + 2) : (quantifierNode.nextHeadExact != null ? (n += 3 + n4 + 2) : (n += 2 + n4 + 2))) : (n += 2 + n4 + 2);
        } else if (quantifierNode.upper == 0 && quantifierNode.isRefered) {
            n = 2 + n3;
        } else if (!bl && quantifierNode.greedy && (quantifierNode.upper == 1 || (n3 + 2) * quantifierNode.upper <= 50)) {
            n = n3 * quantifierNode.lower;
            n += (2 + n3) * (quantifierNode.upper - quantifierNode.lower);
        } else {
            n = !quantifierNode.greedy && quantifierNode.upper == 1 && quantifierNode.lower == 0 ? 4 + n3 : 2 + n4 + 1 + 1 + 1;
        }
        return n;
    }

    protected void compileNonCECQuantifierNode(QuantifierNode quantifierNode) {
        boolean bl = QuantifierNode.isRepeatInfinite(quantifierNode.upper);
        int n = quantifierNode.targetEmptyInfo;
        int n2 = this.compileLengthTree(quantifierNode.target);
        if (quantifierNode.isAnyCharStar()) {
            this.compileTreeNTimes(quantifierNode.target, quantifierNode.lower);
            if (quantifierNode.nextHeadExact != null) {
                if (Option.isMultiline(this.regex.options)) {
                    this.addOpcode(this.enc.isSingleByte() ? 93 : 28);
                } else {
                    this.addOpcode(this.enc.isSingleByte() ? 92 : 27);
                }
                StringNode stringNode = (StringNode)quantifierNode.nextHeadExact;
                this.addBytes(stringNode.bytes, stringNode.p, 1);
                return;
            }
            if (Option.isMultiline(this.regex.options)) {
                this.addOpcode(this.enc.isSingleByte() ? 91 : 26);
            } else {
                this.addOpcode(this.enc.isSingleByte() ? 90 : 25);
            }
            return;
        }
        int n3 = n != 0 ? n2 + 4 : n2;
        if (bl && (quantifierNode.lower <= 1 || n2 * quantifierNode.lower <= 50)) {
            if (quantifierNode.lower == 1 && n2 > 50) {
                if (quantifierNode.greedy) {
                    if (quantifierNode.headExact != null) {
                        this.addOpcodeRelAddr(55, 3);
                    } else if (quantifierNode.nextHeadExact != null) {
                        this.addOpcodeRelAddr(55, 3);
                    } else {
                        this.addOpcodeRelAddr(55, 2);
                    }
                } else {
                    this.addOpcodeRelAddr(55, 2);
                }
            } else {
                this.compileTreeNTimes(quantifierNode.target, quantifierNode.lower);
            }
            if (quantifierNode.greedy) {
                if (quantifierNode.headExact != null) {
                    this.addOpcodeRelAddr(58, n3 + 2);
                    StringNode stringNode = (StringNode)quantifierNode.headExact;
                    this.addBytes(stringNode.bytes, stringNode.p, 1);
                    this.compileTreeEmptyCheck(quantifierNode.target, n);
                    this.addOpcodeRelAddr(55, -(n3 + 2 + 3));
                } else if (quantifierNode.nextHeadExact != null) {
                    this.addOpcodeRelAddr(59, n3 + 2);
                    StringNode stringNode = (StringNode)quantifierNode.nextHeadExact;
                    this.addBytes(stringNode.bytes, stringNode.p, 1);
                    this.compileTreeEmptyCheck(quantifierNode.target, n);
                    this.addOpcodeRelAddr(55, -(n3 + 2 + 3));
                } else {
                    this.addOpcodeRelAddr(56, n3 + 2);
                    this.compileTreeEmptyCheck(quantifierNode.target, n);
                    this.addOpcodeRelAddr(55, -(n3 + 2 + 2));
                }
            } else {
                this.addOpcodeRelAddr(55, n3);
                this.compileTreeEmptyCheck(quantifierNode.target, n);
                this.addOpcodeRelAddr(56, -(n3 + 2));
            }
        } else if (quantifierNode.upper == 0 && quantifierNode.isRefered) {
            this.addOpcodeRelAddr(55, n2);
            this.compileTree(quantifierNode.target);
        } else if (!bl && quantifierNode.greedy && (quantifierNode.upper == 1 || (n2 + 2) * quantifierNode.upper <= 50)) {
            int n4 = quantifierNode.upper - quantifierNode.lower;
            this.compileTreeNTimes(quantifierNode.target, quantifierNode.lower);
            for (int i = 0; i < n4; ++i) {
                this.addOpcodeRelAddr(56, (n4 - i) * n2 + (n4 - i - 1) * 2);
                this.compileTree(quantifierNode.target);
            }
        } else if (!quantifierNode.greedy && quantifierNode.upper == 1 && quantifierNode.lower == 0) {
            this.addOpcodeRelAddr(56, 2);
            this.addOpcodeRelAddr(55, n2);
            this.compileTree(quantifierNode.target);
        } else {
            this.compileRangeRepeatNode(quantifierNode, n3, n);
        }
    }

    private int compileLengthOptionNode(EncloseNode encloseNode) {
        int n = this.regex.options;
        this.regex.options = encloseNode.option;
        int n2 = this.compileLengthTree(encloseNode.target);
        this.regex.options = n;
        if (Option.isDynamic(n ^ encloseNode.option)) {
            return 5 + n2 + 2;
        }
        return n2;
    }

    protected void compileOptionNode(EncloseNode encloseNode) {
        int n = this.regex.options;
        if (Option.isDynamic(n ^ encloseNode.option)) {
            this.addOpcodeOption(86, encloseNode.option);
            this.addOpcodeOption(87, n);
            this.addOpcode(54);
        }
        this.regex.options = encloseNode.option;
        this.compileTree(encloseNode.target);
        this.regex.options = n;
        if (Option.isDynamic(n ^ encloseNode.option)) {
            this.addOpcodeOption(87, n);
        }
    }

    private int compileLengthEncloseNode(EncloseNode encloseNode) {
        int n;
        if (encloseNode.isOption()) {
            return this.compileLengthOptionNode(encloseNode);
        }
        int n2 = encloseNode.target != null ? this.compileLengthTree(encloseNode.target) : 0;
        switch (encloseNode.type) {
            case 1: {
                if (encloseNode.isCalled()) {
                    n = 2 + n2 + 2 + 2 + 1;
                    if (BitStatus.bsAt(this.regex.btMemEnd, encloseNode.regNum)) {
                        n += encloseNode.isRecursion() ? 2 : 2;
                        break;
                    }
                    n += encloseNode.isRecursion() ? 2 : 2;
                    break;
                }
                n = BitStatus.bsAt(this.regex.btMemStart, encloseNode.regNum) ? 2 : 2;
                n += n2 + (BitStatus.bsAt(this.regex.btMemEnd, encloseNode.regNum) ? 2 : 2);
                break;
            }
            case 4: {
                if (encloseNode.isStopBtSimpleRepeat()) {
                    QuantifierNode quantifierNode = (QuantifierNode)encloseNode.target;
                    n2 = this.compileLengthTree(quantifierNode.target);
                    n = n2 * quantifierNode.lower + 2 + n2 + 1 + 2;
                    break;
                }
                n = 1 + n2 + 1;
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
                return 0;
            }
        }
        return n;
    }

    protected void compileEncloseNode(EncloseNode encloseNode) {
        switch (encloseNode.type) {
            case 1: {
                if (encloseNode.isCalled()) {
                    this.addOpcode(79);
                    encloseNode.callAddr = this.regex.codeLength + 1 + 2;
                    encloseNode.setAddrFixed();
                    this.addAbsAddr(encloseNode.callAddr);
                    int n = this.compileLengthTree(encloseNode.target);
                    n += 3;
                    n = BitStatus.bsAt(this.regex.btMemEnd, encloseNode.regNum) ? (n += encloseNode.isRecursion() ? 2 : 2) : (n += encloseNode.isRecursion() ? 2 : 2);
                    this.addOpcodeRelAddr(55, n);
                }
                if (BitStatus.bsAt(this.regex.btMemStart, encloseNode.regNum)) {
                    this.addOpcode(49);
                } else {
                    this.addOpcode(48);
                }
                this.addMemNum(encloseNode.regNum);
                this.compileTree(encloseNode.target);
                if (encloseNode.isCalled()) {
                    if (BitStatus.bsAt(this.regex.btMemEnd, encloseNode.regNum)) {
                        this.addOpcode(encloseNode.isRecursion() ? 51 : 50);
                    } else {
                        this.addOpcode(encloseNode.isRecursion() ? 53 : 52);
                    }
                    this.addMemNum(encloseNode.regNum);
                    this.addOpcode(80);
                    break;
                }
                if (BitStatus.bsAt(this.regex.btMemEnd, encloseNode.regNum)) {
                    this.addOpcode(50);
                } else {
                    this.addOpcode(52);
                }
                this.addMemNum(encloseNode.regNum);
                break;
            }
            case 4: {
                if (encloseNode.isStopBtSimpleRepeat()) {
                    QuantifierNode quantifierNode = (QuantifierNode)encloseNode.target;
                    this.compileTreeNTimes(quantifierNode.target, quantifierNode.lower);
                    int n = this.compileLengthTree(quantifierNode.target);
                    this.addOpcodeRelAddr(56, n + 1 + 2);
                    this.compileTree(quantifierNode.target);
                    this.addOpcode(57);
                    this.addOpcodeRelAddr(55, -(2 + n + 1 + 2));
                    break;
                }
                this.addOpcode(74);
                this.compileTree(encloseNode.target);
                this.addOpcode(75);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    private int compileLengthAnchorNode(AnchorNode anchorNode) {
        int n;
        int n2 = anchorNode.target != null ? this.compileLengthTree(anchorNode.target) : 0;
        switch (anchorNode.type) {
            case 1024: {
                n = 1 + n2 + 1;
                break;
            }
            case 2048: {
                n = 2 + n2 + 1;
                break;
            }
            case 4096: {
                n = 2 + n2;
                break;
            }
            case 8192: {
                n = 3 + n2 + 1;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    protected void compileAnchorNode(AnchorNode anchorNode) {
        switch (anchorNode.type) {
            case 1: {
                this.addOpcode(35);
                break;
            }
            case 8: {
                this.addOpcode(36);
                break;
            }
            case 2: {
                this.addOpcode(37);
                break;
            }
            case 32: {
                this.addOpcode(38);
                break;
            }
            case 16: {
                this.addOpcode(39);
                break;
            }
            case 4: {
                this.addOpcode(40);
                break;
            }
            case 64: {
                this.addOpcode(this.enc.isSingleByte() ? 100 : 31);
                break;
            }
            case 128: {
                this.addOpcode(this.enc.isSingleByte() ? 101 : 32);
                break;
            }
            case 256: {
                this.addOpcode(this.enc.isSingleByte() ? 102 : 33);
                break;
            }
            case 512: {
                this.addOpcode(this.enc.isSingleByte() ? 103 : 34);
                break;
            }
            case 1024: {
                this.addOpcode(70);
                this.compileTree(anchorNode.target);
                this.addOpcode(71);
                break;
            }
            case 2048: {
                int n = this.compileLengthTree(anchorNode.target);
                this.addOpcodeRelAddr(72, n + 1);
                this.compileTree(anchorNode.target);
                this.addOpcode(73);
                break;
            }
            case 4096: {
                int n;
                this.addOpcode(this.enc.isSingleByte() ? 104 : 76);
                if (anchorNode.charLength < 0) {
                    n = this.analyser.getCharLengthTree(anchorNode.target);
                    if (this.analyser.returnCode != 0) {
                        this.newSyntaxException("invalid pattern in look-behind");
                    }
                } else {
                    n = anchorNode.charLength;
                }
                this.addLength(n);
                this.compileTree(anchorNode.target);
                break;
            }
            case 8192: {
                int n;
                int n2 = this.compileLengthTree(anchorNode.target);
                this.addOpcodeRelAddr(77, n2 + 1);
                if (anchorNode.charLength < 0) {
                    n = this.analyser.getCharLengthTree(anchorNode.target);
                    if (this.analyser.returnCode != 0) {
                        this.newSyntaxException("invalid pattern in look-behind");
                    }
                } else {
                    n = anchorNode.charLength;
                }
                this.addLength(n);
                this.compileTree(anchorNode.target);
                this.addOpcode(78);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    private int compileLengthTree(Node node) {
        int n = 0;
        switch (node.getType()) {
            case 8: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    n += this.compileLengthTree(consAltNode.car);
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                int n2 = 0;
                do {
                    n += this.compileLengthTree(consAltNode.car);
                    ++n2;
                } while ((consAltNode = consAltNode.cdr) != null);
                n += 4 * (n2 - 1);
                break;
            }
            case 0: {
                StringNode stringNode = (StringNode)node;
                if (stringNode.isRaw()) {
                    n = this.compileLengthStringRawNode(stringNode);
                    break;
                }
                n = this.compileLengthStringNode(stringNode);
                break;
            }
            case 1: {
                n = this.compileLengthCClassNode((CClassNode)node);
                break;
            }
            case 2: 
            case 3: {
                n = 1;
                break;
            }
            case 4: {
                BackRefNode backRefNode = (BackRefNode)node;
                if (backRefNode.isNestLevel()) {
                    n = 4 + 1 * backRefNode.backNum;
                    break;
                }
                if (backRefNode.backNum == 1) {
                    n = !Option.isIgnoreCase(this.regex.options) && backRefNode.back[0] <= 2 ? 1 : 2;
                    break;
                }
                n = 2 + 1 * backRefNode.backNum;
                break;
            }
            case 10: {
                n = 2;
                break;
            }
            case 5: {
                n = this.compileNonCECLengthQuantifierNode((QuantifierNode)node);
                break;
            }
            case 6: {
                n = this.compileLengthEncloseNode((EncloseNode)node);
                break;
            }
            case 7: {
                n = this.compileLengthAnchorNode((AnchorNode)node);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
        return n;
    }

    private void ensure(int n) {
        if (n >= this.regex.code.length) {
            int n2;
            for (n2 = this.regex.code.length << 1; n2 <= n; n2 <<= 1) {
            }
            int[] nArray = new int[n2];
            System.arraycopy(this.regex.code, 0, nArray, 0, this.regex.code.length);
            this.regex.code = nArray;
        }
    }

    private void addInt(int n) {
        if (this.regex.codeLength >= this.regex.code.length) {
            int[] nArray = new int[this.regex.code.length << 1];
            System.arraycopy(this.regex.code, 0, nArray, 0, this.regex.code.length);
            this.regex.code = nArray;
        }
        this.regex.code[this.regex.codeLength++] = n;
    }

    void setInt(int n, int n2) {
        this.ensure(n2);
        this.regex.code[n2] = n;
    }

    private void addObject(Object object) {
        if (this.regex.operands == null) {
            this.regex.operands = new Object[4];
        } else if (this.regex.operandLength >= this.regex.operands.length) {
            Object[] objectArray = new Object[this.regex.operands.length << 1];
            System.arraycopy(this.regex.operands, 0, objectArray, 0, this.regex.operands.length);
            this.regex.operands = objectArray;
        }
        this.addInt(this.regex.operandLength);
        this.regex.operands[this.regex.operandLength++] = object;
    }

    private void addBytes(byte[] byArray, int n, int n2) {
        this.ensure(this.regex.codeLength + n2);
        int n3 = n + n2;
        while (n < n3) {
            this.regex.code[this.regex.codeLength++] = byArray[n++];
        }
    }

    private void addInts(int[] nArray, int n) {
        this.ensure(this.regex.codeLength + n);
        System.arraycopy(nArray, 0, this.regex.code, this.regex.codeLength, n);
        this.regex.codeLength += n;
    }

    private void addOpcode(int n) {
        this.addInt(n);
        switch (n) {
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 70: 
            case 72: 
            case 74: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                this.regex.stackNeeded = true;
            }
        }
    }

    private void addStateCheckNum(int n) {
        this.addInt(n);
    }

    private void addRelAddr(int n) {
        this.addInt(n);
    }

    private void addAbsAddr(int n) {
        this.addInt(n);
    }

    private void addLength(int n) {
        this.addInt(n);
    }

    private void addMemNum(int n) {
        this.addInt(n);
    }

    private void addPointer(Object object) {
        this.addObject(object);
    }

    private void addOption(int n) {
        this.addInt(n);
    }

    private void addOpcodeRelAddr(int n, int n2) {
        this.addOpcode(n);
        this.addRelAddr(n2);
    }

    private void addOpcodeOption(int n, int n2) {
        this.addOpcode(n);
        this.addOption(n2);
    }
}

