/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import com.kenai.constantine.platform.AddressFamily;
import com.kenai.constantine.platform.INAddr;
import com.kenai.constantine.platform.IPProto;
import com.kenai.constantine.platform.NameInfo;
import com.kenai.constantine.platform.ProtocolFamily;
import com.kenai.constantine.platform.Shutdown;
import com.kenai.constantine.platform.Sock;
import com.kenai.constantine.platform.SocketLevel;
import com.kenai.constantine.platform.SocketOption;
import com.kenai.constantine.platform.TCP;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.IANA;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.ext.socket.RubyTCPServer;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.ext.socket.RubyUDPSocket;
import org.jruby.ext.socket.RubyUNIXServer;
import org.jruby.ext.socket.RubyUNIXSocket;
import org.jruby.platform.Platform;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.ByteList;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"Socket"}, parent="BasicSocket", include={"Socket::Constants"})
public class RubySocket
extends RubyBasicSocket {
    private static ObjectAllocator SOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubySocket(runtime2, klass);
        }
    };
    public static final int MSG_OOB = 1;
    public static final int MSG_PEEK = 2;
    public static final int MSG_DONTROUTE = 4;
    private int soDomain;
    private int soType;
    private int soProtocol;
    private static final ByteList BROADCAST = new ByteList("<broadcast>".getBytes());
    private static final byte[] INADDR_BROADCAST = new byte[]{-1, -1, -1, -1};
    private static final ByteList ANY = new ByteList("<any>".getBytes());
    private static final byte[] INADDR_ANY = new byte[]{0, 0, 0, 0};
    private static final Pattern STRING_ADDRESS_PATTERN = Pattern.compile("((.*)\\/)?([\\.0-9]+)(:([0-9]+))?");
    private static final int HOST_GROUP = 3;
    private static final int PORT_GROUP = 5;

    static void createSocket(Ruby runtime2) {
        RubyClass rb_cSocket = runtime2.defineClass("Socket", runtime2.fastGetClass("BasicSocket"), SOCKET_ALLOCATOR);
        RubyModule rb_mConstants = rb_cSocket.defineModuleUnder("Constants");
        runtime2.loadConstantSet(rb_mConstants, Sock.class);
        runtime2.loadConstantSet(rb_mConstants, SocketOption.class);
        runtime2.loadConstantSet(rb_mConstants, SocketLevel.class);
        runtime2.loadConstantSet(rb_mConstants, ProtocolFamily.class);
        runtime2.loadConstantSet(rb_mConstants, AddressFamily.class);
        runtime2.loadConstantSet(rb_mConstants, INAddr.class);
        runtime2.loadConstantSet(rb_mConstants, IPProto.class);
        runtime2.loadConstantSet(rb_mConstants, Shutdown.class);
        runtime2.loadConstantSet(rb_mConstants, TCP.class);
        runtime2.loadConstantSet(rb_mConstants, NameInfo.class);
        rb_mConstants.fastSetConstant("MSG_OOB", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("MSG_PEEK", runtime2.newFixnum(2));
        rb_mConstants.fastSetConstant("MSG_DONTROUTE", runtime2.newFixnum(4));
        rb_mConstants.fastSetConstant("AI_PASSIVE", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("IP_MULTICAST_TTL", runtime2.newFixnum(10));
        rb_mConstants.fastSetConstant("IP_MULTICAST_LOOP", runtime2.newFixnum(11));
        rb_mConstants.fastSetConstant("IP_ADD_MEMBERSHIP", runtime2.newFixnum(12));
        rb_mConstants.fastSetConstant("IP_MAX_MEMBERSHIPS", runtime2.newFixnum(20));
        rb_mConstants.fastSetConstant("IP_DEFAULT_MULTICAST_LOOP", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("IP_DEFAULT_MULTICAST_TTL", runtime2.newFixnum(1));
        rb_cSocket.includeModule(rb_mConstants);
        rb_cSocket.defineAnnotatedMethods(RubySocket.class);
    }

    public RubySocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    protected int getSoTypeDefault() {
        return this.soType;
    }

    @Deprecated
    public static IRubyObject for_fd(IRubyObject socketClass, IRubyObject fd) {
        return RubySocket.for_fd(socketClass.getRuntime().getCurrentContext(), socketClass, fd);
    }

    @JRubyMethod(frame=true, meta=true)
    public static IRubyObject for_fd(ThreadContext context, IRubyObject socketClass, IRubyObject fd) {
        Ruby ruby = context.getRuntime();
        if (fd instanceof RubyFixnum) {
            RubySocket socket2 = (RubySocket)((RubyClass)socketClass).allocate();
            ChannelDescriptor descriptor = socket2.getDescriptorByFileno((int)((RubyFixnum)fd).getLongValue());
            if (descriptor == null) {
                throw ruby.newErrnoEBADFError();
            }
            Channel mainChannel = descriptor.getChannel();
            if (mainChannel instanceof SocketChannel) {
                socket2.soDomain = AddressFamily.AF_INET.value();
                socket2.soType = Sock.SOCK_STREAM.value();
                socket2.soProtocol = 0;
            } else if (mainChannel instanceof DatagramChannel) {
                socket2.soDomain = AddressFamily.AF_INET.value();
                socket2.soType = Sock.SOCK_DGRAM.value();
                socket2.soProtocol = 0;
            } else {
                throw context.getRuntime().newErrnoENOTSOCKError("can't Socket.new/for_fd against a non-socket");
            }
            socket2.initSocket(ruby, descriptor);
            return socket2;
        }
        throw context.getRuntime().newTypeError(fd, context.getRuntime().getFixnum());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject domain, IRubyObject type2, IRubyObject protocol) {
        try {
            void var5_11;
            if (domain instanceof RubyString) {
                String string2 = domain.toString();
                if (string2.equals("AF_INET")) {
                    this.soDomain = AddressFamily.AF_INET.value();
                } else {
                    if (!string2.equals("PF_INET")) throw RubySocket.sockerr(context.getRuntime(), "unknown socket domain " + string2);
                    this.soDomain = ProtocolFamily.PF_INET.value();
                }
            } else {
                this.soDomain = RubyNumeric.fix2int(domain);
            }
            if (type2 instanceof RubyString) {
                String string3 = type2.toString();
                if (string3.equals("SOCK_STREAM")) {
                    this.soType = Sock.SOCK_STREAM.value();
                } else {
                    if (!string3.equals("SOCK_DGRAM")) throw RubySocket.sockerr(context.getRuntime(), "unknown socket type " + string3);
                    this.soType = Sock.SOCK_DGRAM.value();
                }
            } else {
                this.soType = RubyNumeric.fix2int(type2);
            }
            this.soProtocol = RubyNumeric.fix2int(protocol);
            Object var5_8 = null;
            if (this.soType == Sock.SOCK_STREAM.value()) {
                SocketChannel socketChannel = SocketChannel.open();
            } else if (this.soType == Sock.SOCK_DGRAM.value()) {
                DatagramChannel datagramChannel = DatagramChannel.open();
            }
            this.initSocket(context.getRuntime(), new ChannelDescriptor((Channel)var5_11, RubyIO.getNewFileno(), new ModeFlags(ModeFlags.RDWR), new FileDescriptor()));
            return this;
        }
        catch (InvalidValueException invalidValueException) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (IOException iOException) {
            throw RubySocket.sockerr(context.getRuntime(), "initialize: " + iOException.toString());
        }
    }

    private static RuntimeException sockerr(Ruby runtime2, String msg) {
        return new RaiseException(runtime2, runtime2.fastGetClass("SocketError"), msg, true);
    }

    @Deprecated
    public static IRubyObject gethostname(IRubyObject recv2) {
        return RubySocket.gethostname(recv2.getRuntime().getCurrentContext(), recv2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostname(ThreadContext context, IRubyObject recv2) {
        try {
            return context.getRuntime().newString(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            try {
                return context.getRuntime().newString(InetAddress.getByAddress(new byte[]{0, 0, 0, 0}).getHostName());
            }
            catch (UnknownHostException e2) {
                throw RubySocket.sockerr(context.getRuntime(), "gethostname: name or service not known");
            }
        }
    }

    private static InetAddress intoAddress(Ruby runtime2, String s) {
        try {
            byte[] bs = ByteList.plain(s);
            return InetAddress.getByAddress(bs);
        }
        catch (Exception e) {
            throw RubySocket.sockerr(runtime2, "strtoaddr: " + e.toString());
        }
    }

    private static String intoString(Ruby runtime2, InetAddress as) {
        try {
            return new String(ByteList.plain(as.getAddress()));
        }
        catch (Exception e) {
            throw RubySocket.sockerr(runtime2, "addrtostr: " + e.toString());
        }
    }

    @Deprecated
    public static IRubyObject gethostbyaddr(IRubyObject recv2, IRubyObject[] args2) {
        return RubySocket.gethostbyaddr(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(required=1, rest=true, meta=true)
    public static IRubyObject gethostbyaddr(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject[] ret = new IRubyObject[]{runtime2.newString(RubySocket.intoAddress(runtime2, args2[0].convertToString().toString()).getCanonicalHostName()), runtime2.newArray(), runtime2.newFixnum(2), args2[0]};
        return runtime2.newArrayNoCopy(ret);
    }

    @Deprecated
    public static IRubyObject getservbyname(IRubyObject recv2, IRubyObject[] args2) {
        return RubySocket.getservbyname(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject getservbyname(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        int argc = Arity.checkArgumentCount(runtime2, args2, 1, 2);
        String name2 = args2[0].convertToString().toString();
        String service = argc == 1 ? "tcp" : args2[1].convertToString().toString();
        Integer port = IANA.serviceToPort.get(name2 + "/" + service);
        if (port == null) {
            throw RubySocket.sockerr(runtime2, "no such service " + name2 + "/" + service);
        }
        return runtime2.newFixnum(port);
    }

    @Deprecated
    public static IRubyObject pack_sockaddr_un(IRubyObject recv2, IRubyObject filename2) {
        return RubySocket.pack_sockaddr_un(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"pack_sockaddr_un", "sockaddr_un"}, meta=true)
    public static IRubyObject pack_sockaddr_un(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        StringBuilder sb = new StringBuilder();
        sb.append('\u0000');
        sb.append('\u0001');
        String str = filename2.convertToString().toString();
        sb.append(str);
        for (int i = str.length(); i < 104; ++i) {
            sb.append('\u0000');
        }
        return context.getRuntime().newString(sb.toString());
    }

    @Deprecated
    public static IRubyObject pack_sockaddr_in(IRubyObject recv2, IRubyObject port, IRubyObject host) {
        return RubySocket.pack_sockaddr_in(recv2.getRuntime().getCurrentContext(), recv2, port, host);
    }

    @JRubyMethod(name={"pack_sockaddr_in", "sockaddr_in"}, meta=true)
    public static IRubyObject pack_sockaddr_in(ThreadContext context, IRubyObject recv2, IRubyObject port, IRubyObject host) {
        return RubySocket.pack_sockaddr_in(context, recv2, RubyNumeric.fix2int(port), host.isNil() ? null : host.convertToString().toString());
    }

    public static IRubyObject pack_sockaddr_in(ThreadContext context, IRubyObject recv2, int iport, String host) {
        ByteArrayOutputStream bufS = new ByteArrayOutputStream();
        try {
            DataOutputStream ds = new DataOutputStream(bufS);
            if (Platform.IS_BSD) {
                ds.write(16);
                ds.write(2);
            } else {
                ds.write(2);
                ds.write(0);
            }
            ds.write(iport >> 8);
            ds.write(iport);
            try {
                if (host != null && "".equals(host)) {
                    ds.writeInt(0);
                } else {
                    InetAddress[] addrs = InetAddress.getAllByName(host);
                    byte[] addr2 = addrs[0].getAddress();
                    ds.write(addr2, 0, addr2.length);
                }
            }
            catch (UnknownHostException e) {
                throw RubySocket.sockerr(context.getRuntime(), "getaddrinfo: No address associated with nodename");
            }
            ds.writeInt(0);
            ds.writeInt(0);
        }
        catch (IOException e) {
            throw RubySocket.sockerr(context.getRuntime(), "pack_sockaddr_in: internal error");
        }
        return context.getRuntime().newString(new ByteList(bufS.toByteArray(), false));
    }

    @Deprecated
    public static IRubyObject unpack_sockaddr_in(IRubyObject recv2, IRubyObject addr2) {
        return RubySocket.unpack_sockaddr_in(recv2.getRuntime().getCurrentContext(), recv2, addr2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject unpack_sockaddr_in(ThreadContext context, IRubyObject recv2, IRubyObject addr2) {
        String val = addr2.convertToString().toString();
        if (Platform.IS_BSD && val.charAt(0) != '\u0010' && val.charAt(1) != '\u0002' || !Platform.IS_BSD && val.charAt(0) != '\u0002') {
            throw context.getRuntime().newArgumentError("can't resolve socket address of wrong type");
        }
        int port = (val.charAt(2) << 8) + val.charAt(3);
        StringBuilder sb = new StringBuilder();
        sb.append((int)val.charAt(4));
        sb.append(".");
        sb.append((int)val.charAt(5));
        sb.append(".");
        sb.append((int)val.charAt(6));
        sb.append(".");
        sb.append((int)val.charAt(7));
        IRubyObject[] result = new IRubyObject[]{context.getRuntime().newFixnum(port), context.getRuntime().newString(sb.toString())};
        return context.getRuntime().newArrayNoCopy(result);
    }

    public static InetAddress getRubyInetAddress(ByteList address2) throws UnknownHostException {
        if (address2.equal(BROADCAST)) {
            return InetAddress.getByAddress(INADDR_BROADCAST);
        }
        if (address2.equal(ANY)) {
            return InetAddress.getByAddress(INADDR_ANY);
        }
        return InetAddress.getByName(address2.toString());
    }

    @Deprecated
    public static IRubyObject gethostbyname(IRubyObject recv2, IRubyObject hostname) {
        return RubySocket.gethostbyname(recv2.getRuntime().getCurrentContext(), recv2, hostname);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostbyname(ThreadContext context, IRubyObject recv2, IRubyObject hostname) {
        try {
            InetAddress addr2 = RubySocket.getRubyInetAddress(hostname.convertToString().getByteList());
            Ruby runtime2 = context.getRuntime();
            IRubyObject[] ret = new IRubyObject[]{runtime2.newString(addr2.getCanonicalHostName()), runtime2.newArray(), runtime2.newFixnum(2), runtime2.newString(new ByteList(addr2.getAddress()))};
            return runtime2.newArrayNoCopy(ret);
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(context.getRuntime(), "gethostbyname: name or service not known");
        }
    }

    @Deprecated
    public static IRubyObject getaddrinfo(IRubyObject recv2, IRubyObject[] args2) {
        return RubySocket.getaddrinfo(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(required=2, optional=4, meta=true)
    public static IRubyObject getaddrinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        args2 = Arity.scanArgs(context.getRuntime(), args2, 2, 4);
        try {
            int flag;
            boolean emptyHost;
            Ruby r = context.getRuntime();
            IRubyObject host = args2[0];
            IRubyObject port = args2[1];
            boolean bl = emptyHost = host.isNil() || host.convertToString().isEmpty();
            if (port instanceof RubyString) {
                port = RubySocket.getservbyname(context, recv2, new IRubyObject[]{port});
            }
            IRubyObject socktype = args2[3];
            IRubyObject flags = args2[5];
            boolean sock_stream = true;
            boolean sock_dgram = true;
            if (!socktype.isNil()) {
                int val = RubyNumeric.fix2int(socktype);
                if (val == Sock.SOCK_STREAM.value()) {
                    sock_dgram = false;
                } else if (val == Sock.SOCK_DGRAM.value()) {
                    sock_stream = false;
                }
            }
            InetAddress[] addrs = null;
            if (!flags.isNil() && (flag = RubyNumeric.fix2int(flags)) == 1 && emptyHost) {
                addrs = InetAddress.getAllByName("0.0.0.0");
            }
            if (addrs == null) {
                addrs = InetAddress.getAllByName(emptyHost ? null : host.convertToString().toString());
            }
            ArrayList<IRubyObject> l = new ArrayList<IRubyObject>();
            for (int i = 0; i < addrs.length; ++i) {
                IRubyObject[] c;
                if (sock_dgram) {
                    c = new IRubyObject[]{r.newString("AF_INET"), port, r.newString(addrs[i].getCanonicalHostName()), r.newString(addrs[i].getHostAddress()), r.newFixnum(ProtocolFamily.PF_INET), r.newFixnum(Sock.SOCK_DGRAM), r.newFixnum(IPProto.IPPROTO_UDP)};
                    l.add(r.newArrayNoCopy(c));
                }
                if (!sock_stream) continue;
                c = new IRubyObject[]{r.newString("AF_INET"), port, r.newString(addrs[i].getCanonicalHostName()), r.newString(addrs[i].getHostAddress()), r.newFixnum(ProtocolFamily.PF_INET), r.newFixnum(Sock.SOCK_STREAM), r.newFixnum(IPProto.IPPROTO_TCP)};
                l.add(r.newArrayNoCopy(c));
            }
            return r.newArray(l);
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(context.getRuntime(), "getaddrinfo: name or service not known");
        }
    }

    @Deprecated
    public static IRubyObject getnameinfo(IRubyObject recv2, IRubyObject[] args2) {
        return RubySocket.getnameinfo(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject getnameinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        String serv;
        InetAddress addr2;
        String port;
        String host;
        Ruby runtime2 = context.getRuntime();
        int argc = Arity.checkArgumentCount(runtime2, args2, 1, 2);
        int flags = argc == 2 ? RubyNumeric.num2int(args2[1]) : 0;
        IRubyObject arg0 = args2[0];
        if (arg0 instanceof RubyArray) {
            List list2 = ((RubyArray)arg0).getList();
            int len = list2.size();
            if (len < 3 || len > 4) {
                throw runtime2.newArgumentError("array size should be 3 or 4, " + len + " given");
            }
            host = list2.get(2).toString();
            port = list2.get(1).toString();
        } else {
            if (!(arg0 instanceof RubyString)) throw runtime2.newArgumentError("invalid args");
            String arg2 = ((RubyString)arg0).toString();
            Matcher m = STRING_ADDRESS_PATTERN.matcher(arg2);
            if (!m.matches()) {
                IRubyObject obj = RubySocket.unpack_sockaddr_in(context, recv2, arg0);
                if (!(obj instanceof RubyArray)) throw runtime2.newArgumentError("invalid address string");
                List list3 = ((RubyArray)obj).getList();
                int len = list3.size();
                if (len != 2) {
                    throw runtime2.newArgumentError("invalid address representation");
                }
                host = list3.get(1).toString();
                port = list3.get(0).toString();
            } else {
                host = m.group(3);
                if (host == null || host.length() == 0 || (port = m.group(5)) == null || port.length() == 0) {
                    throw runtime2.newArgumentError("invalid address string");
                }
            }
        }
        try {
            addr2 = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(runtime2, "unknown host: " + host);
        }
        host = (flags & NameInfo.NI_NUMERICHOST.value()) == 0 ? addr2.getCanonicalHostName() : addr2.getHostAddress();
        if ((flags & NameInfo.NI_NUMERICSERV.value()) != 0 || (serv = IANA.portToService.get(Integer.parseInt(port))) == null) return runtime2.newArray((IRubyObject)runtime2.newString(host), (IRubyObject)runtime2.newString(port));
        port = serv.substring(0, serv.indexOf(47));
        return runtime2.newArray((IRubyObject)runtime2.newString(host), (IRubyObject)runtime2.newString(port));
    }

    @JRubyModule(name={"Socket::Constants"})
    public static class Constants {
    }

    public static class Service
    implements Library {
        public void load(Ruby runtime2, boolean wrap2) throws IOException {
            runtime2.defineClass("SocketError", runtime2.getStandardError(), runtime2.getStandardError().getAllocator());
            RubyBasicSocket.createBasicSocket(runtime2);
            RubySocket.createSocket(runtime2);
            runtime2.getInstanceConfig();
            if (RubyInstanceConfig.nativeEnabled && RubyUNIXSocket.tryUnixDomainSocket()) {
                RubyUNIXSocket.createUNIXSocket(runtime2);
                RubyUNIXServer.createUNIXServer(runtime2);
            }
            RubyIPSocket.createIPSocket(runtime2);
            RubyTCPSocket.createTCPSocket(runtime2);
            RubyTCPServer.createTCPServer(runtime2);
            RubyUDPSocket.createUDPSocket(runtime2);
        }
    }

    @JRubyClass(name={"SocketError"}, parent="StandardError")
    public static class SocketError {
    }
}

