/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class ZlibDeflate {
    private final Deflater flater;
    private final Ruby runtime;
    private ByteList collected;
    public static final int BASE_SIZE = 100;
    public static final int DEF_MEM_LEVEL = 8;
    public static final int MAX_MEM_LEVEL = 9;
    public static final int MAX_WBITS = 15;
    public static final int NO_FLUSH = 0;
    public static final int SYNC_FLUSH = 2;
    public static final int FULL_FLUSH = 3;
    public static final int FINISH = 4;

    public ZlibDeflate(IRubyObject caller, int level2, int win_bits, int memlevel, int strategy) {
        this.flater = new Deflater(level2, win_bits < 0);
        this.flater.setStrategy(strategy);
        this.collected = new ByteList(100);
        this.runtime = caller.getRuntime();
    }

    public static IRubyObject s_deflate(IRubyObject caller, ByteList str, int level2) throws DataFormatException, IOException {
        ZlibDeflate zstream = new ZlibDeflate(caller, level2, 15, 8, 0);
        IRubyObject result = zstream.deflate(str, 4);
        zstream.close();
        return result;
    }

    public Deflater getDeflater() {
        return this.flater;
    }

    public void append(IRubyObject obj) throws IOException, UnsupportedEncodingException {
        this.append(obj.convertToString().getByteList());
    }

    public void append(ByteList obj) throws IOException {
        this.flater.setInput(obj.unsafeBytes(), obj.begin, obj.realSize);
        this.run();
    }

    public void params(int level2, int strategy) {
        this.flater.setLevel(level2);
        this.flater.setStrategy(strategy);
        this.run();
    }

    public IRubyObject set_dictionary(IRubyObject str) throws UnsupportedEncodingException {
        this.flater.setDictionary(str.convertToString().getBytes());
        this.run();
        return str;
    }

    public IRubyObject flush(int flush2) throws IOException {
        return this.deflate(new ByteList(0), flush2);
    }

    public IRubyObject deflate(ByteList str, int flush2) throws IOException {
        if (null == str) {
            return this.finish();
        }
        this.append(str);
        if (flush2 == 4) {
            return this.finish();
        }
        return RubyString.newEmptyString(this.runtime);
    }

    public IRubyObject finish() throws IOException {
        this.flater.finish();
        this.run();
        return RubyString.newString(this.runtime, this.collected);
    }

    private void run() {
        byte[] outp = new byte[1024];
        int resultLength = -1;
        while (!this.flater.finished() && resultLength != 0) {
            resultLength = this.flater.deflate(outp);
            this.collected.append(outp, 0, resultLength);
            if (resultLength != outp.length) continue;
            outp = new byte[outp.length * 2];
        }
    }

    public void close() {
    }
}

