/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import com.kenai.constantine.platform.AddressFamily;
import com.kenai.constantine.platform.Fcntl;
import com.kenai.constantine.platform.OpenFlags;
import com.kenai.constantine.platform.ProtocolFamily;
import com.kenai.constantine.platform.Sock;
import com.kenai.constantine.platform.SocketLevel;
import com.kenai.constantine.platform.SocketOption;
import com.kenai.jaffl.LastError;
import com.kenai.jaffl.Library;
import com.kenai.jaffl.annotations.In;
import com.kenai.jaffl.annotations.Out;
import com.kenai.jaffl.annotations.Transient;
import com.kenai.jaffl.byref.IntByReference;
import com.kenai.jaffl.struct.Struct;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.posix.util.Platform;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"UNIXSocket"}, parent="BasicSocket")
public class RubyUNIXSocket
extends RubyBasicSocket {
    protected static volatile LibCSocket INSTANCE = null;
    private static ObjectAllocator UNIXSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyUNIXSocket(runtime2, klass);
        }
    };
    protected int fd;
    protected String fpath;
    protected static final int F_GETFL = Fcntl.F_GETFL.value();
    protected static final int F_SETFL = Fcntl.F_SETFL.value();
    protected static final int O_NONBLOCK = OpenFlags.O_NONBLOCK.value();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryUnixDomainSocket() {
        if (INSTANCE != null) {
            return true;
        }
        try {
            Class<RubyUNIXSocket> clazz = RubyUNIXSocket.class;
            synchronized (RubyUNIXSocket.class) {
                String[] stringArray;
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return true;
                }
                if (Platform.IS_SOLARIS) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "socket";
                    stringArray2[1] = "nsl";
                    stringArray = stringArray2;
                    stringArray2[2] = "c";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "c";
                }
                String[] libnames = stringArray;
                INSTANCE = Library.loadLibrary(LibCSocket.class, libnames);
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
        }
        catch (Throwable e) {
            return false;
        }
    }

    static void createUNIXSocket(Ruby runtime2) {
        RubyClass rb_cUNIXSocket = runtime2.defineClass("UNIXSocket", runtime2.fastGetClass("BasicSocket"), UNIXSOCKET_ALLOCATOR);
        runtime2.getObject().fastSetConstant("UNIXsocket", rb_cUNIXSocket);
        rb_cUNIXSocket.defineAnnotatedMethods(RubyUNIXSocket.class);
    }

    public RubyUNIXSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    protected static void rb_sys_fail(Ruby runtime2, String message2) {
        int n = LastError.getLastError();
        IRubyObject arg2 = message2 != null ? runtime2.newString(message2) : runtime2.getNil();
        RubyClass instance = runtime2.getErrno(n);
        if (instance == null) {
            instance = runtime2.getSystemCallError();
            throw new RaiseException((RubyException)instance.newInstance(runtime2.getCurrentContext(), new IRubyObject[]{arg2, runtime2.newFixnum(n)}, Block.NULL_BLOCK));
        }
        throw new RaiseException((RubyException)instance.newInstance(runtime2.getCurrentContext(), new IRubyObject[]{arg2}, Block.NULL_BLOCK));
    }

    protected void init_unixsock(Ruby runtime2, IRubyObject _path, boolean server) {
        int status2;
        this.fd = -1;
        try {
            this.fd = INSTANCE.socket(AddressFamily.AF_UNIX.value(), Sock.SOCK_STREAM.value(), 0);
        }
        catch (UnsatisfiedLinkError ule) {
            // empty catch block
        }
        if (this.fd < 0) {
            RubyUNIXSocket.rb_sys_fail(runtime2, "socket(2)");
        }
        LibCSocket.sockaddr_un sockaddr = LibCSocket.sockaddr_un.newInstance();
        sockaddr.setFamily(AddressFamily.AF_UNIX.value());
        ByteList path2 = _path.convertToString().getByteList();
        this.fpath = path2.toString();
        if (sockaddr.path().length() <= path2.realSize) {
            throw runtime2.newArgumentError("too long unix socket path (max: " + (sockaddr.path().length() - 1) + "bytes)");
        }
        sockaddr.path().set(this.fpath);
        if (server) {
            status2 = INSTANCE.bind(this.fd, sockaddr, 106);
        } else {
            try {
                status2 = INSTANCE.connect(this.fd, sockaddr, 106);
            }
            catch (RuntimeException e) {
                INSTANCE.close(this.fd);
                throw e;
            }
        }
        if (status2 < 0) {
            INSTANCE.close(this.fd);
            RubyUNIXSocket.rb_sys_fail(runtime2, this.fpath);
        }
        if (server) {
            INSTANCE.listen(this.fd, 5);
        }
        this.init_sock(runtime2);
        if (server) {
            this.openFile.setPath(this.fpath);
        }
    }

    public IRubyObject setsockopt(ThreadContext context, IRubyObject lev, IRubyObject optname, IRubyObject val) {
        int level2 = RubyNumeric.fix2int(lev);
        int opt = RubyNumeric.fix2int(optname);
        block0 : switch (SocketLevel.valueOf(level2)) {
            case SOL_SOCKET: {
                switch (SocketOption.valueOf(opt)) {
                    case SO_KEEPALIVE: {
                        byte[] byArray;
                        if (this.asBoolean(val)) {
                            byte[] byArray2 = new byte[4];
                            byArray2[0] = 32;
                            byArray2[1] = 0;
                            byArray2[2] = 0;
                            byArray = byArray2;
                            byArray2[3] = 0;
                        } else {
                            byte[] byArray3 = new byte[4];
                            byArray3[0] = 0;
                            byArray3[1] = 0;
                            byArray3[2] = 0;
                            byArray = byArray3;
                            byArray3[3] = 0;
                        }
                        int res = INSTANCE.setsockopt(this.fd, level2, opt, byArray, 4);
                        if (res != -1) break block0;
                        RubyUNIXSocket.rb_sys_fail(context.getRuntime(), this.openFile.getPath());
                        break block0;
                    }
                    default: {
                        throw context.getRuntime().newErrnoENOPROTOOPTError();
                    }
                }
            }
            default: {
                throw context.getRuntime().newErrnoENOPROTOOPTError();
            }
        }
        return context.getRuntime().newFixnum(0);
    }

    protected void init_sock(Ruby runtime2) {
        try {
            ModeFlags modes = new ModeFlags(ModeFlags.RDWR);
            this.openFile.setMainStream(new ChannelStream(runtime2, new ChannelDescriptor(new UnixDomainSocketChannel(this.fd), RubyUNIXSocket.getNewFileno(), modes, new FileDescriptor())));
            this.openFile.setPipeStream(this.openFile.getMainStream());
            this.openFile.setMode(modes.getOpenFileFlags());
            this.openFile.getMainStream().setSync(true);
        }
        catch (InvalidValueException ive) {
            throw runtime2.newErrnoEINVALError();
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject path2) {
        this.init_unixsock(context.getRuntime(), path2, false);
        return this;
    }

    private String unixpath(LibCSocket.sockaddr_un addr2, IntByReference len) {
        if ((Integer)len.getValue() > 2) {
            return addr2.path().toString();
        }
        return "";
    }

    private IRubyObject unixaddr(Ruby runtime2, LibCSocket.sockaddr_un addr2, IntByReference len) {
        return runtime2.newArrayNoCopy(runtime2.newString("AF_UNIX"), runtime2.newString(this.unixpath(addr2, len)));
    }

    @Deprecated
    public IRubyObject path() {
        return this.path(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject path(ThreadContext context) {
        if (this.openFile.getPath() == null) {
            IntByReference len;
            LibCSocket.sockaddr_un addr2 = LibCSocket.sockaddr_un.newInstance();
            if (INSTANCE.getsockname(this.fd, addr2, len = new IntByReference(106)) < 0) {
                RubyUNIXSocket.rb_sys_fail(context.getRuntime(), null);
            }
            this.openFile.setPath(this.unixpath(addr2, len));
        }
        return context.getRuntime().newString(this.openFile.getPath());
    }

    @Deprecated
    public IRubyObject addr() {
        return this.addr(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject addr(ThreadContext context) {
        IntByReference len;
        LibCSocket.sockaddr_un addr2 = LibCSocket.sockaddr_un.newInstance();
        if (INSTANCE.getsockname(this.fd, addr2, len = new IntByReference(106)) < 0) {
            RubyUNIXSocket.rb_sys_fail(context.getRuntime(), "getsockname(2)");
        }
        return this.unixaddr(context.getRuntime(), addr2, len);
    }

    @Deprecated
    public IRubyObject peeraddr() {
        return this.peeraddr(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject peeraddr(ThreadContext context) {
        IntByReference len;
        LibCSocket.sockaddr_un addr2 = LibCSocket.sockaddr_un.newInstance();
        if (INSTANCE.getpeername(this.fd, addr2, len = new IntByReference(106)) < 0) {
            RubyUNIXSocket.rb_sys_fail(context.getRuntime(), "getpeername(2)");
        }
        return this.unixaddr(context.getRuntime(), addr2, len);
    }

    @Deprecated
    public IRubyObject recvfrom(IRubyObject[] args2) {
        return this.recvfrom(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(name={"recvfrom"}, required=1, optional=1)
    public IRubyObject recvfrom(ThreadContext context, IRubyObject[] args2) {
        ByteBuffer str = ByteBuffer.allocateDirect(1024);
        LibCSocket.sockaddr_un buf = LibCSocket.sockaddr_un.newInstance();
        IntByReference alen = new IntByReference(106);
        IRubyObject flg = Arity.checkArgumentCount(context.getRuntime(), args2, 1, 2) == 2 ? args2[1] : context.getRuntime().getNil();
        IRubyObject len = args2[0];
        int flags = flg.isNil() ? 0 : RubyNumeric.fix2int(flg);
        int buflen = RubyNumeric.fix2int(len);
        int slen = INSTANCE.recvfrom(this.fd, str, buflen, flags, buf, alen);
        if (slen < 0) {
            RubyUNIXSocket.rb_sys_fail(context.getRuntime(), "recvfrom(2)");
        }
        if (slen < buflen) {
            buflen = slen;
        }
        byte[] outp = new byte[buflen];
        str.get(outp);
        RubyString _str = context.getRuntime().newString(new ByteList(outp, 0, buflen, false));
        return context.getRuntime().newArrayNoCopy(_str, this.unixaddr(context.getRuntime(), buf, alen));
    }

    @JRubyMethod
    public IRubyObject send_io(IRubyObject path2) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public IRubyObject recv_io(IRubyObject[] args2) {
        return this.getRuntime().getNil();
    }

    public IRubyObject close() {
        super.close();
        INSTANCE.close(this.fd);
        return this.getRuntime().getNil();
    }

    @Deprecated
    public static IRubyObject open(IRubyObject recv2, IRubyObject path2) {
        return RubyUNIXSocket.open(recv2.getRuntime().getCurrentContext(), recv2, path2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        return RuntimeHelpers.invoke(context, recv2, "new", path2);
    }

    private static int getSocketType(IRubyObject tp) {
        if (tp instanceof RubyString) {
            String str = tp.toString();
            if ("SOCK_STREAM".equals(str)) {
                return Sock.SOCK_STREAM.value();
            }
            if ("SOCK_DGRAM".equals(str)) {
                return Sock.SOCK_DGRAM.value();
            }
            if ("SOCK_RAW".equals(str)) {
                return Sock.SOCK_RAW.value();
            }
            return -1;
        }
        return RubyNumeric.fix2int(tp);
    }

    @Deprecated
    public static IRubyObject socketpair(IRubyObject recv2, IRubyObject[] args2) {
        return RubyUNIXSocket.socketpair(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(name={"socketpair", "pair"}, optional=2, meta=true)
    public static IRubyObject socketpair(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int domain = ProtocolFamily.PF_UNIX.value();
        Ruby runtime2 = context.getRuntime();
        Arity.checkArgumentCount(runtime2, args2, 0, 2);
        int type2 = args2.length == 0 ? Sock.SOCK_STREAM.value() : RubyUNIXSocket.getSocketType(args2[0]);
        int protocol = args2.length <= 1 ? 0 : RubyNumeric.fix2int(args2[1]);
        int[] sp = new int[2];
        int ret = -1;
        try {
            ret = INSTANCE.socketpair(domain, type2, protocol, sp);
        }
        catch (UnsatisfiedLinkError ule) {
            // empty catch block
        }
        if (ret < 0) {
            RubyUNIXSocket.rb_sys_fail(runtime2, "socketpair(2)");
        }
        RubyUNIXSocket sock = (RubyUNIXSocket)RuntimeHelpers.invoke(context, runtime2.fastGetClass("UNIXSocket"), "allocate");
        sock.fd = sp[0];
        sock.init_sock(runtime2);
        RubyUNIXSocket sock2 = (RubyUNIXSocket)RuntimeHelpers.invoke(context, runtime2.fastGetClass("UNIXSocket"), "allocate");
        sock2.fd = sp[1];
        sock2.init_sock(runtime2);
        return runtime2.newArrayNoCopy(sock, sock2);
    }

    public static interface LibCSocket {
        public int socketpair(int var1, int var2, int var3, int[] var4);

        public int socket(int var1, int var2, int var3);

        public int connect(int var1, @In @Transient sockaddr_un var2, int var3);

        public int bind(int var1, @Transient sockaddr_un var2, int var3);

        public int listen(int var1, int var2);

        public int accept(int var1, @Transient sockaddr_un var2, IntByReference var3);

        public int getsockname(int var1, @Out @Transient sockaddr_un var2, IntByReference var3);

        public int getpeername(int var1, @Out @Transient sockaddr_un var2, IntByReference var3);

        public int getsockopt(int var1, int var2, int var3, @Out byte[] var4, IntByReference var5);

        public int setsockopt(int var1, int var2, int var3, @In byte[] var4, int var5);

        public int recv(int var1, @Out ByteBuffer var2, int var3, int var4);

        public int recvfrom(int var1, @Out ByteBuffer var2, int var3, int var4, @Out @Transient sockaddr_un var5, IntByReference var6);

        public int send(int var1, @In ByteBuffer var2, int var3, int var4);

        public int fcntl(int var1, int var2, int var3);

        public int unlink(String var1);

        public int close(int var1);

        public void perror(String var1);

        public static final class DefaultSockAddrUnix
        extends sockaddr_un {
            public final Struct.Signed16 sun_family = new Struct.Signed16();
            public final Struct.UTF8String sun_path = new Struct.UTF8String(104);

            public final void setFamily(int family) {
                this.sun_family.set((short)family);
            }

            public final int getFamily() {
                return this.sun_family.get();
            }

            public final Struct.UTF8String path() {
                return this.sun_path;
            }
        }

        public static final class BSDSockAddrUnix
        extends sockaddr_un {
            public final Struct.Signed8 sun_len = new Struct.Signed8();
            public final Struct.Signed8 sun_family = new Struct.Signed8();
            public final Struct.UTF8String sun_path = new Struct.UTF8String(104);

            public final void setFamily(int family) {
                this.sun_family.set((byte)family);
            }

            public final int getFamily() {
                return this.sun_family.get();
            }

            public final Struct.UTF8String path() {
                return this.sun_path;
            }
        }

        public static abstract class sockaddr_un
        extends Struct {
            public static final int LENGTH = 106;

            public abstract void setFamily(int var1);

            public abstract int getFamily();

            public abstract Struct.UTF8String path();

            public static final sockaddr_un newInstance() {
                return Platform.IS_BSD ? new BSDSockAddrUnix() : new DefaultSockAddrUnix();
            }
        }
    }

    private static class UnixDomainSocketChannel
    implements ReadableByteChannel,
    WritableByteChannel {
        private final int fd;
        private boolean open = true;

        public UnixDomainSocketChannel(int fd) {
            this.fd = fd;
        }

        public void close() throws IOException {
            this.open = false;
        }

        public boolean isOpen() {
            return this.open;
        }

        public int read(ByteBuffer dst) throws IOException {
            int max2 = dst.remaining();
            int v = INSTANCE.recv(this.fd, dst, max2, 0);
            if (v != -1) {
                dst.position(dst.position() + v);
            }
            return v;
        }

        public int write(ByteBuffer src) throws IOException {
            int max2 = src.remaining();
            int v = INSTANCE.send(this.fd, src, max2, 0);
            if (v != -1) {
                src.position(src.position() + v);
            }
            return v;
        }
    }
}

