/*
 * Decompiled with CFR 0.152.
 */
package jruby.objectweb.asm.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jruby.objectweb.asm.ClassVisitor;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.MethodVisitor;
import jruby.objectweb.asm.Type;
import jruby.objectweb.asm.commons.LocalVariablesSorter;
import jruby.objectweb.asm.commons.Method;
import jruby.objectweb.asm.commons.TableSwitchGenerator;

public class GeneratorAdapter
extends LocalVariablesSorter {
    private static final String CLDESC = "Ljava/lang/Class;";
    private static final Type BYTE_TYPE = Type.getObjectType("java/lang/Byte");
    private static final Type BOOLEAN_TYPE = Type.getObjectType("java/lang/Boolean");
    private static final Type SHORT_TYPE = Type.getObjectType("java/lang/Short");
    private static final Type CHARACTER_TYPE = Type.getObjectType("java/lang/Character");
    private static final Type INTEGER_TYPE = Type.getObjectType("java/lang/Integer");
    private static final Type FLOAT_TYPE = Type.getObjectType("java/lang/Float");
    private static final Type LONG_TYPE = Type.getObjectType("java/lang/Long");
    private static final Type DOUBLE_TYPE = Type.getObjectType("java/lang/Double");
    private static final Type NUMBER_TYPE = Type.getObjectType("java/lang/Number");
    private static final Type OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    private static final Method BOOLEAN_VALUE = Method.getMethod("boolean booleanValue()");
    private static final Method CHAR_VALUE = Method.getMethod("char charValue()");
    private static final Method INT_VALUE = Method.getMethod("int intValue()");
    private static final Method FLOAT_VALUE = Method.getMethod("float floatValue()");
    private static final Method LONG_VALUE = Method.getMethod("long longValue()");
    private static final Method DOUBLE_VALUE = Method.getMethod("double doubleValue()");
    public static final int ADD = 96;
    public static final int SUB = 100;
    public static final int MUL = 104;
    public static final int DIV = 108;
    public static final int REM = 112;
    public static final int NEG = 116;
    public static final int SHL = 120;
    public static final int SHR = 122;
    public static final int USHR = 124;
    public static final int AND = 126;
    public static final int OR = 128;
    public static final int XOR = 130;
    public static final int EQ = 153;
    public static final int NE = 154;
    public static final int LT = 155;
    public static final int GE = 156;
    public static final int GT = 157;
    public static final int LE = 158;
    private final int access;
    private final Type returnType;
    private final Type[] argumentTypes;
    private final List localTypes = new ArrayList();

    public GeneratorAdapter(MethodVisitor methodVisitor, int n, String string2, String string3) {
        super(n, string3, methodVisitor);
        this.access = n;
        this.returnType = Type.getReturnType(string3);
        this.argumentTypes = Type.getArgumentTypes(string3);
    }

    public GeneratorAdapter(int n, Method method2, MethodVisitor methodVisitor) {
        super(n, method2.getDescriptor(), methodVisitor);
        this.access = n;
        this.returnType = method2.getReturnType();
        this.argumentTypes = method2.getArgumentTypes();
    }

    public GeneratorAdapter(int n, Method method2, String string2, Type[] typeArray, ClassVisitor classVisitor) {
        this(n, method2, classVisitor.visitMethod(n, method2.getName(), method2.getDescriptor(), string2, GeneratorAdapter.getInternalNames(typeArray)));
    }

    private static String[] getInternalNames(Type[] typeArray) {
        if (typeArray == null) {
            return null;
        }
        String[] stringArray = new String[typeArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = typeArray[i].getInternalName();
        }
        return stringArray;
    }

    public void push(boolean bl) {
        this.push(bl ? 1 : 0);
    }

    public void push(int n) {
        if (n >= -1 && n <= 5) {
            this.mv.visitInsn(3 + n);
        } else if (n >= -128 && n <= 127) {
            this.mv.visitIntInsn(16, n);
        } else if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            this.mv.visitIntInsn(17, n);
        } else {
            this.mv.visitLdcInsn(new Integer(n));
        }
    }

    public void push(long l) {
        if (l == 0L || l == 1L) {
            this.mv.visitInsn(9 + (int)l);
        } else {
            this.mv.visitLdcInsn(new Long(l));
        }
    }

    public void push(float f) {
        int n = Float.floatToIntBits(f);
        if ((long)n == 0L || n == 1065353216 || n == 0x40000000) {
            this.mv.visitInsn(11 + (int)f);
        } else {
            this.mv.visitLdcInsn(new Float(f));
        }
    }

    public void push(double d) {
        long l = Double.doubleToLongBits(d);
        if (l == 0L || l == 0x3FF0000000000000L) {
            this.mv.visitInsn(14 + (int)d);
        } else {
            this.mv.visitLdcInsn(new Double(d));
        }
    }

    public void push(String string2) {
        if (string2 == null) {
            this.mv.visitInsn(1);
        } else {
            this.mv.visitLdcInsn(string2);
        }
    }

    public void push(Type type2) {
        if (type2 == null) {
            this.mv.visitInsn(1);
        } else {
            switch (type2.getSort()) {
                case 1: {
                    this.mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", CLDESC);
                    break;
                }
                case 2: {
                    this.mv.visitFieldInsn(178, "java/lang/Char", "TYPE", CLDESC);
                    break;
                }
                case 3: {
                    this.mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", CLDESC);
                    break;
                }
                case 4: {
                    this.mv.visitFieldInsn(178, "java/lang/Short", "TYPE", CLDESC);
                    break;
                }
                case 5: {
                    this.mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", CLDESC);
                    break;
                }
                case 6: {
                    this.mv.visitFieldInsn(178, "java/lang/Float", "TYPE", CLDESC);
                    break;
                }
                case 7: {
                    this.mv.visitFieldInsn(178, "java/lang/Long", "TYPE", CLDESC);
                    break;
                }
                case 8: {
                    this.mv.visitFieldInsn(178, "java/lang/Double", "TYPE", CLDESC);
                    break;
                }
                default: {
                    this.mv.visitLdcInsn(type2);
                }
            }
        }
    }

    private int getArgIndex(int n) {
        int n2 = (this.access & 8) == 0 ? 1 : 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.argumentTypes[i].getSize();
        }
        return n2;
    }

    private void loadInsn(Type type2, int n) {
        this.mv.visitVarInsn(type2.getOpcode(21), n);
    }

    private void storeInsn(Type type2, int n) {
        this.mv.visitVarInsn(type2.getOpcode(54), n);
    }

    public void loadThis() {
        if ((this.access & 8) != 0) {
            throw new IllegalStateException("no 'this' pointer within static method");
        }
        this.mv.visitVarInsn(25, 0);
    }

    public void loadArg(int n) {
        this.loadInsn(this.argumentTypes[n], this.getArgIndex(n));
    }

    public void loadArgs(int n, int n2) {
        int n3 = this.getArgIndex(n);
        for (int i = 0; i < n2; ++i) {
            Type type2 = this.argumentTypes[n + i];
            this.loadInsn(type2, n3);
            n3 += type2.getSize();
        }
    }

    public void loadArgs() {
        this.loadArgs(0, this.argumentTypes.length);
    }

    public void loadArgArray() {
        this.push(this.argumentTypes.length);
        this.newArray(OBJECT_TYPE);
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            this.dup();
            this.push(i);
            this.loadArg(i);
            this.box(this.argumentTypes[i]);
            this.arrayStore(OBJECT_TYPE);
        }
    }

    public void storeArg(int n) {
        this.storeInsn(this.argumentTypes[n], this.getArgIndex(n));
    }

    public Type getLocalType(int n) {
        return (Type)this.localTypes.get(n - this.firstLocal);
    }

    protected void setLocalType(int n, Type type2) {
        int n2 = n - this.firstLocal;
        while (this.localTypes.size() < n2 + 1) {
            this.localTypes.add(null);
        }
        this.localTypes.set(n2, type2);
    }

    public void loadLocal(int n) {
        this.loadInsn(this.getLocalType(n), n);
    }

    public void loadLocal(int n, Type type2) {
        this.setLocalType(n, type2);
        this.loadInsn(type2, n);
    }

    public void storeLocal(int n) {
        this.storeInsn(this.getLocalType(n), n);
    }

    public void storeLocal(int n, Type type2) {
        this.setLocalType(n, type2);
        this.storeInsn(type2, n);
    }

    public void arrayLoad(Type type2) {
        this.mv.visitInsn(type2.getOpcode(46));
    }

    public void arrayStore(Type type2) {
        this.mv.visitInsn(type2.getOpcode(79));
    }

    public void pop() {
        this.mv.visitInsn(87);
    }

    public void pop2() {
        this.mv.visitInsn(88);
    }

    public void dup() {
        this.mv.visitInsn(89);
    }

    public void dup2() {
        this.mv.visitInsn(92);
    }

    public void dupX1() {
        this.mv.visitInsn(90);
    }

    public void dupX2() {
        this.mv.visitInsn(91);
    }

    public void dup2X1() {
        this.mv.visitInsn(93);
    }

    public void dup2X2() {
        this.mv.visitInsn(94);
    }

    public void swap() {
        this.mv.visitInsn(95);
    }

    public void swap(Type type2, Type type3) {
        if (type3.getSize() == 1) {
            if (type2.getSize() == 1) {
                this.swap();
            } else {
                this.dupX2();
                this.pop();
            }
        } else if (type2.getSize() == 1) {
            this.dup2X1();
            this.pop2();
        } else {
            this.dup2X2();
            this.pop2();
        }
    }

    public void math(int n, Type type2) {
        this.mv.visitInsn(type2.getOpcode(n));
    }

    public void not() {
        this.mv.visitInsn(4);
        this.mv.visitInsn(130);
    }

    public void iinc(int n, int n2) {
        this.mv.visitIincInsn(n, n2);
    }

    public void cast(Type type2, Type type3) {
        if (type2 != type3) {
            if (type2 == Type.DOUBLE_TYPE) {
                if (type3 == Type.FLOAT_TYPE) {
                    this.mv.visitInsn(144);
                } else if (type3 == Type.LONG_TYPE) {
                    this.mv.visitInsn(143);
                } else {
                    this.mv.visitInsn(142);
                    this.cast(Type.INT_TYPE, type3);
                }
            } else if (type2 == Type.FLOAT_TYPE) {
                if (type3 == Type.DOUBLE_TYPE) {
                    this.mv.visitInsn(141);
                } else if (type3 == Type.LONG_TYPE) {
                    this.mv.visitInsn(140);
                } else {
                    this.mv.visitInsn(139);
                    this.cast(Type.INT_TYPE, type3);
                }
            } else if (type2 == Type.LONG_TYPE) {
                if (type3 == Type.DOUBLE_TYPE) {
                    this.mv.visitInsn(138);
                } else if (type3 == Type.FLOAT_TYPE) {
                    this.mv.visitInsn(137);
                } else {
                    this.mv.visitInsn(136);
                    this.cast(Type.INT_TYPE, type3);
                }
            } else if (type3 == Type.BYTE_TYPE) {
                this.mv.visitInsn(145);
            } else if (type3 == Type.CHAR_TYPE) {
                this.mv.visitInsn(146);
            } else if (type3 == Type.DOUBLE_TYPE) {
                this.mv.visitInsn(135);
            } else if (type3 == Type.FLOAT_TYPE) {
                this.mv.visitInsn(134);
            } else if (type3 == Type.LONG_TYPE) {
                this.mv.visitInsn(133);
            } else if (type3 == Type.SHORT_TYPE) {
                this.mv.visitInsn(147);
            }
        }
    }

    public void box(Type type2) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return;
        }
        if (type2 == Type.VOID_TYPE) {
            this.push((String)null);
        } else {
            Type type3 = type2;
            switch (type2.getSort()) {
                case 3: {
                    type3 = BYTE_TYPE;
                    break;
                }
                case 1: {
                    type3 = BOOLEAN_TYPE;
                    break;
                }
                case 4: {
                    type3 = SHORT_TYPE;
                    break;
                }
                case 2: {
                    type3 = CHARACTER_TYPE;
                    break;
                }
                case 5: {
                    type3 = INTEGER_TYPE;
                    break;
                }
                case 6: {
                    type3 = FLOAT_TYPE;
                    break;
                }
                case 7: {
                    type3 = LONG_TYPE;
                    break;
                }
                case 8: {
                    type3 = DOUBLE_TYPE;
                }
            }
            this.newInstance(type3);
            if (type2.getSize() == 2) {
                this.dupX2();
                this.dupX2();
                this.pop();
            } else {
                this.dupX1();
                this.swap();
            }
            this.invokeConstructor(type3, new Method("<init>", Type.VOID_TYPE, new Type[]{type2}));
        }
    }

    public void unbox(Type type2) {
        Type type3 = NUMBER_TYPE;
        Method method2 = null;
        switch (type2.getSort()) {
            case 0: {
                return;
            }
            case 2: {
                type3 = CHARACTER_TYPE;
                method2 = CHAR_VALUE;
                break;
            }
            case 1: {
                type3 = BOOLEAN_TYPE;
                method2 = BOOLEAN_VALUE;
                break;
            }
            case 8: {
                method2 = DOUBLE_VALUE;
                break;
            }
            case 6: {
                method2 = FLOAT_VALUE;
                break;
            }
            case 7: {
                method2 = LONG_VALUE;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                method2 = INT_VALUE;
            }
        }
        if (method2 == null) {
            this.checkCast(type2);
        } else {
            this.checkCast(type3);
            this.invokeVirtual(type3, method2);
        }
    }

    public Label newLabel() {
        return new Label();
    }

    public void mark(Label label) {
        this.mv.visitLabel(label);
    }

    public Label mark() {
        Label label = new Label();
        this.mv.visitLabel(label);
        return label;
    }

    public void ifCmp(Type type2, int n, Label label) {
        int n2 = -1;
        switch (type2.getSort()) {
            case 7: {
                this.mv.visitInsn(148);
                break;
            }
            case 8: {
                this.mv.visitInsn(152);
                break;
            }
            case 6: {
                this.mv.visitInsn(150);
                break;
            }
            case 9: 
            case 10: {
                switch (n) {
                    case 153: {
                        this.mv.visitJumpInsn(165, label);
                        return;
                    }
                    case 154: {
                        this.mv.visitJumpInsn(166, label);
                        return;
                    }
                }
                throw new IllegalArgumentException("Bad comparison for type " + type2);
            }
            default: {
                switch (n) {
                    case 153: {
                        n2 = 159;
                        break;
                    }
                    case 154: {
                        n2 = 160;
                        break;
                    }
                    case 156: {
                        n2 = 162;
                        break;
                    }
                    case 155: {
                        n2 = 161;
                        break;
                    }
                    case 158: {
                        n2 = 164;
                        break;
                    }
                    case 157: {
                        n2 = 163;
                    }
                }
                this.mv.visitJumpInsn(n2, label);
                return;
            }
        }
        int n3 = n;
        switch (n) {
            case 156: {
                n3 = 155;
                break;
            }
            case 158: {
                n3 = 157;
            }
        }
        this.mv.visitJumpInsn(n3, label);
    }

    public void ifICmp(int n, Label label) {
        this.ifCmp(Type.INT_TYPE, n, label);
    }

    public void ifZCmp(int n, Label label) {
        this.mv.visitJumpInsn(n, label);
    }

    public void ifNull(Label label) {
        this.mv.visitJumpInsn(198, label);
    }

    public void ifNonNull(Label label) {
        this.mv.visitJumpInsn(199, label);
    }

    public void goTo(Label label) {
        this.mv.visitJumpInsn(167, label);
    }

    public void ret(int n) {
        this.mv.visitVarInsn(169, n);
    }

    public void tableSwitch(int[] nArray, TableSwitchGenerator tableSwitchGenerator) {
        float f = nArray.length == 0 ? 0.0f : (float)nArray.length / (float)(nArray[nArray.length - 1] - nArray[0] + 1);
        this.tableSwitch(nArray, tableSwitchGenerator, f >= 0.5f);
    }

    public void tableSwitch(int[] nArray, TableSwitchGenerator tableSwitchGenerator, boolean bl) {
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] >= nArray[i - 1]) continue;
            throw new IllegalArgumentException("keys must be sorted ascending");
        }
        Label label = this.newLabel();
        Label label2 = this.newLabel();
        if (nArray.length > 0) {
            int n = nArray.length;
            int n2 = nArray[0];
            int n3 = nArray[n - 1];
            int n4 = n3 - n2 + 1;
            if (bl) {
                int n5;
                Object[] objectArray = new Label[n4];
                Arrays.fill(objectArray, label);
                for (n5 = 0; n5 < n; ++n5) {
                    objectArray[nArray[n5] - n2] = this.newLabel();
                }
                this.mv.visitTableSwitchInsn(n2, n3, label, (Label[])objectArray);
                for (n5 = 0; n5 < n4; ++n5) {
                    Object object = objectArray[n5];
                    if (object == label) continue;
                    this.mark((Label)object);
                    tableSwitchGenerator.generateCase(n5 + n2, label2);
                }
            } else {
                int n6;
                Label[] labelArray = new Label[n];
                for (n6 = 0; n6 < n; ++n6) {
                    labelArray[n6] = this.newLabel();
                }
                this.mv.visitLookupSwitchInsn(label, nArray, labelArray);
                for (n6 = 0; n6 < n; ++n6) {
                    this.mark(labelArray[n6]);
                    tableSwitchGenerator.generateCase(nArray[n6], label2);
                }
            }
        }
        this.mark(label);
        tableSwitchGenerator.generateDefault();
        this.mark(label2);
    }

    public void returnValue() {
        this.mv.visitInsn(this.returnType.getOpcode(172));
    }

    private void fieldInsn(int n, Type type2, String string2, Type type3) {
        this.mv.visitFieldInsn(n, type2.getInternalName(), string2, type3.getDescriptor());
    }

    public void getStatic(Type type2, String string2, Type type3) {
        this.fieldInsn(178, type2, string2, type3);
    }

    public void putStatic(Type type2, String string2, Type type3) {
        this.fieldInsn(179, type2, string2, type3);
    }

    public void getField(Type type2, String string2, Type type3) {
        this.fieldInsn(180, type2, string2, type3);
    }

    public void putField(Type type2, String string2, Type type3) {
        this.fieldInsn(181, type2, string2, type3);
    }

    private void invokeInsn(int n, Type type2, Method method2) {
        String string2 = type2.getSort() == 9 ? type2.getDescriptor() : type2.getInternalName();
        this.mv.visitMethodInsn(n, string2, method2.getName(), method2.getDescriptor());
    }

    public void invokeVirtual(Type type2, Method method2) {
        this.invokeInsn(182, type2, method2);
    }

    public void invokeConstructor(Type type2, Method method2) {
        this.invokeInsn(183, type2, method2);
    }

    public void invokeStatic(Type type2, Method method2) {
        this.invokeInsn(184, type2, method2);
    }

    public void invokeInterface(Type type2, Method method2) {
        this.invokeInsn(185, type2, method2);
    }

    private void typeInsn(int n, Type type2) {
        this.mv.visitTypeInsn(n, type2.getInternalName());
    }

    public void newInstance(Type type2) {
        this.typeInsn(187, type2);
    }

    public void newArray(Type type2) {
        int n;
        switch (type2.getSort()) {
            case 1: {
                n = 4;
                break;
            }
            case 2: {
                n = 5;
                break;
            }
            case 3: {
                n = 8;
                break;
            }
            case 4: {
                n = 9;
                break;
            }
            case 5: {
                n = 10;
                break;
            }
            case 6: {
                n = 6;
                break;
            }
            case 7: {
                n = 11;
                break;
            }
            case 8: {
                n = 7;
                break;
            }
            default: {
                this.typeInsn(189, type2);
                return;
            }
        }
        this.mv.visitIntInsn(188, n);
    }

    public void arrayLength() {
        this.mv.visitInsn(190);
    }

    public void throwException() {
        this.mv.visitInsn(191);
    }

    public void throwException(Type type2, String string2) {
        this.newInstance(type2);
        this.dup();
        this.push(string2);
        this.invokeConstructor(type2, Method.getMethod("void <init> (String)"));
        this.throwException();
    }

    public void checkCast(Type type2) {
        if (!type2.equals(OBJECT_TYPE)) {
            this.typeInsn(192, type2);
        }
    }

    public void instanceOf(Type type2) {
        this.typeInsn(193, type2);
    }

    public void monitorEnter() {
        this.mv.visitInsn(194);
    }

    public void monitorExit() {
        this.mv.visitInsn(195);
    }

    public void endMethod() {
        if ((this.access & 0x400) == 0) {
            this.mv.visitMaxs(0, 0);
        }
        this.mv.visitEnd();
    }

    public void catchException(Label label, Label label2, Type type2) {
        this.mv.visitTryCatchBlock(label, label2, this.mark(), type2.getInternalName());
    }
}

