/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import java.dyn.CallSite;
import java.dyn.Linkage;
import java.dyn.MethodHandle;
import java.dyn.MethodHandles;
import java.dyn.MethodType;
import jruby.objectweb.asm.MethodVisitor;
import jruby.objectweb.asm.Type;
import org.jruby.RubyClass;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class InvokeDynamicSupport {
    public static Object bootstrap(CallSite site, Object ... args2) {
        IRubyObject self = (IRubyObject)args2[0];
        ThreadContext context = (ThreadContext)args2[1];
        String methodName = (String)args2[2];
        CallType callType = CallType.NORMAL;
        String siteName = site.name();
        boolean iterator = siteName.length() == 2 && siteName.charAt(1) == 'b';
        switch (siteName.charAt(0)) {
            case 'c': {
                callType = CallType.NORMAL;
                break;
            }
            case 'f': {
                callType = CallType.FUNCTIONAL;
                break;
            }
            case 'v': {
                callType = CallType.VARIABLE;
            }
        }
        DynamicMethod method2 = self.getMetaClass().searchMethod(methodName);
        IRubyObject caller2 = context.getFrameSelf();
        if (InvokeDynamicSupport.shouldCallMethodMissing(method2, methodName, caller2, callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), methodName, callType, Block.NULL_BLOCK);
        }
        String dispatcherName = iterator ? "invokeDynamicIter" : "invokeDynamic";
        MethodHandle outHandle = MethodHandles.findStatic(InvokeDynamicSupport.class, (String)dispatcherName, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])site.type().parameterArray()));
        MethodHandle inHandle = MethodHandles.insertArgument((MethodHandle)outHandle, (Object)method2);
        site.setTarget(inHandle);
        int length2 = args2.length;
        if (args2[length2 - 1] instanceof Block) {
            if (iterator) {
                switch (length2) {
                    case 4: {
                        return InvokeDynamicSupport.invokeDynamicIter(method2, self, context, methodName, (Block)args2[length2 - 1]);
                    }
                    case 5: {
                        if (args2[length2 - 2] instanceof IRubyObject[]) {
                            return InvokeDynamicSupport.invokeDynamicIter(method2, (Object)self, context, methodName, (IRubyObject[])args2[length2 - 2], (Block)args2[length2 - 1]);
                        }
                        return InvokeDynamicSupport.invokeDynamicIter(method2, (Object)self, context, methodName, (IRubyObject)args2[length2 - 2], (Block)args2[length2 - 1]);
                    }
                    case 6: {
                        return InvokeDynamicSupport.invokeDynamicIter(method2, self, context, methodName, (IRubyObject)args2[length2 - 3], (IRubyObject)args2[length2 - 2], (Block)args2[length2 - 1]);
                    }
                    case 7: {
                        return InvokeDynamicSupport.invokeDynamicIter(method2, self, context, methodName, (IRubyObject)args2[length2 - 4], (IRubyObject)args2[length2 - 3], (IRubyObject)args2[length2 - 2], (Block)args2[length2 - 1]);
                    }
                }
            } else {
                switch (length2) {
                    case 4: {
                        return InvokeDynamicSupport.invokeDynamic(method2, (Object)self, context, methodName, (Block)args2[length2 - 1]);
                    }
                    case 5: {
                        if (args2[length2 - 2] instanceof IRubyObject[]) {
                            return InvokeDynamicSupport.invokeDynamic(method2, (Object)self, context, methodName, (IRubyObject[])args2[length2 - 2], (Block)args2[length2 - 1]);
                        }
                        return InvokeDynamicSupport.invokeDynamic(method2, (Object)self, context, methodName, (IRubyObject)args2[length2 - 2], (Block)args2[length2 - 1]);
                    }
                    case 6: {
                        return InvokeDynamicSupport.invokeDynamic(method2, (Object)self, context, methodName, (IRubyObject)args2[length2 - 3], (IRubyObject)args2[length2 - 2], (Block)args2[length2 - 1]);
                    }
                    case 7: {
                        return InvokeDynamicSupport.invokeDynamic(method2, self, context, methodName, (IRubyObject)args2[length2 - 4], (IRubyObject)args2[length2 - 3], (IRubyObject)args2[length2 - 2], (Block)args2[length2 - 1]);
                    }
                }
            }
        } else {
            switch (length2) {
                case 3: {
                    return InvokeDynamicSupport.invokeDynamic(method2, self, context, methodName);
                }
                case 4: {
                    if (args2[length2 - 1] instanceof IRubyObject[]) {
                        return InvokeDynamicSupport.invokeDynamic(method2, (Object)self, context, methodName, (IRubyObject[])args2[length2 - 1]);
                    }
                    return InvokeDynamicSupport.invokeDynamic(method2, (Object)self, context, methodName, (IRubyObject)args2[length2 - 1]);
                }
                case 5: {
                    return InvokeDynamicSupport.invokeDynamic(method2, (Object)self, context, methodName, (IRubyObject)args2[length2 - 2], (IRubyObject)args2[length2 - 1]);
                }
                case 6: {
                    return InvokeDynamicSupport.invokeDynamic(method2, (Object)self, context, methodName, (IRubyObject)args2[length2 - 3], (IRubyObject)args2[length2 - 2], (IRubyObject)args2[length2 - 1]);
                }
            }
        }
        throw new RuntimeException("Unsupported method signature for dynamic call: " + site.type());
    }

    public static void installBytecode(MethodVisitor method2, String classname) {
        SkinnyMethodAdapter clinitMethod = new SkinnyMethodAdapter(method2);
        clinitMethod.ldc(CodegenUtils.c(classname));
        clinitMethod.invokestatic(CodegenUtils.p(Class.class), "forName", CodegenUtils.sig(Class.class, CodegenUtils.params(String.class)));
        clinitMethod.ldc(Type.getType(InvokeDynamicSupport.class));
        clinitMethod.ldc("bootstrap");
        clinitMethod.getstatic(CodegenUtils.p(Linkage.class), "BOOTSTRAP_METHOD_TYPE", CodegenUtils.ci(MethodType.class));
        clinitMethod.invokestatic(CodegenUtils.p(MethodHandles.class), "findStatic", CodegenUtils.sig(MethodHandle.class, Class.class, String.class, MethodType.class));
        clinitMethod.invokestatic(CodegenUtils.p(Linkage.class), "registerBootstrapMethod", CodegenUtils.sig(Void.TYPE, Class.class, MethodHandle.class));
    }

    private static boolean shouldCallMethodMissing(DynamicMethod method2, String name2, IRubyObject caller2, CallType callType) {
        return method2.isUndefined() || InvokeDynamicSupport.notVisibleAndNotMethodMissing(method2, name2, caller2, callType);
    }

    private static boolean notVisibleAndNotMethodMissing(DynamicMethod method2, String name2, IRubyObject caller2, CallType callType) {
        return !method2.isCallableFrom(caller2, callType) && !name2.equals("method_missing");
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2) {
        IRubyObject self = (IRubyObject)selfObj;
        return method2.call(context, self, self.getMetaClass(), name2);
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            return method2.call(context, self, (RubyModule)selfType, name2, block);
        }
        catch (JumpException.BreakJump bj) {
            return InvokeDynamicSupport.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
    }

    public static IRubyObject invokeDynamicIter(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            IRubyObject iRubyObject = method2.call(context, self, (RubyModule)selfType, name2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg2) {
        IRubyObject self = (IRubyObject)selfObj;
        return method2.call(context, self, (RubyModule)self.getMetaClass(), name2, arg2);
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            return method2.call(context, self, (RubyModule)selfType, name2, arg2, block);
        }
        catch (JumpException.BreakJump bj) {
            return InvokeDynamicSupport.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
    }

    public static IRubyObject invokeDynamicIter(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            IRubyObject iRubyObject = method2.call(context, self, (RubyModule)selfType, name2, arg2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject self = (IRubyObject)selfObj;
        return method2.call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, arg1);
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            return method2.call(context, self, (RubyModule)selfType, name2, arg0, arg1, block);
        }
        catch (JumpException.BreakJump bj) {
            return InvokeDynamicSupport.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
    }

    public static IRubyObject invokeDynamicIter(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            IRubyObject iRubyObject = method2.call(context, self, (RubyModule)selfType, name2, arg0, arg1, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject self = (IRubyObject)selfObj;
        return method2.call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, arg1, arg2);
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            return method2.call(context, self, (RubyModule)selfType, name2, arg0, arg1, arg2, block);
        }
        catch (JumpException.BreakJump bj) {
            return InvokeDynamicSupport.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
    }

    public static IRubyObject invokeDynamicIter(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            IRubyObject iRubyObject = method2.call(context, self, (RubyModule)selfType, name2, arg0, arg1, arg2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject[] args2) {
        IRubyObject self = (IRubyObject)selfObj;
        return method2.call(context, self, (RubyModule)self.getMetaClass(), name2, args2);
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject[] args2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            return method2.call(context, self, (RubyModule)selfType, name2, args2, block);
        }
        catch (JumpException.BreakJump bj) {
            return InvokeDynamicSupport.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
    }

    public static IRubyObject invokeDynamicIter(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject[] args2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            IRubyObject iRubyObject = method2.call(context, self, (RubyModule)selfType, name2, args2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    private static RubyClass pollAndGetClass(ThreadContext context, IRubyObject self) {
        context.callThreadPoll();
        RubyClass selfType = self.getMetaClass();
        return selfType;
    }

    private static IRubyObject handleBreakJump(ThreadContext context, JumpException.BreakJump bj) throws JumpException.BreakJump {
        if (context.getFrameJumpTarget() == bj.getTarget()) {
            return (IRubyObject)bj.getValue();
        }
        throw bj;
    }

    private static RaiseException retryJumpError(ThreadContext context) {
        return context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.RETRY, context.getRuntime().getNil(), "retry outside of rescue not supported");
    }
}

