/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Platform;

public class NativeMemoryIO
implements MemoryIO,
DirectMemoryIO {
    private static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
    protected final Pointer ptr;

    public NativeMemoryIO(Pointer ptr) {
        this.ptr = ptr;
    }

    Pointer getPointer() {
        return this.ptr;
    }

    public final long getAddress() {
        PointerByReference ref = new PointerByReference(this.ptr);
        return ADDRESS_SIZE == 32 ? (long)ref.getPointer().getInt(0L) & 0xFFFFFFFFL : ref.getPointer().getLong(0L);
    }

    public final boolean isNull() {
        return this.ptr == null;
    }

    public final boolean isDirect() {
        return true;
    }

    public final byte getByte(long offset2) {
        return this.ptr.getByte(offset2);
    }

    public final short getShort(long offset2) {
        return this.ptr.getShort(offset2);
    }

    public final int getInt(long offset2) {
        return this.ptr.getInt(offset2);
    }

    public final long getLong(long offset2) {
        return this.ptr.getLong(offset2);
    }

    public final long getNativeLong(long offset2) {
        return this.ptr.getNativeLong(offset2).longValue();
    }

    public long getAddress(long offset2) {
        return ADDRESS_SIZE == 32 ? (long)this.getInt(offset2) & 0xFFFFFFFFL : this.getLong(offset2);
    }

    public final DirectMemoryIO getMemoryIO(long offset2) {
        Pointer p2 = this.ptr.getPointer(offset2);
        return p2 != null ? new NativeMemoryIO(p2) : null;
    }

    public final float getFloat(long offset2) {
        return this.ptr.getFloat(offset2);
    }

    public final double getDouble(long offset2) {
        return this.ptr.getDouble(offset2);
    }

    public final Pointer getPointer(long offset2) {
        return this.ptr.getPointer(offset2);
    }

    public final void putByte(long offset2, byte value2) {
        this.ptr.setByte(offset2, value2);
    }

    public final void putShort(long offset2, short value2) {
        this.ptr.setShort(offset2, value2);
    }

    public final void putInt(long offset2, int value2) {
        this.ptr.setInt(offset2, value2);
    }

    public final void putLong(long offset2, long value2) {
        this.ptr.setLong(offset2, value2);
    }

    public final void putNativeLong(long offset2, long value2) {
        this.ptr.setNativeLong(offset2, new NativeLong(value2));
    }

    public final void putAddress(long offset2, long value2) {
        if (ADDRESS_SIZE == 32) {
            this.ptr.setInt(offset2, (int)value2);
        } else {
            this.ptr.setLong(offset2, value2);
        }
    }

    public final void putMemoryIO(long offset2, MemoryIO value2) {
        if (value2 instanceof NativeMemoryIO) {
            this.ptr.setPointer(offset2, ((NativeMemoryIO)value2).ptr);
        } else {
            this.putAddress(offset2, ((DirectMemoryIO)value2).getAddress());
        }
    }

    public final void putFloat(long offset2, float value2) {
        this.ptr.setFloat(offset2, value2);
    }

    public final void putDouble(long offset2, double value2) {
        this.ptr.setDouble(offset2, value2);
    }

    public final void putPointer(long offset2, Pointer value2) {
        this.ptr.setPointer(offset2, value2);
    }

    public final void get(long offset2, byte[] dst, int off, int len) {
        this.ptr.read(offset2, dst, off, len);
    }

    public final void put(long offset2, byte[] dst, int off, int len) {
        this.ptr.write(offset2, dst, off, len);
    }

    public final void get(long offset2, short[] dst, int off, int len) {
        this.ptr.read(offset2, dst, off, len);
    }

    public final void put(long offset2, short[] dst, int off, int len) {
        this.ptr.write(offset2, dst, off, len);
    }

    public final void get(long offset2, int[] dst, int off, int len) {
        this.ptr.read(offset2, dst, off, len);
    }

    public final void put(long offset2, int[] dst, int off, int len) {
        this.ptr.write(offset2, dst, off, len);
    }

    public final void get(long offset2, long[] dst, int off, int len) {
        this.ptr.read(offset2, dst, off, len);
    }

    public final void put(long offset2, long[] dst, int off, int len) {
        this.ptr.write(offset2, dst, off, len);
    }

    public final void get(long offset2, float[] dst, int off, int len) {
        this.ptr.read(offset2, dst, off, len);
    }

    public final void put(long offset2, float[] dst, int off, int len) {
        this.ptr.write(offset2, dst, off, len);
    }

    public final void get(long offset2, double[] dst, int off, int len) {
        this.ptr.read(offset2, dst, off, len);
    }

    public final void put(long offset2, double[] dst, int off, int len) {
        this.ptr.write(offset2, dst, off, len);
    }

    public final int indexOf(long offset2, byte value2) {
        return (int)this.ptr.indexOf(offset2, value2);
    }

    public final int indexOf(long offset2, byte value2, int maxlen) {
        return (int)this.ptr.indexOf(offset2, value2);
    }

    public final void setMemory(long offset2, long size2, byte value2) {
        this.ptr.setMemory(offset2, size2, value2);
    }

    public NativeMemoryIO slice(long offset2) {
        return offset2 == 0L ? this : new NativeMemoryIO(this.ptr.share(offset2));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NativeMemoryIO)) {
            return false;
        }
        NativeMemoryIO other = (NativeMemoryIO)obj;
        return this.ptr == other.ptr || this.ptr != null && this.ptr.equals(other.ptr);
    }

    public int hashCode() {
        return this.ptr == null ? 0 : this.ptr.hashCode();
    }
}

