/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.io;

import java.io.FileDescriptor;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.io.FileDescriptorByteChannel;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"FFI::FileDescriptorIO"}, parent="IO")
public class FileDescriptorIO
extends RubyIO {
    public static final String CLASS_NAME = "FileDescriptorIO";

    public FileDescriptorIO(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    public FileDescriptorIO(Ruby runtime2, IRubyObject fd) {
        super(runtime2, runtime2.fastGetModule("FFI").fastGetClass(CLASS_NAME));
        ModeFlags modes;
        try {
            modes = new ModeFlags(2L);
        }
        catch (InvalidValueException ex) {
            throw new RuntimeException(ex);
        }
        this.openFile.setMainStream(new ChannelStream(this.getRuntime(), new ChannelDescriptor(new FileDescriptorByteChannel(RubyNumeric.fix2int(fd)), FileDescriptorIO.getNewFileno(), modes, new FileDescriptor())));
        this.openFile.setPipeStream(this.openFile.getMainStream());
        this.openFile.setMode(modes.getOpenFileFlags());
        this.openFile.getMainStream().setSync(true);
    }

    public static RubyClass createFileDescriptorIOClass(Ruby runtime2, RubyModule module) {
        RubyClass result = runtime2.defineClassUnder(CLASS_NAME, runtime2.fastGetClass("IO"), Allocator.INSTANCE, module);
        result.defineAnnotatedMethods(FileDescriptorIO.class);
        result.defineAnnotatedConstants(FileDescriptorIO.class);
        return result;
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static FileDescriptorIO newInstance(ThreadContext context, IRubyObject recv2, IRubyObject fd) {
        return new FileDescriptorIO(context.getRuntime(), fd);
    }

    @JRubyMethod(name={"wrap"}, required=1, meta=true)
    public static RubyIO wrap(ThreadContext context, IRubyObject recv2, IRubyObject fd) {
        return new FileDescriptorIO(context.getRuntime(), fd);
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new FileDescriptorIO(runtime2, klass);
        }
    }
}

