/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.Function;
import com.sun.jna.NativeLibrary;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jna.DynamicLibrary;
import org.jruby.ext.ffi.jna.FunctionInvoker;
import org.jruby.ext.ffi.jna.Invocation;
import org.jruby.ext.ffi.jna.JNAProvider;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::VariadicInvoker"}, parent="Object")
public class JNAVariadicInvoker
extends RubyObject {
    private final Function function;
    private final FunctionInvoker functionInvoker;

    public static RubyClass createVariadicInvokerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("VariadicInvoker", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(JNAVariadicInvoker.class);
        result.defineAnnotatedConstants(JNAVariadicInvoker.class);
        return result;
    }

    private JNAVariadicInvoker(Ruby runtime2, Function function, FunctionInvoker functionInvoker) {
        super(runtime2, runtime2.fastGetModule("FFI").fastGetClass("VariadicInvoker"));
        this.function = function;
        this.functionInvoker = functionInvoker;
    }

    public final Arity getArity() {
        return Arity.OPTIONAL;
    }

    @JRubyMethod(name={"__new"}, meta=true, required=4)
    public static JNAVariadicInvoker newInvoker(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Function function;
        int conv2 = "stdcall".equals(args2[3].toString()) ? 1 : 0;
        try {
            NativeLibrary lib = args2[0] instanceof DynamicLibrary ? ((DynamicLibrary)args2[0]).getNativeLibrary() : NativeLibrary.getInstance(args2[0].toString());
            function = lib.getFunction(args2[1].toString(), conv2);
        }
        catch (UnsatisfiedLinkError ex) {
            throw context.getRuntime().newLoadError(ex.getMessage());
        }
        FunctionInvoker functionInvoker = JNAProvider.getFunctionInvoker(NativeType.valueOf(Util.int32Value(args2[2])));
        return new JNAVariadicInvoker(recv2.getRuntime(), function, functionInvoker);
    }

    @JRubyMethod(name={"invoke"})
    public IRubyObject invoke(ThreadContext context, IRubyObject typesArg, IRubyObject paramsArg) {
        IRubyObject[] types = ((RubyArray)typesArg).toJavaArrayMaybeUnsafe();
        IRubyObject[] params2 = ((RubyArray)paramsArg).toJavaArrayMaybeUnsafe();
        Object[] args2 = new Object[types.length];
        Invocation invocation = new Invocation(context);
        block4: for (int i = 0; i < types.length; ++i) {
            NativeType type2 = NativeType.valueOf(Util.int32Value(types[i]));
            switch (type2) {
                case INT8: 
                case UINT8: 
                case INT16: 
                case UINT16: 
                case INT32: 
                case UINT32: {
                    args2[i] = Util.int32Value(params2[i]);
                    continue block4;
                }
                case FLOAT32: 
                case FLOAT64: {
                    args2[i] = Util.doubleValue(params2[i]);
                    continue block4;
                }
                default: {
                    args2[i] = JNAProvider.getMarshaller(type2).marshal(invocation, params2[i]);
                }
            }
        }
        return this.functionInvoker.invoke(context.getRuntime(), this.function, args2);
    }
}

