/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.JavaFileStat;
import org.jruby.ext.posix.JavaPasswd;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;
import org.jruby.ext.posix.util.Chmod;
import org.jruby.ext.posix.util.ExecIt;
import org.jruby.ext.posix.util.FieldAccess;

public class JavaLibCHelper {
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    POSIXHandler handler;
    Field fdField;
    Field handleField;

    public JavaLibCHelper(POSIXHandler handler) {
        this.handler = handler;
        this.handleField = FieldAccess.getProtectedField(FileDescriptor.class, "handle");
        this.fdField = FieldAccess.getProtectedField(FileDescriptor.class, "fd");
    }

    public int chmod(String filename2, int mode2) {
        return Chmod.chmod(new File(filename2), Integer.toOctalString(mode2));
    }

    public int chown(String filename2, int user, int group2) {
        ExecIt launcher = new ExecIt(this.handler);
        int chownResult = -1;
        int chgrpResult = -1;
        try {
            if (user != -1) {
                chownResult = launcher.runAndWait("chown", "" + user, filename2);
            }
            if (group2 != -1) {
                chgrpResult = launcher.runAndWait("chgrp ", "" + user, filename2);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return chownResult != -1 && chgrpResult != -1 ? 0 : 1;
    }

    public int getfd(FileDescriptor descriptor) {
        if (descriptor == null || this.fdField == null) {
            return -1;
        }
        try {
            return this.fdField.getInt(descriptor);
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }

    public long gethandle(FileDescriptor descriptor) {
        if (descriptor == null || this.handleField == null) {
            return -1L;
        }
        try {
            return this.handleField.getLong(descriptor);
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1L;
    }

    public String getlogin() {
        return System.getProperty("user.name");
    }

    public int getpid() {
        return this.handler.getPID();
    }

    public Passwd getpwent() {
        return new JavaPasswd(this.handler);
    }

    public int setpwent() {
        return 0;
    }

    public int endpwent() {
        return 0;
    }

    public int isatty(int fd) {
        return fd == 1 || fd == 0 || fd == 2 ? 1 : 0;
    }

    public int link(String oldpath, String newpath) {
        try {
            return new ExecIt(this.handler).runAndWait("ln", oldpath, newpath);
        }
        catch (Exception exception2) {
            return -1;
        }
    }

    public int lstat(String path2, FileStat stat2) {
        File file2 = new File(path2);
        if (!file2.exists()) {
            this.handler.error(POSIX.ERRORS.ENOENT, path2);
        }
        JavaFileStat jstat = (JavaFileStat)stat2;
        jstat.setup(path2);
        return 0;
    }

    public int mkdir(String path2, int mode2) {
        File dir = new File(path2);
        if (!dir.mkdir()) {
            return -1;
        }
        this.chmod(path2, mode2);
        return 0;
    }

    public int stat(String path2, FileStat stat2) {
        JavaFileStat jstat = (JavaFileStat)stat2;
        try {
            File file2 = new File(path2);
            if (!file2.exists()) {
                this.handler.error(POSIX.ERRORS.ENOENT, path2);
            }
            jstat.setup(file2.getCanonicalPath());
        }
        catch (IOException e) {
            // empty catch block
        }
        return 0;
    }

    public int symlink(String oldpath, String newpath) {
        try {
            return new ExecIt(this.handler).runAndWait("ln", "-s", oldpath, newpath);
        }
        catch (Exception exception2) {
            return -1;
        }
    }

    public int readlink(String oldpath, ByteBuffer buffer, int length2) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new ExecIt(this.handler).runAndWait(baos, "readlink", oldpath);
            byte[] bytes2 = baos.toByteArray();
            if (bytes2.length > length2 || bytes2.length == 0) {
                return -1;
            }
            buffer.put(bytes2, 0, bytes2.length - 1);
            return buffer.position();
        }
        catch (InterruptedException e) {
            return -1;
        }
    }
}

