/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.BasePointer;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.NativeParam;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"StructLayoutBuilder"}, parent="Object")
public final class StructLayoutBuilder
extends RubyObject {
    public static final String CLASS_NAME = "StructLayoutBuilder";
    static final int LONG_SIZE = Platform.getPlatform().longSize();
    static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
    static final int REGISTER_SIZE = Platform.getPlatform().addressSize();
    static final long LONG_MASK = LONG_SIZE == 32 ? Integer.MAX_VALUE : Long.MAX_VALUE;
    static final int LONG_ALIGN = StructLayoutBuilder.isSparc() ? 64 : LONG_SIZE;
    static final int ADDRESS_ALIGN = StructLayoutBuilder.isSparc() ? 64 : REGISTER_SIZE;
    static final int DOUBLE_ALIGN = StructLayoutBuilder.isSparc() ? 64 : REGISTER_SIZE;
    static final int FLOAT_ALIGN = StructLayoutBuilder.isSparc() ? 64 : 32;
    private final Map<IRubyObject, StructLayout.Member> fields = new LinkedHashMap<IRubyObject, StructLayout.Member>();
    private int size = 0;
    private int minAlign = 1;
    private int fieldCount = 0;
    private boolean isUnion = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSparc() {
        Platform.CPU cpu = Platform.getPlatform().getCPU();
        if (cpu == Platform.CPU.SPARC) return true;
        if (cpu != Platform.CPU.SPARCV9) return false;
        return true;
    }

    public static RubyClass createStructLayoutBuilderClass(Ruby runtime2, RubyModule module) {
        RubyClass result = runtime2.defineClassUnder(CLASS_NAME, runtime2.getObject(), Allocator.INSTANCE, module);
        result.defineAnnotatedMethods(StructLayoutBuilder.class);
        result.defineAnnotatedConstants(StructLayoutBuilder.class);
        return result;
    }

    StructLayoutBuilder(Ruby runtime2) {
        this(runtime2, FFIProvider.getModule(runtime2).fastGetClass(CLASS_NAME));
    }

    StructLayoutBuilder(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static StructLayoutBuilder newInstance(ThreadContext context, IRubyObject recv2) {
        return new StructLayoutBuilder(context.getRuntime());
    }

    @JRubyMethod(name={"build"})
    public StructLayout build(ThreadContext context) {
        return new StructLayout(context.getRuntime(), this.fields, this.minAlign + (this.size - 1 & ~(this.minAlign - 1)), this.minAlign);
    }

    @JRubyMethod(name={"size"})
    public IRubyObject get_size(ThreadContext context) {
        return context.getRuntime().newFixnum(this.size);
    }

    @JRubyMethod(name={"size="})
    public IRubyObject set_size(ThreadContext context, IRubyObject sizeArg) {
        int newSize = RubyNumeric.num2int(sizeArg);
        if (newSize > this.size) {
            this.size = newSize;
        }
        return context.getRuntime().newFixnum(this.size);
    }

    private static int alignMemberBits(int offset2, int alignBits) {
        int align = alignBits >> 3;
        return align + (offset2 - 1 & ~(align - 1));
    }

    private static int getAlignmentBits(NativeType type2) {
        switch (type2) {
            case INT8: 
            case UINT8: {
                return 8;
            }
            case INT16: 
            case UINT16: {
                return 16;
            }
            case INT32: 
            case UINT32: {
                return 32;
            }
            case INT64: 
            case UINT64: {
                return LONG_ALIGN;
            }
            case LONG: 
            case ULONG: {
                return LONG_ALIGN;
            }
            case FLOAT32: {
                return FLOAT_ALIGN;
            }
            case FLOAT64: {
                return DOUBLE_ALIGN;
            }
            case POINTER: 
            case STRING: 
            case RBXSTRING: {
                return ADDRESS_ALIGN;
            }
        }
        throw new UnsupportedOperationException("Cannot determine alignment of " + type2);
    }

    private static int getSizeBits(NativeType type2) {
        switch (type2) {
            case INT8: 
            case UINT8: {
                return 8;
            }
            case INT16: 
            case UINT16: {
                return 16;
            }
            case INT32: 
            case UINT32: {
                return 32;
            }
            case INT64: 
            case UINT64: {
                return 64;
            }
            case LONG: 
            case ULONG: {
                return LONG_SIZE;
            }
            case FLOAT32: {
                return 32;
            }
            case FLOAT64: {
                return 64;
            }
            case POINTER: 
            case STRING: 
            case RBXSTRING: {
                return ADDRESS_SIZE;
            }
        }
        throw new UnsupportedOperationException("Cannot determine size of " + type2);
    }

    private static IRubyObject createSymbolKey(Ruby runtime2, IRubyObject key2) {
        if (key2 instanceof RubySymbol) {
            return key2;
        }
        return runtime2.getSymbolTable().getSymbol(key2.asJavaString());
    }

    private static IRubyObject createStringKey(Ruby runtime2, IRubyObject key2) {
        if (key2 instanceof RubyString) {
            return key2;
        }
        return RubyString.newString(runtime2, key2.asJavaString());
    }

    private final IRubyObject storeField(Ruby runtime2, IRubyObject name2, StructLayout.Member field2, int align, int size2) {
        this.fields.put(StructLayoutBuilder.createStringKey(runtime2, name2), field2);
        this.fields.put(StructLayoutBuilder.createSymbolKey(runtime2, name2), field2);
        this.size = Math.max(this.size, (int)field2.offset + size2);
        this.minAlign = Math.max(this.minAlign, align);
        return this;
    }

    @JRubyMethod(name={"union="})
    public IRubyObject set_union(ThreadContext context, IRubyObject isUnion) {
        this.isUnion = isUnion.isTrue();
        return this;
    }

    @JRubyMethod(name={"add_field"}, required=2, optional=1)
    public IRubyObject add(ThreadContext context, IRubyObject[] args2) {
        StructLayout.Member field2;
        NativeParam type2;
        Ruby runtime2 = context.getRuntime();
        IRubyObject name2 = args2[0];
        int offset2 = args2.length > 2 && !args2[2].isNil() ? Util.int32Value(args2[2]) : -1;
        int alignBits = 8;
        int sizeBits = 8;
        if (args2[1] instanceof CallbackInfo) {
            type2 = (CallbackInfo)args2[1];
            alignBits = ADDRESS_ALIGN;
            sizeBits = ADDRESS_SIZE;
        } else {
            NativeType t = NativeType.valueOf(Util.int32Value(args2[1]));
            type2 = t;
            alignBits = StructLayoutBuilder.getAlignmentBits(t);
            sizeBits = StructLayoutBuilder.getSizeBits(t);
        }
        if (offset2 < 0) {
            int n = offset2 = this.isUnion ? 0 : StructLayoutBuilder.alignMemberBits(this.size, alignBits);
        }
        if ((field2 = this.createMember(context.getRuntime(), type2, this.fieldCount++, offset2)) == null) {
            throw runtime2.newArgumentError("Unknown field type: " + type2);
        }
        return this.storeField(runtime2, name2, field2, alignBits / 8, sizeBits / 8);
    }

    @JRubyMethod(name={"add_struct"}, required=2, optional=1)
    public IRubyObject add_struct(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject name2 = args2[0];
        int offset2 = args2.length > 2 && !args2[2].isNil() ? Util.int32Value(args2[2]) : -1;
        StructLayout layout = Struct.getStructLayout(runtime2, args2[1]);
        int alignBits = layout.getMinimumAlignment() * 8;
        if (offset2 < 0) {
            offset2 = this.isUnion ? 0 : StructLayoutBuilder.alignMemberBits(this.size, alignBits);
        }
        StructLayout.Member field2 = StructMember.create((RubyClass)args2[1], this.fieldCount++, offset2);
        return this.storeField(runtime2, name2, field2, alignBits / 8, layout.getSize());
    }

    @JRubyMethod(name={"add_array"}, required=3, optional=1)
    public IRubyObject add_array(ThreadContext context, IRubyObject[] args2) {
        StructLayout.ArrayMemberIO io2;
        Ruby runtime2 = context.getRuntime();
        IRubyObject name2 = args2[0];
        NativeType type2 = NativeType.valueOf(Util.int32Value(args2[1]));
        int length2 = Util.int32Value(args2[2]);
        int offset2 = args2.length > 3 && !args2[3].isNil() ? Util.int32Value(args2[3]) : -1;
        int alignBits = StructLayoutBuilder.getAlignmentBits(type2);
        int sizeBits = StructLayoutBuilder.getSizeBits(type2);
        if (offset2 < 0) {
            int n = offset2 = this.isUnion ? 0 : StructLayoutBuilder.alignMemberBits(this.size, alignBits);
        }
        if ((io2 = StructLayoutBuilder.getArrayMemberIO(type2)) == null) {
            throw context.getRuntime().newNotImplementedError("Unsupported array field type: " + type2);
        }
        ArrayMember field2 = new ArrayMember(this.fieldCount++, offset2, io2, sizeBits, length2);
        return this.storeField(runtime2, name2, field2, alignBits / 8, sizeBits / 8 * length2);
    }

    @JRubyMethod(name={"add_char_array"}, required=2, optional=1)
    public IRubyObject add_char_array(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject name2 = args2[0];
        int strlen = Util.int32Value(args2[1]);
        long offset2 = args2.length > 2 ? Util.int64Value(args2[2]) : -1L;
        int alignBits = 8;
        if (offset2 < 0L) {
            offset2 = this.isUnion ? 0L : (long)StructLayoutBuilder.alignMemberBits(this.size, alignBits);
        }
        return this.storeField(runtime2, name2, CharArrayMember.create(this.fieldCount++, offset2, strlen), alignBits / 8, strlen);
    }

    StructLayout.Member createMember(Ruby runtime2, Object type2, int index2, long offset2) {
        if (type2 instanceof NativeType) {
            return StructLayoutBuilder.createMember((NativeType)type2, index2, offset2);
        }
        if (type2 instanceof CallbackInfo) {
            return CallbackMember.create((CallbackInfo)type2, index2, offset2);
        }
        if (type2 instanceof RubyClass && Struct.isStruct(runtime2, (RubyClass)type2)) {
            return StructMember.create((RubyClass)type2, index2, offset2);
        }
        return null;
    }

    static StructLayout.Member createMember(NativeType type2, int index2, long offset2) {
        switch (type2) {
            case INT8: {
                return Signed8Member.create(index2, offset2);
            }
            case UINT8: {
                return Unsigned8Member.create(index2, offset2);
            }
            case INT16: {
                return Signed16Member.create(index2, offset2);
            }
            case UINT16: {
                return Unsigned16Member.create(index2, offset2);
            }
            case INT32: {
                return Signed32Member.create(index2, offset2);
            }
            case UINT32: {
                return Unsigned32Member.create(index2, offset2);
            }
            case INT64: {
                return Signed64Member.create(index2, offset2);
            }
            case UINT64: {
                return Unsigned64Member.create(index2, offset2);
            }
            case LONG: {
                return LONG_SIZE == 32 ? Signed32Member.create(index2, offset2) : Signed64Member.create(index2, offset2);
            }
            case ULONG: {
                return LONG_SIZE == 32 ? Unsigned32Member.create(index2, offset2) : Unsigned64Member.create(index2, offset2);
            }
            case FLOAT32: {
                return Float32Member.create(index2, offset2);
            }
            case FLOAT64: {
                return Float64Member.create(index2, offset2);
            }
            case POINTER: {
                return PointerMember.create(index2, offset2);
            }
            case STRING: 
            case RBXSTRING: {
                return StringMember.create(index2, offset2);
            }
        }
        return null;
    }

    private static final StructLayout.ArrayMemberIO getArrayMemberIO(NativeType type2) {
        switch (type2) {
            case INT8: {
                return Signed8ArrayIO.INSTANCE;
            }
            case UINT8: {
                return Unsigned8ArrayIO.INSTANCE;
            }
            case INT16: {
                return Signed16ArrayIO.INSTANCE;
            }
            case UINT16: {
                return Unsigned16ArrayIO.INSTANCE;
            }
            case INT32: {
                return Signed32ArrayIO.INSTANCE;
            }
            case UINT32: {
                return Unsigned32ArrayIO.INSTANCE;
            }
            case INT64: {
                return Signed64ArrayIO.INSTANCE;
            }
            case UINT64: {
                return Unsigned64ArrayIO.INSTANCE;
            }
        }
        return null;
    }

    static final class Unsigned64ArrayIO
    extends StructLayout.ArrayMemberIO {
        static StructLayout.ArrayMemberIO INSTANCE = new Unsigned64ArrayIO();

        Unsigned64ArrayIO() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putLong(offset2, Util.uint64Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newUnsigned64(runtime2, io2.getLong(offset2));
        }
    }

    static final class Signed64ArrayIO
    extends StructLayout.ArrayMemberIO {
        static StructLayout.ArrayMemberIO INSTANCE = new Signed64ArrayIO();

        Signed64ArrayIO() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putLong(offset2, Util.int64Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newSigned64(runtime2, io2.getLong(offset2));
        }
    }

    static final class Unsigned32ArrayIO
    extends StructLayout.ArrayMemberIO {
        static StructLayout.ArrayMemberIO INSTANCE = new Unsigned32ArrayIO();

        Unsigned32ArrayIO() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putInt(offset2, (int)Util.uint32Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newUnsigned32(runtime2, io2.getInt(offset2));
        }
    }

    static final class Signed32ArrayIO
    extends StructLayout.ArrayMemberIO {
        static StructLayout.ArrayMemberIO INSTANCE = new Signed32ArrayIO();

        Signed32ArrayIO() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putInt(offset2, Util.int32Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newSigned32(runtime2, io2.getInt(offset2));
        }
    }

    static final class Unsigned16ArrayIO
    extends StructLayout.ArrayMemberIO {
        static StructLayout.ArrayMemberIO INSTANCE = new Unsigned16ArrayIO();

        Unsigned16ArrayIO() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putShort(offset2, (short)Util.uint16Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newUnsigned16(runtime2, io2.getShort(offset2));
        }
    }

    static final class Signed16ArrayIO
    extends StructLayout.ArrayMemberIO {
        static StructLayout.ArrayMemberIO INSTANCE = new Signed16ArrayIO();

        Signed16ArrayIO() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putShort(offset2, Util.int16Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newSigned16(runtime2, io2.getShort(offset2));
        }
    }

    static final class Unsigned8ArrayIO
    extends StructLayout.ArrayMemberIO {
        static StructLayout.ArrayMemberIO INSTANCE = new Unsigned8ArrayIO();

        Unsigned8ArrayIO() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putByte(offset2, (byte)Util.uint8Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newUnsigned8(runtime2, io2.getByte(offset2));
        }
    }

    static final class Signed8ArrayIO
    extends StructLayout.ArrayMemberIO {
        static StructLayout.ArrayMemberIO INSTANCE = new Signed8ArrayIO();

        Signed8ArrayIO() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putByte(offset2, Util.int8Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newSigned8(runtime2, io2.getByte(offset2));
        }
    }

    static final class ArrayMember
    extends StructLayout.Member {
        private final StructLayout.ArrayMemberIO io;
        private final int length;
        private final int typeSize;

        ArrayMember(int index2, long offset2, StructLayout.ArrayMemberIO io2, int typeSize, int length2) {
            super(index2, offset2);
            this.io = io2;
            this.typeSize = typeSize;
            this.length = length2;
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            throw runtime2.newNotImplementedError("Cannot set Array fields");
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return new StructLayout.Array(runtime2, ptr, this.offset, this.length, this.typeSize, this.io);
        }

        public IRubyObject get(Ruby runtime2, Struct struct) {
            IRubyObject s = struct.getCachedValue(this);
            if (s == null) {
                s = new StructLayout.Array(runtime2, struct.getMemory(), this.offset, this.length, this.typeSize, this.io);
                struct.putCachedValue(this, s);
            }
            return s;
        }

        protected boolean isCacheable() {
            return true;
        }
    }

    static final class StructMember
    extends StructLayout.Member {
        private final RubyClass klass;

        StructMember(RubyClass klass, int index2, long offset2) {
            super(index2, offset2);
            this.klass = klass;
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            throw runtime2.newNotImplementedError("Cannot set Struct fields");
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return Struct.newStruct(runtime2, this.klass, ((AbstractMemory)ptr).slice(runtime2, this.getOffset(ptr)));
        }

        public IRubyObject get(Ruby runtime2, Struct struct) {
            IRubyObject s = struct.getCachedValue(this);
            if (s == null) {
                IRubyObject ptr = struct.getMemory();
                s = Struct.newStruct(runtime2, this.klass, ((AbstractMemory)ptr).slice(runtime2, this.getOffset(ptr)));
                struct.putCachedValue(this, s);
            }
            return s;
        }

        protected boolean isCacheable() {
            return true;
        }

        static StructLayout.Member create(RubyClass klass, int index2, long offset2) {
            return new StructMember(klass, index2, offset2);
        }
    }

    static final class CallbackMember
    extends StructLayout.Member {
        private final CallbackInfo cbInfo;

        CallbackMember(CallbackInfo cbInfo, int index2, long offset2) {
            super(index2, offset2);
            this.cbInfo = cbInfo;
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            if (value2.isNil()) {
                CallbackMember.getMemoryIO(ptr).putAddress(this.getOffset(ptr), 0L);
            } else {
                Pointer cb = Factory.getInstance().getCallbackManager().getCallback(runtime2, this.cbInfo, value2);
                CallbackMember.getMemoryIO(ptr).putMemoryIO(this.getOffset(ptr), cb.getMemoryIO());
            }
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            throw runtime2.newNotImplementedError("Cannot get callback struct fields");
        }

        static StructLayout.Member create(CallbackInfo cbInfo, int index2, long offset2) {
            return new CallbackMember(cbInfo, index2, offset2);
        }
    }

    static final class CharArrayMember
    extends StructLayout.Member {
        private final int size;

        CharArrayMember(int index2, long offset2, int size2) {
            super(index2, offset2);
            this.size = size2;
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            MemoryIO io2 = CharArrayMember.getMemoryIO(ptr);
            ByteList bl = value2.convertToString().getByteList();
            int len = Math.min(bl.length(), this.size - 1);
            io2.put(this.getOffset(ptr), bl.unsafeBytes(), bl.begin(), len);
            io2.putByte(this.getOffset(ptr) + (long)len, (byte)0);
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            MemoryIO io2 = CharArrayMember.getMemoryIO(ptr);
            int len = io2.indexOf(this.getOffset(ptr), (byte)0, this.size);
            if (len < 0) {
                len = this.size;
            }
            ByteList bl = new ByteList(len);
            bl.length(len);
            io2.get(0L, bl.unsafeBytes(), bl.begin(), len);
            return runtime2.newString(bl);
        }

        static StructLayout.Member create(int index2, long offset2, int size2) {
            return new CharArrayMember(index2, offset2, size2);
        }
    }

    static final class StringMember
    extends StructLayout.Member {
        StringMember(int index2, long offset2) {
            super(index2, offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            DirectMemoryIO io2 = StringMember.getMemoryIO(ptr).getMemoryIO(this.getOffset(ptr));
            if (io2 == null || io2.isNull()) {
                throw runtime2.newRuntimeError("Invalid memory access");
            }
            ByteList bl = value2.convertToString().getByteList();
            io2.put(0L, bl.unsafeBytes(), bl.begin(), bl.length());
            io2.putByte(bl.length(), (byte)0);
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            DirectMemoryIO io2 = StringMember.getMemoryIO(ptr).getMemoryIO(this.getOffset(ptr));
            if (io2 == null || io2.isNull()) {
                return runtime2.getNil();
            }
            int len = io2.indexOf(0L, (byte)0, Integer.MAX_VALUE);
            ByteList bl = new ByteList(len);
            bl.length(len);
            io2.get(0L, bl.unsafeBytes(), bl.begin(), len);
            return runtime2.newString(bl);
        }

        static StructLayout.Member create(int index2, long offset2) {
            return new StringMember(index2, offset2);
        }
    }

    static final class Float64Member
    extends StructLayout.Member {
        Float64Member(int index2, long offset2) {
            super(index2, offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Float64Member.getMemoryIO(ptr).putDouble(this.getOffset(ptr), Util.doubleValue(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return RubyFloat.newFloat(runtime2, Float64Member.getMemoryIO(ptr).getDouble(this.getOffset(ptr)));
        }

        static StructLayout.Member create(int index2, long offset2) {
            return new Float64Member(index2, offset2);
        }
    }

    static final class Float32Member
    extends StructLayout.Member {
        Float32Member(int index2, long offset2) {
            super(index2, offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Float32Member.getMemoryIO(ptr).putFloat(this.getOffset(ptr), Util.floatValue(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return RubyFloat.newFloat(runtime2, Float32Member.getMemoryIO(ptr).getFloat(this.getOffset(ptr)));
        }

        static StructLayout.Member create(int index2, long offset2) {
            return new Float32Member(index2, offset2);
        }
    }

    static final class PointerMember
    extends StructLayout.Member {
        PointerMember(int index2, long offset2) {
            super(index2, offset2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            if (value2 instanceof Pointer) {
                PointerMember.getMemoryIO(ptr).putMemoryIO(this.getOffset(ptr), ((Pointer)value2).getMemoryIO());
                return;
            } else if (value2 instanceof Struct) {
                PointerMember.getMemoryIO(ptr).putMemoryIO(this.getOffset(ptr), ((Struct)value2).getMemoryIO());
                return;
            } else if (value2 instanceof RubyInteger) {
                PointerMember.getMemoryIO(ptr).putAddress(this.offset, Util.int64Value(ptr));
                return;
            } else if (value2.respondsTo("to_ptr")) {
                IRubyObject addr2 = value2.callMethod(runtime2.getCurrentContext(), "to_ptr");
                if (!(addr2 instanceof Pointer)) throw runtime2.newArgumentError("Invalid pointer value");
                PointerMember.getMemoryIO(ptr).putMemoryIO(this.offset, ((Pointer)addr2).getMemoryIO());
                return;
            } else {
                if (!value2.isNil()) throw runtime2.newArgumentError("Invalid pointer value");
                PointerMember.getMemoryIO(ptr).putAddress(this.offset, 0L);
            }
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return ((AbstractMemory)ptr).getPointer(runtime2, this.getOffset(ptr));
        }

        public IRubyObject get(Ruby runtime2, Struct struct) {
            IRubyObject ptr = struct.getMemory();
            DirectMemoryIO memory = ((AbstractMemory)ptr).getMemoryIO().getMemoryIO(this.getOffset(ptr));
            IRubyObject old = struct.getCachedValue(this);
            if (old != null) {
                MemoryIO oldMemory = ((AbstractMemory)old).getMemoryIO();
                if (memory != null && memory.equals(oldMemory) || memory == null && oldMemory.isNull()) {
                    return old;
                }
            }
            BasePointer retval = new BasePointer(runtime2, memory != null ? memory : new NullMemoryIO(runtime2));
            struct.putCachedValue(this, retval);
            return retval;
        }

        protected boolean isCacheable() {
            return true;
        }

        static StructLayout.Member create(int index2, long offset2) {
            return new PointerMember(index2, offset2);
        }
    }

    static final class Unsigned64Member
    extends StructLayout.Member {
        Unsigned64Member(int index2, long offset2) {
            super(index2, offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Unsigned64Member.getMemoryIO(ptr).putLong(this.getOffset(ptr), Util.uint64Value(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return Util.newUnsigned64(runtime2, Unsigned64Member.getMemoryIO(ptr).getLong(this.getOffset(ptr)));
        }

        static StructLayout.Member create(int index2, long offset2) {
            return new Unsigned64Member(index2, offset2);
        }
    }

    static final class Signed64Member
    extends StructLayout.Member {
        Signed64Member(int index2, long offset2) {
            super(index2, offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Signed64Member.getMemoryIO(ptr).putLong(this.getOffset(ptr), Util.int64Value(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return Util.newSigned64(runtime2, Signed64Member.getMemoryIO(ptr).getLong(this.getOffset(ptr)));
        }

        static StructLayout.Member create(int index2, long offset2) {
            return new Signed64Member(index2, offset2);
        }
    }

    static final class Unsigned32Member
    extends StructLayout.Member {
        Unsigned32Member(int index2, long offset2) {
            super(index2, offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Unsigned32Member.getMemoryIO(ptr).putInt(this.getOffset(ptr), (int)Util.uint32Value(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return Util.newUnsigned32(runtime2, Unsigned32Member.getMemoryIO(ptr).getInt(this.getOffset(ptr)));
        }

        static StructLayout.Member create(int index2, long offset2) {
            return new Unsigned32Member(index2, offset2);
        }
    }

    static final class Signed32Member
    extends StructLayout.Member {
        Signed32Member(int index2, long offset2) {
            super(index2, offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Signed32Member.getMemoryIO(ptr).putInt(this.getOffset(ptr), Util.int32Value(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return Util.newSigned32(runtime2, Signed32Member.getMemoryIO(ptr).getInt(this.getOffset(ptr)));
        }

        static StructLayout.Member create(int index2, long offset2) {
            return new Signed32Member(index2, offset2);
        }
    }

    static final class Unsigned16Member
    extends StructLayout.Member {
        Unsigned16Member(int index2, long offset2) {
            super(index2, offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Unsigned16Member.getMemoryIO(ptr).putShort(this.getOffset(ptr), (short)Util.uint16Value(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return Util.newUnsigned16(runtime2, Unsigned16Member.getMemoryIO(ptr).getShort(this.getOffset(ptr)));
        }

        static StructLayout.Member create(int index2, long offset2) {
            return new Unsigned16Member(index2, offset2);
        }
    }

    static final class Signed16Member
    extends StructLayout.Member {
        Signed16Member(int index2, long offset2) {
            super(index2, offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Signed16Member.getMemoryIO(ptr).putShort(this.getOffset(ptr), Util.int16Value(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return Util.newSigned16(runtime2, Signed16Member.getMemoryIO(ptr).getShort(this.getOffset(ptr)));
        }

        static StructLayout.Member create(int index2, long offset2) {
            return new Signed16Member(index2, offset2);
        }
    }

    static final class Unsigned8Member
    extends StructLayout.Member {
        Unsigned8Member(int index2, long offset2) {
            super(index2, offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Unsigned8Member.getMemoryIO(ptr).putByte(this.getOffset(ptr), (byte)Util.uint8Value(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return Util.newUnsigned8(runtime2, Unsigned8Member.getMemoryIO(ptr).getByte(this.getOffset(ptr)));
        }

        static StructLayout.Member create(int index2, long offset2) {
            return new Unsigned8Member(index2, offset2);
        }
    }

    static final class Signed8Member
    extends StructLayout.Member {
        Signed8Member(int index2, long offset2) {
            super(index2, offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Signed8Member.getMemoryIO(ptr).putByte(this.getOffset(ptr), Util.int8Value(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return Util.newSigned8(runtime2, Signed8Member.getMemoryIO(ptr).getByte(this.getOffset(ptr)));
        }

        static StructLayout.Member create(int index2, long offset2) {
            return new Signed8Member(index2, offset2);
        }
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new StructLayoutBuilder(runtime2, klass);
        }
    }
}

