/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class DynamicMethod {
    protected RubyModule implementationClass;
    protected Visibility visibility;
    protected CallConfiguration callConfig;

    protected DynamicMethod(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
        this.visibility = visibility;
        this.implementationClass = implementationClass;
        this.callConfig = callConfig;
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

    public abstract DynamicMethod dup();

    public boolean isCallableFrom(IRubyObject caller, CallType callType) {
        switch (this.visibility) {
            case PUBLIC: {
                return true;
            }
            case PRIVATE: {
                if (callType != CallType.NORMAL) break;
                return false;
            }
            case PROTECTED: {
                RubyModule defined = this.getImplementationClass();
                while (defined.isIncluded()) {
                    defined = defined.getMetaClass();
                }
                if (caller.isKindOf(defined)) break;
                return false;
            }
        }
        return true;
    }

    public RubyModule getImplementationClass() {
        return this.implementationClass;
    }

    public void setImplementationClass(RubyModule implClass) {
        this.implementationClass = implClass;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public boolean isUndefined() {
        return false;
    }

    public Arity getArity() {
        return Arity.optional();
    }

    public DynamicMethod getRealMethod() {
        return this;
    }

    public CallConfiguration getCallConfig() {
        return this.callConfig;
    }

    public void setCallConfig(CallConfiguration callConfig) {
        this.callConfig = callConfig;
    }

    public boolean isNative() {
        return false;
    }
}

