/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.util.Iterator;
import org.jruby.RubyMatchData;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.BranchCallback;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.MethodCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.ScriptCompiler;
import org.jruby.compiler.YARVNodesCompiler;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.CallType;
import org.jruby.runtime.builtin.IRubyObject;

public class ASTCompiler {
    public static void compile(Node node, MethodCompiler context) {
        if (node == null) {
            context.loadNil();
            return;
        }
        switch (node.nodeId) {
            case ALIASNODE: {
                ASTCompiler.compileAlias(node, context);
                break;
            }
            case ANDNODE: {
                ASTCompiler.compileAnd(node, context);
                break;
            }
            case ARGSCATNODE: {
                ASTCompiler.compileArgsCat(node, context);
                break;
            }
            case ARGSPUSHNODE: {
                ASTCompiler.compileArgsPush(node, context);
                break;
            }
            case ARRAYNODE: {
                ASTCompiler.compileArray(node, context);
                break;
            }
            case ATTRASSIGNNODE: {
                ASTCompiler.compileAttrAssign(node, context);
                break;
            }
            case BACKREFNODE: {
                ASTCompiler.compileBackref(node, context);
                break;
            }
            case BEGINNODE: {
                ASTCompiler.compileBegin(node, context);
                break;
            }
            case BIGNUMNODE: {
                ASTCompiler.compileBignum(node, context);
                break;
            }
            case BLOCKNODE: {
                ASTCompiler.compileBlock(node, context);
                break;
            }
            case BREAKNODE: {
                ASTCompiler.compileBreak(node, context);
                break;
            }
            case CALLNODE: {
                ASTCompiler.compileCall(node, context);
                break;
            }
            case CASENODE: {
                ASTCompiler.compileCase(node, context);
                break;
            }
            case CLASSNODE: {
                ASTCompiler.compileClass(node, context);
                break;
            }
            case CLASSVARNODE: {
                ASTCompiler.compileClassVar(node, context);
                break;
            }
            case CLASSVARASGNNODE: {
                ASTCompiler.compileClassVarAsgn(node, context);
                break;
            }
            case CLASSVARDECLNODE: {
                ASTCompiler.compileClassVarDecl(node, context);
                break;
            }
            case COLON2NODE: {
                ASTCompiler.compileColon2(node, context);
                break;
            }
            case COLON3NODE: {
                ASTCompiler.compileColon3(node, context);
                break;
            }
            case CONSTDECLNODE: {
                ASTCompiler.compileConstDecl(node, context);
                break;
            }
            case CONSTNODE: {
                ASTCompiler.compileConst(node, context);
                break;
            }
            case DASGNNODE: {
                ASTCompiler.compileDAsgn(node, context);
                break;
            }
            case DEFINEDNODE: {
                ASTCompiler.compileDefined(node, context);
                break;
            }
            case DEFNNODE: {
                ASTCompiler.compileDefn(node, context);
                break;
            }
            case DEFSNODE: {
                ASTCompiler.compileDefs(node, context);
                break;
            }
            case DOTNODE: {
                ASTCompiler.compileDot(node, context);
                break;
            }
            case DREGEXPNODE: {
                ASTCompiler.compileDRegexp(node, context);
                break;
            }
            case DSTRNODE: {
                ASTCompiler.compileDStr(node, context);
                break;
            }
            case DSYMBOLNODE: {
                ASTCompiler.compileDSymbol(node, context);
                break;
            }
            case DVARNODE: {
                ASTCompiler.compileDVar(node, context);
                break;
            }
            case DXSTRNODE: {
                ASTCompiler.compileDXStr(node, context);
                break;
            }
            case ENSURENODE: {
                ASTCompiler.compileEnsureNode(node, context);
                break;
            }
            case EVSTRNODE: {
                ASTCompiler.compileEvStr(node, context);
                break;
            }
            case FALSENODE: {
                ASTCompiler.compileFalse(node, context);
                break;
            }
            case FCALLNODE: {
                ASTCompiler.compileFCall(node, context);
                break;
            }
            case FIXNUMNODE: {
                ASTCompiler.compileFixnum(node, context);
                break;
            }
            case FLIPNODE: {
                ASTCompiler.compileFlip(node, context);
                break;
            }
            case FLOATNODE: {
                ASTCompiler.compileFloat(node, context);
                break;
            }
            case FORNODE: {
                ASTCompiler.compileFor(node, context);
                break;
            }
            case GLOBALASGNNODE: {
                ASTCompiler.compileGlobalAsgn(node, context);
                break;
            }
            case GLOBALVARNODE: {
                ASTCompiler.compileGlobalVar(node, context);
                break;
            }
            case HASHNODE: {
                ASTCompiler.compileHash(node, context);
                break;
            }
            case IFNODE: {
                ASTCompiler.compileIf(node, context);
                break;
            }
            case INSTASGNNODE: {
                ASTCompiler.compileInstAsgn(node, context);
                break;
            }
            case INSTVARNODE: {
                ASTCompiler.compileInstVar(node, context);
                break;
            }
            case ITERNODE: {
                ASTCompiler.compileIter(node, context);
                break;
            }
            case LOCALASGNNODE: {
                ASTCompiler.compileLocalAsgn(node, context);
                break;
            }
            case LOCALVARNODE: {
                ASTCompiler.compileLocalVar(node, context);
                break;
            }
            case MATCH2NODE: {
                ASTCompiler.compileMatch2(node, context);
                break;
            }
            case MATCH3NODE: {
                ASTCompiler.compileMatch3(node, context);
                break;
            }
            case MATCHNODE: {
                ASTCompiler.compileMatch(node, context);
                break;
            }
            case MODULENODE: {
                ASTCompiler.compileModule(node, context);
                break;
            }
            case MULTIPLEASGNNODE: {
                ASTCompiler.compileMultipleAsgn(node, context);
                break;
            }
            case NEWLINENODE: {
                ASTCompiler.compileNewline(node, context);
                break;
            }
            case NEXTNODE: {
                ASTCompiler.compileNext(node, context);
                break;
            }
            case NTHREFNODE: {
                ASTCompiler.compileNthRef(node, context);
                break;
            }
            case NILNODE: {
                ASTCompiler.compileNil(node, context);
                break;
            }
            case NOTNODE: {
                ASTCompiler.compileNot(node, context);
                break;
            }
            case OPASGNANDNODE: {
                ASTCompiler.compileOpAsgnAnd(node, context);
                break;
            }
            case OPASGNNODE: {
                ASTCompiler.compileOpAsgn(node, context);
                break;
            }
            case OPASGNORNODE: {
                ASTCompiler.compileOpAsgnOr(node, context);
                break;
            }
            case OPELEMENTASGNNODE: {
                ASTCompiler.compileOpElementAsgn(node, context);
                break;
            }
            case ORNODE: {
                ASTCompiler.compileOr(node, context);
                break;
            }
            case POSTEXENODE: {
                ASTCompiler.compilePostExe(node, context);
                break;
            }
            case PREEXENODE: {
                ASTCompiler.compilePreExe(node, context);
                break;
            }
            case REDONODE: {
                ASTCompiler.compileRedo(node, context);
                break;
            }
            case REGEXPNODE: {
                ASTCompiler.compileRegexp(node, context);
                break;
            }
            case RESCUEBODYNODE: {
                throw new NotCompilableException("rescue body is handled by rescue compilation at: " + node.getPosition());
            }
            case RESCUENODE: {
                ASTCompiler.compileRescue(node, context);
                break;
            }
            case RETRYNODE: {
                ASTCompiler.compileRetry(node, context);
                break;
            }
            case RETURNNODE: {
                ASTCompiler.compileReturn(node, context);
                break;
            }
            case ROOTNODE: {
                throw new NotCompilableException("Use compileRoot(); Root node at: " + node.getPosition());
            }
            case SCLASSNODE: {
                ASTCompiler.compileSClass(node, context);
                break;
            }
            case SELFNODE: {
                ASTCompiler.compileSelf(node, context);
                break;
            }
            case SPLATNODE: {
                ASTCompiler.compileSplat(node, context);
                break;
            }
            case STRNODE: {
                ASTCompiler.compileStr(node, context);
                break;
            }
            case SUPERNODE: {
                ASTCompiler.compileSuper(node, context);
                break;
            }
            case SVALUENODE: {
                ASTCompiler.compileSValue(node, context);
                break;
            }
            case SYMBOLNODE: {
                ASTCompiler.compileSymbol(node, context);
                break;
            }
            case TOARYNODE: {
                ASTCompiler.compileToAry(node, context);
                break;
            }
            case TRUENODE: {
                ASTCompiler.compileTrue(node, context);
                break;
            }
            case UNDEFNODE: {
                ASTCompiler.compileUndef(node, context);
                break;
            }
            case UNTILNODE: {
                ASTCompiler.compileUntil(node, context);
                break;
            }
            case VALIASNODE: {
                ASTCompiler.compileVAlias(node, context);
                break;
            }
            case VCALLNODE: {
                ASTCompiler.compileVCall(node, context);
                break;
            }
            case WHILENODE: {
                ASTCompiler.compileWhile(node, context);
                break;
            }
            case WHENNODE: {
                assert (false) : "When nodes are handled by case node compilation.";
                break;
            }
            case XSTRNODE: {
                ASTCompiler.compileXStr(node, context);
                break;
            }
            case YIELDNODE: {
                ASTCompiler.compileYield(node, context);
                break;
            }
            case ZARRAYNODE: {
                ASTCompiler.compileZArray(node, context);
                break;
            }
            case ZSUPERNODE: {
                ASTCompiler.compileZSuper(node, context);
                break;
            }
            default: {
                assert (false) : "Unknown node encountered in compiler: " + node;
                break;
            }
        }
    }

    public static void compileArguments(Node node, MethodCompiler context) {
        switch (node.nodeId) {
            case ARGSCATNODE: {
                ASTCompiler.compileArgsCatArguments(node, context);
                break;
            }
            case ARGSPUSHNODE: {
                ASTCompiler.compileArgsPushArguments(node, context);
                break;
            }
            case ARRAYNODE: {
                ASTCompiler.compileArrayArguments(node, context);
                break;
            }
            case SPLATNODE: {
                ASTCompiler.compileSplatArguments(node, context);
                break;
            }
            default: {
                ASTCompiler.compile(node, context);
                context.convertToJavaArray();
            }
        }
    }

    public static void compileAssignment(Node node, MethodCompiler context) {
        switch (node.nodeId) {
            case ATTRASSIGNNODE: {
                ASTCompiler.compileAttrAssignAssignment(node, context);
                break;
            }
            case DASGNNODE: {
                ASTCompiler.compileDAsgnAssignment(node, context);
                break;
            }
            case CLASSVARASGNNODE: {
                ASTCompiler.compileClassVarAsgnAssignment(node, context);
                break;
            }
            case CLASSVARDECLNODE: {
                ASTCompiler.compileClassVarDeclAssignment(node, context);
                break;
            }
            case CONSTDECLNODE: {
                ASTCompiler.compileConstDeclAssignment(node, context);
                break;
            }
            case GLOBALASGNNODE: {
                ASTCompiler.compileGlobalAsgnAssignment(node, context);
                break;
            }
            case INSTASGNNODE: {
                ASTCompiler.compileInstAsgnAssignment(node, context);
                break;
            }
            case LOCALASGNNODE: {
                ASTCompiler.compileLocalAsgnAssignment(node, context);
                break;
            }
            case MULTIPLEASGNNODE: {
                ASTCompiler.compileMultipleAsgnAssignment(node, context);
                break;
            }
            case ZEROARGNODE: {
                throw new NotCompilableException("Shouldn't get here; zeroarg does not do assignment: " + node);
            }
            default: {
                throw new NotCompilableException("Can't compile assignment node: " + node);
            }
        }
    }

    public static YARVNodesCompiler getYARVCompiler() {
        return new YARVNodesCompiler();
    }

    public static void compileAlias(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        AliasNode alias = (AliasNode)node;
        context.defineAlias(alias.getNewName(), alias.getOldName());
    }

    public static void compileAnd(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final AndNode andNode = (AndNode)node;
        ASTCompiler.compile(andNode.getFirstNode(), context);
        BranchCallback longCallback = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                ASTCompiler.compile(andNode.getSecondNode(), context);
            }
        };
        context.performLogicalAnd(longCallback);
    }

    public static void compileArray(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        ArrayNode arrayNode = (ArrayNode)node;
        ArrayCallback callback = new ArrayCallback(){

            @Override
            public void nextValue(MethodCompiler context, Object sourceArray, int index) {
                Node node = (Node)((Object[])sourceArray)[index];
                ASTCompiler.compile(node, context);
            }
        };
        context.createObjectArray(arrayNode.childNodes().toArray(), callback);
        context.createNewArray(arrayNode.isLightweight());
    }

    public static void compileArgsCat(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        ArgsCatNode argsCatNode = (ArgsCatNode)node;
        ASTCompiler.compile(argsCatNode.getFirstNode(), context);
        context.ensureRubyArray();
        ASTCompiler.compile(argsCatNode.getSecondNode(), context);
        context.splatCurrentValue();
        context.concatArrays();
    }

    public static void compileArgsPush(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        ArgsPushNode argsPush = (ArgsPushNode)node;
        ASTCompiler.compile(argsPush.getFirstNode(), context);
        ASTCompiler.compile(argsPush.getSecondNode(), context);
        context.concatArrays();
    }

    public static void compileAttrAssign(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        AttrAssignNode attrAssignNode = (AttrAssignNode)node;
        ASTCompiler.compile(attrAssignNode.getReceiverNode(), context);
        ASTCompiler.compileArguments(attrAssignNode.getArgsNode(), context);
        context.getInvocationCompiler().invokeAttrAssign(attrAssignNode.getName());
    }

    public static void compileAttrAssignAssignment(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        AttrAssignNode attrAssignNode = (AttrAssignNode)node;
        ASTCompiler.compile(attrAssignNode.getReceiverNode(), context);
        context.swapValues();
        if (attrAssignNode.getArgsNode() != null) {
            ASTCompiler.compileArguments(attrAssignNode.getArgsNode(), context);
            context.swapValues();
            context.appendToObjectArray();
        } else {
            context.createObjectArray(1);
        }
        context.getInvocationCompiler().invokeAttrAssign(attrAssignNode.getName());
    }

    public static void compileBackref(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        BackRefNode iVisited = (BackRefNode)node;
        context.performBackref(iVisited.getType());
    }

    public static void compileBegin(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        BeginNode beginNode = (BeginNode)node;
        ASTCompiler.compile(beginNode.getBodyNode(), context);
    }

    public static void compileBignum(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        context.createNewBignum(((BignumNode)node).getValue());
    }

    public static void compileBlock(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        BlockNode blockNode = (BlockNode)node;
        Iterator<Node> iter = blockNode.childNodes().iterator();
        while (iter.hasNext()) {
            Node n = iter.next();
            ASTCompiler.compile(n, context);
            if (!iter.hasNext()) continue;
            context.consumeCurrentValue();
        }
    }

    public static void compileBreak(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final BreakNode breakNode = (BreakNode)node;
        ClosureCallback valueCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                if (breakNode.getValueNode() != null) {
                    ASTCompiler.compile(breakNode.getValueNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        context.issueBreakEvent(valueCallback);
    }

    public static void compileCall(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final CallNode callNode = (CallNode)node;
        ClosureCallback receiverCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                ASTCompiler.compile(callNode.getReceiverNode(), context);
            }
        };
        ClosureCallback argsCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                ASTCompiler.compileArguments(callNode.getArgsNode(), context);
            }
        };
        if (callNode.getIterNode() == null) {
            if (callNode.getArgsNode() != null) {
                context.getInvocationCompiler().invokeDynamic(callNode.getName(), receiverCallback, argsCallback, CallType.NORMAL, null, false);
            } else {
                context.getInvocationCompiler().invokeDynamic(callNode.getName(), receiverCallback, null, CallType.NORMAL, null, false);
            }
        } else {
            ClosureCallback closureArg = ASTCompiler.getBlock(callNode.getIterNode());
            if (callNode.getArgsNode() != null) {
                context.getInvocationCompiler().invokeDynamic(callNode.getName(), receiverCallback, argsCallback, CallType.NORMAL, closureArg, false);
            } else {
                context.getInvocationCompiler().invokeDynamic(callNode.getName(), receiverCallback, null, CallType.NORMAL, closureArg, false);
            }
        }
    }

    public static void compileCase(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        CaseNode caseNode = (CaseNode)node;
        boolean hasCase = false;
        if (caseNode.getCaseNode() != null) {
            ASTCompiler.compile(caseNode.getCaseNode(), context);
            hasCase = true;
        }
        context.pollThreadEvents();
        Node firstWhenNode = caseNode.getFirstWhenNode();
        ASTCompiler.compileWhen(firstWhenNode, context, hasCase);
    }

    public static void compileWhen(Node node, MethodCompiler context, final boolean hasCase) {
        if (node == null) {
            if (hasCase) {
                context.consumeCurrentValue();
            }
            context.loadNil();
            return;
        }
        if (!(node instanceof WhenNode)) {
            if (hasCase) {
                context.consumeCurrentValue();
            }
            ASTCompiler.compile(node, context);
            return;
        }
        WhenNode whenNode = (WhenNode)node;
        if (whenNode.getExpressionNodes() instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)whenNode.getExpressionNodes();
            ASTCompiler.compileMultiArgWhen(whenNode, arrayNode, 0, context, hasCase);
        } else {
            if (hasCase) {
                context.duplicateCurrentValue();
            }
            ASTCompiler.compile(whenNode.getExpressionNodes(), context);
            final WhenNode currentWhen = whenNode;
            if (hasCase) {
                context.swapValues();
                context.createObjectArray(1);
                context.getInvocationCompiler().invokeEqq();
            }
            BranchCallback trueBranch = new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    if (hasCase) {
                        context.consumeCurrentValue();
                    }
                    if (currentWhen.getBodyNode() != null) {
                        ASTCompiler.compile(currentWhen.getBodyNode(), context);
                    } else {
                        context.loadNil();
                    }
                }
            };
            BranchCallback falseBranch = new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    ASTCompiler.compileWhen(currentWhen.getNextCase(), context, hasCase);
                }
            };
            context.performBooleanBranch(trueBranch, falseBranch);
        }
    }

    public static void compileMultiArgWhen(final WhenNode whenNode, final ArrayNode expressionsNode, final int conditionIndex, MethodCompiler context, final boolean hasCase) {
        if (conditionIndex >= expressionsNode.size()) {
            ASTCompiler.compileWhen(whenNode.getNextCase(), context, hasCase);
            return;
        }
        Node tag = expressionsNode.get(conditionIndex);
        context.setPosition(tag.getPosition());
        if (tag instanceof WhenNode) {
            if (hasCase) {
                context.duplicateCurrentValue();
            } else {
                context.loadNull();
            }
            ASTCompiler.compile(((WhenNode)tag).getExpressionNodes(), context);
            context.checkWhenWithSplat();
        } else {
            if (hasCase) {
                context.duplicateCurrentValue();
            }
            ASTCompiler.compile(tag, context);
            if (hasCase) {
                context.swapValues();
                context.createObjectArray(1);
                context.getInvocationCompiler().invokeEqq();
            }
        }
        BranchCallback trueBranch = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                if (hasCase) {
                    context.consumeCurrentValue();
                }
                if (whenNode.getBodyNode() != null) {
                    ASTCompiler.compile(whenNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        BranchCallback falseBranch = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                ASTCompiler.compileMultiArgWhen(whenNode, expressionsNode, conditionIndex + 1, context, hasCase);
            }
        };
        context.performBooleanBranch(trueBranch, falseBranch);
    }

    public static void compileClass(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final ClassNode classNode = (ClassNode)node;
        final Node superNode = classNode.getSuperNode();
        final Colon3Node cpathNode = classNode.getCPath();
        ClosureCallback superCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                ASTCompiler.compile(superNode, context);
            }
        };
        if (superNode == null) {
            superCallback = null;
        }
        ClosureCallback bodyCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                if (classNode.getBodyNode() != null) {
                    ASTCompiler.compile(classNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        ClosureCallback pathCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                if (cpathNode instanceof Colon2Node) {
                    Node leftNode = ((Colon2Node)cpathNode).getLeftNode();
                    if (leftNode != null) {
                        ASTCompiler.compile(leftNode, context);
                    } else {
                        context.loadNil();
                    }
                } else if (cpathNode instanceof Colon3Node) {
                    context.loadObject();
                } else {
                    context.loadNil();
                }
            }
        };
        context.defineClass(classNode.getCPath().getName(), classNode.getScope(), superCallback, pathCallback, bodyCallback, null);
    }

    public static void compileSClass(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final SClassNode sclassNode = (SClassNode)node;
        ClosureCallback receiverCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                ASTCompiler.compile(sclassNode.getReceiverNode(), context);
            }
        };
        ClosureCallback bodyCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                if (sclassNode.getBodyNode() != null) {
                    ASTCompiler.compile(sclassNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        context.defineClass("SCLASS", sclassNode.getScope(), null, null, bodyCallback, receiverCallback);
    }

    public static void compileClassVar(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        ClassVarNode classVarNode = (ClassVarNode)node;
        context.retrieveClassVariable(classVarNode.getName());
    }

    public static void compileClassVarAsgn(Node node, MethodCompiler context) {
        ClassVarAsgnNode classVarAsgnNode = (ClassVarAsgnNode)node;
        ASTCompiler.compile(classVarAsgnNode.getValueNode(), context);
        ASTCompiler.compileClassVarAsgnAssignment(node, context);
    }

    public static void compileClassVarAsgnAssignment(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        ClassVarAsgnNode classVarAsgnNode = (ClassVarAsgnNode)node;
        context.assignClassVariable(classVarAsgnNode.getName());
    }

    public static void compileClassVarDecl(Node node, MethodCompiler context) {
        ClassVarDeclNode classVarDeclNode = (ClassVarDeclNode)node;
        ASTCompiler.compile(classVarDeclNode.getValueNode(), context);
        ASTCompiler.compileClassVarDeclAssignment(node, context);
    }

    public static void compileClassVarDeclAssignment(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        ClassVarDeclNode classVarDeclNode = (ClassVarDeclNode)node;
        context.declareClassVariable(classVarDeclNode.getName());
    }

    public static void compileConstDecl(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        ConstDeclNode constDeclNode = (ConstDeclNode)node;
        Node constNode = constDeclNode.getConstNode();
        if (constDeclNode.getConstNode() == null) {
            ASTCompiler.compile(constDeclNode.getValueNode(), context);
            context.assignConstantInCurrent(constDeclNode.getName());
        } else if (constNode.nodeId == NodeType.COLON2NODE) {
            ASTCompiler.compile(((Colon2Node)constNode).getLeftNode(), context);
            ASTCompiler.compile(constDeclNode.getValueNode(), context);
            context.assignConstantInModule(constDeclNode.getName());
        } else {
            ASTCompiler.compile(constDeclNode.getValueNode(), context);
            context.assignConstantInObject(constDeclNode.getName());
        }
    }

    public static void compileConstDeclAssignment(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        ConstDeclNode constDeclNode = (ConstDeclNode)node;
        if (constDeclNode.getConstNode() == null) {
            context.assignConstantInCurrent(constDeclNode.getName());
        } else if (constDeclNode.nodeId == NodeType.COLON2NODE) {
            context.assignConstantInModule(constDeclNode.getName());
        } else {
            context.assignConstantInObject(constDeclNode.getName());
        }
    }

    public static void compileConst(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        ConstNode constNode = (ConstNode)node;
        context.retrieveConstant(constNode.getName());
    }

    public static void compileColon2(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final Colon2Node iVisited = (Colon2Node)node;
        Node leftNode = iVisited.getLeftNode();
        final String name = iVisited.getName();
        if (leftNode == null) {
            context.loadObject();
            context.retrieveConstantFromModule(name);
        } else {
            final ClosureCallback receiverCallback = new ClosureCallback(){

                @Override
                public void compile(MethodCompiler context) {
                    ASTCompiler.compile(iVisited.getLeftNode(), context);
                }
            };
            BranchCallback moduleCallback = new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    receiverCallback.compile(context);
                    context.retrieveConstantFromModule(name);
                }
            };
            BranchCallback notModuleCallback = new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    context.getInvocationCompiler().invokeDynamic(name, receiverCallback, null, CallType.FUNCTIONAL, null, false);
                }
            };
            context.branchIfModule(receiverCallback, moduleCallback, notModuleCallback);
        }
    }

    public static void compileColon3(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        Colon3Node iVisited = (Colon3Node)node;
        String name = iVisited.getName();
        context.loadObject();
        context.retrieveConstantFromModule(name);
    }

    public static void compileGetDefinitionBase(final Node node, MethodCompiler context) {
        BranchCallback reg = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                context.inDefined();
                ASTCompiler.compileGetDefinition(node, context);
            }
        };
        BranchCallback out = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                context.outDefined();
            }
        };
        context.protect(reg, out, String.class);
    }

    public static void compileDefined(Node node, MethodCompiler context) {
        ASTCompiler.compileGetDefinitionBase(((DefinedNode)node).getExpressionNode(), context);
        context.stringOrNil();
    }

    public static void compileGetArgumentDefinition(Node node, MethodCompiler context, String type) {
        if (node == null) {
            context.pushString(type);
        } else if (node instanceof ArrayNode) {
            Object endToken = context.getNewEnding();
            for (int i = 0; i < ((ArrayNode)node).size(); ++i) {
                Node iterNode = ((ArrayNode)node).get(i);
                ASTCompiler.compileGetDefinition(iterNode, context);
                context.ifNull(endToken);
            }
            context.pushString(type);
            Object realToken = context.getNewEnding();
            context.go(realToken);
            context.setEnding(endToken);
            context.pushNull();
            context.setEnding(realToken);
        } else {
            ASTCompiler.compileGetDefinition(node, context);
            Object endToken = context.getNewEnding();
            context.ifNull(endToken);
            context.pushString(type);
            Object realToken = context.getNewEnding();
            context.go(realToken);
            context.setEnding(endToken);
            context.pushNull();
            context.setEnding(realToken);
        }
    }

    public static void compileGetDefinition(final Node node, MethodCompiler context) {
        switch (node.nodeId) {
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case GLOBALASGNNODE: 
            case LOCALASGNNODE: 
            case MULTIPLEASGNNODE: 
            case OPASGNNODE: 
            case OPELEMENTASGNNODE: {
                context.pushString("assignment");
                break;
            }
            case BACKREFNODE: {
                context.backref();
                context.isInstanceOf(RubyMatchData.class, new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushString("$" + ((BackRefNode)node).getType());
                    }
                }, new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case DVARNODE: {
                context.pushString("local-variable(in-block)");
                break;
            }
            case FALSENODE: {
                context.pushString("false");
                break;
            }
            case TRUENODE: {
                context.pushString("true");
                break;
            }
            case LOCALVARNODE: {
                context.pushString("local-variable");
                break;
            }
            case MATCH2NODE: 
            case MATCH3NODE: {
                context.pushString("method");
                break;
            }
            case NILNODE: {
                context.pushString("nil");
                break;
            }
            case NTHREFNODE: {
                context.isCaptured(((NthRefNode)node).getMatchNumber(), new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushString("$" + ((NthRefNode)node).getMatchNumber());
                    }
                }, new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case SELFNODE: {
                context.pushString("self");
                break;
            }
            case VCALLNODE: {
                context.loadSelf();
                context.isMethodBound(((VCallNode)node).getName(), new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushString("method");
                    }
                }, new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case YIELDNODE: {
                context.hasBlock(new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushString("yield");
                    }
                }, new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case GLOBALVARNODE: {
                context.isGlobalDefined(((GlobalVarNode)node).getName(), new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushString("global-variable");
                    }
                }, new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case INSTVARNODE: {
                context.isInstanceVariableDefined(((InstVarNode)node).getName(), new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushString("instance-variable");
                    }
                }, new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case CONSTNODE: {
                context.isConstantDefined(((ConstNode)node).getName(), new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushString("constant");
                    }
                }, new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case FCALLNODE: {
                context.loadSelf();
                context.isMethodBound(((FCallNode)node).getName(), new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        ASTCompiler.compileGetArgumentDefinition(((FCallNode)node).getArgsNode(), context, "method");
                    }
                }, new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case COLON2NODE: 
            case COLON3NODE: {
                final Colon3Node iVisited = (Colon3Node)node;
                String name = iVisited.getName();
                BranchCallback setup = new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        if (iVisited instanceof Colon2Node) {
                            Node leftNode = ((Colon2Node)iVisited).getLeftNode();
                            ASTCompiler.compile(leftNode, context);
                        } else {
                            context.loadObject();
                        }
                    }
                };
                BranchCallback isConstant = new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushString("constant");
                    }
                };
                BranchCallback isMethod = new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushString("method");
                    }
                };
                BranchCallback none = new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                };
                context.isConstantBranch(setup, isConstant, isMethod, none, name);
                break;
            }
            case CALLNODE: {
                final CallNode iVisited = (CallNode)node;
                Object isnull = context.getNewEnding();
                Object ending = context.getNewEnding();
                ASTCompiler.compileGetDefinition(iVisited.getReceiverNode(), context);
                context.ifNull(isnull);
                context.rescue(new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        ASTCompiler.compile(iVisited.getReceiverNode(), context);
                        context.duplicateCurrentValue();
                        context.metaclass();
                        context.duplicateCurrentValue();
                        context.getVisibilityFor(iVisited.getName());
                        context.duplicateCurrentValue();
                        final Object isfalse = context.getNewEnding();
                        Object isreal = context.getNewEnding();
                        Object ending = context.getNewEnding();
                        context.isPrivate(isfalse, 3);
                        context.isNotProtected(isreal, 1);
                        context.selfIsKindOf(isreal);
                        context.consumeCurrentValue();
                        context.go(isfalse);
                        context.setEnding(isreal);
                        context.isMethodBound(iVisited.getName(), new BranchCallback(){

                            @Override
                            public void branch(MethodCompiler context) {
                                ASTCompiler.compileGetArgumentDefinition(iVisited.getArgsNode(), context, "method");
                            }
                        }, new BranchCallback(){

                            @Override
                            public void branch(MethodCompiler context) {
                                context.go(isfalse);
                            }
                        });
                        context.go(ending);
                        context.setEnding(isfalse);
                        context.pushNull();
                        context.setEnding(ending);
                    }
                }, JumpException.class, new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                }, String.class);
                context.go(ending);
                context.setEnding(isnull);
                context.pushNull();
                context.setEnding(ending);
                break;
            }
            case CLASSVARNODE: {
                ClassVarNode iVisited = (ClassVarNode)node;
                final Object ending = context.getNewEnding();
                Object failure = context.getNewEnding();
                Object singleton = context.getNewEnding();
                Object second = context.getNewEnding();
                Object third = context.getNewEnding();
                context.loadCurrentModule();
                context.duplicateCurrentValue();
                context.ifNotNull(second);
                context.consumeCurrentValue();
                context.loadSelf();
                context.metaclass();
                context.duplicateCurrentValue();
                context.isClassVarDefined(iVisited.getName(), new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.consumeCurrentValue();
                        context.pushString("class variable");
                        context.go(ending);
                    }
                }, new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                    }
                });
                context.setEnding(second);
                context.duplicateCurrentValue();
                context.isClassVarDefined(iVisited.getName(), new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.consumeCurrentValue();
                        context.pushString("class variable");
                        context.go(ending);
                    }
                }, new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                    }
                });
                context.setEnding(third);
                context.duplicateCurrentValue();
                context.ifSingleton(singleton);
                context.consumeCurrentValue();
                context.go(failure);
                context.setEnding(singleton);
                context.attached();
                context.notIsModuleAndClassVarDefined(iVisited.getName(), failure);
                context.pushString("class variable");
                context.go(ending);
                context.setEnding(failure);
                context.pushNull();
                context.setEnding(ending);
                break;
            }
            case ZSUPERNODE: {
                Object fail = context.getNewEnding();
                Object fail2 = context.getNewEnding();
                Object fail_easy = context.getNewEnding();
                Object ending = context.getNewEnding();
                context.getFrameName();
                context.duplicateCurrentValue();
                context.ifNull(fail);
                context.getFrameKlazz();
                context.duplicateCurrentValue();
                context.ifNull(fail2);
                context.superClass();
                context.ifNotSuperMethodBound(fail_easy);
                context.pushString("super");
                context.go(ending);
                context.setEnding(fail2);
                context.consumeCurrentValue();
                context.setEnding(fail);
                context.consumeCurrentValue();
                context.setEnding(fail_easy);
                context.pushNull();
                context.setEnding(ending);
                break;
            }
            case SUPERNODE: {
                Object fail = context.getNewEnding();
                Object fail2 = context.getNewEnding();
                Object fail_easy = context.getNewEnding();
                Object ending = context.getNewEnding();
                context.getFrameName();
                context.duplicateCurrentValue();
                context.ifNull(fail);
                context.getFrameKlazz();
                context.duplicateCurrentValue();
                context.ifNull(fail2);
                context.superClass();
                context.ifNotSuperMethodBound(fail_easy);
                ASTCompiler.compileGetArgumentDefinition(((SuperNode)node).getArgsNode(), context, "super");
                context.go(ending);
                context.setEnding(fail2);
                context.consumeCurrentValue();
                context.setEnding(fail);
                context.consumeCurrentValue();
                context.setEnding(fail_easy);
                context.pushNull();
                context.setEnding(ending);
                break;
            }
            case ATTRASSIGNNODE: {
                final AttrAssignNode iVisited = (AttrAssignNode)node;
                Object isnull = context.getNewEnding();
                Object ending = context.getNewEnding();
                ASTCompiler.compileGetDefinition(iVisited.getReceiverNode(), context);
                context.ifNull(isnull);
                context.rescue(new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        ASTCompiler.compile(iVisited.getReceiverNode(), context);
                        context.duplicateCurrentValue();
                        context.metaclass();
                        context.duplicateCurrentValue();
                        context.getVisibilityFor(iVisited.getName());
                        context.duplicateCurrentValue();
                        final Object isfalse = context.getNewEnding();
                        Object isreal = context.getNewEnding();
                        Object ending = context.getNewEnding();
                        context.isPrivate(isfalse, 3);
                        context.isNotProtected(isreal, 1);
                        context.selfIsKindOf(isreal);
                        context.consumeCurrentValue();
                        context.go(isfalse);
                        context.setEnding(isreal);
                        context.isMethodBound(iVisited.getName(), new BranchCallback(){

                            @Override
                            public void branch(MethodCompiler context) {
                                ASTCompiler.compileGetArgumentDefinition(iVisited.getArgsNode(), context, "assignment");
                            }
                        }, new BranchCallback(){

                            @Override
                            public void branch(MethodCompiler context) {
                                context.go(isfalse);
                            }
                        });
                        context.go(ending);
                        context.setEnding(isfalse);
                        context.pushNull();
                        context.setEnding(ending);
                    }
                }, JumpException.class, new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                }, String.class);
                context.go(ending);
                context.setEnding(isnull);
                context.pushNull();
                context.setEnding(ending);
                break;
            }
            default: {
                context.rescue(new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        ASTCompiler.compile(node, context);
                        context.consumeCurrentValue();
                        context.pushNull();
                    }
                }, JumpException.class, new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                }, String.class);
                context.consumeCurrentValue();
                context.pushString("expression");
            }
        }
    }

    public static void compileDAsgn(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        DAsgnNode dasgnNode = (DAsgnNode)node;
        ASTCompiler.compile(dasgnNode.getValueNode(), context);
        ASTCompiler.compileDAsgnAssignment(dasgnNode, context);
    }

    public static void compileDAsgnAssignment(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        DAsgnNode dasgnNode = (DAsgnNode)node;
        context.getVariableCompiler().assignLocalVariable(dasgnNode.getIndex(), dasgnNode.getDepth());
    }

    public static void compileDefn(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final DefnNode defnNode = (DefnNode)node;
        final ArgsNode argsNode = defnNode.getArgsNode();
        ClosureCallback body = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                if (defnNode.getBodyNode() != null) {
                    ASTCompiler.compile(defnNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        ClosureCallback args = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                ASTCompiler.compileArgs(argsNode, context);
            }
        };
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(defnNode.getArgsNode());
        inspector.inspect(defnNode.getBodyNode());
        context.defineNewMethod(defnNode.getName(), defnNode.getScope(), body, args, null, inspector);
    }

    public static void compileDefs(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final DefsNode defsNode = (DefsNode)node;
        final ArgsNode argsNode = defsNode.getArgsNode();
        ClosureCallback receiver = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                ASTCompiler.compile(defsNode.getReceiverNode(), context);
            }
        };
        ClosureCallback body = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                if (defsNode.getBodyNode() != null) {
                    ASTCompiler.compile(defsNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        ClosureCallback args = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                ASTCompiler.compileArgs(argsNode, context);
            }
        };
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(defsNode.getArgsNode());
        inspector.inspect(defsNode.getBodyNode());
        context.defineNewMethod(defsNode.getName(), defsNode.getScope(), body, args, receiver, inspector);
    }

    public static void compileArgs(Node node, MethodCompiler context) {
        final ArgsNode argsNode = (ArgsNode)node;
        int required = argsNode.getRequiredArgsCount();
        int opt = argsNode.getOptionalArgsCount();
        int rest = argsNode.getRestArg();
        ArrayCallback requiredAssignment = null;
        ArrayCallback optionalGiven = null;
        ArrayCallback optionalNotGiven = null;
        ClosureCallback restAssignment = null;
        ClosureCallback blockAssignment = null;
        if (required > 0) {
            requiredAssignment = new ArrayCallback(){

                @Override
                public void nextValue(MethodCompiler context, Object object, int index) {
                    context.getVariableCompiler().assignLocalVariable(index);
                }
            };
        }
        if (opt > 0) {
            optionalGiven = new ArrayCallback(){

                @Override
                public void nextValue(MethodCompiler context, Object object, int index) {
                    Node optArg = ((ListNode)object).get(index);
                    ASTCompiler.compileAssignment(optArg, context);
                }
            };
            optionalNotGiven = new ArrayCallback(){

                @Override
                public void nextValue(MethodCompiler context, Object object, int index) {
                    Node optArg = ((ListNode)object).get(index);
                    ASTCompiler.compile(optArg, context);
                }
            };
        }
        if (rest > -1) {
            restAssignment = new ClosureCallback(){

                @Override
                public void compile(MethodCompiler context) {
                    context.getVariableCompiler().assignLocalVariable(argsNode.getRestArg());
                }
            };
        }
        if (argsNode.getBlockArgNode() != null) {
            blockAssignment = new ClosureCallback(){

                @Override
                public void compile(MethodCompiler context) {
                    context.getVariableCompiler().assignLocalVariable(argsNode.getBlockArgNode().getCount());
                }
            };
        }
        context.lineNumber(argsNode.getPosition());
        context.getVariableCompiler().checkMethodArity(required, opt, rest);
        context.getVariableCompiler().assignMethodArguments(argsNode.getArgs(), argsNode.getRequiredArgsCount(), argsNode.getOptArgs(), argsNode.getOptionalArgsCount(), requiredAssignment, optionalGiven, optionalNotGiven, restAssignment, blockAssignment);
    }

    public static void compileDot(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        DotNode dotNode = (DotNode)node;
        ASTCompiler.compile(dotNode.getBeginNode(), context);
        ASTCompiler.compile(dotNode.getEndNode(), context);
        context.createNewRange(dotNode.isExclusive());
    }

    public static void compileDRegexp(Node node, MethodCompiler context) {
        String lang;
        context.lineNumber(node.getPosition());
        final DRegexpNode dregexpNode = (DRegexpNode)node;
        ClosureCallback createStringCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                ArrayCallback dstrCallback = new ArrayCallback(){

                    @Override
                    public void nextValue(MethodCompiler context, Object sourceArray, int index) {
                        ASTCompiler.compile(dregexpNode.get(index), context);
                    }
                };
                context.createNewString(dstrCallback, dregexpNode.size());
                context.toJavaString();
            }
        };
        int opts = dregexpNode.getOptions();
        String string = lang = (opts & 0x10) != 0 ? "n" : null;
        if ((opts & 0x30) == 48) {
            lang = "s";
        } else if ((opts & 0x20) == 32) {
            lang = "e";
        } else if ((opts & 0x40) != 0) {
            lang = "u";
        }
        context.createNewRegexp(createStringCallback, opts, lang);
    }

    public static void compileDStr(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final DStrNode dstrNode = (DStrNode)node;
        ArrayCallback dstrCallback = new ArrayCallback(){

            @Override
            public void nextValue(MethodCompiler context, Object sourceArray, int index) {
                ASTCompiler.compile(dstrNode.get(index), context);
            }
        };
        context.createNewString(dstrCallback, dstrNode.size());
    }

    public static void compileDSymbol(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final DSymbolNode dsymbolNode = (DSymbolNode)node;
        ArrayCallback dstrCallback = new ArrayCallback(){

            @Override
            public void nextValue(MethodCompiler context, Object sourceArray, int index) {
                ASTCompiler.compile(dsymbolNode.get(index), context);
            }
        };
        context.createNewSymbol(dstrCallback, dsymbolNode.size());
    }

    public static void compileDVar(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        DVarNode dvarNode = (DVarNode)node;
        context.getVariableCompiler().retrieveLocalVariable(dvarNode.getIndex(), dvarNode.getDepth());
    }

    public static void compileDXStr(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final DXStrNode dxstrNode = (DXStrNode)node;
        final ArrayCallback dstrCallback = new ArrayCallback(){

            @Override
            public void nextValue(MethodCompiler context, Object sourceArray, int index) {
                ASTCompiler.compile(dxstrNode.get(index), context);
            }
        };
        ClosureCallback argsCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                context.createNewString(dstrCallback, dxstrNode.size());
                context.createObjectArray(1);
            }
        };
        context.getInvocationCompiler().invokeDynamic("`", null, argsCallback, CallType.FUNCTIONAL, null, false);
    }

    public static void compileEnsureNode(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final EnsureNode ensureNode = (EnsureNode)node;
        if (ensureNode.getEnsureNode() != null) {
            context.protect(new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    if (ensureNode.getBodyNode() != null) {
                        ASTCompiler.compile(ensureNode.getBodyNode(), context);
                    } else {
                        context.loadNil();
                    }
                }
            }, new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    ASTCompiler.compile(ensureNode.getEnsureNode(), context);
                    context.consumeCurrentValue();
                }
            }, IRubyObject.class);
        } else if (ensureNode.getBodyNode() != null) {
            ASTCompiler.compile(ensureNode.getBodyNode(), context);
        } else {
            context.loadNil();
        }
    }

    public static void compileEvStr(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        EvStrNode evStrNode = (EvStrNode)node;
        ASTCompiler.compile(evStrNode.getBody(), context);
        context.asString();
    }

    public static void compileFalse(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        context.loadFalse();
        context.pollThreadEvents();
    }

    public static void compileFCall(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final FCallNode fcallNode = (FCallNode)node;
        ClosureCallback argsCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                ASTCompiler.compileArguments(fcallNode.getArgsNode(), context);
            }
        };
        if (fcallNode.getIterNode() == null) {
            if (fcallNode.getArgsNode() != null) {
                context.getInvocationCompiler().invokeDynamic(fcallNode.getName(), null, argsCallback, CallType.FUNCTIONAL, null, false);
            } else {
                context.getInvocationCompiler().invokeDynamic(fcallNode.getName(), null, null, CallType.FUNCTIONAL, null, false);
            }
        } else {
            ClosureCallback closureArg = ASTCompiler.getBlock(fcallNode.getIterNode());
            if (fcallNode.getArgsNode() != null) {
                context.getInvocationCompiler().invokeDynamic(fcallNode.getName(), null, argsCallback, CallType.FUNCTIONAL, closureArg, false);
            } else {
                context.getInvocationCompiler().invokeDynamic(fcallNode.getName(), null, null, CallType.FUNCTIONAL, closureArg, false);
            }
        }
    }

    private static ClosureCallback getBlock(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.nodeId) {
            case ITERNODE: {
                final IterNode iterNode = (IterNode)node;
                return new ClosureCallback(){

                    @Override
                    public void compile(MethodCompiler context) {
                        ASTCompiler.compile(iterNode, context);
                    }
                };
            }
            case BLOCKPASSNODE: {
                final BlockPassNode blockPassNode = (BlockPassNode)node;
                return new ClosureCallback(){

                    @Override
                    public void compile(MethodCompiler context) {
                        ASTCompiler.compile(blockPassNode.getBodyNode(), context);
                        context.unwrapPassedBlock();
                    }
                };
            }
        }
        throw new NotCompilableException("ERROR: Encountered a method with a non-block, non-blockpass iter node at: " + node);
    }

    public static void compileFixnum(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        FixnumNode fixnumNode = (FixnumNode)node;
        context.createNewFixnum(fixnumNode.getValue());
    }

    public static void compileFlip(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final FlipNode flipNode = (FlipNode)node;
        context.getVariableCompiler().retrieveLocalVariable(flipNode.getIndex(), flipNode.getDepth());
        if (flipNode.isExclusive()) {
            context.performBooleanBranch(new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    ASTCompiler.compile(flipNode.getEndNode(), context);
                    context.performBooleanBranch(new BranchCallback(){

                        @Override
                        public void branch(MethodCompiler context) {
                            context.loadFalse();
                            context.getVariableCompiler().assignLocalVariable(flipNode.getIndex(), flipNode.getDepth());
                            context.consumeCurrentValue();
                        }
                    }, new BranchCallback(){

                        @Override
                        public void branch(MethodCompiler context) {
                        }
                    });
                    context.loadTrue();
                }
            }, new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    ASTCompiler.compile(flipNode.getBeginNode(), context);
                    ASTCompiler.becomeTrueOrFalse(context);
                    context.getVariableCompiler().assignLocalVariable(flipNode.getIndex(), flipNode.getDepth());
                }
            });
        } else {
            context.performBooleanBranch(new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    ASTCompiler.compile(flipNode.getEndNode(), context);
                    context.performBooleanBranch(new BranchCallback(){

                        @Override
                        public void branch(MethodCompiler context) {
                            context.loadFalse();
                            context.getVariableCompiler().assignLocalVariable(flipNode.getIndex(), flipNode.getDepth());
                            context.consumeCurrentValue();
                        }
                    }, new BranchCallback(){

                        @Override
                        public void branch(MethodCompiler context) {
                        }
                    });
                    context.loadTrue();
                }
            }, new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    ASTCompiler.compile(flipNode.getBeginNode(), context);
                    context.performBooleanBranch(new BranchCallback(){

                        @Override
                        public void branch(MethodCompiler context) {
                            ASTCompiler.compile(flipNode.getEndNode(), context);
                            ASTCompiler.flipTrueOrFalse(context);
                            context.getVariableCompiler().assignLocalVariable(flipNode.getIndex(), flipNode.getDepth());
                            context.consumeCurrentValue();
                            context.loadTrue();
                        }
                    }, new BranchCallback(){

                        @Override
                        public void branch(MethodCompiler context) {
                            context.loadFalse();
                        }
                    });
                }
            });
        }
    }

    private static void becomeTrueOrFalse(MethodCompiler context) {
        context.performBooleanBranch(new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                context.loadTrue();
            }
        }, new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                context.loadFalse();
            }
        });
    }

    private static void flipTrueOrFalse(MethodCompiler context) {
        context.performBooleanBranch(new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                context.loadFalse();
            }
        }, new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                context.loadTrue();
            }
        });
    }

    public static void compileFloat(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        FloatNode floatNode = (FloatNode)node;
        context.createNewFloat(floatNode.getValue());
    }

    public static void compileFor(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final ForNode forNode = (ForNode)node;
        ClosureCallback receiverCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                ASTCompiler.compile(forNode.getIterNode(), context);
            }
        };
        ClosureCallback closureArg = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                ASTCompiler.compileForIter(forNode, context);
            }
        };
        context.getInvocationCompiler().invokeDynamic("each", receiverCallback, null, CallType.NORMAL, closureArg, false);
    }

    public static void compileForIter(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final ForNode forNode = (ForNode)node;
        ClosureCallback closureBody = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                if (forNode.getBodyNode() != null) {
                    ASTCompiler.compile(forNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        ClosureCallback closureArgs = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                if (forNode.getVarNode() != null) {
                    ASTCompiler.compileAssignment(forNode.getVarNode(), context);
                }
            }
        };
        boolean hasMultipleArgsHead = false;
        if (forNode.getVarNode() instanceof MultipleAsgnNode) {
            hasMultipleArgsHead = ((MultipleAsgnNode)forNode.getVarNode()).getHeadNode() != null;
        }
        NodeType argsNodeId = null;
        if (forNode.getVarNode() != null) {
            argsNodeId = forNode.getVarNode().nodeId;
        }
        if (argsNodeId == null) {
            context.createNewForLoop(Arity.procArityOf(forNode.getVarNode()).getValue(), closureBody, null, hasMultipleArgsHead, argsNodeId);
        } else {
            context.createNewForLoop(Arity.procArityOf(forNode.getVarNode()).getValue(), closureBody, closureArgs, hasMultipleArgsHead, argsNodeId);
        }
    }

    public static void compileGlobalAsgn(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        GlobalAsgnNode globalAsgnNode = (GlobalAsgnNode)node;
        ASTCompiler.compile(globalAsgnNode.getValueNode(), context);
        if (globalAsgnNode.getName().length() == 2) {
            switch (globalAsgnNode.getName().charAt(1)) {
                case '_': {
                    context.getVariableCompiler().assignLastLine();
                    return;
                }
                case '~': {
                    assert (false) : "Parser shouldn't allow assigning to $~";
                    return;
                }
            }
        }
        context.assignGlobalVariable(globalAsgnNode.getName());
    }

    public static void compileGlobalAsgnAssignment(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        GlobalAsgnNode globalAsgnNode = (GlobalAsgnNode)node;
        if (globalAsgnNode.getName().length() == 2) {
            switch (globalAsgnNode.getName().charAt(1)) {
                case '_': {
                    context.getVariableCompiler().assignLastLine();
                    return;
                }
                case '~': {
                    assert (false) : "Parser shouldn't allow assigning to $~";
                    return;
                }
            }
        }
        context.assignGlobalVariable(globalAsgnNode.getName());
    }

    public static void compileGlobalVar(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        GlobalVarNode globalVarNode = (GlobalVarNode)node;
        if (globalVarNode.getName().length() == 2) {
            switch (globalVarNode.getName().charAt(1)) {
                case '_': {
                    context.getVariableCompiler().retrieveLastLine();
                    return;
                }
                case '~': {
                    context.getVariableCompiler().retrieveBackRef();
                    return;
                }
            }
        }
        context.retrieveGlobalVariable(globalVarNode.getName());
    }

    public static void compileHash(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        HashNode hashNode = (HashNode)node;
        if (hashNode.getListNode() == null || hashNode.getListNode().size() == 0) {
            context.createEmptyHash();
            return;
        }
        ArrayCallback hashCallback = new ArrayCallback(){

            @Override
            public void nextValue(MethodCompiler context, Object sourceArray, int index) {
                ListNode listNode = (ListNode)sourceArray;
                int keyIndex = index * 2;
                ASTCompiler.compile(listNode.get(keyIndex), context);
                ASTCompiler.compile(listNode.get(keyIndex + 1), context);
            }
        };
        context.createNewHash(hashNode.getListNode(), hashCallback, hashNode.getListNode().size() / 2);
    }

    public static void compileIf(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final IfNode ifNode = (IfNode)node;
        ASTCompiler.compile(ifNode.getCondition(), context);
        BranchCallback trueCallback = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                if (ifNode.getThenBody() != null) {
                    ASTCompiler.compile(ifNode.getThenBody(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        BranchCallback falseCallback = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                if (ifNode.getElseBody() != null) {
                    ASTCompiler.compile(ifNode.getElseBody(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        context.performBooleanBranch(trueCallback, falseCallback);
    }

    public static void compileInstAsgn(Node node, MethodCompiler context) {
        InstAsgnNode instAsgnNode = (InstAsgnNode)node;
        ASTCompiler.compile(instAsgnNode.getValueNode(), context);
        ASTCompiler.compileInstAsgnAssignment(node, context);
    }

    public static void compileInstAsgnAssignment(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        InstAsgnNode instAsgnNode = (InstAsgnNode)node;
        context.assignInstanceVariable(instAsgnNode.getName());
    }

    public static void compileInstVar(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        InstVarNode instVarNode = (InstVarNode)node;
        context.retrieveInstanceVariable(instVarNode.getName());
    }

    public static void compileIter(Node node, MethodCompiler context) {
        MultipleAsgnNode multipleAsgnNode;
        context.lineNumber(node.getPosition());
        final IterNode iterNode = (IterNode)node;
        ClosureCallback closureBody = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                if (iterNode.getBodyNode() != null) {
                    ASTCompiler.compile(iterNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        ClosureCallback closureArgs = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                if (iterNode.getVarNode() != null) {
                    ASTCompiler.compileAssignment(iterNode.getVarNode(), context);
                }
            }
        };
        boolean hasMultipleArgsHead = false;
        if (iterNode.getVarNode() instanceof MultipleAsgnNode) {
            hasMultipleArgsHead = ((MultipleAsgnNode)iterNode.getVarNode()).getHeadNode() != null;
        }
        NodeType argsNodeId = null;
        if (iterNode.getVarNode() != null && iterNode.getVarNode().nodeId != NodeType.ZEROARGNODE && (argsNodeId = iterNode.getVarNode().nodeId) == NodeType.MULTIPLEASGNNODE && (multipleAsgnNode = (MultipleAsgnNode)iterNode.getVarNode()).getHeadNode() == null && multipleAsgnNode.getArgsNode() != null) {
            argsNodeId = NodeType.SVALUENODE;
        }
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(iterNode.getBodyNode());
        inspector.inspect(iterNode.getVarNode());
        if (argsNodeId == null) {
            context.createNewClosure(iterNode.getScope(), Arity.procArityOf(iterNode.getVarNode()).getValue(), closureBody, null, hasMultipleArgsHead, argsNodeId, inspector);
        } else {
            context.createNewClosure(iterNode.getScope(), Arity.procArityOf(iterNode.getVarNode()).getValue(), closureBody, closureArgs, hasMultipleArgsHead, argsNodeId, inspector);
        }
    }

    public static void compileLocalAsgn(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
        ASTCompiler.compile(localAsgnNode.getValueNode(), context);
        context.getVariableCompiler().assignLocalVariable(localAsgnNode.getIndex(), localAsgnNode.getDepth());
    }

    public static void compileLocalAsgnAssignment(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
        context.getVariableCompiler().assignLocalVariable(localAsgnNode.getIndex(), localAsgnNode.getDepth());
    }

    public static void compileLocalVar(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        LocalVarNode localVarNode = (LocalVarNode)node;
        context.getVariableCompiler().retrieveLocalVariable(localVarNode.getIndex(), localVarNode.getDepth());
    }

    public static void compileMatch(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        MatchNode matchNode = (MatchNode)node;
        ASTCompiler.compile(matchNode.getRegexpNode(), context);
        context.match();
    }

    public static void compileMatch2(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        Match2Node matchNode = (Match2Node)node;
        ASTCompiler.compile(matchNode.getReceiverNode(), context);
        ASTCompiler.compile(matchNode.getValueNode(), context);
        context.match2();
    }

    public static void compileMatch3(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        Match3Node matchNode = (Match3Node)node;
        ASTCompiler.compile(matchNode.getReceiverNode(), context);
        ASTCompiler.compile(matchNode.getValueNode(), context);
        context.match3();
    }

    public static void compileModule(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final ModuleNode moduleNode = (ModuleNode)node;
        final Colon3Node cpathNode = moduleNode.getCPath();
        ClosureCallback bodyCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                if (moduleNode.getBodyNode() != null) {
                    ASTCompiler.compile(moduleNode.getBodyNode(), context);
                }
                context.loadNil();
            }
        };
        ClosureCallback pathCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                if (cpathNode instanceof Colon2Node) {
                    Node leftNode = ((Colon2Node)cpathNode).getLeftNode();
                    if (leftNode != null) {
                        ASTCompiler.compile(leftNode, context);
                    } else {
                        context.loadNil();
                    }
                } else if (cpathNode instanceof Colon3Node) {
                    context.loadObject();
                } else {
                    context.loadNil();
                }
            }
        };
        context.defineModule(moduleNode.getCPath().getName(), moduleNode.getScope(), pathCallback, bodyCallback);
    }

    public static void compileMultipleAsgn(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)node;
        ASTCompiler.compile(multipleAsgnNode.getValueNode(), context);
        ASTCompiler.compileMultipleAsgnAssignment(node, context);
    }

    public static void compileMultipleAsgnAssignment(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)node;
        context.ensureMultipleAssignableRubyArray(multipleAsgnNode.getHeadNode() != null);
        ArrayCallback headAssignCallback = new ArrayCallback(){

            @Override
            public void nextValue(MethodCompiler context, Object sourceArray, int index) {
                ListNode headNode = (ListNode)sourceArray;
                Node assignNode = headNode.get(index);
                ASTCompiler.compileAssignment(assignNode, context);
            }
        };
        ArrayCallback headNilCallback = new ArrayCallback(){

            @Override
            public void nextValue(MethodCompiler context, Object sourceArray, int index) {
                ListNode headNode = (ListNode)sourceArray;
                Node assignNode = headNode.get(index);
                context.loadNil();
                ASTCompiler.compileAssignment(assignNode, context);
            }
        };
        ClosureCallback argsCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                Node argsNode = multipleAsgnNode.getArgsNode();
                if (!(argsNode instanceof StarNode)) {
                    ASTCompiler.compileAssignment(argsNode, context);
                }
            }
        };
        if (multipleAsgnNode.getHeadNode() == null) {
            if (multipleAsgnNode.getArgsNode() == null) {
                throw new NotCompilableException("Something's wrong, multiple assignment with no head or args at: " + multipleAsgnNode.getPosition());
            }
            context.forEachInValueArray(0, 0, null, null, null, argsCallback);
        } else if (multipleAsgnNode.getArgsNode() == null) {
            context.forEachInValueArray(0, multipleAsgnNode.getHeadNode().size(), multipleAsgnNode.getHeadNode(), headAssignCallback, headNilCallback, null);
        } else {
            context.forEachInValueArray(0, multipleAsgnNode.getHeadNode().size(), multipleAsgnNode.getHeadNode(), headAssignCallback, headNilCallback, argsCallback);
        }
    }

    public static void compileNewline(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        context.setPosition(node.getPosition());
        NewlineNode newlineNode = (NewlineNode)node;
        ASTCompiler.compile(newlineNode.getNextNode(), context);
    }

    public static void compileNext(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final NextNode nextNode = (NextNode)node;
        ClosureCallback valueCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                if (nextNode.getValueNode() != null) {
                    ASTCompiler.compile(nextNode.getValueNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        context.pollThreadEvents();
        context.issueNextEvent(valueCallback);
    }

    public static void compileNthRef(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        NthRefNode nthRefNode = (NthRefNode)node;
        context.nthRef(nthRefNode.getMatchNumber());
    }

    public static void compileNil(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        context.loadNil();
        context.pollThreadEvents();
    }

    public static void compileNot(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        NotNode notNode = (NotNode)node;
        ASTCompiler.compile(notNode.getConditionNode(), context);
        context.negateCurrentValue();
    }

    public static void compileOpAsgnAnd(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final BinaryOperatorNode andNode = (BinaryOperatorNode)((Object)node);
        ASTCompiler.compile(andNode.getFirstNode(), context);
        BranchCallback longCallback = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                ASTCompiler.compile(andNode.getSecondNode(), context);
            }
        };
        context.performLogicalAnd(longCallback);
        context.pollThreadEvents();
    }

    public static void compileOpAsgnOr(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final OpAsgnOrNode orNode = (OpAsgnOrNode)node;
        ASTCompiler.compileGetDefinitionBase(orNode.getFirstNode(), context);
        context.isNull(new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                ASTCompiler.compile(orNode.getSecondNode(), context);
            }
        }, new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                ASTCompiler.compile(orNode.getFirstNode(), context);
                context.duplicateCurrentValue();
                context.performBooleanBranch(new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                    }
                }, new BranchCallback(){

                    @Override
                    public void branch(MethodCompiler context) {
                        context.consumeCurrentValue();
                        ASTCompiler.compile(orNode.getSecondNode(), context);
                    }
                });
            }
        });
        context.pollThreadEvents();
    }

    public static void compileOpAsgn(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final OpAsgnNode opAsgnNode = (OpAsgnNode)node;
        final ClosureCallback receiverCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                ASTCompiler.compile(opAsgnNode.getReceiverNode(), context);
                context.duplicateCurrentValue();
            }
        };
        BranchCallback doneBranch = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                context.swapValues();
                context.consumeCurrentValue();
            }
        };
        final ArrayCallback justEvalValue = new ArrayCallback(){

            @Override
            public void nextValue(MethodCompiler context, Object sourceArray, int index) {
                ASTCompiler.compile(((Node[])sourceArray)[index], context);
            }
        };
        BranchCallback assignBranch = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                context.consumeCurrentValue();
                context.createObjectArray(new Node[]{opAsgnNode.getValueNode()}, justEvalValue);
                context.getInvocationCompiler().invokeAttrAssign(opAsgnNode.getVariableNameAsgn());
            }
        };
        ClosureCallback receiver2Callback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                context.getInvocationCompiler().invokeDynamic(opAsgnNode.getVariableName(), receiverCallback, null, CallType.FUNCTIONAL, null, false);
            }
        };
        if (opAsgnNode.getOperatorName() == "||") {
            receiver2Callback.compile(context);
            context.duplicateCurrentValue();
            context.performBooleanBranch(doneBranch, assignBranch);
        } else if (opAsgnNode.getOperatorName() == "&&") {
            receiver2Callback.compile(context);
            context.duplicateCurrentValue();
            context.performBooleanBranch(assignBranch, doneBranch);
        } else {
            ClosureCallback argsCallback = new ClosureCallback(){

                @Override
                public void compile(MethodCompiler context) {
                    context.createObjectArray(new Node[]{opAsgnNode.getValueNode()}, justEvalValue);
                }
            };
            context.getInvocationCompiler().invokeDynamic(opAsgnNode.getOperatorName(), receiver2Callback, argsCallback, CallType.FUNCTIONAL, null, false);
            context.createObjectArray(1);
            context.getInvocationCompiler().invokeAttrAssign(opAsgnNode.getVariableNameAsgn());
        }
        context.pollThreadEvents();
    }

    public static void compileOpElementAsgn(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        ASTCompiler.compile(opElementAsgnNode.getReceiverNode(), context);
        ASTCompiler.compileArguments(opElementAsgnNode.getArgsNode(), context);
        ClosureCallback valueArgsCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                ASTCompiler.compile(opElementAsgnNode.getValueNode(), context);
            }
        };
        context.getInvocationCompiler().opElementAsgn(valueArgsCallback, opElementAsgnNode.getOperatorName());
    }

    public static void compileOr(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final OrNode orNode = (OrNode)node;
        ASTCompiler.compile(orNode.getFirstNode(), context);
        BranchCallback longCallback = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                ASTCompiler.compile(orNode.getSecondNode(), context);
            }
        };
        context.performLogicalOr(longCallback);
    }

    public static void compilePostExe(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final PostExeNode postExeNode = (PostExeNode)node;
        ClosureCallback closureBody = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                if (postExeNode.getBodyNode() != null) {
                    ASTCompiler.compile(postExeNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        context.createNewEndBlock(closureBody);
    }

    public static void compilePreExe(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final PreExeNode preExeNode = (PreExeNode)node;
        ClosureCallback closureBody = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                if (preExeNode.getBodyNode() != null) {
                    ASTCompiler.compile(preExeNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        context.runBeginBlock(preExeNode.getScope(), closureBody);
    }

    public static void compileRedo(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        context.issueRedoEvent();
    }

    public static void compileRegexp(Node node, MethodCompiler context) {
        String lang;
        context.lineNumber(node.getPosition());
        RegexpNode reNode = (RegexpNode)node;
        int opts = reNode.getOptions();
        String string = lang = (opts & 0x10) == 16 ? "n" : null;
        if ((opts & 0x30) == 48) {
            lang = "s";
        } else if ((opts & 0x20) == 32) {
            lang = "e";
        } else if ((opts & 0x40) != 0) {
            lang = "u";
        }
        context.createNewRegexp(reNode.getValue(), reNode.getOptions(), lang);
    }

    public static void compileRescue(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final RescueNode rescueNode = (RescueNode)node;
        BranchCallback body = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                if (rescueNode.getBodyNode() != null) {
                    ASTCompiler.compile(rescueNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
                if (rescueNode.getElseNode() != null) {
                    context.consumeCurrentValue();
                    ASTCompiler.compile(rescueNode.getElseNode(), context);
                }
            }
        };
        BranchCallback handler = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                context.loadException();
                context.unwrapRaiseException();
                context.duplicateCurrentValue();
                context.assignGlobalVariable("$!");
                context.consumeCurrentValue();
                context.rethrowIfSystemExit();
                ASTCompiler.compileRescueBody(rescueNode.getRescueNode(), context);
            }
        };
        context.rescue(body, RaiseException.class, handler, IRubyObject.class);
    }

    public static void compileRescueBody(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final RescueBodyNode rescueBodyNode = (RescueBodyNode)node;
        context.loadException();
        context.unwrapRaiseException();
        Node exceptionList = rescueBodyNode.getExceptionNodes();
        if (exceptionList == null) {
            context.loadClass("StandardError");
            context.createObjectArray(1);
        } else {
            ASTCompiler.compileArguments(exceptionList, context);
        }
        context.checkIsExceptionHandled();
        BranchCallback trueBranch = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                if (rescueBodyNode.getBodyNode() != null) {
                    ASTCompiler.compile(rescueBodyNode.getBodyNode(), context);
                    context.loadNil();
                    context.assignGlobalVariable("$!");
                    context.consumeCurrentValue();
                } else {
                    context.loadNil();
                    context.assignGlobalVariable("$!");
                }
            }
        };
        BranchCallback falseBranch = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                if (rescueBodyNode.getOptRescueNode() != null) {
                    ASTCompiler.compileRescueBody(rescueBodyNode.getOptRescueNode(), context);
                } else {
                    context.rethrowException();
                }
            }
        };
        context.performBooleanBranch(trueBranch, falseBranch);
    }

    public static void compileRetry(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        context.pollThreadEvents();
        context.issueRetryEvent();
    }

    public static void compileReturn(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        ReturnNode returnNode = (ReturnNode)node;
        if (returnNode.getValueNode() != null) {
            ASTCompiler.compile(returnNode.getValueNode(), context);
        } else {
            context.loadNil();
        }
        context.performReturn();
    }

    public static void compileRoot(Node node, ScriptCompiler context, ASTInspector inspector) {
        RootNode rootNode = (RootNode)node;
        context.startScript(rootNode.getStaticScope());
        MethodCompiler methodCompiler = context.startMethod("__file__", null, rootNode.getStaticScope(), inspector);
        Node nextNode = rootNode.getBodyNode();
        if (nextNode != null) {
            if (nextNode.nodeId == NodeType.BLOCKNODE) {
                BlockNode blockNode = (BlockNode)nextNode;
                for (int i = 0; i < blockNode.size(); ++i) {
                    if ((i + 1) % 500 == 0) {
                        methodCompiler = methodCompiler.chainToMethod("__file__from_line_" + (i + 1), inspector);
                    }
                    ASTCompiler.compile(blockNode.get(i), methodCompiler);
                    if (i + 1 >= blockNode.size()) continue;
                    methodCompiler.consumeCurrentValue();
                }
            } else {
                ASTCompiler.compile(nextNode, methodCompiler);
            }
        } else {
            methodCompiler.loadNil();
        }
        methodCompiler.endMethod();
        context.endScript();
    }

    public static void compileSelf(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        context.retrieveSelf();
    }

    public static void compileSplat(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        SplatNode splatNode = (SplatNode)node;
        ASTCompiler.compile(splatNode.getValue(), context);
        context.splatCurrentValue();
    }

    public static void compileStr(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        StrNode strNode = (StrNode)node;
        context.createNewString(strNode.getValue());
    }

    public static void compileSuper(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final SuperNode superNode = (SuperNode)node;
        ClosureCallback argsCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                ASTCompiler.compileArguments(superNode.getArgsNode(), context);
            }
        };
        if (superNode.getIterNode() == null) {
            if (superNode.getArgsNode() != null) {
                context.getInvocationCompiler().invokeSuper(argsCallback, null);
            } else {
                context.getInvocationCompiler().invokeSuper(null, null);
            }
        } else {
            ClosureCallback closureArg = ASTCompiler.getBlock(superNode.getIterNode());
            if (superNode.getArgsNode() != null) {
                context.getInvocationCompiler().invokeSuper(argsCallback, closureArg);
            } else {
                context.getInvocationCompiler().invokeSuper(null, closureArg);
            }
        }
    }

    public static void compileSValue(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        SValueNode svalueNode = (SValueNode)node;
        ASTCompiler.compile(svalueNode.getValue(), context);
        context.singlifySplattedValue();
    }

    public static void compileSymbol(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        context.createNewSymbol(((SymbolNode)node).getName());
    }

    public static void compileToAry(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        ToAryNode toAryNode = (ToAryNode)node;
        ASTCompiler.compile(toAryNode.getValue(), context);
        context.aryToAry();
    }

    public static void compileTrue(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        context.loadTrue();
        context.pollThreadEvents();
    }

    public static void compileUndef(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        context.undefMethod(((UndefNode)node).getName());
    }

    public static void compileUntil(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final UntilNode untilNode = (UntilNode)node;
        BranchCallback condition = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                ASTCompiler.compile(untilNode.getConditionNode(), context);
                context.negateCurrentValue();
            }
        };
        BranchCallback body = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                if (untilNode.getBodyNode() == null) {
                    context.loadNil();
                    return;
                }
                ASTCompiler.compile(untilNode.getBodyNode(), context);
            }
        };
        context.performBooleanLoop(condition, body, untilNode.evaluateAtStart());
        context.pollThreadEvents();
    }

    public static void compileVAlias(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        VAliasNode valiasNode = (VAliasNode)node;
        context.aliasGlobal(valiasNode.getNewName(), valiasNode.getOldName());
    }

    public static void compileVCall(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        VCallNode vcallNode = (VCallNode)node;
        context.getInvocationCompiler().invokeDynamic(vcallNode.getName(), null, null, CallType.VARIABLE, null, false);
    }

    public static void compileWhile(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final WhileNode whileNode = (WhileNode)node;
        BranchCallback condition = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                ASTCompiler.compile(whileNode.getConditionNode(), context);
            }
        };
        BranchCallback body = new BranchCallback(){

            @Override
            public void branch(MethodCompiler context) {
                if (whileNode.getBodyNode() == null) {
                    context.loadNil();
                } else {
                    ASTCompiler.compile(whileNode.getBodyNode(), context);
                }
            }
        };
        context.performBooleanLoop(condition, body, whileNode.evaluateAtStart());
        context.pollThreadEvents();
    }

    public static void compileXStr(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        final XStrNode xstrNode = (XStrNode)node;
        ClosureCallback argsCallback = new ClosureCallback(){

            @Override
            public void compile(MethodCompiler context) {
                context.createNewString(xstrNode.getValue());
                context.createObjectArray(1);
            }
        };
        context.getInvocationCompiler().invokeDynamic("`", null, argsCallback, CallType.FUNCTIONAL, null, false);
    }

    public static void compileYield(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        YieldNode yieldNode = (YieldNode)node;
        if (yieldNode.getArgsNode() != null) {
            ASTCompiler.compile(yieldNode.getArgsNode(), context);
        }
        context.getInvocationCompiler().yield(yieldNode.getArgsNode() != null, yieldNode.getCheckState());
    }

    public static void compileZArray(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        context.createEmptyArray();
    }

    public static void compileZSuper(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        ZSuperNode zsuperNode = (ZSuperNode)node;
        ClosureCallback closure = ASTCompiler.getBlock(zsuperNode.getIterNode());
        context.callZSuper(closure);
    }

    public static void compileArgsCatArguments(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        ArgsCatNode argsCatNode = (ArgsCatNode)node;
        ASTCompiler.compileArguments(argsCatNode.getFirstNode(), context);
        context.createNewArray(true);
        ASTCompiler.compile(argsCatNode.getSecondNode(), context);
        context.splatCurrentValue();
        context.concatArrays();
        context.convertToJavaArray();
    }

    public static void compileArgsPushArguments(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        ArgsPushNode argsPushNode = (ArgsPushNode)node;
        ASTCompiler.compile(argsPushNode.getFirstNode(), context);
        ASTCompiler.compile(argsPushNode.getSecondNode(), context);
        context.appendToArray();
        context.convertToJavaArray();
    }

    public static void compileArrayArguments(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        ArrayNode arrayNode = (ArrayNode)node;
        ArrayCallback callback = new ArrayCallback(){

            @Override
            public void nextValue(MethodCompiler context, Object sourceArray, int index) {
                Node node = (Node)((Object[])sourceArray)[index];
                ASTCompiler.compile(node, context);
            }
        };
        context.createObjectArray(arrayNode.childNodes().toArray(), callback);
    }

    public static void compileSplatArguments(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        SplatNode splatNode = (SplatNode)node;
        ASTCompiler.compile(splatNode.getValue(), context);
        context.splatCurrentValue();
        context.convertToJavaArray();
    }

    public static void confirmNodeIsSafe(Node node) {
        switch (node.nodeId) {
            case ARGSNODE: {
                ArgsNode argsNode = (ArgsNode)node;
                if (argsNode.getOptArgs() == null || argsNode.getOptArgs().size() <= 0) break;
                int index = argsNode.getRequiredArgsCount() - 1;
                for (int i = 0; i < argsNode.getOptArgs().size(); ++i) {
                    int newIndex = ((LocalAsgnNode)argsNode.getOptArgs().get(i)).getIndex();
                    if (newIndex - index != 1) {
                        throw new NotCompilableException("Can't compile def with optional args that assign other variables at: " + node.getPosition());
                    }
                    index = newIndex;
                }
                break;
            }
        }
    }
}

