/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.util;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.builtin.IRubyObject;

public final class ArgsUtil {
    public static IRubyObject[] convertToJavaArray(IRubyObject value) {
        if (value == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (value instanceof RubyArray) {
            return ((RubyArray)value).toJavaArrayMaybeUnsafe();
        }
        return new IRubyObject[]{value};
    }

    public static RubyArray convertToRubyArray(Ruby runtime, IRubyObject value, boolean coerce) {
        if (value == null) {
            return RubyArray.newArrayLight(runtime, 0L);
        }
        if (!coerce) {
            return RubyArray.newArrayNoCopyLight(runtime, new IRubyObject[]{value});
        }
        IRubyObject newValue = value.convertToType(runtime.getArray(), MethodIndex.TO_ARY, "to_ary", false);
        if (newValue.isNil()) {
            return RubyArray.newArrayNoCopyLight(runtime, new IRubyObject[]{value});
        }
        return (RubyArray)newValue;
    }

    public static IRubyObject[] popArray(IRubyObject[] array) {
        if (array == null || array.length == 0) {
            return IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] newArray = new IRubyObject[array.length - 1];
        System.arraycopy(array, 1, newArray, 0, array.length - 1);
        return newArray;
    }
}

