/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import jregex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.parser.ReOptions;
import org.jruby.regexp.PatternSyntaxException;
import org.jruby.regexp.RegexpFactory;
import org.jruby.regexp.RegexpMatcher;
import org.jruby.regexp.RegexpPattern;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.Sprintf;

public class RubyRegexp
extends RubyObject
implements ReOptions {
    private static final Pattern SPECIAL_CHARS = new Pattern("([\\\t\\\n\\\f\\\r\\ \\#\\\u000b\\+\\-\\[\\]\\.\\?\\*\\(\\)\\{\\}\\|\\\\\\^\\$])");
    private RegexpPattern pattern;
    private KCode code;
    private int options;
    private String lastTarget = null;
    private RegexpMatcher matcher = null;
    private static ObjectAllocator REGEXP_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyRegexp instance = new RubyRegexp(runtime, klass);
            return instance;
        }
    };

    KCode getCode() {
        return this.code;
    }

    public RubyRegexp(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    private RubyRegexp(Ruby runtime) {
        super(runtime, runtime.getRegexp());
    }

    public static RubyClass createRegexpClass(Ruby runtime) {
        RubyClass regexpClass = runtime.defineClass("Regexp", runtime.getObject(), REGEXP_ALLOCATOR);
        runtime.setRegexp(regexpClass);
        regexpClass.index = 9;
        regexpClass.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyRegexp;
            }
        };
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyRegexp.class);
        regexpClass.defineConstant("IGNORECASE", runtime.newFixnum(1L));
        regexpClass.defineConstant("EXTENDED", runtime.newFixnum(2L));
        regexpClass.defineConstant("MULTILINE", runtime.newFixnum(4L));
        regexpClass.defineAnnotatedMethods(RubyRegexp.class);
        regexpClass.dispatcher = callbackFactory.createDispatcher(regexpClass);
        return regexpClass;
    }

    @Override
    public int getNativeTypeIndex() {
        return 9;
    }

    public void initialize(ByteList regex, int options) {
        try {
            if ((options & 0x100) == 256) {
                this.pattern = RegexpFactory.getFactory("java").createPattern(regex, options, this.code.flags());
                this.options = options & 0xFFFFFEFF;
            } else {
                this.pattern = this.getRuntime().getRegexpFactory().createPattern(regex, options, this.code.flags());
                this.options = options;
            }
        }
        catch (PatternSyntaxException e) {
            throw this.getRuntime().newRegexpError(e.getMessage());
        }
    }

    public void initialize(String regex, int options) {
        this.initialize(ByteList.create(regex), options);
    }

    public static String escapeSpecialChars(String original) {
        return SPECIAL_CHARS.replacer("\\\\$1").replace(original);
    }

    private void recompileIfNeeded() {
        this.checkInitialized();
    }

    private void checkInitialized() {
        if (this.pattern == null) {
            throw this.getRuntime().newTypeError("uninitialized Regexp");
        }
    }

    public static RubyRegexp regexpValue(IRubyObject obj) {
        if (obj instanceof RubyRegexp) {
            return (RubyRegexp)obj;
        }
        if (obj instanceof RubyString) {
            return RubyRegexp.newRegexp(obj.getRuntime().newString(RubyRegexp.escapeSpecialChars(((RubyString)obj).toString())), 0, null);
        }
        throw obj.getRuntime().newArgumentError("can't convert arg to Regexp");
    }

    public static RubyRegexp newRegexp(RubyString str, int options, String lang) {
        return RubyRegexp.newRegexp(str.getRuntime(), str.getByteList(), options, lang);
    }

    public static RubyRegexp newRegexp(Ruby runtime, RegexpPattern pattern, String lang) {
        RubyRegexp re = new RubyRegexp(runtime);
        re.code = KCode.create(runtime, lang);
        re.pattern = pattern;
        return re;
    }

    public static RubyRegexp newRegexp(Ruby runtime, String str, int options, String kcode) {
        RubyRegexp re = new RubyRegexp(runtime);
        re.code = KCode.create(runtime, kcode);
        re.initialize(str, options);
        return re;
    }

    public static RubyRegexp newRegexp(Ruby runtime, ByteList str, int options, String kcode) {
        RubyRegexp re = new RubyRegexp(runtime);
        re.code = KCode.create(runtime, kcode);
        re.initialize(str, options);
        return re;
    }

    @JRubyMethod(name={"new", "compile"}, required=1, optional=2, meta=true)
    public static RubyRegexp newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyClass klass = (RubyClass)recv;
        RubyRegexp re = (RubyRegexp)klass.allocate();
        re.callInit(args, Block.NULL_BLOCK);
        return re;
    }

    @JRubyMethod(name={"initialize"}, optional=3, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 1, 3);
        ByteList pat = args[0] instanceof RubyRegexp ? ((RubyRegexp)args[0]).source().getByteList() : RubyString.stringValue(args[0]).getByteList();
        int opts = 0;
        if (args.length > 1) {
            if (args[1] instanceof RubyFixnum) {
                opts = (int)((RubyFixnum)args[1]).getLongValue();
            } else if (args[1].isTrue()) {
                opts |= 1;
            }
        }
        this.code = args.length > 2 ? KCode.create(this.getRuntime(), RubyString.stringValue(args[2]).toString()) : KCode.create(this.getRuntime(), null);
        this.initialize(pat, opts);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"quote"}, required=1, optional=1, meta=true)
    public static IRubyObject quote(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0 || args.length > 2) {
            throw recv.getRuntime().newArgumentError(0, args.length);
        }
        KCode kcode = recv.getRuntime().getKCode();
        if (args.length > 1) {
            kcode = KCode.create(recv.getRuntime(), args[1].toString());
        }
        RubyString str = args[0].convertToString();
        if (kcode == KCode.NONE) {
            return RubyRegexp.quote(recv, str);
        }
        try {
            ByteList bytes = str.getByteList();
            CharsetDecoder decoder = kcode.decoder();
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            CharBuffer decoded = decoder.decode(ByteBuffer.wrap(bytes.unsafeBytes(), bytes.begin(), bytes.length()));
            String escaped = RubyRegexp.escapeSpecialChars(decoded.toString());
            ByteBuffer encoded = kcode.encoder().encode(CharBuffer.wrap(escaped));
            return (RubyString)RubyString.newString(recv.getRuntime(), new ByteList(encoded.array(), encoded.arrayOffset(), encoded.limit() - encoded.arrayOffset())).infectBy(str);
        }
        catch (CharacterCodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @JRubyMethod(name={"escape"}, required=1, meta=true)
    public static IRubyObject quote(IRubyObject recv, IRubyObject str) {
        return recv.getRuntime().newString(RubyRegexp.escapeSpecialChars(str.toString())).infectBy(str);
    }

    @JRubyMethod(name={"last_match"}, optional=1, meta=true)
    public static IRubyObject last_match_s(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            IRubyObject ret = recv.getRuntime().getCurrentContext().getCurrentFrame().getBackRef();
            if (ret instanceof RubyMatchData) {
                ((RubyMatchData)ret).use();
            }
            return ret;
        }
        return ((RubyMatchData)recv.getRuntime().getCurrentContext().getCurrentFrame().getBackRef()).op_aref(args);
    }

    @Override
    @JRubyMethod(name={"==", "eql?"}, required=1)
    public IRubyObject op_equal(IRubyObject other) {
        if (other == this) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyRegexp)) {
            return this.getRuntime().getFalse();
        }
        RubyRegexp re = (RubyRegexp)other;
        this.checkInitialized();
        if (!re.pattern.toString().equals(this.pattern.toString()) || re.pattern.getFlags() != this.pattern.getFlags()) {
            return this.getRuntime().getFalse();
        }
        if (this.code != re.code) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"~"})
    public IRubyObject op_match2() {
        IRubyObject target = this.getRuntime().getCurrentContext().getCurrentFrame().getLastLine();
        return target instanceof RubyString ? this.op_match(target) : this.getRuntime().getNil();
    }

    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject eqq(IRubyObject target) {
        int result;
        if (!(target instanceof RubyString) && (target = target.checkStringType()).isNil()) {
            this.getRuntime().getCurrentContext().getCurrentFrame().setBackRef(this.getRuntime().getNil());
            return this.getRuntime().getFalse();
        }
        RubyString ss = RubyString.stringValue(target);
        String string = ss.toString();
        if (string.length() == 0 && "^$".equals(this.pattern.toString())) {
            string = "\n";
        }
        return (result = this.search(string, ss, 0)) < 0 ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    @Override
    @JRubyMethod(name={"=~"}, required=1)
    public IRubyObject op_match(IRubyObject target) {
        int result;
        if (target.isNil()) {
            return this.getRuntime().getFalse();
        }
        if (target instanceof RubySymbol || target instanceof RubyHash || target instanceof RubyArray) {
            return this.getRuntime().getFalse();
        }
        RubyString ss = RubyString.stringValue(target);
        String string = ss.toString();
        if (string.length() == 0 && "^$".equals(this.pattern.toString())) {
            string = "\n";
        }
        return (result = this.search(string, ss, 0)) < 0 ? this.getRuntime().getNil() : this.getRuntime().newFixnum(result);
    }

    @JRubyMethod(name={"match"}, required=1)
    public IRubyObject match_m(IRubyObject target) {
        if (target.isNil()) {
            return target;
        }
        IRubyObject result = this.op_match(target);
        if (result.isNil()) {
            return result;
        }
        result = this.getRuntime().getCurrentContext().getCurrentFrame().getBackRef();
        ((RubyMatchData)result).use();
        return result;
    }

    @JRubyMethod(name={"source"})
    public RubyString source() {
        this.checkInitialized();
        return this.getRuntime().newString(this.pattern.getSource());
    }

    @JRubyMethod(name={"kcode"})
    public IRubyObject kcode() {
        if (this.code == KCode.NIL) {
            return this.code.kcode(this.getRuntime());
        }
        return this.getRuntime().newString(this.code.kcode(this.getRuntime()).toString().toLowerCase());
    }

    @JRubyMethod(name={"options"})
    public IRubyObject options() {
        if (this.pattern.isCaseInsensitive()) {
            this.options |= 1;
        }
        if (this.pattern.isExtended()) {
            this.options |= 2;
        }
        if (this.pattern.isDotAll()) {
            this.options |= 4;
        }
        return this.getRuntime().newFixnum(this.options + this.code.bits());
    }

    @JRubyMethod(name={"casefold?"})
    public RubyBoolean casefold_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.pattern.isCaseInsensitive());
    }

    public static IRubyObject nth_match(int n, IRubyObject match) {
        IRubyObject nil = match.getRuntime().getNil();
        if (match.isNil()) {
            return nil;
        }
        RubyMatchData rmd = (RubyMatchData)match;
        if ((long)n > rmd.getSize()) {
            return nil;
        }
        if (n < 0 && (n = (int)((long)n + rmd.getSize())) <= 0) {
            return nil;
        }
        return rmd.group(n);
    }

    public static IRubyObject last_match(IRubyObject match) {
        if (match.isNil()) {
            return match;
        }
        ((RubyMatchData)match).use();
        return ((RubyMatchData)match).group(0L);
    }

    public static IRubyObject match_pre(IRubyObject match) {
        if (match.isNil()) {
            return match;
        }
        ((RubyMatchData)match).use();
        return ((RubyMatchData)match).pre_match();
    }

    public static IRubyObject match_post(IRubyObject match) {
        if (match.isNil()) {
            return match;
        }
        ((RubyMatchData)match).use();
        return ((RubyMatchData)match).post_match();
    }

    public static IRubyObject match_last(IRubyObject match) {
        if (match.isNil()) {
            return match;
        }
        RubyMatchData md = (RubyMatchData)match;
        md.use();
        for (long i = md.getSize() - 1L; i > 0L; --i) {
            if (md.group(i).isNil()) continue;
            return md.group(i);
        }
        return md.getRuntime().getNil();
    }

    public int search(String target, RubyString rtarget, int pos) {
        if (pos > target.length()) {
            return -1;
        }
        this.recompileIfNeeded();
        IRubyObject result = this.match(target, rtarget, pos);
        this.getRuntime().getCurrentContext().getCurrentFrame().setBackRef(result);
        return result instanceof RubyMatchData ? ((RubyMatchData)result).matchStartPosition() : -1;
    }

    public IRubyObject search2(String str, RubyString rtarget) {
        IRubyObject result = this.match(str, rtarget, 0);
        this.getRuntime().getCurrentContext().getCurrentFrame().setBackRef(result);
        return result;
    }

    public int searchAgain(String target, RubyString rtarget, boolean utf) {
        if (this.matcher == null || !target.equals(this.lastTarget)) {
            this.matcher = this.pattern.matcher(target);
            this.lastTarget = target;
        }
        if (!this.matcher.find()) {
            return -1;
        }
        IRubyObject _match = this.getRuntime().getCurrentContext().getCurrentFrame().getBackRef();
        RubyMatchData match = _match instanceof RubyMatchData ? (RubyMatchData)_match : (RubyMatchData)null;
        RubyMatchData newMatch = this.matcher.createOrReplace(match, target, rtarget, utf);
        if (newMatch != match) {
            this.getRuntime().getCurrentContext().getCurrentFrame().setBackRef(newMatch);
        }
        return newMatch.matchStartPosition();
    }

    public IRubyObject match(String target, RubyString rtarget, int startPos) {
        boolean utf8 = this.getCode() == KCode.UTF8;
        String t = target;
        if (utf8) {
            try {
                byte[] bs = ByteList.plain(target);
                String string = new String(bs, 0, startPos, "UTF8");
                startPos = string.length();
                t = new String(ByteList.plain(target), "UTF8");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        RegexpMatcher aMatcher = this.pattern.matcher(t);
        aMatcher.setPosition(startPos);
        if (aMatcher.find()) {
            IRubyObject _match = this.getRuntime().getCurrentContext().getCurrentFrame().getBackRef();
            RubyMatchData match = _match instanceof RubyMatchData ? (RubyMatchData)_match : (RubyMatchData)null;
            return aMatcher.createOrReplace(match, target, rtarget, utf8);
        }
        return this.getRuntime().getNil();
    }

    /*
     * WARNING - void declaration
     */
    public RubyString regsub(IRubyObject str, RubyString src, RubyMatchData match) {
        void p;
        int n;
        ByteList val = null;
        ByteList strList = str.convertToString().getByteList();
        byte[] strBytes = strList.unsafeBytes();
        int s = n = strList.begin;
        void e = p + strList.realSize;
        block8: while (p < e) {
            void no;
            byte[] srcBytes;
            ByteList srcList;
            int mat;
            char c;
            void ss = p;
            if ((c = (char)(strBytes[p++] & 0xFF)) != '\\' || p == e) continue;
            if (val == null) {
                val = new ByteList((int)(ss - s));
                val.append(strBytes, s, (int)(ss - s));
            } else {
                val.append(strBytes, s, (int)(ss - s));
            }
            c = (char)(strBytes[p++] & 0xFF);
            s = p;
            RegexpMatcher regexpMatcher = match.matcher;
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    mat = c - 48;
                    break;
                }
                case '&': {
                    mat = 0;
                    break;
                }
                case '`': {
                    srcList = src.getByteList();
                    srcBytes = srcList.unsafeBytes();
                    val.append(srcBytes, srcList.begin, no.start(0));
                    continue block8;
                }
                case '\'': {
                    srcList = src.getByteList();
                    srcBytes = srcList.unsafeBytes();
                    val.append(srcBytes, srcList.begin + no.end(0), srcList.length() - no.end(0));
                    continue block8;
                }
                case '+': {
                    for (mat = no.groupCount() - 1; !no.isCaptured(mat) && mat > 0; --mat) {
                    }
                    if (mat != 0) break;
                    continue block8;
                }
                case '\\': {
                    val.append(strBytes, (int)(p - true), 1);
                    continue block8;
                }
                default: {
                    val.append(strBytes, (int)(p - 2), 2);
                    continue block8;
                }
            }
            if (mat < 0 || mat >= no.groupCount() || !no.isCaptured(mat)) continue;
            srcList = src.getByteList();
            srcBytes = srcList.unsafeBytes();
            val.append(srcBytes, srcList.begin + no.start(mat), no.end(mat) - no.start(mat));
        }
        if (s < e) {
            if (val == null) {
                val = new ByteList((int)(e - s));
                val.append(strBytes, s, (int)(e - s));
            } else {
                val.append(strBytes, s, (int)(e - s));
            }
        }
        if (val == null) {
            return (RubyString)str;
        }
        return RubyString.newString(this.getRuntime(), val);
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        if (this.getMetaClass() != original.getMetaClass()) {
            throw this.getRuntime().newTypeError("wrong argument class");
        }
        RubyRegexp origRegexp = (RubyRegexp)original;
        this.pattern = origRegexp.pattern;
        this.code = origRegexp.code;
        return this;
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        ByteList regex = this.pattern.getSource();
        int length = regex.length();
        StringBuffer sb = new StringBuffer(length + 2);
        sb.append('/');
        for (int i = 0; i < length; ++i) {
            char c = regex.charAt(i);
            if (RubyString.isAlnum(c)) {
                sb.append(c);
                continue;
            }
            if (c == '/') {
                if (i == 0 || regex.charAt(i - 1) != '\\') {
                    sb.append("\\");
                }
                sb.append(c);
                continue;
            }
            if (RubyString.isPrint(c)) {
                sb.append(c);
                continue;
            }
            if (c == '\n') {
                sb.append('\\').append('n');
                continue;
            }
            if (c == '\r') {
                sb.append('\\').append('r');
                continue;
            }
            if (c == '\t') {
                sb.append('\\').append('t');
                continue;
            }
            if (c == '\f') {
                sb.append('\\').append('f');
                continue;
            }
            if (c == '\u000b') {
                sb.append('\\').append('v');
                continue;
            }
            if (c == '\u0007') {
                sb.append('\\').append('a');
                continue;
            }
            if (c == '\u001b') {
                sb.append('\\').append('e');
                continue;
            }
            sb.append(Sprintf.sprintf(this.getRuntime(), (CharSequence)"\\%.3o", c));
        }
        sb.append('/');
        if (this.code == KCode.NONE) {
            sb.append('n');
        } else if (this.code == KCode.UTF8) {
            sb.append('u');
        } else if (this.code == KCode.SJIS) {
            sb.append('s');
        }
        if (this.pattern.isCaseInsensitive()) {
            sb.append('i');
        }
        if (this.pattern.isDotAll()) {
            sb.append('m');
        }
        if (this.pattern.isExtended()) {
            sb.append('x');
        }
        return this.getRuntime().newString(sb.toString());
    }

    @JRubyMethod(name={"union"}, rest=true, meta=true)
    public static IRubyObject union(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        if (args.length == 0) {
            return RubyRegexp.newInstance(recv, new IRubyObject[]{runtime.newString("(?!)")});
        }
        if (args.length == 1) {
            IRubyObject arg = args[0].convertToTypeWithCheck(runtime.getRegexp(), 0, "to_regexp");
            if (!arg.isNil()) {
                return arg;
            }
            return RubyRegexp.newInstance(recv, new IRubyObject[]{RubyRegexp.quote(recv, args[0].convertToString())});
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            IRubyObject arg;
            if (i > 0) {
                buffer.append("|");
            }
            if ((arg = args[i].convertToTypeWithCheck(runtime.getRegexp(), 0, "to_regexp")).isNil()) {
                arg = RubyRegexp.quote(recv, args[i].convertToString());
            }
            buffer.append(arg.toString());
        }
        return RubyRegexp.newInstance(recv, new IRubyObject[]{runtime.newString(buffer.toString())});
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return this.getRuntime().newString(this.toString());
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        StringBuffer off = new StringBuffer(3);
        buffer.append("(?");
        this.flagToString(buffer, off, this.pattern.isDotAll(), 'm');
        this.flagToString(buffer, off, this.pattern.isCaseInsensitive(), 'i');
        this.flagToString(buffer, off, this.pattern.isExtended(), 'x');
        if (off.length() > 0) {
            buffer.append('-').append(off);
        }
        buffer.append(':');
        buffer.append(this.pattern.toString().replaceAll("^/|([^\\\\])/", "$1\\\\/"));
        buffer.append(')');
        return buffer.toString();
    }

    private void flagToString(StringBuffer buffer, StringBuffer off, boolean flag, char c) {
        if (flag) {
            buffer.append(c);
        } else {
            off.append(c);
        }
    }

    public static RubyRegexp unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyRegexp result = RubyRegexp.newRegexp(input.getRuntime(), input.unmarshalString(), input.unmarshalInt(), null);
        input.registerLinkTarget(result);
        return result;
    }

    public static void marshalTo(RubyRegexp regexp, MarshalStream output) throws IOException {
        output.writeString(regexp.pattern.toString());
        int _flags = 0;
        if (regexp.pattern.isDotAll()) {
            _flags |= 4;
        }
        if (regexp.pattern.isCaseInsensitive()) {
            _flags |= 1;
        }
        if (regexp.pattern.isExtended()) {
            _flags |= 2;
        }
        output.writeInt(_flags);
    }

    public RegexpPattern getPattern() {
        return this.pattern;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.pattern.toString().hashCode() + this.pattern.getFlags());
    }
}

