/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyDir;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.DirectoryAsFileException;
import org.jruby.util.IOHandler;
import org.jruby.util.IOHandlerNull;
import org.jruby.util.IOHandlerSeekable;
import org.jruby.util.IOHandlerUnseekable;
import org.jruby.util.IOModes;
import org.jruby.util.JRubyFile;
import org.jruby.util.ShellLauncher;

public class RubyFile
extends RubyIO {
    public static final int LOCK_SH = 1;
    public static final int LOCK_EX = 2;
    public static final int LOCK_NB = 4;
    public static final int LOCK_UN = 8;
    private static final int FNM_NOESCAPE = 1;
    private static final int FNM_PATHNAME = 2;
    private static final int FNM_DOTMATCH = 4;
    private static final int FNM_CASEFOLD = 8;
    static final boolean IS_WINDOWS;
    protected String path;
    private FileLock currentLock;
    private static ObjectAllocator FILE_ALLOCATOR;

    public RubyFile(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public RubyFile(Ruby runtime, String path) {
        this(runtime, path, RubyFile.open(runtime, path));
    }

    private static InputStream open(Ruby runtime, String path) {
        try {
            return new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            throw runtime.newIOError(e.getMessage());
        }
    }

    public RubyFile(Ruby runtime, String path, final Reader reader) {
        this(runtime, path, new InputStream(){

            @Override
            public int read() throws IOException {
                return reader.read();
            }
        });
    }

    public RubyFile(Ruby runtime, String path, InputStream in) {
        super(runtime, runtime.getFile());
        this.path = path;
        try {
            this.handler = new IOHandlerUnseekable(runtime, in, null);
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
        this.modes = this.handler.getModes();
        this.registerIOHandler(this.handler);
    }

    public static RubyClass createFileClass(Ruby runtime) {
        RubyClass fileClass = runtime.defineClass("File", runtime.getIO(), FILE_ALLOCATOR);
        runtime.setFile(fileClass);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyFile.class);
        RubyClass fileMetaClass = fileClass.getMetaClass();
        RubyString separator = runtime.newString("/");
        fileClass.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyFile;
            }
        };
        separator.freeze();
        fileClass.defineConstant("SEPARATOR", separator);
        fileClass.defineConstant("Separator", separator);
        if (File.separatorChar == '\\') {
            RubyString altSeparator = runtime.newString("\\");
            altSeparator.freeze();
            fileClass.defineConstant("ALT_SEPARATOR", altSeparator);
        } else {
            fileClass.defineConstant("ALT_SEPARATOR", runtime.getNil());
        }
        RubyString pathSeparator = runtime.newString(File.pathSeparator);
        pathSeparator.freeze();
        fileClass.defineConstant("PATH_SEPARATOR", pathSeparator);
        fileClass.fastSetConstant("BINARY", runtime.newFixnum(4096L));
        fileClass.fastSetConstant("FNM_NOESCAPE", runtime.newFixnum(1L));
        fileClass.fastSetConstant("FNM_CASEFOLD", runtime.newFixnum(8L));
        fileClass.fastSetConstant("FNM_SYSCASE", runtime.newFixnum(8L));
        fileClass.fastSetConstant("FNM_DOTMATCH", runtime.newFixnum(4L));
        fileClass.fastSetConstant("FNM_PATHNAME", runtime.newFixnum(2L));
        fileClass.fastSetConstant("RDONLY", runtime.newFixnum(0L));
        fileClass.fastSetConstant("WRONLY", runtime.newFixnum(1L));
        fileClass.fastSetConstant("RDWR", runtime.newFixnum(2L));
        fileClass.fastSetConstant("CREAT", runtime.newFixnum(64L));
        fileClass.fastSetConstant("EXCL", runtime.newFixnum(128L));
        fileClass.fastSetConstant("NOCTTY", runtime.newFixnum(256L));
        fileClass.fastSetConstant("TRUNC", runtime.newFixnum(512L));
        fileClass.fastSetConstant("APPEND", runtime.newFixnum(1024L));
        fileClass.fastSetConstant("NONBLOCK", runtime.newFixnum(2048L));
        fileClass.fastSetConstant("LOCK_SH", runtime.newFixnum(1L));
        fileClass.fastSetConstant("LOCK_EX", runtime.newFixnum(2L));
        fileClass.fastSetConstant("LOCK_NB", runtime.newFixnum(4L));
        fileClass.fastSetConstant("LOCK_UN", runtime.newFixnum(8L));
        RubyModule constants = fileClass.defineModuleUnder("Constants");
        constants.fastSetConstant("BINARY", runtime.newFixnum(32768L));
        constants.fastSetConstant("FNM_NOESCAPE", runtime.newFixnum(1L));
        constants.fastSetConstant("FNM_CASEFOLD", runtime.newFixnum(8L));
        constants.fastSetConstant("FNM_DOTMATCH", runtime.newFixnum(4L));
        constants.fastSetConstant("FNM_PATHNAME", runtime.newFixnum(2L));
        constants.fastSetConstant("RDONLY", runtime.newFixnum(0L));
        constants.fastSetConstant("WRONLY", runtime.newFixnum(1L));
        constants.fastSetConstant("RDWR", runtime.newFixnum(2L));
        constants.fastSetConstant("CREAT", runtime.newFixnum(64L));
        constants.fastSetConstant("EXCL", runtime.newFixnum(128L));
        constants.fastSetConstant("NOCTTY", runtime.newFixnum(256L));
        constants.fastSetConstant("TRUNC", runtime.newFixnum(512L));
        constants.fastSetConstant("APPEND", runtime.newFixnum(1024L));
        constants.fastSetConstant("NONBLOCK", runtime.newFixnum(2048L));
        constants.fastSetConstant("LOCK_SH", runtime.newFixnum(1L));
        constants.fastSetConstant("LOCK_EX", runtime.newFixnum(2L));
        constants.fastSetConstant("LOCK_NB", runtime.newFixnum(4L));
        constants.fastSetConstant("LOCK_UN", runtime.newFixnum(8L));
        runtime.getFileTest().extend_object(fileClass);
        fileClass.defineAnnotatedMethods(RubyFile.class);
        fileClass.dispatcher = callbackFactory.createDispatcher(fileClass);
        return fileClass;
    }

    public void openInternal(String newPath, IOModes newModes) {
        this.path = newPath;
        this.modes = newModes;
        try {
            this.handler = newPath.equals("/dev/null") ? new IOHandlerNull(this.getRuntime(), newModes) : new IOHandlerSeekable(this.getRuntime(), newPath, newModes);
            this.registerIOHandler(this.handler);
        }
        catch (IOHandler.InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (DirectoryAsFileException e) {
            throw this.getRuntime().newErrnoEISDirError();
        }
        catch (FileNotFoundException e) {
            throw this.getRuntime().newErrnoENOENTError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    @Override
    @JRubyMethod
    public IRubyObject close() {
        if (this.currentLock != null) {
            try {
                this.currentLock.release();
            }
            catch (IOException e) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
        }
        return super.close();
    }

    @JRubyMethod(required=1)
    public IRubyObject flock(IRubyObject lockingConstant) {
        block15: {
            FileChannel fileChannel = this.handler.getFileChannel();
            int lockMode = RubyNumeric.num2int(lockingConstant);
            try {
                switch (lockMode) {
                    case 8: 
                    case 12: {
                        if (this.currentLock == null) break;
                        this.currentLock.release();
                        this.currentLock = null;
                        return this.getRuntime().newFixnum(0L);
                    }
                    case 2: {
                        if (this.currentLock != null) {
                            this.currentLock.release();
                            this.currentLock = null;
                        }
                        this.currentLock = fileChannel.lock();
                        if (this.currentLock == null) break;
                        return this.getRuntime().newFixnum(0L);
                    }
                    case 6: {
                        if (this.currentLock != null) {
                            this.currentLock.release();
                            this.currentLock = null;
                        }
                        this.currentLock = fileChannel.tryLock();
                        if (this.currentLock == null) break;
                        return this.getRuntime().newFixnum(0L);
                    }
                    case 1: {
                        if (this.currentLock != null) {
                            this.currentLock.release();
                            this.currentLock = null;
                        }
                        this.currentLock = fileChannel.lock(0L, Long.MAX_VALUE, true);
                        if (this.currentLock == null) break;
                        return this.getRuntime().newFixnum(0L);
                    }
                    case 5: {
                        if (this.currentLock != null) {
                            this.currentLock.release();
                            this.currentLock = null;
                        }
                        this.currentLock = fileChannel.tryLock(0L, Long.MAX_VALUE, true);
                        if (this.currentLock == null) break;
                        return this.getRuntime().newFixnum(0L);
                    }
                }
            }
            catch (IOException ioe) {
                if (this.getRuntime().getDebug().isTrue()) {
                    ioe.printStackTrace(System.err);
                }
            }
            catch (OverlappingFileLockException ioe) {
                if (!this.getRuntime().getDebug().isTrue()) break block15;
                ioe.printStackTrace(System.err);
            }
        }
        return this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(required=1, optional=2, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        IRubyObject fd;
        if (args.length == 0) {
            throw this.getRuntime().newArgumentError(0, 1);
        }
        if (args.length < 3 && !(fd = args[0].convertToTypeWithCheck(this.getRuntime().getFixnum(), MethodIndex.TO_INT, "to_int")).isNil()) {
            args[0] = fd;
            return super.initialize(args, block);
        }
        this.getRuntime().checkSafeString(args[0]);
        this.path = args[0].toString();
        IOModes iOModes = this.modes = args.length > 1 ? RubyFile.getModes(this.getRuntime(), args[1]) : new IOModes(this.getRuntime(), 0L);
        if (this.handler != null) {
            this.close();
        }
        this.openInternal(this.path, this.modes);
        if (block.isGiven()) {
            // empty if block
        }
        return this;
    }

    @JRubyMethod(required=1)
    public IRubyObject chmod(IRubyObject arg) {
        RubyInteger mode = arg.convertToInteger();
        if (!new File(this.path).exists()) {
            throw this.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        int result = Ruby.getPosix().chmod(this.path, (int)mode.getLongValue());
        return this.getRuntime().newFixnum(result);
    }

    @JRubyMethod(required=2)
    public IRubyObject chown(IRubyObject arg, IRubyObject arg2) {
        RubyInteger owner = arg.convertToInteger();
        RubyInteger group = arg2.convertToInteger();
        if (!new File(this.path).exists()) {
            throw this.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        int result = Ruby.getPosix().chown(this.path, (int)owner.getLongValue(), (int)group.getLongValue());
        return RubyFixnum.newFixnum(this.getRuntime(), result);
    }

    @JRubyMethod(name={"atime", "ctime"})
    public IRubyObject atime() {
        return this.getRuntime().newTime(JRubyFile.create(this.getRuntime().getCurrentDirectory(), this.path).getParentFile().lastModified());
    }

    @JRubyMethod(name={"mtime"})
    public IRubyObject mtime() {
        return this.getRuntime().newTime(JRubyFile.create(this.getRuntime().getCurrentDirectory(), this.path).lastModified());
    }

    @JRubyMethod
    public RubyString path() {
        return this.getRuntime().newString(this.path);
    }

    @JRubyMethod
    public IRubyObject stat() {
        return this.getRuntime().newRubyFileStat(this.path);
    }

    @JRubyMethod(required=1)
    public IRubyObject truncate(IRubyObject arg) {
        RubyInteger newLength = arg.convertToInteger();
        if (newLength.getLongValue() < 0L) {
            throw this.getRuntime().newErrnoEINVALError("invalid argument: " + this.path);
        }
        try {
            this.handler.truncate(newLength.getLongValue());
        }
        catch (IOHandler.PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    @Override
    public String toString() {
        return "RubyFile(" + this.path + ", " + this.modes + ", " + fileno + ")";
    }

    private static IOModes getModes(Ruby runtime, IRubyObject object) {
        if (object instanceof RubyString) {
            return new IOModes(runtime, ((RubyString)object).toString());
        }
        if (object instanceof RubyFixnum) {
            return new IOModes(runtime, ((RubyFixnum)object).getLongValue());
        }
        throw runtime.newTypeError("Invalid type for modes");
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect() {
        StringBuffer val = new StringBuffer();
        val.append("#<File:").append(this.path);
        if (!this.isOpen()) {
            val.append(" (closed)");
        }
        val.append(">");
        return this.getRuntime().newString(val.toString());
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject basename(IRubyObject recv, IRubyObject[] args) {
        int index;
        char c;
        Arity.checkArgumentCount(recv.getRuntime(), args, 1, 2);
        String name = RubyString.stringValue(args[0]).toString();
        if (IS_WINDOWS && name.length() > 1 && name.charAt(1) == ':' && Character.isLetter(name.charAt(0))) {
            switch (name.length()) {
                case 2: {
                    return recv.getRuntime().newString("").infectBy(args[0]);
                }
                case 3: {
                    return recv.getRuntime().newString(name.substring(2)).infectBy(args[0]);
                }
            }
            switch (name.charAt(2)) {
                case '/': 
                case '\\': {
                    break;
                }
                default: {
                    name = name.substring(2);
                }
            }
        }
        while (name.length() > 1 && name.charAt(name.length() - 1) == '/') {
            name = name.substring(0, name.length() - 1);
        }
        int slashCount = 0;
        int length = name.length();
        for (int i = length - 1; i >= 0 && ((c = name.charAt(i)) == '/' || c == '\\'); --i) {
            ++slashCount;
        }
        if (slashCount > 0 && length > 1) {
            name = name.substring(0, name.length() - slashCount);
        }
        if ((index = name.lastIndexOf(47)) == -1) {
            index = name.lastIndexOf(92);
        }
        if (!name.equals("/") && index != -1) {
            name = name.substring(index + 1);
        }
        if (args.length == 2) {
            String ext = RubyString.stringValue(args[1]).toString();
            if (".*".equals(ext)) {
                index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(0, index);
                }
            } else if (name.endsWith(ext)) {
                name = name.substring(0, name.length() - ext.length());
            }
        }
        return recv.getRuntime().newString(name).infectBy(args[0]);
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject chmod(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        Arity.checkArgumentCount(runtime, args, 2, -1);
        int count = 0;
        RubyInteger mode = args[0].convertToInteger();
        for (int i = 1; i < args.length; ++i) {
            boolean result;
            IRubyObject filename = args[i];
            if (!RubyFileTest.exist_p(filename, filename.convertToString()).isTrue()) {
                throw runtime.newErrnoENOENTError("No such file or directory - " + filename);
            }
            boolean bl = result = 0 == Ruby.getPosix().chmod(filename.toString(), (int)mode.getLongValue());
            if (!result) continue;
            ++count;
        }
        return runtime.newFixnum(count);
    }

    @JRubyMethod(required=3, rest=true, meta=true)
    public static IRubyObject chown(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        Arity.checkArgumentCount(runtime, args, 3, -1);
        int count = 0;
        RubyInteger owner = args[0].convertToInteger();
        RubyInteger group = args[1].convertToInteger();
        for (int i = 2; i < args.length; ++i) {
            boolean result;
            IRubyObject filename = args[i];
            if (!RubyFileTest.exist_p(filename, filename.convertToString()).isTrue()) {
                throw runtime.newErrnoENOENTError("No such file or directory - " + filename);
            }
            boolean bl = result = 0 == Ruby.getPosix().chown(filename.toString(), (int)owner.getLongValue(), (int)group.getLongValue());
            if (!result) continue;
            ++count;
        }
        return runtime.newFixnum(count);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject dirname(IRubyObject recv, IRubyObject arg) {
        String result;
        RubyString filename = RubyString.stringValue(arg);
        String jfilename = filename.toString();
        String name = jfilename.replace('\\', '/');
        boolean trimmedSlashes = false;
        while (name.length() > 1 && name.charAt(name.length() - 1) == '/') {
            trimmedSlashes = true;
            name = name.substring(0, name.length() - 1);
        }
        if (IS_WINDOWS && name.length() == 2 && RubyFile.isWindowsDriveLetter(name.charAt(0)) && name.charAt(1) == ':') {
            result = trimmedSlashes ? jfilename.substring(0, 3) : jfilename.substring(0, 2) + '.';
        } else {
            int index = name.lastIndexOf(47);
            if (index == -1) {
                return recv.getRuntime().newString(".");
            }
            if (index == 0) {
                return recv.getRuntime().newString("/");
            }
            if (IS_WINDOWS && index == 2 && RubyFile.isWindowsDriveLetter(name.charAt(0)) && name.charAt(1) == ':') {
                ++index;
            }
            result = jfilename.substring(0, index);
        }
        return recv.getRuntime().newString(result).infectBy(filename);
    }

    private static boolean isWindowsDriveLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject extname(IRubyObject recv, IRubyObject arg) {
        IRubyObject baseFilename = RubyFile.basename(recv, new IRubyObject[]{arg});
        String filename = RubyString.stringValue(baseFilename).toString();
        String result = "";
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex > 0 && dotIndex != filename.length() - 1) {
            result = filename.substring(dotIndex);
        }
        return recv.getRuntime().newString(result);
    }

    @JRubyMethod(required=1, optional=2, meta=true)
    public static IRubyObject expand_path(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        Arity.checkArgumentCount(runtime, args, 1, 2);
        String relativePath = RubyString.stringValue(args[0]).toString();
        String cwd = null;
        relativePath = RubyFile.expandUserPath(recv, relativePath);
        if (args.length == 2 && !args[1].isNil()) {
            String cwdArg = RubyString.stringValue(args[1]).toString();
            cwd = RubyFile.expandUserPath(recv, cwdArg);
            if (cwd.charAt(0) != '/') {
                cwd = JRubyFile.create(runtime.getCurrentDirectory(), cwd).getAbsolutePath();
            }
        } else {
            cwd = runtime.getCurrentDirectory();
        }
        if (cwd == null) {
            return runtime.getNil();
        }
        String padSlashes = "";
        if (relativePath.length() > 0 && relativePath.charAt(0) == '/') {
            padSlashes = RubyFile.countSlashes(relativePath);
        } else if (cwd.length() > 0 && cwd.charAt(0) == '/') {
            padSlashes = RubyFile.countSlashes(cwd);
        }
        JRubyFile path = JRubyFile.create(cwd, relativePath);
        return runtime.newString(padSlashes + RubyFile.canonicalize(path.getAbsolutePath()));
    }

    private static String expandUserPath(IRubyObject recv, String path) {
        int pathLength = path.length();
        if (pathLength >= 1 && path.charAt(0) == '~') {
            int userEnd = path.indexOf(47);
            if (userEnd == -1) {
                if (pathLength == 1) {
                    path = RubyDir.getHomeDirectoryPath(recv).toString();
                } else {
                    userEnd = pathLength;
                }
            }
            if (userEnd == 1) {
                path = RubyDir.getHomeDirectoryPath(recv).toString() + path.substring(1);
            } else if (userEnd > 1) {
                String user = path.substring(1, userEnd);
                IRubyObject dir = RubyDir.getHomeDirectoryPath(recv, user);
                if (dir.isNil()) {
                    Ruby runtime = recv.getRuntime();
                    throw runtime.newArgumentError("user " + user + " does not exist");
                }
                path = "" + dir + (pathLength == userEnd ? "" : path.substring(userEnd));
            }
        }
        return path;
    }

    private static String countSlashes(String stringToCheck) {
        int slashCount = 0;
        for (int i = 0; i < stringToCheck.length() && stringToCheck.charAt(i) == '/'; ++i) {
            ++slashCount;
        }
        if (slashCount > 0) {
            --slashCount;
        }
        byte[] slashes = new byte[slashCount];
        for (int i = 0; i < slashCount; ++i) {
            slashes[i] = 47;
        }
        return new String(slashes);
    }

    private static String canonicalize(String path) {
        return RubyFile.canonicalize(null, path);
    }

    /*
     * WARNING - void declaration
     */
    private static String canonicalize(String canonicalPath, String remaining) {
        String slash;
        if (remaining == null) {
            return canonicalPath;
        }
        int n = remaining.indexOf(47);
        if (n == -1) {
            slash = remaining;
            remaining = null;
        } else {
            void child;
            slash = remaining.substring(0, (int)child);
            remaining = remaining.substring((int)(child + true));
        }
        if (slash.equals(".")) {
            if (canonicalPath != null && canonicalPath.length() == 0) {
                canonicalPath = canonicalPath + "/";
            }
        } else if (slash.equals("..")) {
            if (canonicalPath == null) {
                throw new IllegalArgumentException("Cannot have .. at the start of an absolute path");
            }
            int lastDir = canonicalPath.lastIndexOf(47);
            canonicalPath = lastDir == -1 ? "" : canonicalPath.substring(0, lastDir);
        } else {
            canonicalPath = canonicalPath == null ? slash : canonicalPath + "/" + slash;
        }
        return RubyFile.canonicalize(canonicalPath, remaining);
    }

    @JRubyMethod(name={"fnmatch", "fnmatch?"}, required=2, optional=1, meta=true)
    public static IRubyObject fnmatch(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        int flags = Arity.checkArgumentCount(runtime, args, 2, 3) == 3 ? RubyNumeric.num2int(args[2]) : 0;
        ByteList pattern = args[0].convertToString().getByteList();
        ByteList path = args[1].convertToString().getByteList();
        if (Dir.fnmatch(pattern.bytes, pattern.begin, pattern.realSize, path.bytes, path.begin, path.realSize, flags) == 0) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    @JRubyMethod(rest=true, meta=true)
    public static RubyString join(IRubyObject recv, IRubyObject[] args) {
        boolean isTainted = false;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].isTaint()) {
                isTainted = true;
            }
            String element = args[i] instanceof RubyString ? args[i].toString() : (args[i] instanceof RubyArray ? RubyFile.join(recv, ((RubyArray)args[i]).toJavaArray()).toString() : args[i].convertToString().toString());
            RubyFile.chomp(buffer);
            if (i > 0 && !element.startsWith("/") && !element.startsWith("\\")) {
                buffer.append("/");
            }
            buffer.append(element);
        }
        RubyString fixedStr = RubyString.newString(recv.getRuntime(), buffer.toString());
        fixedStr.setTaint(isTainted);
        return fixedStr;
    }

    private static void chomp(StringBuffer buffer) {
        for (int lastIndex = buffer.length() - 1; lastIndex >= 0 && (buffer.lastIndexOf("/") == lastIndex || buffer.lastIndexOf("\\") == lastIndex); --lastIndex) {
            buffer.setLength(lastIndex);
        }
    }

    @JRubyMethod(name={"lstat", "stat"}, required=1, meta=true)
    public static IRubyObject lstat(IRubyObject recv, IRubyObject filename) {
        RubyString name = RubyString.stringValue(filename);
        return recv.getRuntime().newRubyFileStat(name.toString());
    }

    @JRubyMethod(name={"atime", "ctime"}, required=1, meta=true)
    public static IRubyObject atime(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        RubyString name = RubyString.stringValue(filename);
        JRubyFile file = JRubyFile.create(runtime.getCurrentDirectory(), name.toString());
        if (!file.exists()) {
            throw runtime.newErrnoENOENTError("No such file or directory - " + name.toString());
        }
        return runtime.newTime(file.getParentFile().lastModified());
    }

    @JRubyMethod(name={"mtime"}, required=1, meta=true)
    public static IRubyObject mtime(IRubyObject recv, IRubyObject filename) {
        Ruby runtime = recv.getRuntime();
        RubyString name = RubyString.stringValue(filename);
        JRubyFile file = JRubyFile.create(runtime.getCurrentDirectory(), name.toString());
        if (!file.exists()) {
            throw runtime.newErrnoENOENTError("No such file or directory - " + name.toString());
        }
        return runtime.newTime(file.lastModified());
    }

    @JRubyMethod(required=1, rest=true, frame=true, meta=true)
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyFile.open(recv, args, true, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args, boolean tryToYield, Block block) {
        Ruby runtime = recv.getRuntime();
        Arity.checkArgumentCount(runtime, args, 1, -1);
        ThreadContext tc = runtime.getCurrentContext();
        RubyString pathString = RubyString.stringValue(args[0]);
        runtime.checkSafeString(pathString);
        String path = pathString.toString();
        IOModes modes = args.length >= 2 ? RubyFile.getModes(runtime, args[1]) : new IOModes(runtime, 0L);
        RubyFile file = new RubyFile(runtime, (RubyClass)recv);
        RubyInteger fileMode = args.length >= 3 ? args[2].convertToInteger() : null;
        file.openInternal(path, modes);
        if (fileMode != null) {
            RubyFile.chmod(recv, new IRubyObject[]{fileMode, pathString});
        }
        if (tryToYield && block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(tc, file);
                return iRubyObject;
            }
            finally {
                file.close();
            }
        }
        return file;
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject rename(IRubyObject recv, IRubyObject oldName, IRubyObject newName) {
        Ruby runtime = recv.getRuntime();
        RubyString oldNameString = RubyString.stringValue(oldName);
        RubyString newNameString = RubyString.stringValue(newName);
        runtime.checkSafeString(oldNameString);
        runtime.checkSafeString(newNameString);
        JRubyFile oldFile = JRubyFile.create(runtime.getCurrentDirectory(), oldNameString.toString());
        JRubyFile newFile = JRubyFile.create(runtime.getCurrentDirectory(), newNameString.toString());
        if (!oldFile.exists() || !newFile.getParentFile().exists()) {
            throw runtime.newErrnoENOENTError("No such file or directory - " + oldNameString + " or " + newNameString);
        }
        oldFile.renameTo(JRubyFile.create(runtime.getCurrentDirectory(), newNameString.toString()));
        return RubyFixnum.zero(runtime);
    }

    @JRubyMethod(name={"size?"}, required=1, meta=true)
    public static IRubyObject size_p(IRubyObject recv, IRubyObject filename) {
        long size = 0L;
        try {
            FileInputStream fis = new FileInputStream(new File(filename.toString()));
            FileChannel chan = fis.getChannel();
            size = chan.size();
            chan.close();
            fis.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (size == 0L) {
            return recv.getRuntime().getNil();
        }
        return recv.getRuntime().newFixnum(size);
    }

    @JRubyMethod(required=1, meta=true)
    public static RubyArray split(IRubyObject recv, IRubyObject arg) {
        RubyString filename = RubyString.stringValue(arg);
        return filename.getRuntime().newArray(RubyFile.dirname(recv, filename), RubyFile.basename(recv, new IRubyObject[]{filename}));
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject symlink(IRubyObject recv, IRubyObject from, IRubyObject to) {
        Ruby runtime = recv.getRuntime();
        try {
            int result = new ShellLauncher(runtime).runAndWait(new IRubyObject[]{runtime.newString("ln"), runtime.newString("-s"), from, to});
            return runtime.newFixnum(result);
        }
        catch (Exception e) {
            throw runtime.newNotImplementedError("symlinks");
        }
    }

    @JRubyMethod(name={"symlink?"}, required=1, meta=true)
    public static IRubyObject symlink_p(IRubyObject recv, IRubyObject arg1) {
        Ruby runtime = recv.getRuntime();
        RubyString filename = RubyString.stringValue(arg1);
        JRubyFile file = JRubyFile.create(runtime.getCurrentDirectory(), filename.toString());
        try {
            File absoluteParent = file.getAbsoluteFile().getParentFile();
            File canonicalParent = file.getAbsoluteFile().getParentFile().getCanonicalFile();
            if (canonicalParent.getAbsolutePath().equals(absoluteParent.getAbsolutePath())) {
                return file.getAbsolutePath().equals(file.getCanonicalPath()) ? runtime.getFalse() : runtime.getTrue();
            }
            file = JRubyFile.create(runtime.getCurrentDirectory(), canonicalParent.getAbsolutePath() + "/" + file.getName());
            return file.getAbsolutePath().equals(file.getCanonicalPath()) ? runtime.getFalse() : runtime.getTrue();
        }
        catch (IOException ioe) {
            return runtime.getFalse();
        }
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject truncate(IRubyObject recv, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime = recv.getRuntime();
        RubyString filename = arg1.convertToString();
        RubyInteger newLength = arg2.convertToInteger();
        if (newLength.getLongValue() < 0L) {
            throw runtime.newErrnoEINVALError("invalid argument: " + filename);
        }
        IRubyObject[] args = new IRubyObject[]{filename, runtime.newString("w+")};
        RubyFile file = (RubyFile)RubyFile.open(recv, args, false, null);
        file.truncate(newLength);
        file.close();
        return RubyFixnum.zero(runtime);
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject utime(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        Arity.checkArgumentCount(runtime, args, 2, -1);
        long mtime = args[1] instanceof RubyTime ? ((RubyTime)args[1]).getJavaDate().getTime() : (args[1] instanceof RubyNumeric ? RubyNumeric.num2long(args[1]) : 0L);
        int j = args.length;
        for (int i = 2; i < j; ++i) {
            RubyString filename = RubyString.stringValue(args[i]);
            runtime.checkSafeString(filename);
            JRubyFile fileToTouch = JRubyFile.create(runtime.getCurrentDirectory(), filename.toString());
            if (!fileToTouch.exists()) {
                throw runtime.newErrnoENOENTError(" No such file or directory - \"" + filename + "\"");
            }
            fileToTouch.setLastModified(mtime);
        }
        return runtime.newFixnum(args.length - 2);
    }

    @JRubyMethod(name={"unlink", "delete"}, rest=true, meta=true)
    public static IRubyObject unlink(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        for (int i = 0; i < args.length; ++i) {
            RubyString filename = RubyString.stringValue(args[i]);
            runtime.checkSafeString(filename);
            JRubyFile lToDelete = JRubyFile.create(runtime.getCurrentDirectory(), filename.toString());
            if (!lToDelete.exists()) {
                throw runtime.newErrnoENOENTError(" No such file or directory - \"" + filename + "\"");
            }
            if (lToDelete.delete()) continue;
            return runtime.getFalse();
        }
        return runtime.newFixnum(args.length);
    }

    static {
        String osname = System.getProperty("os.name");
        IS_WINDOWS = osname != null && osname.toLowerCase().indexOf("windows") != -1;
        FILE_ALLOCATOR = new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                RubyFile instance = new RubyFile(runtime, klass);
                instance.setMetaClass(klass);
                return instance;
            }
        };
    }
}

