/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.Vector;
import jregex.LAEntry;
import jregex.MatchIterator;
import jregex.MatchResult;
import jregex.MemReg;
import jregex.Pattern;
import jregex.SearchEntry;
import jregex.Term;
import jregex.TextBuffer;

public class Matcher
implements MatchResult {
    public static final int ANCHOR_START = 1;
    public static final int ANCHOR_LASTMATCH = 2;
    public static final int ANCHOR_END = 4;
    public static final int ACCEPT_INCOMPLETE = 8;
    private static Term startAnchor = new Term(18);
    private static Term lastMatchAnchor = new Term(23);
    private Pattern re;
    private int[] counters;
    private MemReg[] memregs;
    private LAEntry[] lookaheads;
    private int counterCount;
    private int memregCount;
    private int lookaheadCount;
    private char[] data;
    private int offset;
    private int end;
    private int wOffset;
    private int wEnd;
    private boolean shared;
    private SearchEntry top;
    private SearchEntry first;
    private SearchEntry defaultEntry;
    private boolean called;
    private int minQueueLength;
    private String cache;
    private int cacheOffset;
    private int cacheLength;
    private MemReg prefixBounds;
    private MemReg suffixBounds;
    private MemReg targetBounds;

    /*
     * WARNING - void declaration
     */
    Matcher(Pattern regex) {
        void var6_6;
        void var5_5;
        int i;
        int memregs;
        this.re = regex;
        int memregCount = regex.memregs;
        if (memregCount > 0) {
            MemReg[] memRegArray = new MemReg[memregCount];
            for (int j = 0; j < memregCount; ++j) {
                memRegArray[j] = new MemReg(-1);
            }
            this.memregs = memRegArray;
        }
        if ((memregs = regex.counters) > 0) {
            this.counters = new int[memregs];
        }
        if ((i = regex.lookaheads) > 0) {
            LAEntry[] counterCount = new LAEntry[i];
            for (int lookaheadCount = 0; lookaheadCount < i; ++lookaheadCount) {
                counterCount[lookaheadCount] = new LAEntry();
            }
            this.lookaheads = counterCount;
        }
        this.memregCount = memregCount;
        this.counterCount = var5_5;
        this.lookaheadCount = var6_6;
        this.first = new SearchEntry();
        this.defaultEntry = new SearchEntry();
        this.minQueueLength = regex.stringRepr.length() / 2;
    }

    public final void setTarget(Matcher m, int groupId) {
        MemReg mr = m.bounds(groupId);
        if (mr == null) {
            throw new IllegalArgumentException("group #" + groupId + " is not assigned");
        }
        this.data = m.data;
        this.offset = mr.in;
        this.end = mr.out;
        this.cache = m.cache;
        this.cacheLength = m.cacheLength;
        this.cacheOffset = m.cacheOffset;
        if (m != this) {
            this.shared = true;
            m.shared = true;
        }
        this.init();
    }

    public void setTarget(String text) {
        this.setTarget(text, 0, text.length());
    }

    public void setTarget(String text, int start, int len) {
        char[] mychars = this.data;
        if (mychars == null || this.shared || mychars.length < len) {
            this.data = mychars = new char[(int)(1.7f * (float)len)];
            this.shared = false;
        }
        text.getChars(start, len, mychars, 0);
        this.offset = 0;
        this.end = len;
        this.cache = text;
        this.cacheOffset = -start;
        this.cacheLength = text.length();
        this.init();
    }

    public void setTarget(char[] text, int start, int len) {
        this.setTarget(text, start, len, true);
    }

    public final void setTarget(char[] text, int start, int len, boolean shared) {
        this.cache = null;
        this.data = text;
        this.offset = start;
        this.end = start + len;
        this.shared = shared;
        this.init();
    }

    public void setTarget(Reader in, int len) throws IOException {
        int c;
        if (len < 0) {
            this.setAll(in);
            return;
        }
        char[] mychars = this.data;
        boolean shared = this.shared;
        if (mychars == null || shared || mychars.length < len) {
            mychars = new char[len];
            shared = false;
        }
        int count = 0;
        while ((c = in.read(mychars, count, len)) >= 0) {
            count += c;
            if ((len -= c) != 0) continue;
        }
        this.setTarget(mychars, 0, count, shared);
    }

    private void setAll(Reader in) throws IOException {
        int c;
        boolean free;
        int shared;
        char[] mychars = this.data;
        boolean bl = this.shared;
        if (mychars == null || bl) {
            shared = 1024;
            mychars = new char[1024];
            free = false;
        } else {
            shared = mychars.length;
        }
        int count = 0;
        while ((c = in.read(mychars, count, shared)) >= 0) {
            count += c;
            if ((shared -= c) != 0) continue;
            int newsize = count * 3;
            char[] newchars = new char[newsize];
            System.arraycopy(mychars, 0, newchars, 0, count);
            mychars = newchars;
            shared = newsize - count;
            free = false;
        }
        this.setTarget(mychars, 0, count, free);
    }

    private final String getString(int start, int end) {
        String src = this.cache;
        if (src != null) {
            int co = this.cacheOffset;
            return src.substring(start - co, end - co);
        }
        int tEnd = this.end;
        int tOffset = this.offset;
        int tLen = tEnd - tOffset;
        char[] data = this.data;
        if (end - start >= tLen / 3) {
            this.cache = src = new String(data, tOffset, tLen);
            this.cacheOffset = tOffset;
            this.cacheLength = tLen;
            return src.substring(start - tOffset, end - tOffset);
        }
        return new String(data, start, end - start);
    }

    public final boolean matchesPrefix() {
        this.setPosition(0);
        return this.search(13);
    }

    public final boolean isStart() {
        return this.matchesPrefix();
    }

    public final boolean matches() {
        if (this.called) {
            this.setPosition(0);
        }
        return this.search(5);
    }

    public final boolean matches(String s) {
        this.setTarget(s);
        return this.search(5);
    }

    public void setPosition(int pos) {
        this.wOffset = this.offset + pos;
        this.wEnd = -1;
        this.called = false;
        this.flush();
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.wOffset = offset;
        this.wEnd = -1;
        this.called = false;
        this.flush();
    }

    public final boolean find() {
        if (this.called) {
            this.skip();
        }
        return this.search(0);
    }

    public final boolean find(int anchors) {
        if (this.called) {
            this.skip();
        }
        return this.search(anchors);
    }

    public MatchIterator findAll() {
        return this.findAll(0);
    }

    public MatchIterator findAll(final int options) {
        return new MatchIterator(){
            private boolean checked = false;
            private boolean hasMore = false;

            @Override
            public boolean hasMore() {
                if (!this.checked) {
                    this.check();
                }
                return this.hasMore;
            }

            @Override
            public MatchResult nextMatch() {
                if (!this.checked) {
                    this.check();
                }
                if (!this.hasMore) {
                    throw new NoSuchElementException();
                }
                this.checked = false;
                return Matcher.this;
            }

            private final void check() {
                this.hasMore = Matcher.this.find(options);
                this.checked = true;
            }

            @Override
            public int count() {
                if (!this.checked) {
                    this.check();
                }
                if (!this.hasMore) {
                    return 0;
                }
                int c = 1;
                while (Matcher.this.find(options)) {
                    ++c;
                }
                this.checked = false;
                return c;
            }
        };
    }

    public final boolean proceed() {
        return this.proceed(0);
    }

    public final boolean proceed(int options) {
        if (this.called && this.top == null) {
            ++this.wOffset;
        }
        return this.search(0);
    }

    public final void skip() {
        int we = this.wEnd;
        if (this.wOffset == we) {
            if (this.top == null) {
                ++this.wOffset;
                this.flush();
            }
            return;
        }
        this.wOffset = we < 0 ? 0 : we;
        this.flush();
    }

    private final void init() {
        this.wOffset = this.offset;
        this.wEnd = -1;
        this.called = false;
        this.flush();
    }

    private final void flush() {
        MemReg mr;
        int i;
        this.top = null;
        this.defaultEntry.reset(0);
        this.first.reset(this.minQueueLength);
        for (i = this.memregs.length - 1; i > 0; --i) {
            mr = this.memregs[i];
            mr.out = -1;
            mr.in = -1;
        }
        for (i = this.memregs.length - 1; i > 0; --i) {
            mr = this.memregs[i];
            mr.out = -1;
            mr.in = -1;
        }
        this.called = false;
    }

    private final void rflush() {
        SearchEntry entry = this.top;
        this.top = null;
        MemReg[] memregs = this.memregs;
        int[] counters = this.counters;
        while (entry != null) {
            SearchEntry next = entry.sub;
            SearchEntry.popState(entry, memregs, counters);
            entry = next;
        }
        SearchEntry.popState(this.defaultEntry, memregs, counters);
    }

    public String toString() {
        return this.getString(this.wOffset, this.wEnd);
    }

    @Override
    public Pattern pattern() {
        return this.re;
    }

    @Override
    public String target() {
        return this.getString(this.offset, this.end);
    }

    @Override
    public char[] targetChars() {
        this.shared = true;
        return this.data;
    }

    @Override
    public int targetStart() {
        return this.offset;
    }

    @Override
    public int targetEnd() {
        return this.end;
    }

    @Override
    public char charAt(int i) {
        int in = this.wOffset;
        int out = this.wEnd;
        if (in < 0 || out < in) {
            throw new IllegalStateException("unassigned");
        }
        return this.data[in + i];
    }

    @Override
    public char charAt(int i, int groupId) {
        MemReg mr = this.bounds(groupId);
        if (mr == null) {
            throw new IllegalStateException("group #" + groupId + " is not assigned");
        }
        int in = mr.in;
        if (i < 0 || i > mr.out - in) {
            throw new StringIndexOutOfBoundsException("" + i);
        }
        return this.data[in + i];
    }

    @Override
    public final int length() {
        return this.wEnd - this.wOffset;
    }

    @Override
    public final int start() {
        return this.wOffset - this.offset;
    }

    @Override
    public final int end() {
        return this.wEnd - this.offset;
    }

    @Override
    public String prefix() {
        return this.getString(this.offset, this.wOffset);
    }

    @Override
    public String suffix() {
        return this.getString(this.wEnd, this.end);
    }

    @Override
    public int groupCount() {
        return this.memregs.length;
    }

    @Override
    public String group(int n) {
        MemReg mr = this.bounds(n);
        if (mr == null) {
            return null;
        }
        return this.getString(mr.in, mr.out);
    }

    @Override
    public String group(String name) {
        Integer id = this.re.groupId(name);
        if (id == null) {
            throw new IllegalArgumentException("<" + name + "> isn't defined");
        }
        return this.group(id);
    }

    @Override
    public boolean getGroup(int n, TextBuffer tb) {
        MemReg mr = this.bounds(n);
        if (mr == null) {
            return false;
        }
        int in = mr.in;
        tb.append(this.data, in, mr.out - in);
        return true;
    }

    @Override
    public boolean getGroup(String name, TextBuffer tb) {
        Integer id = this.re.groupId(name);
        if (id == null) {
            throw new IllegalArgumentException("unknown group: \"" + name + "\"");
        }
        return this.getGroup((int)id, tb);
    }

    @Override
    public boolean getGroup(int n, StringBuffer sb) {
        MemReg mr = this.bounds(n);
        if (mr == null) {
            return false;
        }
        int in = mr.in;
        sb.append(this.data, in, mr.out - in);
        return true;
    }

    @Override
    public boolean getGroup(String name, StringBuffer sb) {
        Integer id = this.re.groupId(name);
        if (id == null) {
            throw new IllegalArgumentException("unknown group: \"" + name + "\"");
        }
        return this.getGroup((int)id, sb);
    }

    /*
     * WARNING - void declaration
     */
    public String[] groups() {
        MemReg[] memregs = this.memregs;
        String[] groups = new String[memregs.length];
        int n = 0;
        while (n < memregs.length) {
            void in;
            void out;
            MemReg memReg = memregs[n];
            int mr = memReg.in;
            int i = memReg.out;
            mr = out.in;
            if (mr >= 0 && out.out >= mr) {
                groups[in] = this.getString(mr, i);
            }
            ++in;
        }
        return groups;
    }

    public Vector groupv() {
        MemReg[] memregs = this.memregs;
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < memregs.length; ++i) {
            MemReg memReg = this.bounds(i);
            if (memReg == null) {
                v.addElement("empty");
                continue;
            }
            String mr = this.getString(memReg.in, memReg.out);
            v.addElement(mr);
        }
        return v;
    }

    private final MemReg bounds(int id) {
        MemReg mr;
        if (id >= 0) {
            mr = this.memregs[id];
        } else {
            switch (id) {
                case -1: {
                    mr = this.prefixBounds;
                    if (mr == null) {
                        this.prefixBounds = mr = new MemReg(-1);
                    }
                    mr.in = this.offset;
                    mr.out = this.wOffset;
                    break;
                }
                case -2: {
                    mr = this.suffixBounds;
                    if (mr == null) {
                        this.suffixBounds = mr = new MemReg(-2);
                    }
                    mr.in = this.wEnd;
                    mr.out = this.end;
                    break;
                }
                case -3: {
                    mr = this.targetBounds;
                    if (mr == null) {
                        this.targetBounds = mr = new MemReg(-3);
                    }
                    mr.in = this.offset;
                    mr.out = this.end;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal group id: " + id + "; must either nonnegative int, or MatchResult.PREFIX, or MatchResult.SUFFIX");
                }
            }
        }
        int in = mr.in;
        if (in < 0 || mr.out < in) {
            return null;
        }
        return mr;
    }

    @Override
    public final boolean isCaptured() {
        return this.wOffset >= 0 && this.wEnd >= this.wOffset;
    }

    @Override
    public final boolean isCaptured(int id) {
        return this.bounds(id) != null;
    }

    @Override
    public final boolean isCaptured(String groupName) {
        Integer id = this.re.groupId(groupName);
        if (id == null) {
            throw new IllegalArgumentException("unknown group: \"" + groupName + "\"");
        }
        return this.isCaptured(id);
    }

    @Override
    public final int length(int id) {
        MemReg mr = this.bounds(id);
        return mr.out - mr.in;
    }

    @Override
    public final int start(int id) {
        return this.bounds((int)id).in - this.offset;
    }

    @Override
    public final int end(int id) {
        return this.bounds((int)id).out - this.offset;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean search(int anchors) {
        int re;
        Term allowIncomplete;
        this.called = true;
        int end = this.end;
        int offset = this.offset;
        char[] data = this.data;
        int wOffset = this.wOffset;
        int wEnd = this.wEnd;
        MemReg[] memregs = this.memregs;
        int[] counters = this.counters;
        LAEntry[] lookaheads = this.lookaheads;
        int memregCount = this.memregCount;
        int cntCount = this.counterCount;
        SearchEntry defaultEntry = this.defaultEntry;
        SearchEntry first = this.first;
        SearchEntry top = this.top;
        SearchEntry actual = null;
        boolean bl = (anchors & 4) > 0;
        boolean bl2 = (anchors & 8) > 0;
        Pattern pattern = this.re;
        Term matchEnd = pattern.root;
        if (top == null) {
            if ((anchors & 1) > 0) {
                allowIncomplete = pattern.root0;
                matchEnd = startAnchor;
            } else if ((anchors & 2) > 0) {
                allowIncomplete = pattern.root0;
                matchEnd = lastMatchAnchor;
            } else {
                allowIncomplete = matchEnd;
            }
            re = wOffset;
            actual = first;
            SearchEntry.popState(defaultEntry, memregs, counters);
        } else {
            actual = top;
            top = actual.sub;
            allowIncomplete = actual.term;
            re = actual.index;
            SearchEntry.popState(actual, memregs, counters);
        }
        int root = actual.cnt;
        int term = actual.regLen;
        block56: while (wOffset <= end) {
            block57: while (true) {
                void regLen;
                switch (allowIncomplete.type) {
                    case 8: {
                        int n = Matcher.find(data, re + allowIncomplete.distance, end, allowIncomplete.target);
                        if (n < 0) break block56;
                        wOffset = re += n;
                        if (allowIncomplete.eat) {
                            if (re == end) break;
                            ++re;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 9: {
                        MemReg memReg = memregs[allowIncomplete.target.memreg];
                        int n = memReg.in;
                        int n2 = memReg.out - n;
                        if (n < 0 || n2 < 0) break;
                        if (n2 == 0) {
                            allowIncomplete = allowIncomplete.next;
                            continue block57;
                        }
                        int mr = Matcher.findReg(data, re + allowIncomplete.distance, n, n2, allowIncomplete.target, end);
                        if (mr < 0) break block56;
                        wOffset = re += mr;
                        if (allowIncomplete.eat && (re += n2) > end) break;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 17: {
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 0: {
                        if (re >= end || data[re] != allowIncomplete.c) break;
                        ++re;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 4: {
                        if (re >= end) break;
                        ++re;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 5: {
                        if (re >= end || data[re] == '\n') break;
                        ++re;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 19: {
                        if (re < end) break;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 20: {
                        if (re >= end) {
                            allowIncomplete = allowIncomplete.next;
                            continue block57;
                        }
                        boolean bl3 = re >= end | (re + 1 == end && data[re] == '\n');
                        if (!bl3) break;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 22: {
                        if (re >= end) {
                            allowIncomplete = allowIncomplete.next;
                            continue block57;
                        }
                        if (data[re] != '\n') break;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 18: {
                        if (re == offset) {
                            allowIncomplete = allowIncomplete.next;
                            continue block57;
                        }
                        if (top == null && allowIncomplete == startAnchor) break block56;
                        break;
                    }
                    case 23: {
                        if (re != wEnd && wEnd != -1) break block56;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 21: {
                        char sampleOff;
                        if (re == offset) {
                            allowIncomplete = allowIncomplete.next;
                            continue block57;
                        }
                        if (re >= end || (sampleOff = data[re - 1]) != '\n') break;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 1: {
                        char sampleOff;
                        if (re >= end || ((sampleOff = data[re]) > '\u00ff' || !allowIncomplete.bitset[sampleOff]) ^ allowIncomplete.inverse) break;
                        ++re;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 2: {
                        boolean[] blArray;
                        char sampleOff;
                        if (re >= end || (blArray = allowIncomplete.bitset2[(sampleOff = data[re]) >> 8]) == null || !blArray[sampleOff & 0xFF] ^ allowIncomplete.inverse) break;
                        ++re;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 11: {
                        char ch2Meets;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        boolean[] c = allowIncomplete.bitset;
                        int ch1Meets = re - 1;
                        if (ch1Meets >= offset) {
                            ch2Meets = data[ch1Meets];
                            boolean bl6 = bl4 = ch2Meets < '\u0100' && c[ch2Meets];
                        }
                        if (re < end) {
                            ch2Meets = data[re];
                            boolean bl7 = bl5 = ch2Meets < '\u0100' && c[ch2Meets];
                        }
                        if (!(bl4 ^ bl5 ^ allowIncomplete.inverse)) break;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 13: {
                        char ch2Meets;
                        boolean bl8 = false;
                        boolean bl9 = false;
                        boolean[][] c = allowIncomplete.bitset2;
                        int ch1Meets2 = re - 1;
                        if (ch1Meets2 >= offset) {
                            ch2Meets = data[ch1Meets2];
                            boolean[] bitset2 = c[ch2Meets >> 8];
                            boolean bl10 = bl8 = bitset2 != null && bitset2[ch2Meets & 0xFF];
                        }
                        if (re < end) {
                            ch2Meets = data[re];
                            boolean[] ch1Meets2 = c[ch2Meets >> 8];
                            boolean bl11 = bl9 = ch1Meets2 != null && ch1Meets2[ch2Meets & 0xFF];
                        }
                        if (!(bl8 ^ bl9 ^ allowIncomplete.inverse)) break;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 12: {
                        char ch2Meets;
                        boolean bl12 = false;
                        boolean bl13 = false;
                        boolean[] c = allowIncomplete.bitset;
                        boolean ch1Meets = allowIncomplete.inverse;
                        int bitset = re - 1;
                        if (bitset >= offset) {
                            ch2Meets = data[bitset];
                            boolean bl14 = bl12 = ch2Meets < '\u0100' && c[ch2Meets];
                        }
                        if (bl12 ^ ch1Meets) break;
                        if (re < end) {
                            ch2Meets = data[re];
                            bl13 = ch2Meets < '\u0100' && c[ch2Meets];
                        }
                        if (!bl13 ^ ch1Meets) break;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 14: {
                        boolean[] inv;
                        char ch2Meets;
                        boolean bl15 = false;
                        boolean bl16 = false;
                        boolean[][] c = allowIncomplete.bitset2;
                        boolean ch1Meets = allowIncomplete.inverse;
                        int bitset2 = re - 1;
                        if (bitset2 >= offset) {
                            ch2Meets = data[bitset2];
                            inv = c[ch2Meets >> 8];
                            boolean bl17 = bl15 = inv != null && inv[ch2Meets & 0xFF];
                        }
                        if (bl15 ^ ch1Meets) break;
                        if (re < end) {
                            ch2Meets = data[re];
                            inv = c[ch2Meets >> 8];
                            bl16 = inv != null && inv[ch2Meets & 0xFF];
                        }
                        if (!bl16 ^ ch1Meets) break;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 6: {
                        int mr;
                        MemReg memReg = memregs[allowIncomplete.memreg];
                        int n = memReg.in;
                        int n3 = memReg.out;
                        if (n < 0 || (mr = n3 - n) < 0) break;
                        if (mr == 0) {
                            allowIncomplete = allowIncomplete.next;
                            continue block57;
                        }
                        if (re + mr > end || !Matcher.compareRegions(data, n, re, mr, end)) break;
                        re += mr;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 7: {
                        int mr;
                        MemReg memReg = memregs[allowIncomplete.memreg];
                        int n = memReg.in;
                        int n4 = memReg.out;
                        if (n < 0 || (mr = n4 - n) < 0) break;
                        if (mr == 0) {
                            allowIncomplete = allowIncomplete.next;
                            continue block57;
                        }
                        if (re + mr > end || !Matcher.compareRegionsI(data, n, re, mr, end)) break;
                        re += mr;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 45: {
                        root = Matcher.repeat(data, re, end, allowIncomplete.target);
                        if (root <= 0) {
                            allowIncomplete = allowIncomplete.next;
                            continue block57;
                        }
                        actual.cnt = root;
                        actual.term = allowIncomplete.failNext;
                        actual.index = re += root;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 46: {
                        root = Matcher.repeat(data, re, end, allowIncomplete.target);
                        if (root < allowIncomplete.minCount) break;
                        actual.cnt = root;
                        actual.term = allowIncomplete.failNext;
                        actual.index = re += root;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 47: {
                        int n = end;
                        int n5 = re + allowIncomplete.maxCount;
                        root = Matcher.repeat(data, re, n < n5 ? n : n5, allowIncomplete.target);
                        if (root < allowIncomplete.minCount) break;
                        actual.cnt = root;
                        actual.term = allowIncomplete.failNext;
                        actual.index = re += root;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 48: {
                        int mr;
                        MemReg memReg = memregs[allowIncomplete.memreg];
                        int n = memReg.in;
                        int n6 = memReg.out;
                        if (n < 0 || (mr = n6 - n) < 0) break;
                        if (mr == 0) {
                            allowIncomplete = allowIncomplete.next;
                            continue block57;
                        }
                        root = 0;
                        while (Matcher.compareRegions(data, re, n, mr, end)) {
                            ++root;
                            re += mr;
                        }
                        if (root < allowIncomplete.minCount) break;
                        actual.cnt = root;
                        actual.term = allowIncomplete.failNext;
                        actual.index = re;
                        actual.regLen = mr;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 49: {
                        int mr;
                        MemReg memReg = memregs[allowIncomplete.memreg];
                        int n = memReg.in;
                        int n7 = memReg.out;
                        if (n < 0 || (mr = n7 - n) < 0) break;
                        if (mr == 0) {
                            allowIncomplete = allowIncomplete.next;
                            continue block57;
                        }
                        root = 0;
                        for (int sampleOutside = allowIncomplete.maxCount; sampleOutside > 0 && Matcher.compareRegions(data, re, n, mr, end); --sampleOutside) {
                            ++root;
                            re += mr;
                        }
                        if (root < allowIncomplete.minCount) break;
                        actual.cnt = root;
                        actual.term = allowIncomplete.failNext;
                        actual.index = re;
                        actual.regLen = mr;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 50: {
                        root = actual.cnt;
                        if (root <= 0) break;
                        actual.cnt = --root;
                        actual.index = --re;
                        actual.term = allowIncomplete;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 51: {
                        root = actual.cnt;
                        if (root <= allowIncomplete.minCount) break;
                        actual.cnt = --root;
                        actual.index = --re;
                        actual.term = allowIncomplete;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 52: {
                        int n;
                        root = actual.cnt;
                        int n8 = allowIncomplete.minCount;
                        if (root <= n8) break;
                        int n9 = re + allowIncomplete.distance;
                        if (n9 > end) {
                            int n10 = n9 - end;
                            if ((root -= n10) <= n8) break;
                            re -= n10;
                            n9 = end;
                        }
                        if ((n = Matcher.findBack(data, re + allowIncomplete.distance, root - n8, allowIncomplete.target)) < 0) break;
                        if ((root -= n) <= n8) {
                            re -= n;
                            if (allowIncomplete.eat) {
                                ++re;
                            }
                            allowIncomplete = allowIncomplete.next;
                            continue block57;
                        }
                        re -= n;
                        actual.cnt = root;
                        actual.index = re++;
                        if (allowIncomplete.eat) {
                            // empty if block
                        }
                        actual.term = allowIncomplete;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 53: {
                        int sampleOff;
                        root = actual.cnt;
                        int n = allowIncomplete.minCount;
                        if (root <= n) break;
                        int n11 = re + allowIncomplete.distance;
                        if (n11 > end) {
                            int n12 = n11 - end;
                            if ((root -= n12) <= n) break;
                            re -= n12;
                            n11 = end;
                        }
                        MemReg memReg = memregs[allowIncomplete.target.memreg];
                        int minCnt = memReg.in;
                        int mr = memReg.out - minCnt;
                        if (minCnt < 0 || mr < 0) {
                            actual.cnt = --root;
                            actual.index = --re;
                            actual.term = allowIncomplete;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            allowIncomplete = allowIncomplete.next;
                            continue block57;
                        }
                        if (mr == 0) {
                            sampleOff = 1;
                        } else {
                            sampleOff = Matcher.findBackReg(data, re + allowIncomplete.distance, minCnt, mr, root - n, allowIncomplete.target, end);
                            if (sampleOff < 0) break;
                        }
                        actual.cnt = root -= sampleOff;
                        actual.index = re -= sampleOff;
                        if (allowIncomplete.eat) {
                            re += mr;
                        }
                        actual.term = allowIncomplete;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 54: {
                        root = actual.cnt;
                        if (root <= allowIncomplete.minCount) break;
                        term = actual.regLen;
                        actual.cnt = --root;
                        actual.index = re -= term;
                        actual.term = allowIncomplete;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 15: {
                        int n = allowIncomplete.memreg;
                        if (n > 0) {
                            memregs[n].tmp = re;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 16: {
                        int n = allowIncomplete.memreg;
                        if (n > 0) {
                            MemReg memreg = memregs[n];
                            SearchEntry.saveMemregState(top != null ? top : defaultEntry, n, memreg);
                            memreg.in = memreg.tmp;
                            memreg.out = re;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 39: {
                        int memreg = re - allowIncomplete.distance;
                        if (memreg < offset) break;
                        LAEntry lAEntry = lookaheads[allowIncomplete.lookaheadId];
                        lAEntry.index = re;
                        re = memreg;
                        lAEntry.actual = actual;
                        lAEntry.top = top;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 35: 
                    case 43: {
                        LAEntry memreg = lookaheads[allowIncomplete.lookaheadId];
                        memreg.index = re;
                        memreg.actual = actual;
                        memreg.top = top;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 36: 
                    case 40: 
                    case 57: 
                    case 59: {
                        LAEntry memreg = lookaheads[allowIncomplete.lookaheadId];
                        re = memreg.index;
                        actual = memreg.actual;
                        top = memreg.top;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 44: {
                        LAEntry memreg = lookaheads[allowIncomplete.lookaheadId];
                        actual = memreg.actual;
                        top = memreg.top;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 41: {
                        int memreg = re - allowIncomplete.distance;
                        if (memreg < offset) {
                            allowIncomplete = allowIncomplete.failNext;
                            continue block57;
                        }
                        LAEntry lAEntry = lookaheads[allowIncomplete.lookaheadId];
                        lAEntry.actual = actual;
                        lAEntry.top = top;
                        actual.term = allowIncomplete.failNext;
                        actual.index = re;
                        re = memreg;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 37: {
                        LAEntry memreg = lookaheads[allowIncomplete.lookaheadId];
                        memreg.actual = actual;
                        memreg.top = top;
                        actual.term = allowIncomplete.failNext;
                        actual.index = re;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 38: 
                    case 42: {
                        LAEntry memreg = lookaheads[allowIncomplete.lookaheadId];
                        actual = memreg.actual;
                        top = memreg.top;
                        break;
                    }
                    case 58: {
                        int memreg = re - allowIncomplete.distance;
                        if (memreg < offset) {
                            allowIncomplete = allowIncomplete.failNext;
                            continue block57;
                        }
                        LAEntry lAEntry = lookaheads[allowIncomplete.lookaheadId];
                        lAEntry.index = re;
                        lAEntry.actual = actual;
                        lAEntry.top = top;
                        actual.term = allowIncomplete.failNext;
                        actual.index = re;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        re = memreg;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 56: {
                        LAEntry memreg = lookaheads[allowIncomplete.lookaheadId];
                        memreg.index = re;
                        memreg.actual = actual;
                        memreg.top = top;
                        actual.term = allowIncomplete.failNext;
                        actual.index = re;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 55: {
                        MemReg memreg = memregs[allowIncomplete.memreg];
                        int n = memreg.in;
                        int n13 = memreg.out;
                        if (n >= 0 && n13 >= 0 && n13 >= n) {
                            allowIncomplete = allowIncomplete.next;
                            continue block57;
                        }
                        allowIncomplete = allowIncomplete.failNext;
                        continue block57;
                    }
                    case 34: {
                        actual.regLen = term;
                    }
                    case 33: {
                        actual.cnt = root;
                    }
                    case 32: {
                        actual.term = allowIncomplete.failNext;
                        actual.index = re;
                        top = actual;
                        actual = top.on;
                        if (actual == null) {
                            top.on = actual = new SearchEntry();
                            actual.sub = top;
                        }
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 10: {
                        void cnt;
                        if (cnt != false && re != end) break;
                        this.wOffset = memregs[0].in = wOffset;
                        this.wEnd = memregs[0].out = re;
                        this.top = top;
                        return true;
                    }
                    case 24: {
                        root = 0;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 25: {
                        ++root;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 26: {
                        if (root < allowIncomplete.maxCount) break;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 27: {
                        root = actual.cnt;
                        if (root >= allowIncomplete.maxCount) break;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 28: {
                        int n = allowIncomplete.cntreg;
                        int memreg = counters[n];
                        SearchEntry.saveCntState(top != null ? top : defaultEntry, n, memreg);
                        counters[n] = ++memreg;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 29: {
                        counters[allowIncomplete.cntreg] = 0;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 30: {
                        if (counters[allowIncomplete.cntreg] >= allowIncomplete.maxCount) break;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    case 31: {
                        if (counters[allowIncomplete.cntreg] < allowIncomplete.maxCount) break;
                        allowIncomplete = allowIncomplete.next;
                        continue block57;
                    }
                    default: {
                        throw new Error("unknown term type: " + allowIncomplete.type);
                    }
                }
                if (regLen != false && re == end) {
                    return true;
                }
                if (top == null) break;
                actual = top;
                top = actual.sub;
                allowIncomplete = actual.term;
                re = actual.index;
                if (!actual.isState) continue;
                SearchEntry.popState(actual, memregs, counters);
            }
            if (defaultEntry.isState) {
                SearchEntry.popState(defaultEntry, memregs, counters);
            }
            allowIncomplete = matchEnd;
            re = ++wOffset;
        }
        this.wOffset = wOffset;
        this.top = top;
        return false;
    }

    private static final boolean compareRegions(char[] arr, int off1, int off2, int len, int out) {
        int p1 = off1 + len - 1;
        int p2 = off2 + len - 1;
        if (p1 >= out || p2 >= out) {
            return false;
        }
        int c = len;
        while (c > 0) {
            if (arr[p1] != arr[p2]) {
                return false;
            }
            --c;
            --p1;
            --p2;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean compareRegionsI(char[] arr, int off1, int off2, int len, int out) {
        int p1 = off1 + len - 1;
        int p2 = off2 + len - 1;
        if (p1 >= out || p2 >= out) {
            return false;
        }
        int n = len;
        while (n > 0) {
            void c1;
            void c2;
            char c = arr[p1];
            char c3 = arr[p2];
            if (c != Character.toLowerCase(c3) && c2 != Character.toUpperCase(c3) && c2 != Character.toTitleCase(c3)) {
                return false;
            }
            --c1;
            --p1;
            --p2;
        }
        return true;
    }

    private static final int repeat(char[] data, int off, int out, Term term) {
        switch (term.type) {
            case 0: {
                int i;
                char c = term.c;
                for (i = off; i < out && data[i] == c; ++i) {
                }
                return i - off;
            }
            case 4: {
                return out - off;
            }
            case 5: {
                int i;
                for (i = off; i < out && data[i] != '\n'; ++i) {
                }
                return i - off;
            }
            case 1: {
                int i;
                boolean[] arr = term.bitset;
                if (term.inverse) {
                    char c;
                    for (i = off; !(i >= out || (c = data[i]) <= '\u00ff' && arr[c]); ++i) {
                    }
                } else {
                    char c;
                    while (i < out && (c = data[i]) <= '\u00ff' && arr[c]) {
                        ++i;
                    }
                }
                return i - off;
            }
            case 2: {
                int i;
                boolean[][] bitset2 = term.bitset2;
                if (term.inverse) {
                    char c;
                    boolean[] arr;
                    for (i = off; !(i >= out || (arr = bitset2[(c = data[i]) >> 8]) != null && arr[c & 0xFF]); ++i) {
                    }
                } else {
                    char c;
                    boolean[] arr;
                    while (i < out && (arr = bitset2[(c = data[i]) >> 8]) != null && arr[c & 0xFF]) {
                        ++i;
                    }
                }
                return i - off;
            }
        }
        throw new Error("this kind of term can't be quantified:" + term.type);
    }

    private static final int find(char[] data, int off, int out, Term term) {
        if (off >= out) {
            return -1;
        }
        switch (term.type) {
            case 0: {
                int i;
                char c = term.c;
                for (i = off; i < out && data[i] != c; ++i) {
                }
                return i - off;
            }
            case 1: {
                int i;
                boolean[] arr = term.bitset;
                if (!term.inverse) {
                    char c;
                    for (i = off; !(i >= out || (c = data[i]) <= '\u00ff' && arr[c]); ++i) {
                    }
                } else {
                    char c;
                    while (i < out && (c = data[i]) <= '\u00ff' && arr[c]) {
                        ++i;
                    }
                }
                return i - off;
            }
            case 2: {
                int i;
                boolean[][] bitset2 = term.bitset2;
                if (!term.inverse) {
                    char c;
                    boolean[] arr;
                    for (i = off; !(i >= out || (arr = bitset2[(c = data[i]) >> 8]) != null && arr[c & 0xFF]); ++i) {
                    }
                } else {
                    char c;
                    boolean[] arr;
                    while (i < out && (arr = bitset2[(c = data[i]) >> 8]) != null && arr[c & 0xFF]) {
                        ++i;
                    }
                }
                return i - off;
            }
        }
        throw new IllegalArgumentException("can't seek this kind of term:" + term.type);
    }

    private static final int findReg(char[] data, int off, int regOff, int regLen, Term term, int out) {
        int i;
        if (off >= out) {
            return -1;
        }
        if (term.type == 6) {
            for (i = off; i < out && !Matcher.compareRegions(data, i, regOff, regLen, out); ++i) {
            }
        } else if (term.type == 7) {
            while (i < out && !Matcher.compareRegionsI(data, i, regOff, regLen, out)) {
                ++i;
            }
        } else {
            throw new IllegalArgumentException("wrong findReg() target:" + term.type);
        }
        return off - i;
    }

    private static final int findBack(char[] data, int off, int maxCount, Term term) {
        switch (term.type) {
            case 0: {
                char c = term.c;
                int i = off;
                int iMin = off - maxCount;
                while (data[--i] != c) {
                    if (i > iMin) continue;
                    return -1;
                }
                return off - i;
            }
            case 1: {
                boolean[] arr = term.bitset;
                int i = off;
                int iMin = off - maxCount;
                if (!term.inverse) {
                    char c;
                    while ((c = data[--i]) > '\u00ff' || !arr[c]) {
                        if (i > iMin) continue;
                        return -1;
                    }
                } else {
                    char c;
                    while ((c = data[--i]) <= '\u00ff' && arr[c]) {
                        if (i > iMin) continue;
                        return -1;
                    }
                }
                return off - i;
            }
            case 2: {
                boolean[][] bitset2 = term.bitset2;
                int i = off;
                int iMin = off - maxCount;
                if (!term.inverse) {
                    char c;
                    boolean[] arr;
                    while ((arr = bitset2[(c = data[--i]) >> 8]) == null || !arr[c & 0xFF]) {
                        if (i > iMin) continue;
                        return -1;
                    }
                } else {
                    char c;
                    boolean[] arr;
                    while ((arr = bitset2[(c = data[--i]) >> 8]) != null && !arr[c & 0xFF]) {
                        if (i > iMin) continue;
                        return -1;
                    }
                }
                return off - i;
            }
        }
        throw new IllegalArgumentException("can't find this kind of term:" + term.type);
    }

    private static final int findBackReg(char[] data, int off, int regOff, int regLen, int maxCount, Term term, int out) {
        int i = off;
        int iMin = off - maxCount;
        if (term.type == 6) {
            char first = data[regOff];
            ++regOff;
            --regLen;
            while (data[--i] != first || !Matcher.compareRegions(data, i + 1, regOff, regLen, out)) {
                if (i > iMin) continue;
                return -1;
            }
        } else {
            if (term.type == 7) {
                char c = data[regOff];
                char firstLower = Character.toLowerCase(c);
                char firstUpper = Character.toUpperCase(c);
                char firstTitle = Character.toTitleCase(c);
                ++regOff;
                --regLen;
                while ((c = data[--i]) != firstLower && c != firstUpper && c != firstTitle || !Matcher.compareRegionsI(data, i + 1, regOff, regLen, out)) {
                    if (i > iMin) continue;
                    return -1;
                }
                return off - i;
            }
            throw new IllegalArgumentException("wrong findBackReg() target type :" + term.type);
        }
        return off - i;
    }

    public String toString_d() {
        StringBuffer s = new StringBuffer();
        s.append("counters: ");
        s.append(this.counters == null ? 0 : this.counters.length);
        s.append("\r\nmemregs: ");
        s.append(this.memregs.length);
        for (int i = 0; i < this.memregs.length; ++i) {
            s.append("\r\n #" + i + ": [" + this.memregs[i].in + "," + this.memregs[i].out + "](\"" + this.getString(this.memregs[i].in, this.memregs[i].out) + "\")");
        }
        s.append("\r\ndata: ");
        if (this.data != null) {
            s.append(this.data.length);
        } else {
            s.append("[none]");
        }
        s.append("\r\noffset: ");
        s.append(this.offset);
        s.append("\r\nend: ");
        s.append(this.end);
        s.append("\r\nwOffset: ");
        s.append(this.wOffset);
        s.append("\r\nwEnd: ");
        s.append(this.wEnd);
        s.append("\r\nregex: ");
        s.append(this.re);
        return s.toString();
    }
}

