/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Convert;
import org.jruby.util.TypeConverter;

public class Sprintf {
    private static final int FLAG_NONE = 0;
    private static final int FLAG_SPACE = 1;
    private static final int FLAG_ZERO = 2;
    private static final int FLAG_PLUS = 4;
    private static final int FLAG_MINUS = 8;
    private static final int FLAG_SHARP = 16;
    private static final int FLAG_WIDTH = 32;
    private static final int FLAG_PRECISION = 64;
    private static final byte[] PREFIX_OCTAL = new byte[]{48};
    private static final byte[] PREFIX_HEX_LC = new byte[]{48, 120};
    private static final byte[] PREFIX_HEX_UC = new byte[]{48, 88};
    private static final byte[] PREFIX_BINARY_LC = new byte[]{48, 98};
    private static final byte[] PREFIX_BINARY_UC = new byte[]{48, 66};
    private static final byte[] PREFIX_NEGATIVE = new byte[]{46, 46};
    private static final byte[] NAN_VALUE = new byte[]{78, 97, 78};
    private static final byte[] INFINITY_VALUE = new byte[]{73, 110, 102};
    private static final BigInteger BIG_32 = BigInteger.valueOf(0x100000000L);
    private static final BigInteger BIG_64 = BIG_32.shiftLeft(32);
    private static final BigInteger BIG_MINUS_32 = BigInteger.valueOf(-4294967296L);
    private static final BigInteger BIG_MINUS_64 = BIG_MINUS_32.shiftLeft(32);
    private static final int INITIAL_BUFFER_SIZE = 32;
    private static final String ERR_MALFORMED_FORMAT = "malformed format string";
    private static final String ERR_MALFORMED_NUM = "malformed format string - %[0-9]";
    private static final String ERR_MALFORMED_DOT_NUM = "malformed format string - %.[0-9]";
    private static final String ERR_MALFORMED_STAR_NUM = "malformed format string - %*[0-9]";
    private static final String ERR_ILLEGAL_FORMAT_CHAR = "illegal format character - %";

    private Sprintf() {
    }

    public static CharSequence sprintf(Locale locale, CharSequence format, IRubyObject args) {
        return Sprintf.rubySprintf(format, new Args(locale, args));
    }

    public static RubyString sprintf(Ruby runtime, Locale locale, CharSequence format, IRubyObject args) {
        Buffer b = Sprintf.rubySprintfToBuffer(format, new Args(locale, args));
        RubyString s = runtime.newString(b.toByteList());
        if (b.tainted) {
            s.setTaint(true);
        }
        return s;
    }

    public static CharSequence sprintf(CharSequence format, IRubyObject args) {
        return Sprintf.rubySprintf(format, new Args(args));
    }

    public static CharSequence sprintf(Ruby runtime, CharSequence format, int arg) {
        return Sprintf.rubySprintf(format, new Args(runtime, arg));
    }

    public static CharSequence sprintf(Ruby runtime, CharSequence format, long arg) {
        return Sprintf.rubySprintf(format, new Args(runtime, arg));
    }

    public static CharSequence sprintf(Locale locale, RubyString format, IRubyObject args) {
        return Sprintf.rubySprintf(format.getByteList(), new Args(locale, args));
    }

    public static CharSequence sprintf(RubyString format, IRubyObject args) {
        return Sprintf.rubySprintf(format.getByteList(), new Args(args));
    }

    private static CharSequence rubySprintf(CharSequence charFormat, Args args) {
        return Sprintf.rubySprintfToBuffer(charFormat, args).toByteList();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Buffer rubySprintfToBuffer(CharSequence charFormat, Args args) {
        var2_2 = new Buffer();
        if (charFormat instanceof ByteList) {
            buf = (ByteList)charFormat;
            var4_4 = buf.unsafeBytes();
            var6_6 = var5_5 = buf.begin();
            var7_7 = var5_5 + buf.length();
            list = length;
            begin = length;
        } else {
            offset = Sprintf.stringToBytes(charFormat, false);
            start = 0;
            mark = charFormat.length();
            list = 0;
            begin = false;
        }
        while (start < mark) {
            list = start;
            while (start < mark && offset[start] != 37) {
                ++start;
            }
            if (start > list) {
                format.write(offset, list, start - list);
                list = start;
            }
            if (start++ >= mark) break;
            buf = null;
            length = 0;
            width = 0;
            precision = 0;
            number = 0;
            fchar = 0;
            incomplete = true;
            block59: while (incomplete && start < mark) {
                fchar = offset[start];
                switch (fchar) {
                    default: {
                        if (fchar == 0 && length == 0) {
                            format.write(37);
                            format.write(fchar);
                            incomplete = false;
                            ++start;
                            continue block59;
                        }
                        if (Sprintf.isPrintable(fchar)) {
                            Sprintf.raiseArgumentError(args, "malformed format string - %" + (char)fchar);
                            continue block59;
                        }
                        Sprintf.raiseArgumentError(args, "malformed format string");
                        continue block59;
                    }
                    case 32: {
                        length |= 1;
                        ++start;
                        continue block59;
                    }
                    case 48: {
                        length |= 2;
                        ++start;
                        continue block59;
                    }
                    case 43: {
                        length |= 4;
                        ++start;
                        continue block59;
                    }
                    case 45: {
                        length |= 8;
                        ++start;
                        continue block59;
                    }
                    case 35: {
                        length |= 16;
                        ++start;
                        continue block59;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        number = 0;
                        while (start < mark && Sprintf.isDigit(fchar = offset[start])) {
                            number = Sprintf.extendWidth(args, number, fchar);
                            ++start;
                        }
                        Sprintf.checkOffset(args, start, mark, "malformed format string - %[0-9]");
                        if (fchar == 36) {
                            if (buf != null) {
                                Sprintf.raiseArgumentError(args, "value given twice - " + number + "$");
                            }
                            buf = args.getNth(number);
                            ++start;
                            continue block59;
                        }
                        width = number;
                        length |= 32;
                        continue block59;
                    }
                    case 42: {
                        if ((length & 32) != 0) {
                            Sprintf.raiseArgumentError(args, "width given twice");
                        }
                        length |= 32;
                        Sprintf.checkOffset(args, ++start, mark, "malformed format string - %*[0-9]");
                        flags = start;
                        number = 0;
                        while (start < mark && Sprintf.isDigit(fchar = offset[start])) {
                            number = Sprintf.extendWidth(args, number, fchar);
                            ++start;
                        }
                        Sprintf.checkOffset(args, start, mark, "malformed format string - %*[0-9]");
                        if (fchar == 36) {
                            width = args.getNthInt(number);
                            if (width < 0) {
                                length |= 8;
                                width = -width;
                            }
                            ++start;
                            continue block59;
                        }
                        width = args.nextInt();
                        if (width < 0) {
                            length |= 8;
                            width = -width;
                        }
                        start = flags;
                        continue block59;
                    }
                    case 46: {
                        if ((length & 64) != 0) {
                            Sprintf.raiseArgumentError(args, "precision given twice");
                        }
                        length |= 64;
                        Sprintf.checkOffset(args, ++start, mark, "malformed format string - %.[0-9]");
                        fchar = offset[start];
                        if (fchar == 42) {
                            Sprintf.checkOffset(args, ++start, mark, "malformed format string - %*[0-9]");
                            flags = start;
                            number = 0;
                            while (start < mark && Sprintf.isDigit(fchar = offset[start])) {
                                number = Sprintf.extendWidth(args, number, fchar);
                                ++start;
                            }
                            Sprintf.checkOffset(args, start, mark, "malformed format string - %*[0-9]");
                            if (fchar == 36) {
                                precision = args.getNthInt(number);
                                if (precision < 0) {
                                    length &= -65;
                                }
                                ++start;
                                continue block59;
                            }
                            precision = args.nextInt();
                            if (precision < 0) {
                                length &= -65;
                            }
                            start = flags;
                            continue block59;
                        }
                        number = 0;
                        while (start < mark && Sprintf.isDigit(fchar = offset[start])) {
                            number = Sprintf.extendWidth(args, number, fchar);
                            ++start;
                        }
                        Sprintf.checkOffset(args, start, mark, "malformed format string - %.[0-9]");
                        precision = number;
                        continue block59;
                    }
                    case 10: {
                        --start;
                    }
                    case 37: {
                        if (length != 0) {
                            Sprintf.raiseArgumentError(args, "illegal format character - %");
                        }
                        format.write(37);
                        ++start;
                        incomplete = false;
                        continue block59;
                    }
                    case 99: {
                        if (buf == null) {
                            buf = args.next();
                        }
                        c = 0;
                        if (buf instanceof RubyString) {
                            bytes = ((RubyString)buf).getByteList();
                            if (bytes.length() == 1) {
                                c = bytes.unsafeBytes()[bytes.begin()];
                            } else {
                                Sprintf.raiseArgumentError(args, "%c requires a character");
                            }
                        } else {
                            c = args.intValue((IRubyObject)buf);
                        }
                        if ((length & 32) != 0 && width > 1) {
                            if ((length & 8) != 0) {
                                format.write(c);
                                format.fill(32, width - 1);
                            } else {
                                format.fill(32, width - 1);
                                format.write(c);
                            }
                        } else {
                            format.write(c);
                        }
                        ++start;
                        incomplete = false;
                        continue block59;
                    }
                    case 112: 
                    case 115: {
                        if (buf == null) {
                            buf = args.next();
                        }
                        if (fchar == 112) {
                            buf = buf.callMethod(buf.getRuntime().getCurrentContext(), "inspect");
                        }
                        bytes = buf.asString().getByteList();
                        len = bytes.length();
                        if (buf.isTaint()) {
                            Buffer.access$002((Buffer)format, true);
                        }
                        if ((length & 64) != 0 && precision < len) {
                            len = precision;
                        }
                        if ((length & 32) != 0 && width > len) {
                            width -= len;
                            if ((length & 8) != 0) {
                                format.write(bytes.unsafeBytes(), bytes.begin(), len);
                                format.fill(32, width);
                            } else {
                                format.fill(32, width);
                                format.write(bytes.unsafeBytes(), bytes.begin(), len);
                            }
                        } else {
                            format.write(bytes.unsafeBytes(), bytes.begin(), len);
                        }
                        ++start;
                        incomplete = false;
                        continue block59;
                    }
                    case 66: 
                    case 88: 
                    case 98: 
                    case 100: 
                    case 105: 
                    case 111: 
                    case 117: 
                    case 120: {
                        if (buf == null) {
                            buf = args.next();
                        }
                        if ((type = buf.getMetaClass().index) != 1 && type != 2) {
                            switch (type) {
                                case 11: {
                                    buf = RubyNumeric.dbl2num(buf.getRuntime(), ((RubyFloat)buf).getValue());
                                    break;
                                }
                                case 4: {
                                    buf = RubyNumeric.str2inum(buf.getRuntime(), (RubyString)buf, 0, true);
                                    break;
                                }
                                default: {
                                    buf = buf.respondsTo("to_int") != false ? TypeConverter.convertToType((IRubyObject)buf, buf.getRuntime().getInteger(), MethodIndex.TO_INT, "to_int", true) : TypeConverter.convertToType((IRubyObject)buf, buf.getRuntime().getInteger(), MethodIndex.TO_I, "to_i", true);
                                }
                            }
                            type = buf.getMetaClass().index;
                        }
                        bytes = null;
                        first = 0;
                        prefix = null;
                        var19_23 = false;
                        var20_24 = false;
                        if (fchar == 105) {
                            fchar = 100;
                        }
                        if (fchar == 117 && (length & 5) != 0) {
                            fchar = 100;
                        }
                        signChar = fchar == 100 || (length & 5) != 0;
                        switch (fchar) {
                            case 111: {
                                leadChar = 8;
                                break;
                            }
                            case 88: 
                            case 120: {
                                leadChar = 16;
                                break;
                            }
                            case 66: 
                            case 98: {
                                leadChar = 2;
                                break;
                            }
                            default: {
                                leadChar = 10;
                            }
                        }
                        if ((length & 16) != 0) {
                            switch (fchar) {
                                case 111: {
                                    prefix = Sprintf.PREFIX_OCTAL;
                                    break;
                                }
                                case 120: {
                                    prefix = Sprintf.PREFIX_HEX_LC;
                                    break;
                                }
                                case 88: {
                                    prefix = Sprintf.PREFIX_HEX_UC;
                                    break;
                                }
                                case 98: {
                                    prefix = Sprintf.PREFIX_BINARY_LC;
                                    break;
                                }
                                case 66: {
                                    prefix = Sprintf.PREFIX_BINARY_UC;
                                }
                            }
                            if (prefix != null) {
                                width -= prefix.length;
                            }
                        }
                        if (type == 1) {
                            v0 = base = ((RubyFixnum)buf).getLongValue() < 0L;
                            bytes = base && fchar == 117 ? (Object)Sprintf.getUnsignedNegativeBytes((RubyFixnum)buf) : (Object)Sprintf.getFixnumBytes((RubyFixnum)buf, leadChar, signChar, fchar == 88);
                        } else {
                            v1 = base = ((RubyBignum)buf).getValue().signum() < 0;
                            bytes = base != false && fchar == 117 ? (Object)Sprintf.getUnsignedNegativeBytes((RubyBignum)buf) : (Object)Sprintf.getBignumBytes((RubyBignum)buf, leadChar, signChar, fchar == 88);
                        }
                        len = 0;
                        if (signChar) {
                            if (base) {
                                sign = 45;
                                --width;
                                first = 1;
                            } else if ((length & 4) != 0) {
                                sign = 43;
                                --width;
                            } else if ((length & 1) != 0) {
                                sign = 32;
                                --width;
                            }
                        } else if (base) {
                            if (leadChar == 10) {
                                Sprintf.warning(IRubyWarnings.ID.NEGATIVE_NUMBER_FOR_U, args, "negative number for %u specifier");
                                negative = 46;
                                len += 2;
                            } else {
                                if ((length & 66) == 0) {
                                    len += 2;
                                }
                                first = Sprintf.skipSignBits((byte[])bytes, leadChar);
                                switch (fchar) {
                                    case 66: 
                                    case 98: {
                                        negative = 49;
                                        break;
                                    }
                                    case 111: {
                                        negative = 55;
                                        break;
                                    }
                                    case 120: {
                                        negative = 102;
                                        break;
                                    }
                                    case 88: {
                                        negative = 70;
                                    }
                                }
                                if (negative != 0) {
                                    ++len;
                                }
                            }
                        }
                        numlen = ((Object)bytes).length - first;
                        len += numlen;
                        if ((length & 66) == 2) {
                            precision = width;
                            width = 0;
                        } else {
                            if (precision < len) {
                                precision = len;
                            }
                            width -= precision;
                        }
                        if ((length & 8) == 0) {
                            format.fill(32, width);
                            width = 0;
                        }
                        if (sign != 0) {
                            format.write(sign);
                        }
                        if (prefix != null) {
                            format.write(prefix);
                        }
                        if (len < precision) {
                            if (negative == 0) {
                                format.fill(48, precision - len);
                            } else if (negative == 46) {
                                format.fill(negative, precision - len);
                                format.write(Sprintf.PREFIX_NEGATIVE);
                            } else {
                                format.fill(negative, precision - len + 1);
                            }
                        } else if (negative != 0) {
                            if ((length & 66) == 0) {
                                format.write(Sprintf.PREFIX_NEGATIVE);
                            }
                            if (negative != 46) {
                                format.write(negative);
                            }
                        }
                        format.write((byte[])bytes, first, numlen);
                        if (width > 0) {
                            format.fill(32, width);
                        }
                        ++start;
                        incomplete = false;
                        continue block59;
                    }
                    case 69: 
                    case 71: 
                    case 101: 
                    case 102: 
                    case 103: 
                }
                if (buf == null) {
                    buf = args.next();
                }
                if (!(buf instanceof RubyFloat)) {
                    buf = RubyKernel.new_float((IRubyObject)buf, (IRubyObject)buf);
                }
                nan = (var26_33 = ((RubyFloat)buf).getDoubleValue()) != var26_33;
                inf = var26_33 == Infinity || var26_33 == -Infinity;
                signChar = var26_33 < 0.0;
                negative = 0;
                negative = 0;
                exponent = 0;
                if (nan || inf) {
                    if (nan) {
                        len = Sprintf.NAN_VALUE;
                        exponent = Sprintf.NAN_VALUE.length;
                    } else {
                        len = Sprintf.INFINITY_VALUE;
                        exponent = Sprintf.INFINITY_VALUE.length;
                    }
                    if (nDigits != false) {
                        signChar = 45;
                        --width;
                    } else if ((length & 4) != 0) {
                        signChar = 43;
                        --width;
                    } else if ((length & 1) != 0) {
                        signChar = 32;
                        --width;
                    } else {
                        signChar = 0;
                    }
                    if ((width -= exponent) > 0 && (length & 10) == 0) {
                        format.fill(32, width);
                        width = 0;
                    }
                    if (signChar != 0) {
                        format.write(signChar);
                    }
                    if (width > 0 && (length & 8) == 0) {
                        format.fill(48, width);
                        width = 0;
                    }
                    format.write(len);
                    if (width > 0) {
                        format.fill(32, width);
                    }
                    ++start;
                    incomplete = false;
                    continue;
                }
                str = Double.toString(var26_33);
                var28_34 = str.length();
                len = new byte[var28_34];
                var29_35 = false;
                var30_36 = nDigits != false ? 1 : 0;
                var31_37 = 0;
                block64: while (var30_36 < i) {
                    var32_38 = (byte)str.charAt(var30_36++);
                    switch (var32_38) {
                        case 48: {
                            if (negative <= 0) ** GOTO lbl402
                            ++decPos;
                            ** GOTO lbl402
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            if (decPos > 0) {
                                while (decPos > 0) {
                                    len[negative++] = 48;
                                    --decPos;
                                }
                            }
                            len[negative++] = var32_38;
                            ** GOTO lbl402
                        }
                        case 46: {
                            break block64;
                        }
lbl402:
                        // 4 sources

                        default: {
                            continue block64;
                        }
                    }
                }
                var31_37 = negative + decPos;
                block66: while (ival < i) {
                    var32_38 = (byte)str.charAt((int)(++ival));
                    switch (var32_38) {
                        case 48: {
                            if (negative > 0) {
                                ++decPos;
                            } else {
                                --digits;
                            }
                            ** GOTO lbl424
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            if (decPos > 0) {
                                while (decPos > 0) {
                                    len[negative++] = 48;
                                    --decPos;
                                }
                            }
                            len[negative++] = var32_38;
                            ** GOTO lbl424
                        }
                        case 69: {
                            break block66;
                        }
lbl424:
                        // 4 sources

                        default: {
                            continue block66;
                        }
                    }
                }
                if (var30_36 < i) {
                    var33_39 = 0;
                    if (str.charAt(var30_36) == '-') {
                        var34_40 = -1;
                        ++var30_36;
                    } else {
                        var34_40 = 1;
                    }
                    while (var30_36 < i) {
                        var33_39 = var33_39 * 10 + (str.charAt(var30_36++) - 48);
                    }
                    digits += var33_39 * var34_40;
                }
                digits += expSign - negative;
                if (negative == 0) {
                    len[0] = 48;
                    negative = 1;
                    digits = 0;
                }
                if (nDigits != false) {
                    signChar = 45;
                    --width;
                } else if ((length & 4) != 0) {
                    signChar = 43;
                    --width;
                } else if ((length & 1) != 0) {
                    signChar = 32;
                    --width;
                } else {
                    signChar = 0;
                }
                if ((length & 64) == 0) {
                    precision = 6;
                }
                switch (fchar) {
                    case 69: 
                    case 71: {
                        var35_41 = 69;
                        break;
                    }
                    case 101: 
                    case 103: {
                        var35_41 = 101;
                        break;
                    }
                    default: {
                        var35_41 = 0;
                    }
                }
                switch (fchar) {
                    case 71: 
                    case 103: {
                        v2 = digits + negative - 1 < -4 || digits + negative > (precision == 0 ? 1 : precision) ? true : (var36_42 = false);
                        if (var36_42) {
                            expChar = negative - 1;
                            if ((precision = Math.max(0, precision - 1)) < expChar) {
                                expForm = Sprintf.round(len, negative, precision, precision != 0);
                                if (expForm > negative) {
                                    negative = expForm;
                                }
                                expChar = Math.min(negative - 1, precision);
                            }
                            expForm = (length & 16) != 0 ? 1 : 0;
                            ++exponent;
                            exponent = (digits += negative - 1) > 99 ? (exponent += 5) : (exponent += 4);
                            if (expForm != 0) {
                                ++exponent;
                            }
                            if (precision > 0) {
                                if (expForm == 0) {
                                    for (isSharp = expChar; isSharp >= 1 && len[isSharp] == 48; --isSharp) {
                                        --expChar;
                                    }
                                    if (expChar > 0) {
                                        ++exponent;
                                        exponent += expChar;
                                    }
                                } else {
                                    exponent += precision;
                                }
                            }
                            if ((width -= exponent) > 0 && (length & 10) == 0) {
                                format.fill(32, width);
                                width = 0;
                            }
                            if (signChar != 0) {
                                format.write(signChar);
                            }
                            if (width > 0 && (length & 8) == 0) {
                                format.fill(48, width);
                                width = 0;
                            }
                            format.write(len[0]);
                            v3 = isSharp = expForm != 0 || precision > 0 && expChar > 0 ? 1 : 0;
                            if (isSharp != 0) {
                                format.write(args.getDecimalSeparator());
                            }
                            if (precision > 0 && expChar > 0) {
                                format.write(len, 1, expChar);
                                precision -= expChar;
                            }
                            if (precision > 0 && expForm != 0) {
                                format.fill(48, precision);
                            }
                            Sprintf.writeExp((Buffer)format, digits, var35_41);
                            if (width <= 0) break;
                            format.fill(32, width);
                            break;
                        }
                        decDigits = Math.max(0, Math.min(negative + digits, negative));
                        var33_39 = Math.max(0, digits);
                        var40_46 = decDigits + var33_39;
                        expChar = negative - decDigits;
                        var41_47 = Math.max(0, -(expChar + digits));
                        var42_48 = var41_47 + expChar;
                        if ((precision = Math.max(0, precision - var40_46)) < expChar) {
                            expForm = Sprintf.round(len, negative, decDigits + precision - 1, precision != 0);
                            if (expForm > negative) {
                                negative = expForm;
                                decDigits = Math.max(0, Math.min(negative + digits, negative));
                                var40_46 = decDigits + intLength;
                                expChar = negative - decDigits;
                                var41_47 = Math.max(0, -(expChar + digits));
                                precision = Math.max(0, precision - 1);
                            }
                            expChar = precision;
                            var42_48 = var41_47 + expChar;
                        }
                        exponent += var40_46;
                        if (var42_48 > 0) {
                            exponent += var42_48 + 1;
                        } else if ((length & 16) != 0) {
                            ++exponent;
                            if (precision > 0) {
                                exponent += precision;
                            }
                        }
                        if ((width -= exponent) > 0 && (length & 10) == 0) {
                            format.fill(32, width);
                            width = 0;
                        }
                        if (signChar != 0) {
                            format.write(signChar);
                        }
                        if (width > 0 && (length & 8) == 0) {
                            format.fill(48, width);
                            width = 0;
                        }
                        if (var40_46 > 0) {
                            if (decDigits > 0) {
                                format.write(len, 0, decDigits);
                            }
                            if (intLength > 0) {
                                format.fill(48, intLength);
                            }
                        } else {
                            format.write(48);
                        }
                        if (var42_48 > 0 || (length & 16) != 0) {
                            format.write(args.getDecimalSeparator());
                        }
                        if (var42_48 > 0) {
                            if (var41_47 > 0) {
                                format.fill(48, var41_47);
                                precision -= var41_47;
                            }
                            if (expChar > 0) {
                                format.write(len, decDigits, expChar);
                                precision -= expChar;
                            }
                            if ((length & 16) != 0 && precision > 0) {
                                format.fill(48, precision);
                            }
                        }
                        if ((length & 16) != 0 && precision > 0) {
                            format.fill(48, precision);
                        }
                        if (width <= 0) break;
                        format.fill(32, width);
                        break;
                    }
                    case 102: {
                        decDigits = Math.max(0, Math.min(negative + digits, negative));
                        intLength = Math.max(0, digits);
                        var40_46 = decDigits + intLength;
                        expChar = negative - decDigits;
                        var41_47 = Math.max(0, -(expChar + digits));
                        var42_48 = var41_47 + expChar;
                        if (precision < var42_48) {
                            if (precision < var41_47) {
                                expChar = 0;
                                var41_47 = precision;
                            } else {
                                expForm = Sprintf.round(len, negative, decDigits + precision - var41_47 - 1, precision != 0);
                                if (expForm > negative) {
                                    negative = expForm;
                                    decDigits = Math.max(0, Math.min(negative + digits, negative));
                                    var40_46 = decDigits + intLength;
                                    expChar = negative - decDigits;
                                    var41_47 = Math.max(0, -(expChar + digits));
                                    var42_48 = var41_47 + expChar;
                                }
                                expChar = precision - var41_47;
                            }
                            var42_48 = var41_47 + expChar;
                        }
                        if (precision > 0) {
                            exponent += Math.max(1, var40_46) + 1 + precision;
                        } else {
                            exponent += Math.max(1, var40_46);
                            if ((length & 16) != 0) {
                                ++exponent;
                            }
                        }
                        if ((width -= exponent) > 0 && (length & 10) == 0) {
                            format.fill(32, width);
                            width = 0;
                        }
                        if (signChar != 0) {
                            format.write(signChar);
                        }
                        if (width > 0 && (length & 8) == 0) {
                            format.fill(48, width);
                            width = 0;
                        }
                        if (var40_46 > 0) {
                            if (decDigits > 0) {
                                format.write(len, 0, decDigits);
                            }
                            if (intLength > 0) {
                                format.fill(48, intLength);
                            }
                        } else {
                            format.write(48);
                        }
                        if (precision > 0 || (length & 16) != 0) {
                            format.write(args.getDecimalSeparator());
                        }
                        if (precision > 0) {
                            if (var41_47 > 0) {
                                format.fill(48, var41_47);
                                precision -= var41_47;
                            }
                            if (expChar > 0) {
                                format.write(len, decDigits, expChar);
                                precision -= expChar;
                            }
                            if (precision > 0) {
                                format.fill(48, precision);
                            }
                        }
                        if (width <= 0) break;
                        format.fill(32, width);
                        break;
                    }
                    case 69: 
                    case 101: {
                        expChar = negative - 1;
                        if (precision < expChar) {
                            expForm = Sprintf.round(len, negative, precision, precision != 0);
                            if (expForm > negative) {
                                negative = expForm;
                            }
                            expChar = Math.min(negative - 1, precision);
                        }
                        expForm = (length & 16) != 0 ? 1 : 0;
                        ++exponent;
                        exponent = (digits += negative - 1) > 99 ? (exponent += 5) : (exponent += 4);
                        if (precision > 0) {
                            exponent += 1 + precision;
                        } else if (expForm != 0) {
                            ++exponent;
                        }
                        if ((width -= exponent) > 0 && (length & 10) == 0) {
                            format.fill(32, width);
                            width = 0;
                        }
                        if (signChar != 0) {
                            format.write(signChar);
                        }
                        if (width > 0 && (length & 8) == 0) {
                            format.fill(48, width);
                            width = 0;
                        }
                        format.write(len[0]);
                        if (precision > 0) {
                            format.write(args.getDecimalSeparator());
                            if (expChar > 0) {
                                format.write(len, 1, expChar);
                                precision -= expChar;
                            }
                            if (precision > 0) {
                                format.fill(48, precision);
                            }
                        } else if ((length & 16) != 0) {
                            format.write(args.getDecimalSeparator());
                        }
                        Sprintf.writeExp((Buffer)format, digits, (byte)decZeroes);
                        if (width <= 0) break;
                        format.fill(32, width);
                    }
                }
                ++start;
                incomplete = false;
            }
            if (!incomplete) continue;
            if (length == 0) {
                format.write(37);
                continue;
            }
            Sprintf.raiseArgumentError(args, "illegal format character - %");
        }
        if (args.numbered == 0 && args.unnumbered < args.length) {
            if (args.runtime.getDebug().isTrue()) {
                args.raiseArgumentError("too many arguments for format string");
            } else if (args.runtime.getVerbose().isTrue()) {
                args.warn(IRubyWarnings.ID.TOO_MANY_ARGUMENTS, "too many arguments for format string");
            }
        }
        return format;
    }

    private static void writeExp(Buffer buf, int exponent, byte expChar) {
        buf.write(expChar);
        buf.write(exponent >= 0 ? 43 : 45);
        if (exponent < 0) {
            exponent = -exponent;
        }
        if (exponent > 99) {
            buf.write(exponent / 100 + 48);
            buf.write(exponent % 100 / 10 + 48);
        } else {
            buf.write(exponent / 10 + 48);
        }
        buf.write(exponent % 10 + 48);
    }

    private static final void raiseArgumentError(Args args, String message) {
        args.raiseArgumentError(message);
    }

    private static final void warning(IRubyWarnings.ID id, Args args, String message) {
        args.warning(id, message);
    }

    private static final void checkOffset(Args args, int offset, int length, String message) {
        if (offset >= length) {
            Sprintf.raiseArgumentError(args, message);
        }
    }

    private static final int extendWidth(Args args, int oldWidth, byte newChar) {
        int newWidth = oldWidth * 10 + (newChar - 48);
        if (newWidth / 10 != oldWidth) {
            Sprintf.raiseArgumentError(args, "width too big");
        }
        return newWidth;
    }

    private static final boolean isDigit(byte aChar) {
        return aChar >= 48 && aChar <= 57;
    }

    private static final boolean isPrintable(byte aChar) {
        return aChar > 32 && aChar < 127;
    }

    private static final int skipSignBits(byte[] bytes, int base) {
        int skip;
        int length = bytes.length;
        switch (base) {
            case 2: {
                for (skip = 0; skip < length && bytes[skip] == 49; ++skip) {
                }
                break;
            }
            case 8: {
                if (length > 0 && bytes[0] == 51) {
                    ++skip;
                }
                while (skip < length && bytes[skip] == 55) {
                    ++skip;
                }
                break;
            }
            case 10: {
                if (length <= 0 || bytes[0] != 45) break;
                ++skip;
                break;
            }
            case 16: {
                byte b;
                while (skip < length && ((b = bytes[skip]) == 102 || b == 70)) {
                    ++skip;
                }
                break;
            }
        }
        return skip;
    }

    private static final int round(byte[] bytes, int nDigits, int roundPos, boolean roundDown) {
        int next = roundPos + 1;
        if (next >= nDigits || bytes[next] < 53 || roundDown && bytes[next] == 53 && next == nDigits - 1) {
            return nDigits;
        }
        if (roundPos < 0) {
            System.arraycopy(bytes, 0, bytes, 1, nDigits);
            bytes[0] = 49;
            return nDigits + 1;
        }
        int n = roundPos;
        bytes[n] = (byte)(bytes[n] + 1);
        while (bytes[roundPos] > 57) {
            bytes[roundPos] = 48;
            if (--roundPos >= 0) {
                int n2 = roundPos;
                bytes[n2] = (byte)(bytes[n2] + 1);
                continue;
            }
            System.arraycopy(bytes, 0, bytes, 1, nDigits);
            bytes[0] = 49;
            return nDigits + 1;
        }
        return nDigits;
    }

    private static final byte[] getFixnumBytes(RubyFixnum arg, int base, boolean sign, boolean upper) {
        long val = arg.getLongValue();
        if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
            if (sign) {
                return Convert.intToByteArray((int)val, base, upper);
            }
            switch (base) {
                case 2: {
                    return Convert.intToBinaryBytes((int)val);
                }
                case 8: {
                    return Convert.intToOctalBytes((int)val);
                }
                default: {
                    return Convert.intToCharBytes((int)val);
                }
                case 16: 
            }
            return Convert.intToHexBytes((int)val, upper);
        }
        if (sign) {
            return Convert.longToByteArray(val, base, upper);
        }
        switch (base) {
            case 2: {
                return Convert.longToBinaryBytes(val);
            }
            case 8: {
                return Convert.longToOctalBytes(val);
            }
            default: {
                return Convert.longToCharBytes(val);
            }
            case 16: 
        }
        return Convert.longToHexBytes(val, upper);
    }

    private static final byte[] getBignumBytes(RubyBignum arg, int base, boolean sign, boolean upper) {
        BigInteger val = arg.getValue();
        if (sign || base == 10 || val.signum() >= 0) {
            return Sprintf.stringToBytes(val.toString(base), upper);
        }
        byte[] bytes = val.toByteArray();
        switch (base) {
            case 2: {
                return Convert.twosComplementToBinaryBytes(bytes);
            }
            case 8: {
                return Convert.twosComplementToOctalBytes(bytes);
            }
            case 16: {
                return Convert.twosComplementToHexBytes(bytes, upper);
            }
        }
        return Sprintf.stringToBytes(val.toString(base), upper);
    }

    private static final byte[] getUnsignedNegativeBytes(RubyInteger arg) {
        BigInteger bigval;
        if (arg instanceof RubyFixnum) {
            long longval = ((RubyFixnum)arg).getLongValue();
            if (longval >= -4294967296L) {
                return Convert.longToCharBytes(0x100000000L + longval);
            }
            bigval = BigInteger.valueOf(longval);
        } else {
            bigval = ((RubyBignum)arg).getValue();
        }
        int shift = 0;
        BigInteger minus = BIG_MINUS_64;
        while (bigval.compareTo(minus) < 0) {
            minus = minus.shiftLeft(32);
            ++shift;
        }
        BigInteger nPower32 = shift > 0 ? BIG_64.shiftLeft(32 * shift) : BIG_64;
        return Sprintf.stringToBytes(nPower32.add(bigval).toString(), false);
    }

    private static final byte[] stringToBytes(CharSequence s, boolean upper) {
        int len = s.length();
        byte[] bytes = new byte[len];
        if (upper) {
            int i = len;
            while (--i >= 0) {
                byte b = (byte)(s.charAt(i) & 0xFF);
                if (b >= 97 && b <= 122) {
                    bytes[i] = (byte)(b & 0xFFFFFFDF);
                    continue;
                }
                bytes[i] = b;
            }
        } else {
            int i = len;
            while (--i >= 0) {
                bytes[i] = (byte)(s.charAt(i) & 0xFF);
            }
        }
        return bytes;
    }

    private static class Buffer {
        byte[] buf;
        int size;
        private boolean tainted = false;

        Buffer() {
            this.buf = new byte[32];
        }

        Buffer(int initialSize) {
            this.buf = new byte[initialSize];
        }

        final void write(int b) {
            int newSize = this.size + 1;
            if (newSize > this.buf.length) {
                byte[] newBuf = new byte[Math.max(this.buf.length << 1, newSize)];
                System.arraycopy(this.buf, 0, newBuf, 0, this.size);
                this.buf = newBuf;
            }
            this.buf[this.size] = (byte)(b & 0xFF);
            this.size = newSize;
        }

        final void write(byte[] b, int off, int len) {
            if (len <= 0 || off < 0) {
                return;
            }
            int newSize = this.size + len;
            if (newSize > this.buf.length) {
                byte[] newBuf = new byte[Math.max(this.buf.length << 1, newSize)];
                System.arraycopy(this.buf, 0, newBuf, 0, this.size);
                this.buf = newBuf;
            }
            System.arraycopy(b, off, this.buf, this.size, len);
            this.size = newSize;
        }

        final void write(byte[] b) {
            this.write(b, 0, b.length);
        }

        final void fill(int b, int len) {
            if (len <= 0) {
                return;
            }
            int newSize = this.size + len;
            if (newSize > this.buf.length) {
                byte[] newBuf = new byte[Math.max(this.buf.length << 1, newSize)];
                System.arraycopy(this.buf, 0, newBuf, 0, this.size);
                this.buf = newBuf;
            }
            byte fillval = (byte)(b & 0xFF);
            while (--len >= 0) {
                this.buf[this.size + len] = fillval;
            }
            this.size = newSize;
        }

        final void set(int b, int pos) {
            if (pos < 0) {
                pos += this.size;
            }
            if (pos >= 0 && pos < this.size) {
                this.buf[pos] = (byte)(b & 0xFF);
            }
        }

        final void set(int b) {
            if (this.size > 0) {
                this.buf[this.size - 1] = (byte)(b & 0xFF);
            }
        }

        final ByteList toByteList() {
            return new ByteList(this.buf, 0, this.size);
        }

        public final String toString() {
            return new String(this.buf, 0, this.size);
        }

        static /* synthetic */ boolean access$002(Buffer x0, boolean x1) {
            x0.tainted = x1;
            return x0.tainted;
        }
    }

    private static class Args {
        Ruby runtime;
        Locale locale;
        IRubyObject rubyObject;
        List rubyArray;
        int length;
        int unnumbered;
        int numbered;

        Args(Locale locale, IRubyObject rubyObject) {
            if (rubyObject == null) {
                throw new IllegalArgumentException("null IRubyObject passed to sprintf");
            }
            this.locale = locale == null ? Locale.getDefault() : locale;
            this.rubyObject = rubyObject;
            if (rubyObject instanceof RubyArray) {
                this.rubyArray = ((RubyArray)rubyObject).getList();
                this.length = this.rubyArray.size();
            } else {
                this.length = 1;
            }
            this.runtime = rubyObject.getRuntime();
        }

        Args(IRubyObject rubyObject) {
            this(Locale.getDefault(), rubyObject);
        }

        Args(Ruby runtime, long value) {
            this(RubyFixnum.newFixnum(runtime, value));
        }

        final void raiseArgumentError(String message) {
            throw this.runtime.newArgumentError(message);
        }

        final void warn(IRubyWarnings.ID id, String message) {
            this.runtime.getWarnings().warn(id, message, new Object[0]);
        }

        final void warning(IRubyWarnings.ID id, String message) {
            this.runtime.getWarnings().warning(id, message, new Object[0]);
        }

        final IRubyObject next() {
            if (this.numbered > 0) {
                this.raiseArgumentError("unnumbered" + (this.unnumbered + 1) + "mixed with numbered");
            }
            if (this.unnumbered >= this.length) {
                this.raiseArgumentError("too few arguments");
            }
            IRubyObject object = this.rubyArray == null ? this.rubyObject : (IRubyObject)this.rubyArray.get(this.unnumbered);
            ++this.unnumbered;
            return object;
        }

        final IRubyObject get(int index) {
            if (this.unnumbered > 0) {
                this.raiseArgumentError("numbered(" + this.numbered + ") after unnumbered(" + this.unnumbered + ")");
            }
            if (index < 0) {
                this.raiseArgumentError("invalid index - " + (index + 1) + '$');
            }
            if (index >= this.length) {
                this.raiseArgumentError("too few arguments");
            }
            this.numbered = index + 1;
            return this.rubyArray == null ? this.rubyObject : (IRubyObject)this.rubyArray.get(index);
        }

        final IRubyObject getNth(int formatIndex) {
            return this.get(formatIndex - 1);
        }

        final int nextInt() {
            return this.intValue(this.next());
        }

        final int getInt(int index) {
            return this.intValue(this.get(index));
        }

        final int getNthInt(int formatIndex) {
            return this.intValue(this.get(formatIndex - 1));
        }

        final int intValue(IRubyObject obj) {
            if (obj instanceof RubyNumeric) {
                return (int)((RubyNumeric)obj).getLongValue();
            }
            obj = TypeConverter.convertToType(obj, obj.getRuntime().getFixnum(), MethodIndex.TO_INT, "to_int", true);
            return (int)((RubyFixnum)obj).getLongValue();
        }

        final byte getDecimalSeparator() {
            return (byte)new DecimalFormatSymbols(this.locale).getDecimalSeparator();
        }
    }
}

