/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dir {
    public static final boolean DOSISH;
    public static final boolean CASEFOLD_FILESYSTEM;
    public static final int FNM_NOESCAPE = 1;
    public static final int FNM_PATHNAME = 2;
    public static final int FNM_DOTMATCH = 4;
    public static final int FNM_CASEFOLD = 8;
    public static final int FNM_SYSCASE;
    public static final int FNM_NOMATCH = 1;
    public static final int FNM_ERROR = 2;
    public static final byte[] EMPTY;
    public static final byte[] SLASH;
    public static final byte[] STAR;
    public static final byte[] DOUBLE_STAR;
    public static final GlobFunc push_pattern;
    public static final GlobFunc glob_caller;

    private static boolean isdirsep(byte c) {
        return DOSISH ? c == 92 || c == 47 : c == 47;
    }

    private static int rb_path_next(byte[] _s, int s, int send) {
        while (s < send && !Dir.isdirsep(_s[s])) {
            ++s;
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    public static int fnmatch(byte[] bytes, int pstart, int pend, byte[] string, int sstart, int send, int flags) {
        void test;
        boolean period;
        int n = sstart;
        int s = pstart;
        boolean pat = (flags & 1) == 0;
        boolean escape = (flags & 2) != 0;
        boolean pathname = (flags & 4) == 0;
        boolean bl = period = (flags & 8) != 0;
        block6: while (s < pend) {
            char nocase = bytes[s++];
            switch (nocase) {
                case '?': {
                    if (n >= send || escape && Dir.isdirsep(string[n]) || pathname && string[n] == 46 && (n == 0 || escape && Dir.isdirsep(string[n - 1]))) {
                        return 1;
                    }
                    ++n;
                    continue block6;
                }
                case '*': {
                    while (s < pend && (nocase = bytes[s++]) == '*') {
                    }
                    if (n < send && pathname && string[n] == 46 && (n == 0 || escape && Dir.isdirsep(string[n - 1]))) {
                        return 1;
                    }
                    if (s > pend || s == pend && nocase == '*') {
                        if (escape && Dir.rb_path_next(string, n, send) < send) {
                            return 1;
                        }
                        return 0;
                    }
                    if (escape && Dir.isdirsep((byte)nocase)) {
                        if ((n = Dir.rb_path_next(string, n, send)) < send) {
                            ++n;
                            continue block6;
                        }
                        return 1;
                    }
                    char c = (char)((pat && nocase == '\\' && s < pend ? bytes[s] : nocase) & 0xFF);
                    c = Character.toLowerCase(c);
                    --s;
                    while (test < send) {
                        if ((nocase == '?' || nocase == '[' || Character.toLowerCase((char)string[test]) == c) && Dir.fnmatch(bytes, s, pend, string, (int)test, send, flags | 4) == 0) {
                            return 0;
                        }
                        if (escape && Dir.isdirsep(string[test])) break;
                        ++test;
                    }
                    return 1;
                }
                case '[': {
                    if (test >= send || escape && Dir.isdirsep(string[test]) || pathname && string[test] == 46 && (test == false || escape && Dir.isdirsep(string[test - true]))) {
                        return 1;
                    }
                    if ((s = Dir.range(bytes, s, pend, (char)(string[test] & 0xFF), flags)) == -1) {
                        return 1;
                    }
                    ++test;
                    continue block6;
                }
                case '\\': {
                    if (!pat || DOSISH && (s >= pend || "*?[]\\".indexOf((char)bytes[s]) == -1)) break;
                    nocase = s >= pend ? (char)'\\' : bytes[s++];
                }
            }
            if (test >= send) {
                return 1;
            }
            if (!(DOSISH && escape && Dir.isdirsep((byte)nocase) && Dir.isdirsep(string[test]) || !(period ? Character.toLowerCase(nocase) != Character.toLowerCase((char)string[test]) : nocase != (char)string[test]))) {
                return 1;
            }
            ++test;
        }
        return test >= send ? 0 : 1;
    }

    public static int range(byte[] _pat, int pat, int pend, char test, int flags) {
        boolean not;
        boolean escape;
        boolean bl = false;
        boolean ok = (flags & 1) == 0;
        boolean bl2 = escape = _pat[pat] == 33 || _pat[pat] == 94;
        if (escape) {
            ++pat;
        }
        test = Character.toLowerCase(test);
        while (_pat[pat] != 93) {
            char cstart;
            char c;
            if (ok && _pat[pat] == 92) {
                ++pat;
            }
            if (pat >= pend) {
                return -1;
            }
            char cend = c = (char)(_pat[pat++] & 0xFF);
            if (_pat[pat] == 45 && _pat[pat + 1] != 93) {
                if (ok && _pat[++pat] == 92) {
                    ++pat;
                }
                if (pat >= pend) {
                    return -1;
                }
                cstart = (char)(_pat[pat++] & 0xFF);
            }
            if (Character.toLowerCase(cend) > test || test > Character.toLowerCase(cstart)) continue;
            not = true;
        }
        return not == escape ? -1 : pat + 1;
    }

    public static List<ByteList> push_glob(String cwd, ByteList globByteList, int flags) {
        ArrayList<ByteList> result = new ArrayList<ByteList>();
        Dir.push_braces(cwd, result, new GlobPattern(globByteList, flags));
        return result;
    }

    private static int push_braces(String cwd, List<ByteList> result, GlobPattern pattern) {
        pattern.reset();
        int lbrace = pattern.indexOf((byte)123);
        int rbrace = pattern.findClosingIndexOf(lbrace);
        if (lbrace == -1 || rbrace == -1) {
            return Dir.push_globs(cwd, result, pattern);
        }
        ByteList buf = new ByteList(20);
        int n = lbrace;
        while (pattern.bytes[n] != 125) {
            int i;
            int middleRegionIndex;
            for (middleRegionIndex = i = n + 1; middleRegionIndex < pattern.end && pattern.bytes[middleRegionIndex] != 125 && pattern.bytes[middleRegionIndex] != 44; ++middleRegionIndex) {
                if (pattern.bytes[middleRegionIndex] != 123) continue;
                pattern.findClosingIndexOf(middleRegionIndex);
            }
            buf.length(0);
            buf.append(pattern.bytes, pattern.begin, lbrace - pattern.begin);
            buf.append(pattern.bytes, i, middleRegionIndex - i);
            buf.append(pattern.bytes, rbrace + 1, pattern.end - (rbrace + 1));
            int status = Dir.push_braces(cwd, result, new GlobPattern(buf.bytes, buf.begin, buf.realSize, pattern.flags));
            if (status == 0) continue;
            return status;
        }
        return 0;
    }

    private static int push_globs(String cwd, List<ByteList> ary, GlobPattern pattern) {
        pattern.flags |= FNM_SYSCASE;
        return Dir.glob_helper(cwd, pattern.bytes, pattern.begin, pattern.end, -1, pattern.flags, glob_caller, new GlobArgs(push_pattern, ary));
    }

    private static boolean has_magic(byte[] bytes, int begin, int end, int flags) {
        boolean escape = (flags & 1) == 0;
        boolean nocase = (flags & 8) != 0;
        int open = 0;
        block6: for (int i = begin; i < end; ++i) {
            switch (bytes[i]) {
                case 42: 
                case 63: {
                    return true;
                }
                case 91: {
                    ++open;
                    continue block6;
                }
                case 93: {
                    if (open <= 0) continue block6;
                    return true;
                }
                case 92: {
                    if (!escape || i != end) continue block6;
                    return false;
                }
                default: {
                    if (FNM_SYSCASE != 0 || !nocase || !Character.isLetter((char)(bytes[i] & 0xFF))) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    private static int remove_backslashes(byte[] bytes, int index, int len) {
        int t = index;
        while (index < len && (bytes[index] != 92 || ++index != len)) {
            bytes[t] = bytes[index];
            ++index;
            ++t;
        }
        return t;
    }

    private static int strchr(byte[] bytes, int begin, int end, byte ch) {
        for (int i = begin; i < end; ++i) {
            if (bytes[i] != ch) continue;
            return i;
        }
        return -1;
    }

    private static byte[] extract_path(byte[] bytes, int begin, int end) {
        int len = end - begin;
        if (!(len <= 1 || bytes[end - 1] != 47 || DOSISH && len >= 2 && bytes[end - 2] == 58)) {
            --len;
        }
        byte[] alloc = new byte[len];
        System.arraycopy(bytes, begin, alloc, 0, len);
        return alloc;
    }

    private static byte[] extract_elem(byte[] bytes, int begin, int end) {
        int elementEnd = Dir.strchr(bytes, begin, end, (byte)47);
        if (elementEnd == -1) {
            elementEnd = end;
        }
        return Dir.extract_path(bytes, begin, elementEnd);
    }

    private static boolean BASE(byte[] base) {
        return DOSISH ? !(base.length <= 0 || Dir.isdirsep(base[0]) && base.length < 2 || base.length > 2 && base[1] == 58 && Dir.isdirsep(base[2]) && base.length < 4) : base.length > 0 && (!Dir.isdirsep(base[0]) || base.length >= 2);
    }

    private static boolean isJarFilePath(byte[] bytes, int begin, int end) {
        return end > 6 && bytes[begin] == 102 && bytes[begin + 1] == 105 && bytes[begin + 2] == 108 && bytes[begin + 3] == 101 && bytes[begin + 4] == 58;
    }

    private static String[] files(File directory) {
        String[] files = directory.list();
        String[] filesPlusDotFiles = new String[files.length + 2];
        System.arraycopy(files, 0, filesPlusDotFiles, 2, files.length);
        filesPlusDotFiles[0] = ".";
        filesPlusDotFiles[1] = "..";
        return filesPlusDotFiles;
    }

    /*
     * WARNING - void declaration
     */
    private static int glob_helper(String cwd, byte[] bytes, int begin, int end, int sub, int flags, GlobFunc func, GlobArgs arg) {
        int p;
        int status;
        boolean bl = false;
        byte[] byArray = null;
        int n = status = sub != -1 ? sub : begin;
        if (!Dir.has_magic(bytes, status, end, flags)) {
            if (DOSISH || (flags & 1) == 0) {
                byArray = new byte[end];
                System.arraycopy(bytes, 0, byArray, 0, end);
                if (sub != -1) {
                    status = sub - begin;
                    end = Dir.remove_backslashes(byArray, status, end);
                    sub = status;
                } else {
                    end = Dir.remove_backslashes(byArray, 0, end);
                    bytes = byArray;
                }
            }
            if (bytes[begin] == 47 || DOSISH && begin + 2 < end && bytes[begin + 1] == 58 && Dir.isdirsep(bytes[begin + 2])) {
                if (new File(new String(bytes, begin, end - begin)).exists()) {
                    p = func.call(bytes, begin, end, arg);
                }
            } else if (Dir.isJarFilePath(bytes, begin, end)) {
                int newpath = -1;
                for (int i = 0; i < end; ++i) {
                    if (bytes[begin + i] != 33) continue;
                    newpath = i;
                    break;
                }
                File ix = new File(new String(bytes, begin + 5, newpath - 5));
                String st = new String(bytes, begin + newpath + 1, end - (newpath + 1));
                try {
                    JarFile jar = new JarFile(ix);
                    if (st.startsWith("/")) {
                        st = st.substring(1);
                    }
                    if (jar.getEntry(st + "/") != null) {
                        st = st + "/";
                    }
                    if (jar.getEntry(st) != null) {
                        p = func.call(bytes, begin, end, arg);
                    }
                }
                catch (Exception jar) {}
            } else if (end - begin > 0 && new File(cwd, new String(bytes, begin, end - begin)).exists()) {
                p = func.call(bytes, begin, end, arg);
            }
            return p;
        }
        ByteList newpath = new ByteList(20);
        ArrayList<ByteList> st = new ArrayList<ByteList>();
        while (status != -1 && p == 0) {
            void var15_21;
            block48: {
                File buf;
                Object link;
                block47: {
                    void base;
                    JarFile jf;
                    String jar;
                    boolean recursive;
                    byte[] magic;
                    block49: {
                        byte[] byArray2;
                        int e;
                        if (bytes[status] == 47) {
                            ++status;
                        }
                        if (!Dir.has_magic(bytes, status, (e = Dir.strchr(bytes, status, end, (byte)47)) == -1 ? end : e, flags)) break block48;
                        link = Dir.extract_path(bytes, begin, status);
                        if (begin == status) {
                            byte[] byArray3 = new byte[1];
                            byArray2 = byArray3;
                            byArray3[0] = 46;
                        } else {
                            byArray2 = link;
                        }
                        byte[] dir = byArray2;
                        magic = Dir.extract_elem(bytes, status, end);
                        recursive = false;
                        jar = null;
                        jf = null;
                        if (dir[0] == 47 || DOSISH && 2 < dir.length && dir[1] == 58 && Dir.isdirsep(dir[2])) {
                            buf = new File(new String(dir));
                        } else if (Dir.isJarFilePath(dir, 0, dir.length)) {
                            int ix = -1;
                            for (int i = 0; i < dir.length; ++i) {
                                if (dir[i] != 33) continue;
                                ix = i;
                                break;
                            }
                            buf = new File(new String(dir, 5, ix - 5));
                            jar = new String(dir, ix + 1, dir.length - (ix + 1));
                            try {
                                jf = new JarFile(buf);
                                if (jar.startsWith("/")) {
                                    jar = jar.substring(1);
                                }
                                if (jf.getEntry(jar + "/") != null) {
                                    jar = jar + "/";
                                }
                            }
                            catch (Exception e2) {
                                jar = null;
                                jf = null;
                            }
                        } else {
                            buf = new File(cwd, new String(dir));
                        }
                        if ((jf == null || !"".equals(jar) && (jf.getJarEntry(jar) == null || !jf.getJarEntry(jar).isDirectory())) && !buf.isDirectory()) break;
                        if (base == -1 || !Arrays.equals(magic, DOUBLE_STAR)) break block49;
                        int n2 = ((byte[])link).length;
                        recursive = true;
                        newpath.length(0);
                        newpath.append((byte[])link);
                        newpath.append(bytes, (int)(((Object)link).length > 0 ? base : base + true), end - (((Object)link).length > 0 ? base : base + true));
                        p = Dir.glob_helper(cwd, newpath.bytes, newpath.begin, newpath.realSize, n2, flags, func, arg);
                        if (p != 0) break block47;
                    }
                    if (jar == null) {
                        String[] dirp = Dir.files(buf);
                        for (int i = 0; i < dirp.length; ++i) {
                            byte[] bs;
                            if (recursive) {
                                bs = dirp[i].getBytes();
                                if (Dir.fnmatch(STAR, 0, 1, bs, 0, bs.length, flags) != 0) continue;
                                newpath.length(0);
                                newpath.append((byte[])link);
                                newpath.append(Dir.BASE((byte[])link) ? SLASH : EMPTY);
                                newpath.append(dirp[i].getBytes());
                                buf = newpath.bytes[0] == 47 || DOSISH && 2 < newpath.realSize && newpath.bytes[1] == 58 && Dir.isdirsep(newpath.bytes[2]) ? new File(new String(newpath.bytes, newpath.begin, newpath.realSize)) : new File(cwd, new String(newpath.bytes, newpath.begin, newpath.realSize));
                                if (!buf.isDirectory() || ".".equals(dirp[i]) || "..".equals(dirp[i])) continue;
                                int t = newpath.realSize;
                                newpath.append(SLASH);
                                newpath.append(DOUBLE_STAR);
                                newpath.append(bytes, (int)base, end - base);
                                p = Dir.glob_helper(cwd, newpath.bytes, newpath.begin, newpath.realSize, t, flags, func, arg);
                                if (p == 0) continue;
                                break;
                            }
                            bs = dirp[i].getBytes();
                            if (Dir.fnmatch(magic, 0, magic.length, bs, 0, bs.length, flags) != 0) continue;
                            newpath.length(0);
                            newpath.append((byte[])link);
                            newpath.append(Dir.BASE((byte[])link) ? SLASH : EMPTY);
                            newpath.append(dirp[i].getBytes());
                            if (base == -1) {
                                p = func.call(newpath.bytes, 0, newpath.realSize, arg);
                                if (p == 0) continue;
                                break;
                            }
                            st.add(newpath);
                            newpath = new ByteList(20);
                        }
                    } else {
                        try {
                            ArrayList<JarEntry> dirp = new ArrayList<JarEntry>();
                            Enumeration<JarEntry> eje = jf.entries();
                            while (eje.hasMoreElements()) {
                                JarEntry je = eje.nextElement();
                                String name = je.getName();
                                int ix = name.indexOf(47, jar.length());
                                if (name.startsWith("META-INF") || ix != -1 && ix != name.length() - 1 || !"/".equals(jar) && (!name.startsWith(jar) || name.length() <= jar.length())) continue;
                                dirp.add(je);
                            }
                            for (JarEntry je : dirp) {
                                byte[] bs = je.getName().getBytes();
                                int len = bs.length;
                                if (je.isDirectory()) {
                                    --len;
                                }
                                if (recursive) {
                                    if (Dir.fnmatch(STAR, 0, 1, bs, 0, len, flags) != 0) continue;
                                    newpath.length(0);
                                    newpath.append((byte[])link, 0, ((Object)link).length - jar.length());
                                    newpath.append(Dir.BASE((byte[])link) ? SLASH : EMPTY);
                                    newpath.append(bs, 0, len);
                                    if (!je.isDirectory()) continue;
                                    int t = newpath.realSize;
                                    newpath.append(SLASH);
                                    newpath.append(DOUBLE_STAR);
                                    newpath.append(bytes, (int)base, end - base);
                                    p = Dir.glob_helper(cwd, newpath.bytes, newpath.begin, newpath.realSize, t, flags, func, arg);
                                    if (p == 0) continue;
                                }
                                if (Dir.fnmatch(magic, 0, magic.length, bs, 0, len, flags) != 0) continue;
                                newpath.length(0);
                                newpath.append((byte[])link, 0, ((Object)link).length - jar.length());
                                newpath.append(Dir.BASE((byte[])link) ? SLASH : EMPTY);
                                newpath.append(bs, 0, len);
                                if (base == -1) {
                                    p = func.call(newpath.bytes, 0, newpath.realSize, arg);
                                    if (p == 0) continue;
                                }
                                st.add(newpath);
                                newpath = new ByteList(20);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (st.size() > 0) {
                    link = st.iterator();
                    while (link.hasNext()) {
                        void i$;
                        ByteList b = (ByteList)link.next();
                        if (p != 0 || !(buf = b.bytes[0] == 47 || DOSISH && 2 < b.realSize && b.bytes[1] == 58 && Dir.isdirsep(b.bytes[2]) ? new File(new String(b.bytes, 0, b.realSize)) : new File(cwd, new String(b.bytes, 0, b.realSize))).isDirectory()) continue;
                        int len = b.realSize;
                        newpath.length(0);
                        newpath.append(b);
                        newpath.append(bytes, (int)i$, end - i$);
                        p = Dir.glob_helper(cwd, newpath.bytes, 0, newpath.realSize, len, flags, func, arg);
                    }
                    break;
                }
            }
            status = var15_21;
        }
        return p;
    }

    static {
        CASEFOLD_FILESYSTEM = DOSISH = System.getProperty("os.name").indexOf("Windows") != -1;
        FNM_SYSCASE = CASEFOLD_FILESYSTEM ? 8 : 0;
        EMPTY = new byte[0];
        SLASH = new byte[]{47};
        STAR = new byte[]{42};
        DOUBLE_STAR = new byte[]{42, 42};
        push_pattern = new GlobFunc(){

            public int call(byte[] ptr, int p, int len, Object ary) {
                ((List)ary).add(new ByteList(ptr, p, len));
                return 0;
            }
        };
        glob_caller = new GlobFunc(){

            public int call(byte[] ptr, int p, int len, Object ary) {
                GlobArgs args = (GlobArgs)ary;
                args.c = p;
                return args.func.call(ptr, args.c, len, args.v);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GlobArgs {
        GlobFunc func;
        int c = -1;
        List<ByteList> v;

        public GlobArgs(GlobFunc func, List<ByteList> arg) {
            this.func = func;
            this.v = arg;
        }
    }

    private static interface GlobFunc {
        public int call(byte[] var1, int var2, int var3, Object var4);
    }

    private static class GlobPattern {
        byte[] bytes;
        int index;
        int begin;
        int end;
        int flags;

        public GlobPattern(ByteList bytelist, int flags) {
            this(bytelist.bytes, bytelist.begin, bytelist.begin + bytelist.realSize, flags);
        }

        public GlobPattern(byte[] bytes, int index, int end, int flags) {
            this.bytes = bytes;
            this.index = index;
            this.begin = index;
            this.end = end;
            this.flags = flags;
        }

        public int findClosingIndexOf(int leftTokenIndex) {
            byte rightToken;
            if (leftTokenIndex == -1 || leftTokenIndex > this.end) {
                return -1;
            }
            byte leftToken = this.bytes[leftTokenIndex];
            switch (leftToken) {
                case 123: {
                    rightToken = 125;
                    break;
                }
                case 91: {
                    rightToken = 93;
                    break;
                }
                default: {
                    return -1;
                }
            }
            int nest = 1;
            this.index = leftTokenIndex + 1;
            while (this.hasNext()) {
                byte c = this.next();
                if (c == leftToken) {
                    ++nest;
                    continue;
                }
                if (c != rightToken || --nest != 0) continue;
                return this.index();
            }
            return -1;
        }

        public boolean hasNext() {
            return this.index < this.end;
        }

        public void reset() {
            this.index = this.begin;
        }

        public void setIndex(int value) {
            this.index = value;
        }

        public int index() {
            return this.index - 1;
        }

        public int indexOf(byte c) {
            while (this.hasNext()) {
                if (this.next() != c) continue;
                return this.index();
            }
            return -1;
        }

        public byte next() {
            return this.bytes[this.index++];
        }
    }
}

