/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.RubyThread;
import org.jruby.RubyThreadGroup;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyRunnable
implements Runnable {
    private Ruby runtime;
    private Frame currentFrame;
    private RubyProc proc;
    private IRubyObject[] arguments;
    private RubyThread rubyThread;
    private Thread javaThread;

    public RubyRunnable(RubyThread rubyThread, IRubyObject[] args, Block currentBlock) {
        this.rubyThread = rubyThread;
        this.runtime = rubyThread.getRuntime();
        ThreadContext tc = this.runtime.getCurrentContext();
        this.proc = this.runtime.newProc(Block.Type.THREAD, currentBlock);
        this.currentFrame = tc.getCurrentFrame();
        this.arguments = args;
    }

    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    public Thread getJavaThread() {
        return this.javaThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Ruby.RUNTIME_THREADLOCAL) {
            Ruby.setCurrentInstance(this.runtime);
        }
        this.javaThread = Thread.currentThread();
        ThreadContext context = this.runtime.getThreadService().registerNewThread(this.rubyThread);
        context.preRunThread(this.currentFrame);
        try {
            IRubyObject result = this.proc.call(this.arguments);
            this.rubyThread.cleanTerminate(result);
        }
        catch (ThreadKill tk) {
            Object object = this.rubyThread.killLock;
            synchronized (object) {
                this.rubyThread.killLock.notifyAll();
            }
        }
        catch (JumpException.ReturnJump rj) {
            this.rubyThread.exceptionRaised(this.runtime.newThreadError("return can't jump across threads"));
        }
        catch (RaiseException e) {
            this.rubyThread.exceptionRaised(e);
        }
        finally {
            this.runtime.getThreadService().setCritical(false);
            this.runtime.getThreadService().unregisterThread(this.rubyThread);
            ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
        }
    }
}

