/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jline.CandidateListCompletionHandler;
import jline.Completor;
import jline.ConsoleReader;
import jline.FileNameCompletor;
import jline.History;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class Readline {
    private static ConsoleReader readline;
    private static Completor currentCompletor;
    private static History history;

    public static void createReadline(Ruby runtime) throws IOException {
        history = new History();
        currentCompletor = null;
        RubyModule mReadline = runtime.defineModule("Readline");
        CallbackFactory readlinecb = runtime.callbackFactory(Readline.class);
        mReadline.defineMethod("readline", readlinecb.getFastSingletonMethod("s_readline", IRubyObject.class, IRubyObject.class));
        mReadline.module_function(new IRubyObject[]{runtime.newSymbol("readline")});
        mReadline.defineMethod("completion_append_character=", readlinecb.getFastSingletonMethod("s_set_completion_append_character", IRubyObject.class));
        mReadline.module_function(new IRubyObject[]{runtime.newSymbol("completion_append_character=")});
        mReadline.defineMethod("completion_proc=", readlinecb.getFastSingletonMethod("s_set_completion_proc", IRubyObject.class));
        mReadline.module_function(new IRubyObject[]{runtime.newSymbol("completion_proc=")});
        IRubyObject hist = runtime.getObject().callMethod(runtime.getCurrentContext(), "new");
        mReadline.fastSetConstant("HISTORY", hist);
        hist.getSingletonClass().includeModule(runtime.getEnumerable());
        hist.getSingletonClass().defineMethod("push", readlinecb.getFastOptSingletonMethod("s_push"));
        hist.getSingletonClass().defineMethod("pop", readlinecb.getFastSingletonMethod("s_pop"));
        hist.getSingletonClass().defineMethod("to_a", readlinecb.getFastSingletonMethod("s_hist_to_a"));
        hist.getSingletonClass().defineMethod("to_s", readlinecb.getFastSingletonMethod("s_hist_to_s"));
        hist.getSingletonClass().defineMethod("[]", readlinecb.getFastSingletonMethod("s_hist_get", IRubyObject.class));
        hist.getSingletonClass().defineMethod("[]=", readlinecb.getFastSingletonMethod("s_hist_set", IRubyObject.class, IRubyObject.class));
        hist.getSingletonClass().defineMethod("<<", readlinecb.getFastOptSingletonMethod("s_push"));
        hist.getSingletonClass().defineMethod("shift", readlinecb.getFastSingletonMethod("s_hist_shift"));
        hist.getSingletonClass().defineMethod("each", readlinecb.getSingletonMethod("s_hist_each"));
        hist.getSingletonClass().defineMethod("length", readlinecb.getFastSingletonMethod("s_hist_length"));
        hist.getSingletonClass().defineMethod("size", readlinecb.getFastSingletonMethod("s_hist_length"));
        hist.getSingletonClass().defineMethod("empty?", readlinecb.getFastSingletonMethod("s_hist_empty_p"));
        hist.getSingletonClass().defineMethod("delete_at", readlinecb.getFastSingletonMethod("s_hist_delete_at", IRubyObject.class));
    }

    protected static void initReadline() throws IOException {
        readline = new ConsoleReader();
        readline.setUseHistory(false);
        readline.setUsePagination(true);
        readline.setBellEnabled(false);
        ((CandidateListCompletionHandler)readline.getCompletionHandler()).setAlwaysIncludeNewline(false);
        if (currentCompletor == null) {
            currentCompletor = new RubyFileNameCompletor();
        }
        readline.addCompletor(currentCompletor);
        readline.setHistory(history);
    }

    public static History getHistory() {
        return history;
    }

    public static void setCompletor(Completor completor) {
        if (readline != null) {
            readline.removeCompletor(currentCompletor);
        }
        currentCompletor = completor;
        if (readline != null) {
            readline.addCompletor(currentCompletor);
        }
    }

    public static Completor getCompletor() {
        return currentCompletor;
    }

    public static IRubyObject s_readline(IRubyObject recv, IRubyObject prompt, IRubyObject add_to_hist) throws IOException {
        if (readline == null) {
            Readline.initReadline();
        }
        IRubyObject line = recv.getRuntime().getNil();
        readline.getTerminal().disableEcho();
        String v = readline.readLine(prompt.toString());
        readline.getTerminal().enableEcho();
        if (null != v) {
            if (add_to_hist.isTrue()) {
                readline.getHistory().addToHistory(v);
            }
            line = recv.getRuntime().newString(v);
        }
        return line;
    }

    public static IRubyObject s_push(IRubyObject recv, IRubyObject[] lines) throws Exception {
        for (int i = 0; i < lines.length; ++i) {
            history.addToHistory(lines[i].toString());
        }
        return recv.getRuntime().getNil();
    }

    public static IRubyObject s_pop(IRubyObject recv) throws Exception {
        return recv.getRuntime().getNil();
    }

    public static IRubyObject s_hist_to_a(IRubyObject recv) throws Exception {
        RubyArray histList = recv.getRuntime().newArray();
        Iterator i = history.getHistoryList().iterator();
        while (i.hasNext()) {
            histList.append(recv.getRuntime().newString((String)i.next()));
        }
        return histList;
    }

    public static IRubyObject s_hist_to_s(IRubyObject recv) {
        return recv.getRuntime().newString("HISTORY");
    }

    public static IRubyObject s_hist_get(IRubyObject recv, IRubyObject index) {
        int i = (int)index.convertToInteger().getLongValue();
        return recv.getRuntime().newString((String)history.getHistoryList().get(i));
    }

    public static IRubyObject s_hist_set(IRubyObject recv, IRubyObject index, IRubyObject val) {
        throw recv.getRuntime().newNotImplementedError("the []=() function is unimplemented on this machine");
    }

    public static IRubyObject s_hist_shift(IRubyObject recv) {
        throw recv.getRuntime().newNotImplementedError("the shift function is unimplemented on this machine");
    }

    public static IRubyObject s_hist_length(IRubyObject recv) {
        return recv.getRuntime().newFixnum(history.size());
    }

    public static IRubyObject s_hist_empty_p(IRubyObject recv) {
        return recv.getRuntime().newBoolean(history.size() == 0);
    }

    public static IRubyObject s_hist_delete_at(IRubyObject recv, IRubyObject index) {
        throw recv.getRuntime().newNotImplementedError("the delete_at function is unimplemented on this machine");
    }

    public static IRubyObject s_hist_each(IRubyObject recv, Block block) {
        Iterator i = history.getHistoryList().iterator();
        while (i.hasNext()) {
            block.yield(recv.getRuntime().getCurrentContext(), recv.getRuntime().newString((String)i.next()));
        }
        return recv;
    }

    public static IRubyObject s_set_completion_append_character(IRubyObject recv, IRubyObject achar) throws Exception {
        return recv.getRuntime().getNil();
    }

    public static IRubyObject s_set_completion_proc(IRubyObject recv, IRubyObject proc) throws Exception {
        if (!proc.respondsTo("call")) {
            throw recv.getRuntime().newArgumentError("argument must respond to call");
        }
        Readline.setCompletor(new ProcCompletor(proc));
        return recv.getRuntime().getNil();
    }

    public static class RubyFileNameCompletor
    extends FileNameCompletor {
        public int complete(String buffer, int cursor, List candidates) {
            int index = (buffer = buffer.substring(0, cursor)).lastIndexOf(" ");
            if (index != -1) {
                buffer = buffer.substring(index + 1);
            }
            return index + 1 + super.complete(buffer, cursor, candidates);
        }
    }

    public static class ProcCompletor
    implements Completor {
        IRubyObject procCompletor;

        public ProcCompletor(IRubyObject procCompletor) {
            this.procCompletor = procCompletor;
        }

        public int complete(String buffer, int cursor, List candidates) {
            int index = (buffer = buffer.substring(0, cursor)).lastIndexOf(" ");
            if (index != -1) {
                buffer = buffer.substring(index + 1);
            }
            ThreadContext context = this.procCompletor.getRuntime().getCurrentContext();
            IRubyObject comps = this.procCompletor.callMethod(context, "call", new IRubyObject[]{this.procCompletor.getRuntime().newString(buffer)}).callMethod(context, MethodIndex.TO_A, "to_a");
            if (comps instanceof List) {
                for (Object obj : (List)((Object)comps)) {
                    if (obj == null) continue;
                    candidates.add(obj.toString());
                }
                Collections.sort(candidates);
            }
            return cursor - buffer.length();
        }
    }

    public static class Service
    implements Library {
        public void load(Ruby runtime, boolean wrap) throws IOException {
            Readline.createReadline(runtime);
        }
    }
}

