/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.util.HashMap;
import java.util.Map;
import jruby.objectweb.asm.ClassVisitor;
import jruby.objectweb.asm.Label;
import org.jruby.Ruby;
import org.jruby.RubySymbol;
import org.jruby.compiler.CacheCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;

public class InheritedCacheCompiler
implements CacheCompiler {
    private StandardASMCompiler scriptCompiler;
    public static final int MAX_INHERITED_CALL_SITES = 0;
    int callSiteCount = 0;
    Map<String, String> byteLists = new HashMap<String, String>();
    Map<String, String> symbols = new HashMap<String, String>();

    public InheritedCacheCompiler(StandardASMCompiler scriptCompiler) {
        this.scriptCompiler = scriptCompiler;
    }

    public void cacheCallSite(SkinnyMethodAdapter method, String name, CallType callType) {
        String fieldName = "site" + this.callSiteCount;
        SkinnyMethodAdapter initMethod = this.scriptCompiler.getInitMethod();
        initMethod.aload(0);
        method.aload(0);
        initMethod.ldc(name);
        if (callType.equals(CallType.NORMAL)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.FUNCTIONAL)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getFunctionalCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.VARIABLE)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getVariableCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        }
        if (this.callSiteCount >= 0) {
            this.scriptCompiler.getNewField(CodegenUtils.ci(CallSite.class), fieldName, null);
            initMethod.putfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
            method.getfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
        } else {
            initMethod.putfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
            method.getfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
        }
        ++this.callSiteCount;
    }

    public void cacheByteList(SkinnyMethodAdapter method, String contents) {
        String fieldName = this.byteLists.get(contents);
        if (fieldName == null) {
            SkinnyMethodAdapter clinitMethod = this.scriptCompiler.getClassInitMethod();
            fieldName = this.scriptCompiler.getNewStaticConstant(CodegenUtils.ci(ByteList.class), "byteList");
            this.byteLists.put(contents, fieldName);
            clinitMethod.ldc(contents);
            clinitMethod.invokestatic(CodegenUtils.p(ByteList.class), "create", CodegenUtils.sig(ByteList.class, CharSequence.class));
            clinitMethod.putstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(ByteList.class));
        }
        method.getstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(ByteList.class));
    }

    public void cacheSymbol(SkinnyMethodAdapter method, String symbol) {
        String methodName = this.symbols.get(symbol);
        if (methodName == null) {
            String fieldName = this.scriptCompiler.getNewConstant(CodegenUtils.ci(RubySymbol.class), "symbol");
            methodName = "getSymbol" + fieldName;
            this.symbols.put(symbol, methodName);
            ClassVisitor cv = this.scriptCompiler.getClassVisitor();
            SkinnyMethodAdapter symMethod = new SkinnyMethodAdapter(cv.visitMethod(4098, methodName, CodegenUtils.sig(RubySymbol.class, Ruby.class), null, null));
            symMethod.start();
            symMethod.aload(0);
            symMethod.getfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(RubySymbol.class));
            symMethod.dup();
            symMethod.astore(2);
            Label ifNullEnd = new Label();
            symMethod.ifnull(ifNullEnd);
            symMethod.aload(2);
            symMethod.areturn();
            symMethod.label(ifNullEnd);
            symMethod.aload(0);
            symMethod.aload(1);
            symMethod.ldc(symbol);
            symMethod.invokevirtual(CodegenUtils.p(Ruby.class), "fastNewSymbol", CodegenUtils.sig(RubySymbol.class, String.class));
            symMethod.dup_x1();
            symMethod.putfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(RubySymbol.class));
            symMethod.areturn();
            symMethod.end();
        }
        method.aload(0);
        method.aload(6);
        method.invokevirtual(this.scriptCompiler.getClassname(), methodName, CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(Ruby.class)));
    }
}

