/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyProc
extends RubyObject
implements JumpTarget {
    private Block block = Block.NULL_BLOCK;
    private Block.Type type;
    private static ObjectAllocator PROC_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyProc instance = RubyProc.newProc(runtime, Block.Type.PROC);
            instance.setMetaClass(klass);
            return instance;
        }
    };

    public RubyProc(Ruby runtime, RubyClass rubyClass, Block.Type type) {
        super(runtime, rubyClass);
        this.type = type;
    }

    public static RubyClass createProcClass(Ruby runtime) {
        RubyClass procClass = runtime.defineClass("Proc", runtime.getObject(), PROC_ALLOCATOR);
        runtime.setProc(procClass);
        procClass.defineAnnotatedMethods(RubyProc.class);
        return procClass;
    }

    public Block getBlock() {
        return this.block;
    }

    public static RubyProc newProc(Ruby runtime, Block.Type type) {
        return new RubyProc(runtime, runtime.getProc(), type);
    }

    public static RubyProc newProc(Ruby runtime, Block block, Block.Type type) {
        RubyProc proc = new RubyProc(runtime, runtime.getProc(), type);
        proc.callInit(NULL_ARRAY, block);
        return proc;
    }

    @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        if (!block.isGiven()) {
            block = runtime.getCurrentContext().getPreviousFrame().getBlock();
        }
        if (block.isGiven() && block.getProcObject() != null) {
            return block.getProcObject();
        }
        IRubyObject obj = ((RubyClass)recv).allocate();
        obj.callMethod(runtime.getCurrentContext(), "initialize", args, block);
        return obj;
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(Block procBlock) {
        if (!procBlock.isGiven()) {
            throw this.getRuntime().newArgumentError("tried to create Proc object without a block");
        }
        if (this.type != Block.Type.LAMBDA || procBlock == null) {
            // empty if block
        }
        this.block = procBlock.cloneBlock();
        this.block.type = this.type;
        this.block.setProcObject(this);
        return this;
    }

    @JRubyMethod(name={"clone"})
    public IRubyObject rbClone() {
        RubyProc newProc = new RubyProc(this.getRuntime(), this.getRuntime().getProc(), this.type);
        newProc.block = this.getBlock();
        return newProc;
    }

    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        RubyProc newProc = new RubyProc(this.getRuntime(), this.getRuntime().getProc(), this.type);
        newProc.block = this.getBlock();
        return newProc;
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(IRubyObject other) {
        if (!(other instanceof RubyProc)) {
            return this.getRuntime().getFalse();
        }
        if (this == other || this.block == ((RubyProc)other).block) {
            return this.getRuntime().newBoolean(true);
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        Binding binding = this.block.getBinding();
        Frame frame = binding.getFrame();
        return RubyString.newString(this.getRuntime(), "#<Proc:0x" + Integer.toString(this.block.hashCode(), 16) + "@" + frame.getFile() + ":" + (frame.getLine() + 1) + ">");
    }

    @JRubyMethod(name={"binding"})
    public IRubyObject binding() {
        return this.getRuntime().newBinding(this.block.getBinding());
    }

    public IRubyObject call(IRubyObject[] args) {
        return this.call(args, null, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, frame=true)
    public IRubyObject call(IRubyObject[] args, Block unusedBlock) {
        return this.call(args, null, Block.NULL_BLOCK);
    }

    public IRubyObject call(IRubyObject[] args, IRubyObject self, Block unusedBlock) {
        assert (args != null);
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        try {
            Block newBlock = this.block.cloneBlock();
            if (self != null) {
                newBlock.getBinding().setSelf(self);
            }
            if (newBlock.type == Block.Type.LAMBDA) {
                newBlock.getBinding().getFrame().setJumpTarget(this);
            }
            return newBlock.call(context, args);
        }
        catch (JumpException.BreakJump bj) {
            if (this.block.type == Block.Type.LAMBDA) {
                return (IRubyObject)bj.getValue();
            }
            throw runtime.newLocalJumpError("break", (IRubyObject)bj.getValue(), "break from proc-closure");
        }
        catch (JumpException.ReturnJump rj) {
            JumpTarget target = rj.getTarget();
            if (target == this || this.block.type == Block.Type.LAMBDA) {
                return (IRubyObject)rj.getValue();
            }
            if (target == null) {
                if (this.type == Block.Type.THREAD) {
                    throw runtime.newThreadError("return can't jump across threads");
                }
                throw runtime.newLocalJumpError("return", (IRubyObject)rj.getValue(), "unexpected return");
            }
            throw rj;
        }
        catch (JumpException.RetryJump rj) {
            throw runtime.newLocalJumpError("retry", (IRubyObject)rj.getValue(), "retry not supported outside rescue");
        }
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.block.arity().getValue());
    }

    @JRubyMethod(name={"to_proc"})
    public RubyProc to_proc() {
        return this;
    }
}

