/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyIO;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyArgsFile {
    public static void setCurrentLineNumber(IRubyObject recv, int newLineNumber) {
        ArgsFileData.getDataFrom((IRubyObject)recv).currentLineNumber = newLineNumber;
    }

    public static void initArgsFile(Ruby runtime) {
        RubyObject argsFile = new RubyObject(runtime, runtime.getObject());
        runtime.getEnumerable().extend_object(argsFile);
        runtime.defineReadonlyVariable("$<", argsFile);
        runtime.defineGlobalConstant("ARGF", argsFile);
        RubyClass argfClass = argsFile.getMetaClass();
        argfClass.defineAnnotatedMethods(RubyArgsFile.class);
        runtime.defineReadonlyVariable("$FILENAME", runtime.newString("-"));
    }

    @JRubyMethod(name={"fileno", "to_i"})
    public static IRubyObject fileno(IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (!data.startedProcessing && !data.nextArgsFile()) {
            throw recv.getRuntime().newArgumentError("no stream");
        }
        return ((RubyIO)data.currentFile).fileno();
    }

    @JRubyMethod(name={"to_io"})
    public static IRubyObject to_io(IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (!data.startedProcessing && !data.nextArgsFile()) {
            throw recv.getRuntime().newArgumentError("no stream");
        }
        return data.currentFile;
    }

    public static IRubyObject internalGets(IRubyObject recv, IRubyObject[] args) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile()) {
            return recv.getRuntime().getNil();
        }
        ThreadContext context = recv.getRuntime().getCurrentContext();
        IRubyObject line = data.currentFile.callMethod(context, "gets", args);
        while (line instanceof RubyNil) {
            data.currentFile.callMethod(context, "close");
            if (!data.nextArgsFile()) {
                data.currentFile = null;
                return line;
            }
            line = data.currentFile.callMethod(context, "gets", args);
        }
        ++data.currentLineNumber;
        recv.getRuntime().getGlobalVariables().set("$.", recv.getRuntime().newFixnum(data.currentLineNumber));
        return line;
    }

    @JRubyMethod(name={"gets"}, optional=1, frame=true)
    public static IRubyObject gets(IRubyObject recv, IRubyObject[] args) {
        IRubyObject result = RubyArgsFile.internalGets(recv, args);
        if (!result.isNil()) {
            recv.getRuntime().getCurrentContext().getCurrentFrame().setLastLine(result);
        }
        return result;
    }

    @JRubyMethod(name={"readline"}, optional=1, frame=true)
    public static IRubyObject readline(IRubyObject recv, IRubyObject[] args) {
        IRubyObject line = RubyArgsFile.gets(recv, args);
        if (line.isNil()) {
            throw recv.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readlines"}, optional=1, frame=true)
    public static RubyArray readlines(IRubyObject recv, IRubyObject[] args) {
        IRubyObject line;
        IRubyObject[] separatorArgument;
        if (args.length > 0) {
            if (!recv.getRuntime().getNilClass().isInstance(args[0]) && !recv.getRuntime().getString().isInstance(args[0])) {
                throw recv.getRuntime().newTypeError(args[0], recv.getRuntime().getString());
            }
            separatorArgument = new IRubyObject[]{args[0]};
        } else {
            separatorArgument = IRubyObject.NULL_ARRAY;
        }
        RubyArray result = recv.getRuntime().newArray();
        while (!(line = RubyArgsFile.internalGets(recv, separatorArgument)).isNil()) {
            result.append(line);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @JRubyMethod(name={"each_byte"}, frame=true)
    public static IRubyObject each_byte(IRubyObject recv, Block block) {
        IRubyObject ctx;
        ThreadContext threadContext = recv.getRuntime().getCurrentContext();
        while (!(ctx = RubyArgsFile.getc(recv)).isNil()) {
            void bt;
            block.yield((ThreadContext)bt, ctx);
        }
        return recv;
    }

    @JRubyMethod(name={"each_line"}, alias={"each"}, optional=1, frame=true)
    public static IRubyObject each_line(IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject nextLine = RubyArgsFile.internalGets(recv, args);
        while (!nextLine.isNil()) {
            block.yield(recv.getRuntime().getCurrentContext(), nextLine);
            nextLine = RubyArgsFile.internalGets(recv, args);
        }
        return recv;
    }

    @JRubyMethod(name={"file"})
    public static IRubyObject file(IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile()) {
            return recv.getRuntime().getNil();
        }
        return data.currentFile;
    }

    @JRubyMethod(name={"skip"})
    public static IRubyObject skip(IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        data.currentFile = null;
        return recv;
    }

    @JRubyMethod(name={"close"})
    public static IRubyObject close(IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile()) {
            return recv;
        }
        data.currentFile = null;
        data.currentLineNumber = 0;
        return recv;
    }

    @JRubyMethod(name={"closed?"})
    public static IRubyObject closed_p(IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile()) {
            return recv;
        }
        return ((RubyIO)data.currentFile).closed_p();
    }

    @JRubyMethod(name={"binmode"})
    public static IRubyObject binmode(IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile()) {
            throw recv.getRuntime().newArgumentError("no stream");
        }
        return ((RubyIO)data.currentFile).binmode();
    }

    @JRubyMethod(name={"lineno"})
    public static IRubyObject lineno(IRubyObject recv) {
        return recv.getRuntime().newFixnum(ArgsFileData.getDataFrom((IRubyObject)recv).currentLineNumber);
    }

    @JRubyMethod(name={"tell"}, alias={"pos"})
    public static IRubyObject tell(IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile()) {
            throw recv.getRuntime().newArgumentError("no stream to tell");
        }
        return ((RubyIO)data.currentFile).pos();
    }

    @JRubyMethod(name={"rewind"})
    public static IRubyObject rewind(IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile()) {
            throw recv.getRuntime().newArgumentError("no stream to rewind");
        }
        return ((RubyIO)data.currentFile).rewind();
    }

    @JRubyMethod(name={"eof", "eof?"})
    public static IRubyObject eof(IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile != null && !data.nextArgsFile()) {
            return recv.getRuntime().getTrue();
        }
        return ((RubyIO)data.currentFile).eof_p();
    }

    @JRubyMethod(name={"pos="}, required=1)
    public static IRubyObject set_pos(IRubyObject recv, IRubyObject offset) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile()) {
            throw recv.getRuntime().newArgumentError("no stream to set position");
        }
        return ((RubyIO)data.currentFile).pos_set(offset);
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1)
    public static IRubyObject seek(IRubyObject recv, IRubyObject[] args) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile()) {
            throw recv.getRuntime().newArgumentError("no stream to seek");
        }
        return ((RubyIO)data.currentFile).seek(args);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public static IRubyObject set_lineno(IRubyObject recv, IRubyObject line) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        data.currentLineNumber = RubyNumeric.fix2int(line);
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"readchar"})
    public static IRubyObject readchar(IRubyObject recv) {
        IRubyObject c = RubyArgsFile.getc(recv);
        if (c.isNil()) {
            throw recv.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod(name={"getc"})
    public static IRubyObject getc(IRubyObject recv) {
        IRubyObject bt;
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        while (true) {
            if (data.currentFile == null && !data.nextArgsFile()) {
                return recv.getRuntime().getNil();
            }
            bt = !(data.currentFile instanceof RubyFile) ? data.currentFile.callMethod(recv.getRuntime().getCurrentContext(), "getc") : ((RubyIO)data.currentFile).getc();
            if (!bt.isNil()) break;
            data.currentFile = null;
        }
        return bt;
    }

    /*
     * WARNING - void declaration
     */
    @JRubyMethod(name={"read"}, optional=2)
    public static IRubyObject read(IRubyObject recv, IRubyObject[] args) {
        IRubyObject len;
        IRubyObject length;
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        long l = 0L;
        if (args.length > 0) {
            length = args[0];
            len = args.length > 1 ? args[1] : recv.getRuntime().getNil();
        } else {
            length = recv.getRuntime().getNil();
            len = recv.getRuntime().getNil();
        }
        if (!length.isNil()) {
            l = RubyNumeric.num2long(length);
        }
        if (!len.isNil()) {
            len = len.convertToString();
            ((RubyString)len).modify();
            ((RubyString)len).getByteList().length(0);
            args[1] = recv.getRuntime().getNil();
        }
        while (true) {
            void tmp;
            if (data.currentFile == null && !data.nextArgsFile()) {
                return len;
            }
            IRubyObject iRubyObject = !(data.currentFile instanceof RubyIO) ? data.currentFile.callMethod(recv.getRuntime().getCurrentContext(), "read", args) : ((RubyIO)data.currentFile).read(args);
            if (len.isNil()) {
                len = iRubyObject;
            } else if (!iRubyObject.isNil()) {
                ((RubyString)len).append(iRubyObject);
            }
            if (iRubyObject.isNil() || length.isNil()) {
                data.currentFile = null;
                continue;
            }
            if (args.length < 1 || (long)((RubyString)len).getByteList().length() >= tmp) break;
            args[0] = recv.getRuntime().newFixnum((long)(tmp -= (long)((RubyString)len).getByteList().length()));
        }
        return len;
    }

    @JRubyMethod(name={"filename"}, alias={"path"})
    public static RubyString filename(IRubyObject recv) {
        return (RubyString)recv.getRuntime().getGlobalVariables().get("$FILENAME");
    }

    @JRubyMethod(name={"to_s"})
    public static IRubyObject to_s(IRubyObject recv) {
        return recv.getRuntime().newString("ARGF");
    }

    private static final class ArgsFileData {
        private Ruby runtime;
        public IRubyObject currentFile;
        public int currentLineNumber;
        public boolean startedProcessing = false;
        public boolean finishedProcessing = false;

        public ArgsFileData(Ruby runtime) {
            this.runtime = runtime;
        }

        public boolean nextArgsFile() {
            if (this.finishedProcessing) {
                return false;
            }
            RubyArray args = (RubyArray)this.runtime.getGlobalVariables().get("$*");
            if (args.getLength() == 0) {
                if (!this.startedProcessing) {
                    this.currentFile = this.runtime.getGlobalVariables().get("$stdin");
                    ((RubyString)this.runtime.getGlobalVariables().get("$FILENAME")).setValue(new StringBuffer("-"));
                    this.currentLineNumber = 0;
                    this.startedProcessing = true;
                    return true;
                }
                this.finishedProcessing = true;
                return false;
            }
            String filename = args.shift().toString();
            ((RubyString)this.runtime.getGlobalVariables().get("$FILENAME")).setValue(new StringBuffer(filename));
            this.currentFile = filename.equals("-") ? this.runtime.getGlobalVariables().get("$stdin") : RubyFile.open(this.runtime.getFile(), new IRubyObject[]{this.runtime.newString(filename)}, Block.NULL_BLOCK);
            this.startedProcessing = true;
            return true;
        }

        public static ArgsFileData getDataFrom(IRubyObject recv) {
            ArgsFileData data = (ArgsFileData)recv.dataGetStruct();
            if (data == null) {
                data = new ArgsFileData(recv.getRuntime());
                recv.dataWrapStruct(data);
            }
            return data;
        }
    }
}

