/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.InputStream;
import java.io.PrintStream;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyNumeric;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SimpleSampler;

public class Main {
    private boolean hasPrintedUsage = false;
    private RubyInstanceConfig config;

    public Main(RubyInstanceConfig config) {
        this.config = config;
    }

    public Main(final InputStream in, final PrintStream out, final PrintStream err) {
        this(new RubyInstanceConfig(){
            {
                this.setInput(in);
                this.setOutput(out);
                this.setError(err);
            }
        });
    }

    public Main() {
        this(new RubyInstanceConfig());
    }

    public static void main(String[] args) {
        Main main = new Main();
        int status = main.run(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    public int run(String[] args) {
        try {
            this.config.processArguments(args);
            return this.run();
        }
        catch (MainExitException mee) {
            if (!mee.isAborted()) {
                if (mee.isUsageError()) {
                    this.printUsage();
                } else {
                    this.config.getOutput().println(mee.getMessage());
                }
            }
            return mee.getStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        if (this.config.isShowVersion()) {
            this.showVersion();
        }
        if (this.config.isShowCopyright()) {
            this.showCopyright();
        }
        if (!this.config.shouldRunInterpreter()) {
            if (this.config.shouldPrintUsage()) {
                this.printUsage();
            }
            if (this.config.shouldPrintProperties()) {
                this.printProperties();
            }
            return 0;
        }
        InputStream in = this.config.getScriptSource();
        String filename = this.config.displayedFileName();
        Ruby runtime = Ruby.newInstance(this.config);
        if (in != null) {
            if (this.config.isShouldCheckSyntax()) {
                runtime.parseFromMain(in, filename);
                this.config.getOutput().println("Syntax OK");
            } else {
                long now = -1L;
                try {
                    if (this.config.isBenchmarking()) {
                        now = System.currentTimeMillis();
                    }
                    if (this.config.isSamplingEnabled()) {
                        SimpleSampler.startSampleThread();
                    }
                    try {
                        runtime.runFromMain(in, filename);
                    }
                    finally {
                        runtime.tearDown();
                        if (this.config.isBenchmarking()) {
                            this.config.getOutput().println("Runtime: " + (System.currentTimeMillis() - now) + " ms");
                        }
                        if (this.config.isSamplingEnabled()) {
                            SimpleSampler.report();
                        }
                    }
                }
                catch (RaiseException rj) {
                    RubyException raisedException = rj.getException();
                    if (runtime.fastGetClass("SystemExit").isInstance(raisedException)) {
                        IRubyObject status = raisedException.callMethod(runtime.getCurrentContext(), "status");
                        if (status != null && !status.isNil()) {
                            return RubyNumeric.fix2int(status);
                        }
                    }
                    runtime.printError(raisedException);
                    return 1;
                }
            }
        }
        return 0;
    }

    private void showVersion() {
        this.config.getOutput().print(this.config.getVersionString());
    }

    private void showCopyright() {
        this.config.getOutput().print(this.config.getCopyrightString());
    }

    public void printUsage() {
        if (!this.hasPrintedUsage) {
            this.config.getOutput().print(this.config.getBasicUsageHelp());
            this.hasPrintedUsage = true;
        }
    }

    public void printProperties() {
        this.config.getOutput().print(this.config.getPropertyHelp());
    }
}

