/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.joni.BitStatus;
import org.joni.IntHolder;
import org.joni.Regex;
import org.joni.StackEntry;
import org.joni.constants.StackType;

abstract class StackMachine
extends IntHolder
implements StackType {
    protected static final int INVALID_INDEX = -1;
    protected StackEntry[] stack;
    protected int stk;
    protected final int[] repeatStk;
    protected final int memStartStk;
    protected final int memEndStk;
    protected final Regex regex;
    protected byte[] stateCheckBuff;
    int stateCheckBuffSize;
    static final ThreadLocal<WeakReference<StackEntry[]>> stacks = new ThreadLocal<WeakReference<StackEntry[]>>(){

        @Override
        protected WeakReference<StackEntry[]> initialValue() {
            return new WeakReference<StackEntry[]>(StackMachine.allocateStack());
        }
    };
    private static final int STATE_CHECK_BUFF_MALLOC_THRESHOLD_SIZE = 16;

    public StackMachine(Regex regex) {
        this.regex = regex;
        this.stack = regex.stackNeeded ? StackMachine.fetchStack() : null;
        int n = regex.numRepeat + (regex.numMem << 1);
        this.repeatStk = n > 0 ? new int[n] : null;
        this.memStartStk = regex.numRepeat - 1;
        this.memEndStk = this.memStartStk + regex.numMem;
    }

    private static StackEntry[] allocateStack() {
        StackEntry[] stack = new StackEntry[64];
        stack[0] = new StackEntry();
        return stack;
    }

    private void doubleStack() {
        StackEntry[] newStack = new StackEntry[this.stack.length << 1];
        System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
        this.stack = newStack;
    }

    private static StackEntry[] fetchStack() {
        WeakReference<StackEntry[]> ref = stacks.get();
        StackEntry[] stack = (StackEntry[])ref.get();
        if (stack == null) {
            stack = StackMachine.allocateStack();
            ref = new WeakReference<StackEntry[]>(stack);
            stacks.set(ref);
        }
        return stack;
    }

    protected final void init() {
        if (this.stack != null) {
            this.pushEnsured(1, this.regex.codeLength - 1);
        }
        if (this.repeatStk != null) {
            for (int i = 1; i <= this.regex.numMem; ++i) {
                this.repeatStk[i + this.memEndStk] = -1;
                this.repeatStk[i + this.memStartStk] = -1;
            }
        }
    }

    protected final void ensure1() {
        if (this.stk >= this.stack.length) {
            this.doubleStack();
        }
        if (this.stack[this.stk] == null) {
            this.stack[this.stk] = new StackEntry();
        }
    }

    protected final void pushType(int type) {
        this.ensure1();
        ++this.stk;
        this.stack[this.stk].type = type;
    }

    protected abstract void stateCheckMark();

    void stateCheckBuffInit(int strLength, int offset, int stateNum) {
        if (stateNum > 0 && strLength >= 7) {
            int size = (strLength + 1) * stateNum + 7 >>> 3;
            offset = offset * stateNum >>> 3;
            if (size > 0 && offset < size && size < 16384) {
                this.stateCheckBuff = size >= 16 ? new byte[size] : new byte[size];
                Arrays.fill(this.stateCheckBuff, offset, size - offset, (byte)0);
                this.stateCheckBuffSize = size;
            } else {
                this.stateCheckBuff = null;
                this.stateCheckBuffSize = 0;
            }
        } else {
            this.stateCheckBuff = null;
            this.stateCheckBuffSize = 0;
        }
    }

    private void push(int type, int pat, int s, int prev) {
        this.ensure1();
        StackEntry e = this.stack[this.stk];
        e.type = type;
        e.setStatePCode(pat);
        e.setStatePStr(s);
        e.setStatePStrPrev(prev);
        ++this.stk;
    }

    protected final void pushEnsured(int type, int pat) {
        StackEntry e = this.stack[this.stk];
        e.type = type;
        e.setStatePCode(pat);
        ++this.stk;
    }

    protected final void pushAltWithStateCheck(int pat, int s, int sprev, int snum) {
        this.ensure1();
        StackEntry e = this.stack[this.stk];
        e.type = 1;
        e.setStatePCode(pat);
        e.setStatePStr(s);
        e.setStatePStrPrev(sprev);
        ++this.stk;
    }

    protected final void pushStateCheck(int s, int snum) {
        if (this.stateCheckBuff != null) {
            this.ensure1();
            StackEntry e = this.stack[this.stk];
            e.type = 4096;
            e.setStatePStr(s);
            e.setStateCheck(snum);
            ++this.stk;
        }
    }

    protected final void pushAlt(int pat, int s, int prev) {
        this.push(1, pat, s, prev);
    }

    protected final void pushPos(int s, int prev) {
        this.push(1280, -1, s, prev);
    }

    protected final void pushPosNot(int pat, int s, int prev) {
        this.push(3, pat, s, prev);
    }

    protected final void pushStopBT() {
        this.pushType(1536);
    }

    protected final void pushLookBehindNot(int pat, int s, int sprev) {
        this.push(2, pat, s, sprev);
    }

    protected final void pushRepeat(int id, int pat) {
        this.ensure1();
        StackEntry e = this.stack[this.stk];
        e.type = 1792;
        e.setRepeatNum(id);
        e.setRepeatPCode(pat);
        e.setRepeatCount(0);
        ++this.stk;
    }

    protected final void pushRepeatInc(int sindex) {
        this.ensure1();
        StackEntry e = this.stack[this.stk];
        e.type = 768;
        e.setSi(sindex);
        ++this.stk;
    }

    protected final void pushMemStart(int mnum, int s) {
        this.ensure1();
        StackEntry e = this.stack[this.stk];
        e.type = 256;
        e.setMemNum(mnum);
        e.setMemPstr(s);
        e.setMemStart(this.repeatStk[this.memStartStk + mnum]);
        e.setMemEnd(this.repeatStk[this.memEndStk + mnum]);
        this.repeatStk[this.memStartStk + mnum] = this.stk++;
        this.repeatStk[this.memEndStk + mnum] = -1;
    }

    protected final void pushMemEnd(int mnum, int s) {
        this.ensure1();
        StackEntry e = this.stack[this.stk];
        e.type = 33280;
        e.setMemNum(mnum);
        e.setMemPstr(s);
        e.setMemStart(this.repeatStk[this.memStartStk + mnum]);
        e.setMemEnd(this.repeatStk[this.memEndStk + mnum]);
        this.repeatStk[this.memEndStk + mnum] = this.stk++;
    }

    protected final void pushMemEndMark(int mnum) {
        this.ensure1();
        StackEntry e = this.stack[this.stk];
        e.type = 33792;
        e.setMemNum(mnum);
        ++this.stk;
    }

    protected final int getMemStart(int mnum) {
        int level = 0;
        int stkp = this.stk;
        while (stkp > 0) {
            StackEntry e = this.stack[--stkp];
            if ((e.type & 0x8000) != 0 && e.getMemNum() == mnum) {
                ++level;
                continue;
            }
            if (e.type != 256 || e.getMemNum() != mnum) continue;
            if (level == 0) break;
            --level;
        }
        return stkp;
    }

    protected final void pushNullCheckStart(int cnum, int s) {
        this.ensure1();
        StackEntry e = this.stack[this.stk];
        e.type = 12288;
        e.setNullCheckNum(cnum);
        e.setNullCheckPStr(s);
        ++this.stk;
    }

    protected final void pushNullCheckEnd(int cnum) {
        this.ensure1();
        StackEntry e = this.stack[this.stk];
        e.type = 20480;
        e.setNullCheckNum(cnum);
        ++this.stk;
    }

    protected final void pushCallFrame(int pat) {
        this.ensure1();
        StackEntry e = this.stack[this.stk];
        e.type = 2048;
        e.setCallFrameRetAddr(pat);
        ++this.stk;
    }

    protected final void pushReturn() {
        this.ensure1();
        StackEntry e = this.stack[this.stk];
        e.type = 2304;
        ++this.stk;
    }

    protected final void popOne() {
        --this.stk;
    }

    protected final StackEntry pop() {
        StackEntry e2;
        switch (this.regex.stackPopLevel) {
            case 0: {
                StackEntry e2;
                do {
                    e2 = this.stack[--this.stk];
                } while ((e2.type & 0xFF) == 0);
                return e2;
            }
            case 1: {
                StackEntry e2;
                while (true) {
                    e2 = this.stack[--this.stk];
                    if ((e2.type & 0xFF) != 0) break;
                    if (e2.type != 256) continue;
                    this.repeatStk[this.memStartStk + e2.getMemNum()] = e2.getMemStart();
                    this.repeatStk[this.memEndStk + e2.getMemNum()] = e2.getMemEnd();
                }
                return e2;
            }
        }
        while (true) {
            e2 = this.stack[--this.stk];
            if ((e2.type & 0xFF) != 0) break;
            if (e2.type == 256) {
                this.repeatStk[this.memStartStk + e2.getMemNum()] = e2.getMemStart();
                this.repeatStk[this.memEndStk + e2.getMemNum()] = e2.getMemEnd();
                continue;
            }
            if (e2.type == 768) {
                this.stack[e2.getSi()].decreaseRepeatCount();
                continue;
            }
            if (e2.type != 33280) continue;
            this.repeatStk[this.memStartStk + e2.getMemNum()] = e2.getMemStart();
            this.repeatStk[this.memEndStk + e2.getMemNum()] = e2.getMemEnd();
        }
        return e2;
    }

    protected final void popTilPosNot() {
        while (true) {
            --this.stk;
            StackEntry e = this.stack[this.stk];
            if (e.type == 3) break;
            if (e.type == 256) {
                this.repeatStk[this.memStartStk + e.getMemNum()] = e.getMemStart();
                this.repeatStk[this.memEndStk + e.getMemNum()] = e.getMemStart();
                continue;
            }
            if (e.type == 768) {
                this.stack[e.getSi()].decreaseRepeatCount();
                continue;
            }
            if (e.type != 33280) continue;
            this.repeatStk[this.memStartStk + e.getMemNum()] = e.getMemStart();
            this.repeatStk[this.memEndStk + e.getMemNum()] = e.getMemStart();
        }
    }

    protected final void popTilLookBehindNot() {
        while (true) {
            --this.stk;
            StackEntry e = this.stack[this.stk];
            if (e.type == 2) break;
            if (e.type == 256) {
                this.repeatStk[this.memStartStk + e.getMemNum()] = e.getMemStart();
                this.repeatStk[this.memEndStk + e.getMemNum()] = e.getMemEnd();
                continue;
            }
            if (e.type == 768) {
                this.stack[e.getSi()].decreaseRepeatCount();
                continue;
            }
            if (e.type != 33280) continue;
            this.repeatStk[this.memStartStk + e.getMemNum()] = e.getMemStart();
            this.repeatStk[this.memEndStk + e.getMemNum()] = e.getMemEnd();
        }
    }

    protected final int posEnd() {
        int k = this.stk;
        while (true) {
            StackEntry e = this.stack[--k];
            if ((e.type & 0x10FF) != 0) {
                e.type = 2560;
                continue;
            }
            if (e.type == 1280) break;
        }
        e.type = 2560;
        return k;
    }

    protected final void stopBtEnd() {
        int k = this.stk;
        while (true) {
            StackEntry e = this.stack[--k];
            if ((e.type & 0x10FF) != 0) {
                e.type = 2560;
                continue;
            }
            if (e.type == 1536) break;
        }
        e.type = 2560;
    }

    protected final int nullCheck(int id, int s) {
        StackEntry e;
        int k = this.stk;
        do {
            e = this.stack[--k];
        } while (e.type != 12288 || e.getNullCheckNum() != id);
        return e.getNullCheckPStr() == s ? 1 : 0;
    }

    protected final int nullCheckRec(int id, int s) {
        int level = 0;
        int k = this.stk;
        while (true) {
            StackEntry e = this.stack[--k];
            if (e.type == 12288) {
                if (e.getNullCheckNum() != id) continue;
                if (level == 0) {
                    return e.getNullCheckPStr() == s ? 1 : 0;
                }
                --level;
                continue;
            }
            if (e.type != 20480) continue;
            ++level;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final int nullCheckMemSt(int id, int s) {
        void var5_5;
        int e;
        StackEntry stackEntry;
        int k = this.stk;
        do {
            stackEntry = this.stack[--k];
        } while (stackEntry.type != 12288 || stackEntry.getNullCheckNum() != id);
        if (stackEntry.getNullCheckPStr() != s) {
            e = 0;
        } else {
            e = 1;
            while (k < this.stk) {
                StackEntry isNull;
                if (isNull.type == 256) {
                    if (isNull.getMemEnd() == -1) {
                        e = 0;
                        break;
                    }
                    int endp = BitStatus.bsAt(this.regex.btMemEnd, isNull.getMemNum()) ? this.stack[isNull.getMemEnd()].getMemPStr() : isNull.getMemEnd();
                    if (this.stack[isNull.getMemStart()].getMemPStr() != endp) {
                        e = 0;
                        break;
                    }
                    if (endp != s) {
                        e = -1;
                    }
                }
                isNull = this.stack[++k];
            }
        }
        return (int)var5_5;
    }

    /*
     * WARNING - void declaration
     */
    protected final int nullCheckMemStRec(int id, int s) {
        void var6_6;
        int level = 0;
        int k = this.stk;
        block0: while (true) {
            StackEntry isNull;
            StackEntry stackEntry = this.stack[--k];
            if (stackEntry.type == 12288) {
                if (stackEntry.getNullCheckNum() != id) continue;
                if (level == 0) {
                    int e;
                    if (stackEntry.getNullCheckPStr() != s) {
                        e = 0;
                        break;
                    }
                    e = 1;
                    while (k < this.stk) {
                        if (isNull.type == 256) {
                            if (isNull.getMemEnd() == -1) {
                                e = 0;
                                break block0;
                            }
                            int endp = BitStatus.bsAt(this.regex.btMemEnd, isNull.getMemNum()) ? this.stack[isNull.getMemEnd()].getMemPStr() : isNull.getMemEnd();
                            if (this.stack[isNull.getMemStart()].getMemPStr() != endp) {
                                e = 0;
                                break block0;
                            }
                            if (endp != s) {
                                e = -1;
                            }
                        }
                        isNull = this.stack[++k];
                    }
                    break;
                }
                --level;
                continue;
            }
            if (isNull.type != 20480 || isNull.getNullCheckNum() != id) continue;
            ++level;
        }
        return (int)var6_6;
    }

    protected final int getRepeat(int id) {
        int level = 0;
        int k = this.stk;
        while (true) {
            StackEntry e = this.stack[--k];
            if (e.type == 1792) {
                if (level != 0 || e.getRepeatNum() != id) continue;
                return k;
            }
            if (e.type == 2048) {
                --level;
                continue;
            }
            if (e.type != 2304) continue;
            ++level;
        }
    }

    protected final int sreturn() {
        int level = 0;
        int k = this.stk;
        while (true) {
            StackEntry e = this.stack[--k];
            if (e.type == 2048) {
                if (level == 0) {
                    return e.getCallFrameRetAddr();
                }
                --level;
                continue;
            }
            if (e.type != 2304) continue;
            ++level;
        }
    }
}

