/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.string;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.jruby.util.string.UstrException;

public class Ustr
implements Comparable,
Serializable {
    private static final long serialVersionUID = -7263880042540200296L;
    private static final byte[] encLength = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, -1, -1, -1, -1, -1, -1, -1, -1};
    private static Hashtable interns = new Hashtable();
    public byte[] s;
    public int base = 0;
    public int offset = 0;

    public Ustr() {
        this.offset = 0;
        this.base = 0;
    }

    public Ustr(int length) {
        this.s = new byte[length];
        this.offset = 0;
        this.base = 0;
        this.s[0] = 0;
    }

    public Ustr(byte[] bytes) {
        this.s = bytes;
        this.offset = 0;
        this.base = 0;
    }

    public Ustr(byte[] bytes, int start) {
        this.s = bytes;
        this.base = this.offset = start;
    }

    public Ustr(Ustr from) {
        this.s = new byte[from.strlen() + 1];
        this.offset = 0;
        this.base = 0;
        this.strcpy(from);
    }

    public Ustr(char[] chars) {
        int i;
        int size = 0;
        for (i = 0; i < chars.length; ++i) {
            char utf16 = chars[i];
            size += Ustr.bytesInChar(utf16);
        }
        this.s = new byte[size + 1];
        this.base = 0;
        this.prepareAppend();
        for (i = 0; i < chars.length; ++i) {
            int val = chars[i];
            if (val >= 55296 && val <= 57343) {
                if (val > 56319) {
                    throw new UstrException("Mangled surrogate pair");
                }
                if (++i == chars.length) {
                    throw new UstrException("Mangled surrogate pair");
                }
                int val2 = chars[i];
                if (val2 < 56320 || val2 > 57343) {
                    throw new UstrException("Mangled surrogate pair");
                }
                val &= 0x3FF;
                val <<= 10;
                val |= (val2 &= 0x3FF);
                val += 65536;
            }
            this.appendChar(val);
        }
        this.s[this.s.length - 1] = 0;
    }

    public Ustr(int[] ints) {
        int i;
        int j;
        int bufsiz = 0;
        for (j = 0; j < ints.length; ++j) {
            i = ints[j];
            if (i < 0) {
                throw new UstrException("Negative character value");
            }
            if (i > 0x10FFFF) {
                throw new UstrException("Character out of Unicode range");
            }
            bufsiz += Ustr.bytesInChar(i);
        }
        this.s = new byte[bufsiz + 1];
        this.offset = 0;
        this.base = 0;
        for (j = 0; j < ints.length; ++j) {
            i = ints[j];
            this.appendChar(i);
        }
    }

    public Ustr(Object o) {
        byte[] inbytes;
        this.offset = 0;
        this.base = 0;
        try {
            inbytes = o.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UstrException("UTF8 not supported!?!?");
        }
        this.s = new byte[inbytes.length + 1];
        for (int i = 0; i < inbytes.length; ++i) {
            this.s[i] = inbytes[i];
        }
        this.s[inbytes.length] = 0;
    }

    public Ustr(int space, Object o) {
        byte[] b;
        this.s = new byte[space];
        this.offset = 0;
        this.base = 0;
        try {
            b = o.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 not supported!?!?");
        }
        for (int i = 0; i < b.length; ++i) {
            this.s[i] = b[i];
        }
        this.s[b.length] = 0;
    }

    public void init() {
        this.s[this.base] = 0;
        this.offset = this.base;
    }

    public int compareTo(Object other) {
        Ustr o = other instanceof Ustr ? (Ustr)other : new Ustr(other);
        return Ustr.strcmp(this.s, this.base, o.s, o.base);
    }

    public String toString() {
        try {
            return new String(this.s, this.base, this.strlen(), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UstrException("UTF8 not supported!?!?");
        }
    }

    public int length() {
        int saveOffset = this.offset;
        int l = 0;
        this.prepareNext();
        while (this.nextChar() != 0) {
            ++l;
        }
        this.offset = saveOffset;
        return l;
    }

    public static int length(byte[] b, int offset) {
        return new Ustr(b, offset).length();
    }

    public static int length(byte[] b) {
        return Ustr.length(b, 0);
    }

    public static int length(String str) {
        return new Ustr(str).length();
    }

    public void prepareAppend() {
        this.offset = this.strlen();
    }

    public void appendChar(int c) {
        this.offset = Ustr.appendChar(c, this.s, this.offset);
    }

    public static int appendChar(int c, byte[] s, int offset) {
        if (c < 0) {
            throw new UstrException("Appended negative character");
        }
        if (c < 128) {
            s[offset++] = (byte)c;
        } else if (c <= 2047) {
            s[offset++] = (byte)(c >> 6 | 0xC0);
            s[offset++] = (byte)(c & 0x3F | 0x80);
        } else if (c <= 65535) {
            s[offset++] = (byte)(c >> 12 | 0xE0);
            s[offset++] = (byte)(c >> 6 & 0x3F | 0x80);
            s[offset++] = (byte)(c & 0x3F | 0x80);
        } else if (c <= 0x10FFFF) {
            s[offset++] = (byte)(c >> 18 | 0xF0);
            s[offset++] = (byte)(c >> 12 & 0x3F | 0x80);
            s[offset++] = (byte)(c >> 6 & 0x3F | 0x80);
            s[offset++] = (byte)(c & 0x3F | 0x80);
        } else {
            throw new UstrException("Appended character > 0x10ffff");
        }
        s[offset] = 0;
        return offset;
    }

    public void prepareNext() {
        this.offset = this.base;
    }

    public int nextChar() {
        if (this.s[this.offset] == 0) {
            return 0;
        }
        if ((this.s[this.offset] & 0x80) == 0) {
            return this.s[this.offset++];
        }
        if ((this.s[this.offset] & 0xE0) == 192) {
            int c = (this.s[this.offset++] & 0x1F) << 6;
            return c |= this.s[this.offset++] & 0x3F;
        }
        if ((this.s[this.offset] & 0xF0) == 224) {
            int c = (this.s[this.offset++] & 0xF) << 12;
            c |= (this.s[this.offset++] & 0x3F) << 6;
            return c |= this.s[this.offset++] & 0x3F;
        }
        int c = (this.s[this.offset++] & 7) << 18;
        c |= (this.s[this.offset++] & 0x3F) << 12;
        c |= (this.s[this.offset++] & 0x3F) << 6;
        return c |= this.s[this.offset++] & 0x3F;
    }

    public int strlen() {
        return Ustr.strlen(this.s, this.base);
    }

    public static int strlen(byte[] b) {
        int i = 0;
        while (b[i] != 0) {
            ++i;
        }
        return i;
    }

    public static int strlen(byte[] b, int base) {
        int i = base;
        while (b[i] != 0) {
            ++i;
        }
        return i - base;
    }

    public static byte[] strcpy(byte[] to, byte[] from) {
        return Ustr.strcpy(to, 0, from, 0);
    }

    public static byte[] strcpy(byte[] to, int tbase, byte[] from, int fbase) {
        while (from[fbase] != 0) {
            to[tbase++] = from[fbase++];
        }
        to[tbase] = 0;
        return to;
    }

    public Ustr strcpy(Ustr from) {
        Ustr.strcpy(this.s, this.base, from.s, from.base);
        return this;
    }

    public Ustr strcpy(Object o) {
        this.strcpy(new Ustr(o));
        return this;
    }

    public Ustr strcpy(byte[] from) {
        Ustr.strcpy(this.s, from);
        return this;
    }

    public Ustr strcpy(byte[] from, int boffset) {
        Ustr.strcpy(this.s, 0, from, boffset);
        return this;
    }

    public static byte[] strcpy(byte[] b, String s) {
        return Ustr.strcpy(b, 0, s);
    }

    public static byte[] strcpy(byte[] b, int offset, String s) {
        byte[] sbytes;
        try {
            sbytes = s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 not supported!?!?");
        }
        for (int i = 0; i < sbytes.length; ++i) {
            b[offset + i] = sbytes[i];
        }
        b[offset + sbytes.length] = 0;
        return b;
    }

    public Ustr sstrcat(Ustr from) {
        Ustr.sstrcat(this.s, this.base, from.s, from.base);
        return this;
    }

    public byte[] sstrcat(byte[] to, byte[] from) {
        return Ustr.sstrcat(to, 0, from, 0);
    }

    public static byte[] sstrcat(byte[] to, int tbase, byte[] from, int fbase) {
        while (to[tbase] != 0) {
            ++tbase;
        }
        try {
            while (from[fbase] != 0) {
                to[tbase++] = from[fbase++];
            }
            to[tbase] = 0;
            return to;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (tbase < to.length) {
                throw e;
            }
            to[to.length - 1] = 0;
            return to;
        }
    }

    public static byte[] sstrcpy(byte[] to, int tbase, byte[] from, int fbase) {
        try {
            while (from[fbase] != 0) {
                to[tbase++] = from[fbase++];
            }
            to[tbase] = 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (tbase >= to.length) {
                to[to.length - 1] = 0;
            }
            throw e;
        }
        return to;
    }

    public static byte[] sstrcpy(byte[] to, byte[] from) {
        return Ustr.sstrcpy(to, 0, from, 0);
    }

    public Ustr sstrcpy(Ustr from) {
        Ustr.sstrcpy(this.s, this.base, from.s, from.base);
        return this;
    }

    public static byte[] strcat(byte[] to, int tbase, byte[] from, int fbase) {
        while (to[tbase] != 0) {
            ++tbase;
        }
        while (from[fbase] != 0) {
            to[tbase++] = from[fbase++];
        }
        to[tbase] = 0;
        return to;
    }

    public static byte[] strcat(byte[] to, byte[] from) {
        return Ustr.strcat(to, 0, from, 0);
    }

    public Ustr strcat(Ustr other) {
        Ustr.strcat(this.s, other.s);
        return this;
    }

    public static int strcmp(byte[] s1, byte[] s2) {
        return Ustr.strcmp(s1, 0, s2, 0);
    }

    public static int strcmp(byte[] s1, int s1base, byte[] s2, int s2base) {
        Ustr u1 = new Ustr(s1, s1base);
        Ustr u2 = new Ustr(s2, s2base);
        int c1 = u1.nextChar();
        int c2 = u2.nextChar();
        while (c1 != 0 && c2 != 0 && c1 == c2) {
            c1 = u1.nextChar();
            c2 = u2.nextChar();
        }
        return c1 - c2;
    }

    public int strcmp(Ustr other) {
        return Ustr.strcmp(this.s, this.base, other.s, other.base);
    }

    public int strcmp(Object other) {
        return this.strcmp(new Ustr(other));
    }

    public Ustr strchr(int c) {
        int where = Ustr.strchr(this.s, c);
        return where == -1 ? null : new Ustr(this.s, where);
    }

    public static int strchr(byte[] b, int c) {
        byte[] cbytes = new byte[10];
        Ustr.appendChar(c, cbytes, 0);
        return Ustr.strstr(b, cbytes);
    }

    public Ustr strrchr(int c) {
        int where = Ustr.strrchr(this.s, c);
        return where == -1 ? null : new Ustr(this.s, where);
    }

    public static int strrchr(byte[] b, int c) {
        byte[] cbytes = new byte[10];
        Ustr.appendChar(c, cbytes, 0);
        for (int where = b.length - Ustr.strlen(cbytes); where >= 0; --where) {
            int i = 0;
            while (cbytes[i] != 0 && b[where + i] == cbytes[i]) {
                ++i;
            }
            if (cbytes[i] != 0) continue;
            return where;
        }
        return -1;
    }

    public Ustr strstr(Ustr little) {
        int where = Ustr.strstr(this.s, little.s);
        return where == -1 ? null : new Ustr(this.s, where);
    }

    public static int strstr(byte[] big, byte[] little) {
        int bi = 0;
        while (big[bi] != 0) {
            int li = 0;
            while (little[li] != 0 && big[bi + li] == little[li]) {
                ++li;
            }
            if (little[li] == 0) {
                return bi;
            }
            ++bi;
        }
        return -1;
    }

    static Ustr copyValueOf(char[] data) {
        return new Ustr(data);
    }

    static Ustr copyValueOf(char[] data, int offset, int count) {
        char[] chunk = new char[count];
        for (int i = 0; i < count; ++i) {
            chunk[i] = data[offset + i];
        }
        return new Ustr(chunk);
    }

    public int charAt(int at) throws IndexOutOfBoundsException {
        if (at < 0) {
            throw new IndexOutOfBoundsException("Negative Ustr charAt");
        }
        int c = 0;
        this.offset = 0;
        this.prepareNext();
        while ((c = this.nextChar()) != 0 && --at >= 0) {
        }
        if (at > 0) {
            throw new IndexOutOfBoundsException("Ustr charAt too large");
        }
        return c;
    }

    public Ustr concat(String str) {
        Ustr us = new Ustr(str);
        return this.concat(us);
    }

    public Ustr concat(Ustr us) {
        Ustr ret = new Ustr(this.strlen() + us.strlen() + 1);
        ret.strcpy(this);
        ret.strcat(us);
        return ret;
    }

    public boolean endsWith(Ustr suffix) {
        int start = this.strlen() - suffix.strlen();
        if (start < 0) {
            return false;
        }
        int i = 0;
        while (this.s[this.base + start + i] != 0 && suffix.s[suffix.base + i] != 0 && this.s[this.base + start + i] == suffix.s[suffix.base + i]) {
            ++i;
        }
        return this.s[this.base + start + i] == suffix.s[suffix.base + i];
    }

    public boolean endsWith(String suffix) {
        return this.endsWith(new Ustr(suffix));
    }

    public boolean equals(Object anObject) {
        return this.compareTo(anObject) == 0;
    }

    public byte[] getBytes() {
        return this.toString().getBytes();
    }

    public byte[] getBytes(String enc) throws UnsupportedEncodingException {
        return this.toString().getBytes(enc);
    }

    public static void getChars(String str, int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        Ustr us = new Ustr(str);
        us.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    /*
     * WARNING - void declaration
     */
    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0 || srcBegin > srcEnd || dstBegin < 0) {
            throw new IndexOutOfBoundsException("bogus getChars index bounds");
        }
        if (dst == null) {
            throw new NullPointerException("null 'dst' argument to getChars");
        }
        this.prepareNext();
        while (srcBegin > 0) {
            --srcBegin;
            this.nextChar();
        }
        int n = srcEnd - srcBegin;
        int howMany = 0;
        int i = 0;
        while (i < n) {
            void c;
            int j = this.nextChar();
            if (j == 0 && i < c - true) {
                throw new IndexOutOfBoundsException("getChars ran off buffer");
            }
            if (j < 65536) {
                dst[dstBegin + howMany] = (char)j;
            } else {
                int uHi = (j -= 65536) >> 10 & 0x3FF;
                dst[dstBegin + howMany] = (char)(0xD800 | uHi);
                int uLo = j & 0x3FF;
                dst[dstBegin + ++howMany] = (char)(0xDC00 | uLo);
            }
            ++i;
            ++howMany;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        long n;
        long h = 0L;
        long l = this.length() - 1;
        this.prepareNext();
        while ((n = (long)this.nextChar()) != 0L) {
            void c;
            h += n * Ustr.pow(31L, (long)c);
            --c;
        }
        return (int)(h & 0xFFFFFFFFFFFFFFFFL);
    }

    private static long pow(long a, long b) {
        long p = 1L;
        while (b-- > 0L) {
            p *= a;
        }
        return p;
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int start) {
        int c;
        int i = 0;
        this.prepareNext();
        while (start-- > 0) {
            this.nextChar();
            ++i;
        }
        while ((c = this.nextChar()) != 0) {
            if (c == ch) {
                return i;
            }
            ++i;
        }
        if (ch == 0) {
            return i;
        }
        return -1;
    }

    public int indexOf(Ustr us) {
        return this.indexOf(us, 0);
    }

    public int indexOf(Ustr us, int start) {
        int i = 0;
        this.prepareNext();
        while (start-- > 0) {
            this.nextChar();
            ++i;
        }
        do {
            int j = 0;
            while (this.s[this.base + this.offset + j] != 0 && us.s[us.base + j] != 0 && this.s[this.base + this.offset + j] == us.s[us.base + j]) {
                ++j;
            }
            if (us.s[this.base + j] == 0) {
                return i;
            }
            ++i;
        } while (this.nextChar() != 0);
        return -1;
    }

    public Ustr intern() {
        Ustr u = (Ustr)interns.get(this);
        if (u != null) {
            return u;
        }
        u = new Ustr(this.strlen() + 1);
        u.strcpy(this);
        interns.put(u, u);
        return u;
    }

    public int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.length());
    }

    public int lastIndexOf(int ch, int stop) {
        int i = 0;
        this.prepareNext();
        int foundAt = -1;
        do {
            if (ch != this.nextChar()) continue;
            foundAt = i;
        } while (++i <= stop);
        return foundAt;
    }

    public int lastIndexOf(Ustr us) {
        return this.lastIndexOf(us, this.length());
    }

    public int lastIndexOf(Ustr us, int stop) {
        int i = 0;
        int foundAt = -1;
        this.prepareNext();
        do {
            int j = 0;
            while (this.s[this.base + this.offset + j] != 0 && us.s[us.base + j] != 0 && this.s[this.base + this.offset + j] == us.s[us.base + j]) {
                ++j;
            }
            if (us.s[this.base + j] != 0) continue;
            foundAt = i;
        } while (this.nextChar() != 0 && ++i <= stop);
        return foundAt;
    }

    private static int bytesInChar(int c) {
        if (c < 128) {
            return 1;
        }
        if (c < 2048) {
            return 2;
        }
        if (c < 65536) {
            return 3;
        }
        return 4;
    }

    public Ustr replace(int oldChar, int newChar) {
        int c;
        if (newChar < 0) {
            throw new UstrException("Negative replacement character");
        }
        if (newChar > 0x10FFFF) {
            throw new UstrException("Replacement character > 0x10ffff");
        }
        int space = this.strlen() + 1;
        int delta = Ustr.bytesInChar(newChar) - Ustr.bytesInChar(newChar);
        if (delta != 0) {
            int c2;
            while ((c2 = this.nextChar()) != 0) {
                if (c2 != oldChar) continue;
                space += delta;
            }
        }
        Ustr us = new Ustr(space);
        this.prepareNext();
        us.prepareAppend();
        while ((c = this.nextChar()) != 0) {
            us.appendChar(c == oldChar ? newChar : c);
        }
        return us;
    }

    public boolean startsWith(Ustr us) {
        return this.startsWith(us, 0);
    }

    public boolean startsWith(Ustr us, int start) {
        this.prepareNext();
        while (start-- > 0) {
            this.nextChar();
        }
        int i = 0;
        while (us.s[this.base + i] != 0) {
            if (this.s[this.base + this.offset + i] != us.s[us.base + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Ustr substring(int start) {
        return this.substring(start, this.length());
    }

    public Ustr substring(int start, int end) {
        if (start < 0 || end < start || end > this.length()) {
            throw new IndexOutOfBoundsException("bogus start/end");
        }
        int howMany = end - start;
        this.offset = 0;
        while (start-- > 0) {
            int c = this.s[this.base + this.offset] & 0xFF;
            if (c == 0) {
                throw new IndexOutOfBoundsException("substring too long");
            }
            this.offset += encLength[c];
        }
        int startAt = this.offset;
        for (int i = 0; i < howMany; ++i) {
            int c = this.s[this.base + this.offset] & 0xFF;
            if (c == 0) {
                throw new IndexOutOfBoundsException("substring too long");
            }
            this.offset += encLength[c];
        }
        int bytesToMove = this.offset - startAt;
        Ustr us = new Ustr(bytesToMove + 1);
        System.arraycopy(this.s, startAt, us.s, 0, bytesToMove);
        us.s[bytesToMove] = 0;
        return us;
    }

    public char[] toCharArray() {
        return this.toString().toCharArray();
    }
}

