/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;

public class NoVarsDynamicScope
extends DynamicScope {
    private IRubyObject variableValue;

    public NoVarsDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public NoVarsDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    public void growIfNeeded() {
        if (this.staticScope.getNumberOfVariables() != 0) {
            throw new RuntimeException("NoVarsDynamicScope cannot be grown; use ManyVarsDynamicScope");
        }
    }

    public DynamicScope cloneScope() {
        return new NoVarsDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValue};
    }

    public IRubyObject getValue(int offset, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset, depth - 1);
        }
        throw new RuntimeException("NoVarsDynamicScope only supports scopes with no variables");
    }

    public IRubyObject getValueOrNil(int offset, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset, nil);
    }

    public IRubyObject getValueDepthZeroOrNil(int offset, IRubyObject nil) {
        throw new RuntimeException("NoVarsDynamicScope only supports scopes with no variables");
    }

    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject nil) {
        throw new RuntimeException("NoVarsDynamicScope only supports scopes with no variables");
    }

    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject nil) {
        throw new RuntimeException("NoVarsDynamicScope only supports scopes with no variables");
    }

    public void setValue(int offset, IRubyObject value, int depth) {
        if (depth > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
        } else {
            throw new RuntimeException("NoVarsDynamicScope only supports scopes with no variables");
        }
        this.parent.setValue(offset, value, depth - 1);
    }

    public void setValueDepthZero(IRubyObject value, int offset) {
        throw new RuntimeException("NoVarsDynamicScope only supports scopes with no variables");
    }

    public void setValueZeroDepthZero(IRubyObject value) {
        throw new RuntimeException("NoVarsDynamicScope only supports scopes with no variables");
    }

    public void setValueOneDepthZero(IRubyObject value) {
        throw new RuntimeException("NoVarsDynamicScope only supports scopes with no variables");
    }

    public void setArgValues(IRubyObject[] values, int size) {
        if (size > 0) {
            throw new RuntimeException("NoVarsDynamicScope only supports scopes with no variables");
        }
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int totalArgs = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        if (totalArgs > 0) {
            throw new RuntimeException("NoVarsDynamicScope only supports scopes with no variables");
        }
        return IRubyObject.NULL_ARRAY;
    }

    public String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " []");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }
}

