/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.Collection;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyThread;
import org.jruby.ast.CommentNode;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.libraries.FiberLibrary;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public final class ThreadContext {
    private static final int INITIAL_SIZE = 50;
    private final Ruby runtime;
    private boolean isWithinTrace;
    private boolean isWithinDefined;
    private RubyThread thread;
    private FiberLibrary.Fiber fiber;
    private IRubyObject errorInfo;
    private RubyModule[] parentStack = new RubyModule[50];
    private int parentIndex = -1;
    private Frame[] frameStack = new Frame[50];
    private int frameIndex = -1;
    private DynamicScope[] scopeStack = new DynamicScope[50];
    private int scopeIndex = -1;
    private RubyKernel.CatchTarget[] catchStack = new RubyKernel.CatchTarget[50];
    private int catchIndex = -1;
    private ISourcePosition sourcePosition = new ISourcePosition(){

        @Override
        public void adjustStartOffset(int relativeValue) {
        }

        @Override
        public int getEndLine() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return 0;
        }

        @Override
        public String getFile() {
            return "";
        }

        @Override
        public int getStartLine() {
            return 0;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public ISourcePosition union(ISourcePosition position) {
            return this;
        }

        @Override
        public Collection<CommentNode> getComments() {
            return null;
        }

        @Override
        public void setComments(Collection<CommentNode> comments) {
        }
    };
    CallType lastCallType;
    Visibility lastVisibility;
    IRubyObject lastExitStatus;

    public static synchronized ThreadContext newContext(Ruby runtime) {
        ThreadContext context = new ThreadContext(runtime);
        return context;
    }

    private ThreadContext(Ruby runtime) {
        this.runtime = runtime;
        this.errorInfo = runtime.getNil();
        LocalStaticScope topStaticScope = new LocalStaticScope(null);
        this.pushScope(new ManyVarsDynamicScope(topStaticScope, null));
        for (int i = 0; i < this.frameStack.length; ++i) {
            this.frameStack[i] = new Frame();
        }
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public IRubyObject getErrorInfo() {
        return this.errorInfo;
    }

    public IRubyObject setErrorInfo(IRubyObject errorInfo) {
        this.errorInfo = errorInfo;
        return errorInfo;
    }

    public void setLastCallStatus(CallType callType) {
        this.lastCallType = callType;
    }

    public CallType getLastCallType() {
        return this.lastCallType;
    }

    public void setLastVisibility(Visibility visibility) {
        this.lastVisibility = visibility;
    }

    public Visibility getLastVisibility() {
        return this.lastVisibility;
    }

    public IRubyObject getLastExitStatus() {
        return this.lastExitStatus;
    }

    public void setLastExitStatus(IRubyObject lastExitStatus) {
        this.lastExitStatus = lastExitStatus;
    }

    public void printScope() {
        System.out.println("SCOPE STACK:");
        for (int i = 0; i <= this.scopeIndex; ++i) {
            System.out.println(this.scopeStack[i]);
        }
    }

    public DynamicScope getCurrentScope() {
        return this.scopeStack[this.scopeIndex];
    }

    public DynamicScope getPreviousScope() {
        return this.scopeStack[this.scopeIndex - 1];
    }

    private void expandFramesIfNecessary(int newMax) {
        if (newMax == this.frameStack.length) {
            int newSize = this.frameStack.length * 2;
            Frame[] newFrameStack = new Frame[newSize];
            System.arraycopy(this.frameStack, 0, newFrameStack, 0, this.frameStack.length);
            for (int i = this.frameStack.length; i < newSize; ++i) {
                newFrameStack[i] = new Frame();
            }
            this.frameStack = newFrameStack;
        }
    }

    private void expandParentsIfNecessary() {
        if (this.parentIndex + 1 == this.parentStack.length) {
            int newSize = this.parentStack.length * 2;
            RubyModule[] newParentStack = new RubyModule[newSize];
            System.arraycopy(this.parentStack, 0, newParentStack, 0, this.parentStack.length);
            this.parentStack = newParentStack;
        }
    }

    public void pushScope(DynamicScope scope) {
        this.scopeStack[++this.scopeIndex] = scope;
        this.expandScopesIfNecessary();
    }

    public void popScope() {
        this.scopeStack[this.scopeIndex--] = null;
    }

    private void expandScopesIfNecessary() {
        if (this.scopeIndex + 1 == this.scopeStack.length) {
            int newSize = this.scopeStack.length * 2;
            DynamicScope[] newScopeStack = new DynamicScope[newSize];
            System.arraycopy(this.scopeStack, 0, newScopeStack, 0, this.scopeStack.length);
            this.scopeStack = newScopeStack;
        }
    }

    public RubyThread getThread() {
        return this.thread;
    }

    public void setThread(RubyThread thread) {
        this.thread = thread;
    }

    public FiberLibrary.Fiber getFiber() {
        return this.fiber;
    }

    public void setFiber(FiberLibrary.Fiber fiber) {
        this.fiber = fiber;
    }

    private void expandCatchIfNecessary() {
        if (this.catchIndex + 1 == this.catchStack.length) {
            int newSize = this.catchStack.length * 2;
            RubyKernel.CatchTarget[] newCatchStack = new RubyKernel.CatchTarget[newSize];
            System.arraycopy(this.catchStack, 0, newCatchStack, 0, this.catchStack.length);
            this.catchStack = newCatchStack;
        }
    }

    public void pushCatch(RubyKernel.CatchTarget catchTarget) {
        this.catchStack[++this.catchIndex] = catchTarget;
        this.expandCatchIfNecessary();
    }

    public void popCatch() {
        --this.catchIndex;
    }

    public RubyKernel.CatchTarget[] getActiveCatches() {
        if (this.catchIndex < 0) {
            return new RubyKernel.CatchTarget[0];
        }
        RubyKernel.CatchTarget[] activeCatches = new RubyKernel.CatchTarget[this.catchIndex + 1];
        System.arraycopy(this.catchStack, 0, activeCatches, 0, this.catchIndex + 1);
        return activeCatches;
    }

    private void pushFrameCopy() {
        Frame currentFrame = this.getCurrentFrame();
        this.frameStack[++this.frameIndex].updateFrame(currentFrame);
        this.expandFramesIfNecessary(this.frameIndex + 1);
    }

    private void pushFrame(Frame frame) {
        this.frameStack[++this.frameIndex] = frame;
        this.expandFramesIfNecessary(this.frameIndex + 1);
    }

    private void pushCallFrame(RubyModule clazz, String name, IRubyObject self, Block block, JumpTarget jumpTarget) {
        this.pushFrame(clazz, name, self, block, jumpTarget);
    }

    private void pushFrame(RubyModule clazz, String name, IRubyObject self, Block block, JumpTarget jumpTarget) {
        this.frameStack[++this.frameIndex].updateFrame(clazz, self, name, block, this.getPosition(), jumpTarget);
        this.expandFramesIfNecessary(this.frameIndex + 1);
    }

    private void pushFrame() {
        this.frameStack[++this.frameIndex].updateFrame(this.getPosition());
        this.expandFramesIfNecessary(this.frameIndex + 1);
    }

    private void popFrame() {
        Frame frame = this.frameStack[this.frameIndex];
        --this.frameIndex;
        this.setPosition(frame.getPosition());
    }

    private void popFrameReal(Frame oldFrame) {
        Frame frame = this.frameStack[this.frameIndex];
        this.frameStack[this.frameIndex] = oldFrame;
        --this.frameIndex;
        this.setPosition(frame.getPosition());
    }

    private void popFrameReal() {
        Frame frame = this.frameStack[this.frameIndex];
        this.frameStack[this.frameIndex] = new Frame();
        --this.frameIndex;
        this.setPosition(frame.getPosition());
    }

    public Frame getCurrentFrame() {
        return this.frameStack[this.frameIndex];
    }

    public Frame getNextFrame() {
        this.expandFramesIfNecessary(this.frameIndex + 1);
        return this.frameStack[this.frameIndex + 1];
    }

    public Frame getPreviousFrame() {
        int size = this.frameIndex + 1;
        return size <= 1 ? null : this.frameStack[size - 2];
    }

    public int getFrameCount() {
        return this.frameIndex + 1;
    }

    public String getFrameName() {
        return this.getCurrentFrame().getName();
    }

    public IRubyObject getFrameSelf() {
        return this.getCurrentFrame().getSelf();
    }

    public JumpTarget getFrameJumpTarget() {
        return this.getCurrentFrame().getJumpTarget();
    }

    public void setFrameJumpTarget(JumpTarget target) {
        this.getCurrentFrame().setJumpTarget(target);
    }

    public RubyModule getFrameKlazz() {
        return this.getCurrentFrame().getKlazz();
    }

    public Block getFrameBlock() {
        return this.getCurrentFrame().getBlock();
    }

    public ISourcePosition getFramePosition() {
        return this.getCurrentFrame().getPosition();
    }

    public ISourcePosition getPreviousFramePosition() {
        return this.getPreviousFrame().getPosition();
    }

    public ISourcePosition getPosition() {
        return this.sourcePosition;
    }

    public String getSourceFile() {
        return this.sourcePosition.getFile();
    }

    public int getSourceLine() {
        return this.sourcePosition.getEndLine();
    }

    public void setPosition(ISourcePosition position) {
        this.sourcePosition = position;
    }

    public Visibility getCurrentVisibility() {
        return this.getCurrentFrame().getVisibility();
    }

    public Visibility getPreviousVisibility() {
        return this.getPreviousFrame().getVisibility();
    }

    public void setCurrentVisibility(Visibility visibility) {
        this.getCurrentFrame().setVisibility(visibility);
    }

    public void pollThreadEvents() {
        this.getThread().pollThreadEvents();
    }

    public void pushRubyClass(RubyModule currentModule) {
        this.parentStack[++this.parentIndex] = currentModule;
        this.expandParentsIfNecessary();
    }

    public RubyModule popRubyClass() {
        RubyModule ret = this.parentStack[this.parentIndex];
        this.parentStack[this.parentIndex--] = null;
        return ret;
    }

    public RubyModule getRubyClass() {
        assert (this.parentIndex != -1) : "Trying to get RubyClass from empty stack";
        RubyModule parentModule = this.parentStack[this.parentIndex];
        return parentModule.getNonIncludedClass();
    }

    public RubyModule getBindingRubyClass() {
        RubyModule parentModule = null;
        parentModule = this.parentIndex == 0 ? this.parentStack[this.parentIndex] : this.parentStack[this.parentIndex - 1];
        return parentModule.getNonIncludedClass();
    }

    /*
     * WARNING - void declaration
     */
    public boolean getConstantDefined(String internedName) {
        IRubyObject iRubyObject = this.runtime.getUndef();
        for (StaticScope undef = this.getCurrentScope().getStaticScope(); undef != null; undef = undef.getPreviousCRefScope()) {
            void result;
            RubyModule scope = undef.getModule();
            IRubyObject module = scope.fastFetchConstant(internedName);
            if (module == null) continue;
            if (module != result) {
                return true;
            }
            return this.runtime.getLoadService().autoloadFor(scope.getName() + "::" + internedName) != null;
        }
        return this.getCurrentScope().getStaticScope().getModule().fastIsConstantDefined(internedName);
    }

    /*
     * WARNING - void declaration
     */
    public IRubyObject getConstant(String internedName) {
        StaticScope scope = this.getCurrentScope().getStaticScope();
        RubyClass object = this.runtime.getObject();
        IRubyObject undef = this.runtime.getUndef();
        do {
            RubyModule rubyModule;
            IRubyObject klass;
            if ((klass = (rubyModule = scope.getModule()).fastFetchConstant(internedName)) != null) {
                void result;
                if (klass != undef) {
                    return klass;
                }
                result.deleteConstant(internedName);
                if (this.runtime.getLoadService().autoload(result.getName() + "::" + internedName) != null) continue;
                break;
            }
            scope = scope.getPreviousCRefScope();
        } while (scope != null && scope.getModule() != object);
        return this.getCurrentScope().getStaticScope().getModule().fastGetConstant(internedName);
    }

    public IRubyObject setConstantInCurrent(String internedName, IRubyObject result) {
        RubyModule module = this.getCurrentScope().getStaticScope().getModule();
        if (module != null) {
            module.fastSetConstant(internedName, result);
            return result;
        }
        throw this.runtime.newTypeError("no class/module to define constant");
    }

    public IRubyObject setConstantInModule(String internedName, RubyModule module, IRubyObject result) {
        module.fastSetConstant(internedName, result);
        return result;
    }

    public IRubyObject setConstantInObject(String internedName, IRubyObject result) {
        this.runtime.getObject().fastSetConstant(internedName, result);
        return result;
    }

    private static void addBackTraceElement(RubyArray backtrace, Frame frame, Frame previousFrame) {
        if (frame.getName() != null && frame.getName().equals(previousFrame.getName()) && frame.getPosition().getFile().equals(previousFrame.getPosition().getFile()) && frame.getPosition().getEndLine() == previousFrame.getPosition().getEndLine()) {
            return;
        }
        StringBuffer buf = new StringBuffer(60);
        buf.append(frame.getPosition().getFile()).append(':').append(frame.getPosition().getEndLine() + 1);
        if (previousFrame.getName() != null) {
            buf.append(":in `").append(previousFrame.getName()).append('\'');
        }
        backtrace.append(backtrace.getRuntime().newString(buf.toString()));
    }

    public static IRubyObject createBacktraceFromFrames(Ruby runtime, Frame[] backtraceFrames) {
        Frame frame;
        RubyArray backtrace = runtime.newArray();
        if (backtraceFrames == null || backtraceFrames.length <= 0) {
            return backtrace;
        }
        int traceSize = backtraceFrames.length;
        for (int i = traceSize - 1; i > 0 && !(frame = backtraceFrames[i]).isBindingFrame(); --i) {
            ThreadContext.addBackTraceElement(backtrace, frame, backtraceFrames[i - 1]);
        }
        return backtrace;
    }

    public Frame[] createBacktrace(int level, boolean nativeException) {
        Frame[] traceFrames;
        int traceSize = this.frameIndex - level + 1;
        if (traceSize <= 0) {
            return null;
        }
        if (nativeException) {
            traceFrames = new Frame[traceSize + 1];
            traceFrames[traceSize] = this.frameStack[this.frameIndex];
        } else {
            traceFrames = new Frame[traceSize];
        }
        System.arraycopy(this.frameStack, 0, traceFrames, 0, traceSize);
        return traceFrames;
    }

    public void preAdoptThread() {
        this.pushFrame();
        this.pushRubyClass(this.runtime.getObject());
        this.getCurrentFrame().setSelf(this.runtime.getTopSelf());
    }

    public void preCompiledClass(RubyModule type, String[] scopeNames) {
        this.pushRubyClass(type);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        LocalStaticScope staticScope = new LocalStaticScope(this.getCurrentScope().getStaticScope(), scopeNames);
        staticScope.setModule(type);
        this.pushScope(new ManyVarsDynamicScope(staticScope, null));
    }

    public void postCompiledClass() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preScopeNode(StaticScope staticScope) {
        this.pushScope(DynamicScope.newDynamicScope(staticScope, this.getCurrentScope()));
    }

    public void postScopeNode() {
        this.popScope();
    }

    public void preClassEval(StaticScope staticScope, RubyModule type) {
        this.pushRubyClass(type);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        this.pushScope(DynamicScope.newDynamicScope(staticScope, null));
    }

    public void postClassEval() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preBsfApply(String[] names) {
        LocalStaticScope staticScope = new LocalStaticScope(null);
        staticScope.setVariables(names);
        this.pushFrame();
    }

    public void postBsfApply() {
        this.popFrame();
    }

    public void preMethodFrameAndScope(RubyModule clazz, String name, IRubyObject self, IRubyObject[] args, int req, Block block, StaticScope staticScope, JumpTarget jumpTarget) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushCallFrame(clazz, name, self, block, jumpTarget);
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(implementationClass);
    }

    public void postMethodFrameAndScope() {
        this.popRubyClass();
        this.popScope();
        this.popFrame();
    }

    public void preMethodFrameOnly(RubyModule clazz, String name, IRubyObject self, IRubyObject[] args, int req, Block block, JumpTarget jumpTarget) {
        this.pushRubyClass(clazz);
        this.pushCallFrame(clazz, name, self, block, jumpTarget);
        this.getCurrentFrame().setVisibility(this.getPreviousFrame().getVisibility());
    }

    public void postMethodFrameOnly() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preMethodScopeOnly(RubyModule clazz, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(implementationClass);
    }

    public void postMethodScopeOnly() {
        this.popRubyClass();
        this.popScope();
    }

    public void preInitCoreClasses() {
        this.pushFrame();
        this.setCurrentVisibility(Visibility.PRIVATE);
    }

    public void preInitBuiltinClasses(RubyClass objectClass, IRubyObject topSelf) {
        this.pushRubyClass(objectClass);
        Frame frame = this.getCurrentFrame();
        frame.setSelf(topSelf);
    }

    public void preNodeEval(RubyModule rubyClass, IRubyObject self) {
        this.pushRubyClass(rubyClass);
        this.pushCallFrame(null, null, self, Block.NULL_BLOCK, null);
        this.setCurrentVisibility(Visibility.PRIVATE);
    }

    public void postNodeEval() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preExecuteUnder(RubyModule executeUnderClass, Block block) {
        Frame frame = this.getCurrentFrame();
        this.pushRubyClass(executeUnderClass);
        DynamicScope scope = this.getCurrentScope();
        BlockStaticScope sScope = new BlockStaticScope(scope.getStaticScope());
        sScope.setModule(executeUnderClass);
        this.pushScope(DynamicScope.newDynamicScope(sScope, scope));
        this.pushCallFrame(frame.getKlazz(), frame.getName(), frame.getSelf(), block, frame.getJumpTarget());
        this.getCurrentFrame().setVisibility(this.getPreviousFrame().getVisibility());
    }

    public void postExecuteUnder() {
        this.popFrame();
        this.popScope();
        this.popRubyClass();
    }

    public void preMproc() {
        this.pushFrame();
    }

    public void postMproc() {
        this.popFrame();
    }

    public void preRunThread(Frame currentFrame) {
        this.pushFrame(currentFrame);
    }

    public void preTrace() {
        this.setWithinTrace(true);
        this.pushFrame();
    }

    public void postTrace() {
        this.popFrame();
        this.setWithinTrace(false);
    }

    public void preForBlock(Binding binding, RubyModule klass) {
        this.pushFrame(binding.getFrame());
        this.getCurrentFrame().setVisibility(binding.getVisibility());
        this.pushScope(binding.getDynamicScope());
        this.pushRubyClass(klass != null ? klass : binding.getKlass());
    }

    public void preYieldSpecificBlock(Binding binding, RubyModule klass) {
        this.pushFrame(binding.getFrame());
        this.getCurrentFrame().setVisibility(binding.getVisibility());
        this.pushScope(binding.getDynamicScope().cloneScope());
        this.pushRubyClass(klass != null ? klass : binding.getKlass());
    }

    public void preYieldSpecificBlockNEW(Binding binding, StaticScope scope, RubyModule klass) {
        this.pushFrame(binding.getFrame());
        this.getCurrentFrame().setVisibility(binding.getVisibility());
        this.pushScope(DynamicScope.newDynamicScope(scope, binding.getDynamicScope()));
        this.pushRubyClass(klass != null ? klass : binding.getKlass());
    }

    public void preYieldLightBlock(Binding binding, RubyModule klass) {
        this.pushFrame(binding.getFrame());
        this.getCurrentFrame().setVisibility(binding.getVisibility());
        this.pushScope(binding.getDynamicScope());
        this.pushRubyClass(klass != null ? klass : binding.getKlass());
    }

    public void preYieldLightBlockNEW(Binding binding, DynamicScope emptyScope, RubyModule klass) {
        this.pushFrame(binding.getFrame());
        this.getCurrentFrame().setVisibility(binding.getVisibility());
        this.pushScope(emptyScope);
        this.pushRubyClass(klass != null ? klass : binding.getKlass());
    }

    public void preYieldNoScope(Binding binding, RubyModule klass) {
        this.pushFrame(binding.getFrame());
        this.getCurrentFrame().setVisibility(binding.getVisibility());
        this.pushRubyClass(klass != null ? klass : binding.getKlass());
    }

    public void preEvalWithBinding(Binding binding) {
        Frame frame = binding.getFrame();
        frame.setIsBindingFrame(true);
        this.pushFrame(frame);
        this.getCurrentFrame().setVisibility(binding.getVisibility());
        this.pushRubyClass(binding.getKlass());
    }

    public void postEvalWithBinding(Binding binding) {
        binding.getFrame().setIsBindingFrame(false);
        this.popFrameReal();
        this.popRubyClass();
    }

    public void postYield(Binding binding) {
        this.popScope();
        this.popFrameReal();
        this.popRubyClass();
    }

    public void postYieldLight(Binding binding) {
        this.popScope();
        this.popFrameReal();
        this.popRubyClass();
    }

    public void postYieldNoScope() {
        this.popFrameReal();
        this.popRubyClass();
    }

    public void preScopedBody(DynamicScope scope) {
        this.pushScope(scope);
    }

    public void postScopedBody() {
        this.popScope();
    }

    public boolean isWithinTrace() {
        return this.isWithinTrace;
    }

    public void setWithinTrace(boolean isWithinTrace) {
        this.isWithinTrace = isWithinTrace;
    }

    public boolean isWithinDefined() {
        return this.isWithinDefined;
    }

    public void setWithinDefined(boolean isWithinDefined) {
        this.isWithinDefined = isWithinDefined;
    }
}

