/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.runtime.Constants;
import org.jruby.runtime.load.Library;
import org.jruby.util.NormalizedFile;

public class RbConfigLibrary
implements Library {
    public void load(Ruby runtime, boolean wrap) {
        RubyModule configModule = runtime.defineModule("Config");
        RubyHash configHash = RubyHash.newHash(runtime);
        configModule.defineConstant("CONFIG", configHash);
        runtime.getObject().defineConstant("RbConfig", configModule);
        String[] versionParts = Constants.RUBY_VERSION.split("\\.");
        RbConfigLibrary.setConfig(configHash, "MAJOR", versionParts[0]);
        RbConfigLibrary.setConfig(configHash, "MINOR", versionParts[1]);
        RbConfigLibrary.setConfig(configHash, "TEENY", versionParts[2]);
        RbConfigLibrary.setConfig(configHash, "ruby_version", versionParts[0] + '.' + versionParts[1]);
        RbConfigLibrary.setConfig(configHash, "arch", "universal-java" + System.getProperty("java.specification.version"));
        String normalizedHome = Ruby.isSecurityRestricted() ? "SECURITY RESTRICTED" : new NormalizedFile(runtime.getJRubyHome()).getAbsolutePath();
        RbConfigLibrary.setConfig(configHash, "bindir", new NormalizedFile(normalizedHome, "bin").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "RUBY_INSTALL_NAME", this.jruby_script());
        RbConfigLibrary.setConfig(configHash, "ruby_install_name", this.jruby_script());
        RbConfigLibrary.setConfig(configHash, "SHELL", this.jruby_shell());
        RbConfigLibrary.setConfig(configHash, "prefix", normalizedHome);
        RbConfigLibrary.setConfig(configHash, "exec_prefix", normalizedHome);
        RbConfigLibrary.setConfig(configHash, "host_os", System.getProperty("os.name"));
        RbConfigLibrary.setConfig(configHash, "host_vendor", System.getProperty("java.vendor"));
        RbConfigLibrary.setConfig(configHash, "host_cpu", System.getProperty("os.arch"));
        String target_os = System.getProperty("os.name");
        if (target_os.compareTo("Mac OS X") == 0) {
            target_os = "darwin";
        }
        RbConfigLibrary.setConfig(configHash, "target_os", target_os);
        RbConfigLibrary.setConfig(configHash, "target_cpu", System.getProperty("os.arch"));
        String jrubyJarFile = "jruby.jar";
        URL jrubyPropertiesUrl = Ruby.class.getClassLoader().getResource("jruby.properties");
        if (jrubyPropertiesUrl != null) {
            Pattern jarFile = Pattern.compile("jar:file:.*?([a-zA-Z0-9.\\-]+\\.jar)!/jruby.properties");
            Matcher jarMatcher = jarFile.matcher(jrubyPropertiesUrl.toString());
            jarMatcher.find();
            if (jarMatcher.matches()) {
                jrubyJarFile = jarMatcher.group(1);
            }
        }
        RbConfigLibrary.setConfig(configHash, "LIBRUBY", jrubyJarFile);
        RbConfigLibrary.setConfig(configHash, "LIBRUBY_SO", jrubyJarFile);
        RbConfigLibrary.setConfig(configHash, "build", Constants.BUILD);
        RbConfigLibrary.setConfig(configHash, "target", Constants.TARGET);
        String libdir = System.getProperty("jruby.lib");
        if (libdir == null) {
            libdir = new NormalizedFile(normalizedHome, "lib").getAbsolutePath();
        } else {
            try {
                libdir = new NormalizedFile(libdir).getCanonicalPath();
            }
            catch (IOException e) {
                libdir = new NormalizedFile(libdir).getAbsolutePath();
            }
        }
        RbConfigLibrary.setConfig(configHash, "libdir", libdir);
        RbConfigLibrary.setConfig(configHash, "rubylibdir", new NormalizedFile(libdir, "ruby/1.8").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "sitedir", new NormalizedFile(libdir, "ruby/site_ruby").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "sitelibdir", new NormalizedFile(libdir, "ruby/site_ruby/1.8").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "sitearchdir", new NormalizedFile(libdir, "ruby/site_ruby/1.8/java").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "archdir", new NormalizedFile(libdir, "ruby/site_ruby/1.8/java").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "configure_args", "");
        RbConfigLibrary.setConfig(configHash, "datadir", new NormalizedFile(normalizedHome, "share").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "mandir", new NormalizedFile(normalizedHome, "man").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "sysconfdir", new NormalizedFile(normalizedHome, "etc").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "DLEXT", "jar");
        if (RbConfigLibrary.isWindows()) {
            RbConfigLibrary.setConfig(configHash, "EXEEXT", ".exe");
        } else {
            RbConfigLibrary.setConfig(configHash, "EXEEXT", "");
        }
    }

    private static void setConfig(RubyHash configHash, String key, String value) {
        Ruby runtime = configHash.getRuntime();
        configHash.op_aset(runtime.newString(key), runtime.newString(value));
    }

    private static boolean isWindows() {
        return System.getProperty("os.name", "").startsWith("Windows");
    }

    private String jruby_script() {
        return System.getProperty("jruby.script", RbConfigLibrary.isWindows() ? "jruby.bat" : "jruby").replace('\\', '/');
    }

    private String jruby_shell() {
        return System.getProperty("jruby.shell", RbConfigLibrary.isWindows() ? "cmd.exe" : "/bin/sh").replace('\\', '/');
    }
}

