/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyThread;
import org.jruby.internal.runtime.RubyNativeThread;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.collections.WeakHashSet;

public class ThreadService {
    private Ruby runtime;
    private ThreadContext mainContext;
    private ThreadLocal localContext;
    private ThreadGroup rubyThreadGroup;
    private Set rubyThreadList;
    private Thread mainThread;
    private ReentrantLock criticalLock = new ReentrantLock();

    public ThreadService(Ruby runtime) {
        this.runtime = runtime;
        this.mainContext = ThreadContext.newContext(runtime);
        this.localContext = new ThreadLocal();
        this.rubyThreadGroup = new ThreadGroup("Ruby Threads#" + runtime.hashCode());
        this.rubyThreadList = Collections.synchronizedSet(new WeakHashSet());
        this.mainThread = Thread.currentThread();
        this.localContext.set(new WeakReference<ThreadContext>(this.mainContext));
        this.rubyThreadList.add(this.mainThread);
    }

    public void disposeCurrentThread() {
        this.localContext.set(null);
    }

    public ThreadContext getCurrentContext() {
        WeakReference wr = null;
        ThreadContext context = null;
        while (context == null) {
            wr = (WeakReference)this.localContext.get();
            if (wr == null) {
                wr = this.adoptCurrentThread();
                context = (ThreadContext)wr.get();
            } else {
                context = (ThreadContext)wr.get();
            }
            if (context != null) continue;
            this.localContext.set(null);
        }
        return context;
    }

    private WeakReference adoptCurrentThread() {
        Thread current = Thread.currentThread();
        RubyThread.adopt(this.runtime.getThread(), current);
        return (WeakReference)this.localContext.get();
    }

    public RubyThread getMainThread() {
        return this.mainContext.getThread();
    }

    public void setMainThread(RubyThread thread) {
        this.mainContext.setThread(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RubyThread[] getActiveRubyThreads() {
        Set set = this.rubyThreadList;
        synchronized (set) {
            ArrayList<RubyThread> rtList = new ArrayList<RubyThread>(this.rubyThreadList.size());
            for (Thread t : this.rubyThreadList) {
                if (!t.isAlive()) continue;
                RubyThread rt = this.getRubyThreadFromThread(t);
                rtList.add(rt);
            }
            RubyThread[] rubyThreads = new RubyThread[rtList.size()];
            rtList.toArray(rubyThreads);
            return rubyThreads;
        }
    }

    public ThreadGroup getRubyThreadGroup() {
        return this.rubyThreadGroup;
    }

    public synchronized ThreadContext registerNewThread(RubyThread thread) {
        ThreadContext context = ThreadContext.newContext(this.runtime);
        this.localContext.set(new WeakReference<ThreadContext>(context));
        this.getCurrentContext().setThread(thread);
        this.rubyThreadList.add(Thread.currentThread());
        return context;
    }

    public synchronized void unregisterThread(RubyThread thread) {
        this.rubyThreadList.remove(Thread.currentThread());
        this.getCurrentContext().setThread(null);
        this.localContext.set(null);
    }

    private RubyThread getRubyThreadFromThread(Thread activeThread) {
        RubyThread rubyThread;
        if (activeThread instanceof RubyNativeThread) {
            RubyNativeThread rubyNativeThread = (RubyNativeThread)activeThread;
            rubyThread = rubyNativeThread.getRubyThread();
        } else {
            rubyThread = this.mainContext.getThread();
        }
        return rubyThread;
    }

    public void setCritical(boolean critical) {
        if (this.criticalLock.isHeldByCurrentThread()) {
            if (!critical) {
                this.criticalLock.unlock();
            }
        } else if (critical) {
            this.criticalLock.lock();
        }
    }

    public boolean getCritical() {
        return this.criticalLock.isHeldByCurrentThread();
    }

    public void waitForCritical() {
        if (this.criticalLock.isLocked()) {
            this.criticalLock.lock();
            this.criticalLock.unlock();
        }
    }
}

