/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import org.jruby.ext.posix.BaseNativeFileStat;
import org.jruby.ext.posix.POSIX;

public class MacOSFileStat
extends BaseNativeFileStat {
    public int st_dev;
    public int st_ino;
    public short st_mode;
    public short st_nlink;
    public int st_uid;
    public int st_gid;
    public int st_rdev;
    public int st_atime;
    public int st_atimensec;
    public int st_mtime;
    public int st_mtimensec;
    public int st_ctime;
    public int st_ctimensec;
    public long st_size;
    public long st_blocks;
    public int st_blksize;
    public int st_flags;
    public int st_gen;
    public int st_lspare;
    public long[] st_qspare = new long[2];

    public MacOSFileStat(POSIX posix) {
        super(posix);
    }

    public long atime() {
        return this.st_atime;
    }

    public long blocks() {
        return this.st_blocks;
    }

    public long blockSize() {
        return this.st_blksize;
    }

    public long ctime() {
        return this.st_ctime;
    }

    public long dev() {
        return this.st_dev;
    }

    public int gid() {
        return this.st_gid;
    }

    public int ino() {
        return this.st_ino;
    }

    public int mode() {
        return this.st_mode & 0xFFFF;
    }

    public long mtime() {
        return this.st_mtime;
    }

    public int nlink() {
        return this.st_nlink;
    }

    public long rdev() {
        return this.st_rdev;
    }

    public long st_size() {
        return this.st_size;
    }

    public int uid() {
        return this.st_uid;
    }

    public String toString() {
        return "Stat {DEV: " + this.st_dev + ", INO: " + this.st_ino + ", MODE: " + this.st_mode + ", NLINK: " + this.st_nlink + ", UID: " + this.st_uid + ", GID: " + this.st_gid + ", RDEV: " + this.st_rdev + ", BLOCKS: " + this.st_blocks + ", SIZE: " + this.st_size + ", BLKSIZE: " + this.st_blksize + ", FLAGS: " + this.st_flags + ", GEN: " + this.st_gen + ", ATIME: " + this.st_atime + ", MTIME: " + this.st_mtime + ", CTIME: " + this.st_ctime;
    }
}

