/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;

public abstract class BasePOSIX
implements POSIX {
    protected LibC libc;
    protected POSIXHandler handler;

    public BasePOSIX(LibC libc, POSIXHandler handler) {
        this.libc = libc;
        this.handler = handler;
    }

    public int chmod(String filename, int mode) {
        return this.libc.chmod(filename, mode);
    }

    public int chown(String filename, int user, int group) {
        return this.libc.chown(filename, user, group);
    }

    public int getegid() {
        return this.libc.getegid();
    }

    public int geteuid() {
        return this.libc.geteuid();
    }

    public int getgid() {
        return this.libc.getgid();
    }

    public String getlogin() {
        return this.libc.getlogin();
    }

    public int getpgid() {
        return this.libc.getpgid();
    }

    public int getpgrp() {
        return this.libc.getpgrp();
    }

    public int getpid() {
        return this.libc.getpid();
    }

    public int getppid() {
        return this.libc.getppid();
    }

    public Passwd getpwent() {
        return this.libc.getpwent();
    }

    public int getuid() {
        return this.libc.getuid();
    }

    public int setegid(int egid) {
        return this.libc.setegid(egid);
    }

    public int seteuid(int euid) {
        return this.libc.seteuid(euid);
    }

    public int setgid(int gid) {
        return this.libc.setgid(gid);
    }

    public int getpgid(int pid) {
        return this.libc.getpgid(pid);
    }

    public int setpgid(int pid, int pgid) {
        return this.libc.setpgid(pid, pgid);
    }

    public int setpgrp(int pid, int pgrp) {
        return this.libc.setpgrp(pid, pgrp);
    }

    public int setsid() {
        return this.libc.setsid();
    }

    public int setuid(int uid) {
        return this.libc.setuid(uid);
    }

    public int kill(int pid, int signal) {
        return this.libc.kill(pid, signal);
    }

    public int lchmod(String filename, int mode) {
        return this.libc.lchmod(filename, mode);
    }

    public int lchown(String filename, int user, int group) {
        return this.libc.lchown(filename, user, group);
    }

    public int link(String oldpath, String newpath) {
        return this.libc.link(oldpath, newpath);
    }

    public FileStat lstat(String path) {
        FileStat stat = this.allocateStat();
        if (this.libc.lstat(path, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }

    public int mkdir(String path, int mode) {
        return this.libc.mkdir(path, mode);
    }

    public FileStat stat(String path) {
        FileStat stat = this.allocateStat();
        if (this.libc.stat(path, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }

    public int symlink(String oldpath, String newpath) {
        return this.libc.symlink(oldpath, newpath);
    }

    public String readlink(String oldpath) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(256);
        int result = this.libc.readlink(oldpath, buffer, buffer.capacity());
        if (result == -1) {
            return null;
        }
        buffer.position(0);
        buffer.limit(result);
        return Charset.forName("ASCII").decode(buffer).toString();
    }

    public int umask(int mask) {
        return this.libc.umask(mask);
    }

    public int fork() {
        return this.libc.fork();
    }

    public int waitpid(int pid, int[] status, int flags) {
        return this.libc.waitpid(pid, status, pid);
    }

    public int wait(int[] status) {
        return this.libc.wait(status);
    }

    public int getpriority(int which, int who) {
        return this.libc.getpriority(which, who);
    }

    public int setpriority(int which, int who, int prio) {
        return this.libc.setpriority(which, who, prio);
    }

    public abstract FileStat allocateStat();
}

