/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import jruby.objectweb.asm.Label;
import org.jruby.RubyModule;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.InvocationCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class StandardInvocationCompiler
implements InvocationCompiler {
    private static final CodegenUtils cg = CodegenUtils.cg;
    private StandardASMCompiler.AbstractMethodCompiler methodCompiler;
    private SkinnyMethodAdapter method;
    private static final int THIS = 0;

    public StandardInvocationCompiler(StandardASMCompiler.AbstractMethodCompiler methodCompiler, SkinnyMethodAdapter method) {
        this.methodCompiler = methodCompiler;
        this.method = method;
    }

    public SkinnyMethodAdapter getMethodAdapter() {
        return this.method;
    }

    public void setMethodAdapter(SkinnyMethodAdapter sma) {
        this.method = sma;
    }

    public void invokeAttrAssign(String name) {
        this.method.dup();
        this.method.dup();
        this.method.arraylength();
        this.method.iconst_1();
        this.method.isub();
        this.method.arrayload();
        this.method.dup_x2();
        this.method.pop();
        this.invokeDynamic(name, true, true, CallType.NORMAL, null, true);
        this.method.pop();
    }

    public void opElementAsgn(CompilerCallback valueCallback, String operator) {
        this.methodCompiler.method.dup2();
        this.invokeDynamic("[]", true, true, CallType.FUNCTIONAL, null, false);
        this.methodCompiler.method.dup();
        Label end = new Label();
        if (operator == "||") {
            Label falseResult = new Label();
            this.methodCompiler.invokeIRubyObject("isTrue", cg.sig(Boolean.TYPE));
            this.methodCompiler.method.ifeq(falseResult);
            this.methodCompiler.method.dup_x2();
            this.methodCompiler.method.pop();
            this.methodCompiler.method.pop2();
            this.methodCompiler.method.go_to(end);
            this.methodCompiler.method.label(falseResult);
            this.methodCompiler.method.pop();
            valueCallback.call(this.methodCompiler);
            this.methodCompiler.method.dup_x2();
            this.methodCompiler.appendToObjectArray();
            this.invokeDynamic("[]=", true, true, CallType.FUNCTIONAL, null, false);
            this.methodCompiler.method.pop();
            this.methodCompiler.method.label(end);
        } else if (operator == "&&") {
            Label falseResult = new Label();
            this.methodCompiler.invokeIRubyObject("isTrue", cg.sig(Boolean.TYPE));
            this.methodCompiler.method.ifeq(falseResult);
            this.methodCompiler.method.pop();
            valueCallback.call(this.methodCompiler);
            this.methodCompiler.appendToObjectArray();
            this.invokeDynamic("[]=", true, true, CallType.FUNCTIONAL, null, false);
            this.methodCompiler.method.go_to(end);
            this.methodCompiler.method.label(falseResult);
            this.methodCompiler.method.dup_x2();
            this.methodCompiler.method.pop();
            this.methodCompiler.method.pop2();
            this.methodCompiler.method.label(end);
        } else {
            this.methodCompiler.method.pop();
            valueCallback.call(this.methodCompiler);
            this.methodCompiler.createObjectArray(1);
            this.invokeDynamic(operator, true, true, CallType.FUNCTIONAL, null, false);
            this.methodCompiler.appendToObjectArray();
            this.invokeDynamic("[]=", true, true, CallType.FUNCTIONAL, null, false);
        }
    }

    public void invokeSuper(CompilerCallback argsCallback, CompilerCallback closureArg) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeUtilityMethod("checkSuperDisabled", cg.sig(Void.TYPE, ThreadContext.class));
        this.methodCompiler.loadSelf();
        this.methodCompiler.loadThreadContext();
        if (argsCallback == null) {
            this.method.getstatic(cg.p(IRubyObject.class), "NULL_ARRAY", cg.ci(IRubyObject[].class));
            if (closureArg == null) {
                this.methodCompiler.loadBlock();
            } else {
                closureArg.call(this.methodCompiler);
            }
        } else {
            argsCallback.call(this.methodCompiler);
            if (closureArg == null) {
                this.methodCompiler.loadBlock();
            } else {
                closureArg.call(this.methodCompiler);
            }
        }
        this.method.invokeinterface(cg.p(IRubyObject.class), "callSuper", cg.sig(IRubyObject.class, ThreadContext.class, IRubyObject[].class, Block.class));
    }

    public void invokeDynamic(String name, CompilerCallback receiverCallback, CompilerCallback argsCallback, CallType callType, CompilerCallback closureArg, boolean attrAssign) {
        String signature;
        String classname = this.methodCompiler.getScriptCompiler().getClassname();
        String fieldname = this.methodCompiler.getScriptCompiler().cacheCallSite(name, callType, closureArg != null);
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        this.method.aload(0);
        this.method.getfield(classname, fieldname, cg.ci(CallSite.class));
        this.method.swap();
        this.methodCompiler.loadThreadContext();
        this.method.swap();
        if (argsCallback == null) {
            if (closureArg == null) {
                signature = cg.sig(IRubyObject.class, cg.params(ThreadContext.class, IRubyObject.class));
            } else {
                closureArg.call(this.methodCompiler);
                signature = cg.sig(IRubyObject.class, cg.params(ThreadContext.class, IRubyObject.class, Block.class));
            }
        } else {
            argsCallback.call(this.methodCompiler);
            if (closureArg == null) {
                signature = cg.sig(IRubyObject.class, cg.params(ThreadContext.class, IRubyObject.class, IRubyObject[].class));
            } else {
                closureArg.call(this.methodCompiler);
                signature = cg.sig(IRubyObject.class, cg.params(ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class));
            }
        }
        this.method.invokevirtual(cg.p(CallSite.class), "call", signature);
    }

    private void invokeDynamic(String name, boolean hasReceiver, boolean hasArgs, CallType callType, CompilerCallback closureArg, boolean attrAssign) {
        String callSig = cg.sig(IRubyObject.class, cg.params(IRubyObject.class, IRubyObject[].class, ThreadContext.class, String.class, IRubyObject.class, CallType.class, Block.class));
        String callSigIndexed = cg.sig(IRubyObject.class, cg.params(IRubyObject.class, IRubyObject[].class, ThreadContext.class, Byte.TYPE, String.class, IRubyObject.class, CallType.class, Block.class));
        int index = MethodIndex.getIndex(name);
        if (hasArgs) {
            if (!hasReceiver) {
                this.methodCompiler.loadSelf();
                this.method.swap();
            }
        } else if (hasReceiver) {
            this.method.getstatic(cg.p(IRubyObject.class), "NULL_ARRAY", cg.ci(IRubyObject[].class));
        } else {
            this.methodCompiler.loadSelf();
            this.method.getstatic(cg.p(IRubyObject.class), "NULL_ARRAY", cg.ci(IRubyObject[].class));
        }
        this.methodCompiler.loadThreadContext();
        if (index != 0) {
            this.method.ldc(new Integer(index));
        }
        this.method.ldc(name);
        this.methodCompiler.loadSelf();
        this.method.getstatic(cg.p(CallType.class), callType.toString(), cg.ci(CallType.class));
        if (closureArg == null) {
            this.method.getstatic(cg.p(Block.class), "NULL_BLOCK", cg.ci(Block.class));
        } else {
            closureArg.call(this.methodCompiler);
        }
        Label tryBegin = new Label();
        Label tryEnd = new Label();
        Label tryCatch = new Label();
        if (closureArg != null) {
            this.method.label(tryBegin);
        }
        if (attrAssign) {
            if (index != 0) {
                this.methodCompiler.invokeUtilityMethod("doAttrAssignIndexed", callSigIndexed);
            } else {
                this.methodCompiler.invokeUtilityMethod("doAttrAssign", callSig);
            }
        } else if (index != 0) {
            this.methodCompiler.invokeUtilityMethod("doInvokeDynamicIndexed", callSigIndexed);
        } else {
            this.methodCompiler.invokeUtilityMethod("doInvokeDynamic", callSig);
        }
        if (closureArg != null) {
            this.method.label(tryEnd);
            Label normalEnd = new Label();
            this.method.go_to(normalEnd);
            this.method.label(tryCatch);
            this.methodCompiler.loadBlock();
            this.methodCompiler.invokeUtilityMethod("handleJumpException", cg.sig(IRubyObject.class, cg.params(JumpException.class, Block.class)));
            this.method.label(normalEnd);
        }
    }

    public void yield(boolean hasArgs, boolean unwrap) {
        this.methodCompiler.loadBlock();
        if (hasArgs) {
            this.method.swap();
            this.methodCompiler.loadThreadContext();
            this.method.swap();
        } else {
            this.methodCompiler.loadThreadContext();
            this.method.aconst_null();
        }
        this.method.aconst_null();
        this.method.aconst_null();
        this.method.ldc(new Boolean(unwrap));
        this.method.invokevirtual(cg.p(Block.class), "yield", cg.sig(IRubyObject.class, cg.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, RubyModule.class, Boolean.TYPE)));
    }

    public void invokeEqq() {
        this.invokeDynamic("===", true, true, CallType.NORMAL, null, false);
    }
}

