/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.joni.encoding.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.parser.ReOptions;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.TypeConverter;

public class RubyRegexp
extends RubyObject
implements ReOptions,
WarnCallback {
    private KCode kcode;
    private Regex pattern;
    private ByteList str;
    private static final byte[] PIPE = new byte[]{124};
    private static final byte[] DASH = new byte[]{45};
    private static final byte[] R_PAREN = new byte[]{41};
    private static final byte[] COLON = new byte[]{58};
    private static final byte[] M_CHAR = new byte[]{109};
    private static final byte[] I_CHAR = new byte[]{105};
    private static final byte[] X_CHAR = new byte[]{120};
    private static final int REGEXP_LITERAL_F = 2048;
    private static final int REGEXP_KCODE_DEFAULT = 4096;
    private static ObjectAllocator REGEXP_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyRegexp instance = new RubyRegexp(runtime, klass);
            return instance;
        }
    };
    private static final int EMBEDDABLE = 7;

    public void setLiteral() {
        this.flags |= 0x800;
    }

    public void clearLiteral() {
        this.flags &= 0xFFFFF7FF;
    }

    public boolean isLiteral() {
        return (this.flags & 0x800) != 0;
    }

    public void setKCodeDefault() {
        this.flags |= 0x1000;
    }

    public void clearKCodeDefault() {
        this.flags &= 0xFFFFEFFF;
    }

    public boolean isKCodeDefault() {
        return (this.flags & 0x1000) != 0;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public static RubyClass createRegexpClass(Ruby runtime) {
        RubyClass regexpClass = runtime.defineClass("Regexp", runtime.getObject(), REGEXP_ALLOCATOR);
        runtime.setRegexp(regexpClass);
        regexpClass.index = 9;
        regexpClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyRegexp;
            }
        };
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyRegexp.class);
        regexpClass.defineConstant("IGNORECASE", runtime.newFixnum(1L));
        regexpClass.defineConstant("EXTENDED", runtime.newFixnum(2L));
        regexpClass.defineConstant("MULTILINE", runtime.newFixnum(4L));
        regexpClass.defineAnnotatedMethods(RubyRegexp.class);
        regexpClass.dispatcher = callbackFactory.createDispatcher(regexpClass);
        return regexpClass;
    }

    private RubyRegexp(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    private RubyRegexp(Ruby runtime) {
        super(runtime, runtime.getRegexp());
    }

    public static RubyRegexp newRegexp(Ruby runtime, String pattern, int options) {
        return RubyRegexp.newRegexp(runtime, ByteList.create(pattern), options);
    }

    public static RubyRegexp newRegexp(Ruby runtime, ByteList pattern, int options) {
        RubyRegexp regexp = new RubyRegexp(runtime);
        regexp.initialize(pattern, options);
        return regexp;
    }

    public void warn(String message) {
        this.getRuntime().getWarnings().warn(message);
    }

    @JRubyMethod(name={"kcode"})
    public IRubyObject kcode() {
        return !this.isKCodeDefault() ? this.getRuntime().newString(this.kcode.name()) : this.getRuntime().getNil();
    }

    public int getNativeTypeIndex() {
        return 9;
    }

    public Regex getPattern() {
        return this.pattern;
    }

    private void check() {
        if (this.pattern == null || this.str == null) {
            throw this.getRuntime().newTypeError("uninitialized Regexp");
        }
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        this.check();
        int hashval = this.pattern.getOptions();
        int len = this.str.realSize;
        int p = this.str.begin;
        while (len-- > 0) {
            hashval = hashval * 33 + this.str.bytes[p++];
        }
        hashval += hashval >> 5;
        return this.getRuntime().newFixnum(hashval);
    }

    @JRubyMethod(name={"==", "eql?"}, required=1)
    public IRubyObject op_equal(IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyRegexp)) {
            return this.getRuntime().getFalse();
        }
        RubyRegexp otherRegex = (RubyRegexp)other;
        this.check();
        otherRegex.check();
        if (this.str.equal(otherRegex.str) && this.kcode == otherRegex.kcode && this.pattern.getOptions() == otherRegex.pattern.getOptions()) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"~"})
    public IRubyObject op_match2() {
        IRubyObject line = this.getRuntime().getCurrentContext().getCurrentFrame().getLastLine();
        if (!(line instanceof RubyString)) {
            this.getRuntime().getCurrentContext().getCurrentFrame().setBackRef(this.getRuntime().getNil());
            return this.getRuntime().getNil();
        }
        int start = this.search((RubyString)line, 0, false);
        if (start < 0) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(start);
    }

    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject eqq(IRubyObject str) {
        if (!(str instanceof RubyString)) {
            str = str.checkStringType();
        }
        if (str.isNil()) {
            this.getRuntime().getCurrentContext().getCurrentFrame().setBackRef(this.getRuntime().getNil());
            return this.getRuntime().getFalse();
        }
        int start = this.search((RubyString)str, 0, false);
        return start < 0 ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    public void initialize(ByteList regex, int options) {
        if (this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify regexp");
        }
        this.checkFrozen();
        if (this.isLiteral()) {
            throw this.getRuntime().newSecurityError("can't modify literal regexp");
        }
        this.clearKCodeDefault();
        switch (options & 0xFFFFFFF0) {
            default: {
                this.setKCodeDefault();
                this.kcode = this.getRuntime().getKCode();
                break;
            }
            case 16: {
                this.kcode = KCode.NONE;
                break;
            }
            case 32: {
                this.kcode = KCode.EUC;
                break;
            }
            case 48: {
                this.kcode = KCode.SJIS;
                break;
            }
            case 64: {
                this.kcode = KCode.UTF8;
            }
        }
        this.pattern = this.makeRegexp(regex, regex.begin, regex.realSize, options & 0xF, this.kcode.getEncoding());
        this.str = regex.makeShared(0, regex.realSize);
    }

    private final Regex makeRegexp(ByteList s, int start, int len, int flags, Encoding enc) {
        try {
            return new Regex(s.bytes, start, start + len, flags, enc, Syntax.DEFAULT, this);
        }
        catch (Exception e) {
            this.rb_reg_raise(s.bytes, start, len, e.getMessage(), flags);
            return null;
        }
    }

    private final void rb_reg_raise(byte[] s, int start, int len, String err, int flags) {
        throw this.getRuntime().newRegexpError(err + ": " + this.rb_reg_desc(s, start, len, flags));
    }

    private final StringBuffer rb_reg_desc(byte[] s, int start, int len, int flags) {
        StringBuffer sb = new StringBuffer("/");
        this.rb_reg_expr_str(sb, s, start, len);
        sb.append("/");
        if ((flags & 4) != 0) {
            sb.append("m");
        }
        if ((flags & 1) != 0) {
            sb.append("i");
        }
        if ((flags & 2) != 0) {
            sb.append("x");
        }
        if (this.kcode != null && !this.isKCodeDefault()) {
            sb.append(this.kcode.name().charAt(0));
        }
        return sb;
    }

    private final void rb_reg_expr_str(StringBuffer sb, byte[] s, int start, int len) {
        boolean p;
        int pend;
        boolean bl = false;
        int n = start;
        int need_escape = start + len;
        Encoding enc = this.kcode.getEncoding();
        while (pend < need_escape) {
            if (s[pend] == 47 || 32 != s[pend] && (Character.isWhitespace(s[pend]) || Character.isISOControl(s[pend])) && enc.length(s[pend]) == 1) {
                p = true;
                break;
            }
            pend += enc.length(s[pend]);
        }
        if (!p) {
            sb.append(new ByteList(s, start, len, false).toString());
        } else {
            pend = 0;
            while (pend < need_escape) {
                if (s[pend] == 92) {
                    int n2 = enc.length(s[pend + 1]) + 1;
                    sb.append(new ByteList(s, pend, n2, false).toString());
                    pend += n2;
                    continue;
                }
                if (s[pend] == 47) {
                    sb.append("\\/");
                } else {
                    if (enc.length(s[pend]) != 1) {
                        sb.append(new ByteList(s, pend, enc.length(s[pend]), false).toString());
                        pend += enc.length(s[pend]);
                        continue;
                    }
                    if (32 == s[pend] || !Character.isWhitespace(s[pend]) && !Character.isISOControl(s[pend])) {
                        sb.append((char)(s[pend] & 0xFF));
                    } else if (!Character.isWhitespace((char)(s[pend] & 0xFF))) {
                        sb.append('\\');
                        sb.append(Integer.toString(s[pend] & 0xFF, 8));
                    } else {
                        sb.append((char)(s[pend] & 0xFF));
                    }
                }
                ++pend;
            }
        }
    }

    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject re) {
        if (this == re) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != re.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("wrong argument type");
        }
        ((RubyRegexp)re).check();
        this.initialize(((RubyRegexp)re).str, ((RubyRegexp)re).rb_reg_options());
        return this;
    }

    private int rb_reg_get_kcode() {
        if (this.kcode == KCode.NONE) {
            return 16;
        }
        if (this.kcode == KCode.EUC) {
            return 32;
        }
        if (this.kcode == KCode.SJIS) {
            return 48;
        }
        if (this.kcode == KCode.UTF8) {
            return 64;
        }
        return 0;
    }

    private int rb_reg_options() {
        this.check();
        int options = this.pattern.getOptions() & 7;
        if (!this.isKCodeDefault()) {
            options |= this.rb_reg_get_kcode();
        }
        return options;
    }

    /*
     * WARNING - void declaration
     */
    @JRubyMethod(name={"initialize"}, optional=3, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_m(IRubyObject[] args) {
        void var4_6;
        int s;
        Arity.checkArgumentCount(this.getRuntime(), args, 1, 3);
        int n = 0;
        if (args[0] instanceof RubyRegexp) {
            if (args.length > 1) {
                this.getRuntime().getWarnings().warn("flags" + (args.length == 3 ? " and encoding" : "") + " ignored");
            }
            ((RubyRegexp)args[0]).check();
            RubyRegexp flags2 = (RubyRegexp)args[0];
            n = flags2.pattern.getOptions() & 0xF;
            if (!flags2.isKCodeDefault() && flags2.kcode != null && flags2.kcode != KCode.NIL) {
                if (flags2.kcode == KCode.NONE) {
                    n |= 0x10;
                } else if (flags2.kcode == KCode.EUC) {
                    n |= 0x20;
                } else if (flags2.kcode == KCode.SJIS) {
                    n |= 0x30;
                } else if (flags2.kcode == KCode.UTF8) {
                    n |= 0x40;
                }
            }
            ByteList r = flags2.str;
        } else {
            ByteList flags2;
            if (args.length >= 2) {
                if (args[1] instanceof RubyFixnum) {
                    s = RubyNumeric.fix2int(args[1]);
                } else if (args[1].isTrue()) {
                    s = 1;
                }
            }
            if (args.length == 3 && !args[2].isNil()) {
                char flags2 = args[2].convertToString().getByteList().charAt(0);
                s &= 0xFFFFFF8F;
                switch (flags2) {
                    case 'N': 
                    case 'n': {
                        s |= 0x10;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        s |= 0x20;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        s |= 0x30;
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        s |= 0x40;
                        break;
                    }
                }
            }
            ByteList bl = flags2 = args[0].convertToString().getByteList();
        }
        this.initialize((ByteList)var4_6, s);
        return this;
    }

    @JRubyMethod(name={"new", "compile"}, required=1, optional=2, meta=true)
    public static RubyRegexp newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyClass klass = (RubyClass)recv;
        RubyRegexp re = (RubyRegexp)klass.allocate();
        re.callInit(args, Block.NULL_BLOCK);
        return re;
    }

    @JRubyMethod(name={"options"})
    public IRubyObject options() {
        return this.getRuntime().newFixnum(this.rb_reg_options());
    }

    public int search(RubyString str, int pos, boolean reverse) {
        Ruby runtime = this.getRuntime();
        Frame frame = runtime.getCurrentContext().getCurrentFrame();
        ByteList value = str.getByteList();
        if (pos > value.realSize || pos < 0) {
            frame.setBackRef(runtime.getNil());
            return -1;
        }
        this.check();
        int range = reverse ? -pos : value.realSize - pos;
        Matcher matcher = this.pattern.matcher(value.bytes, value.begin, value.begin + value.realSize);
        int result = matcher.search(value.begin + pos, value.begin + pos + range, 0);
        if (result < 0) {
            frame.setBackRef(runtime.getNil());
            return result;
        }
        this.updateBackRef(str, frame, matcher);
        return result;
    }

    final RubyMatchData updateBackRef(RubyString str, Frame frame, Matcher matcher) {
        RubyMatchData match;
        IRubyObject backref = frame.getBackRef();
        if (backref == null || backref.isNil() || ((RubyMatchData)backref).used()) {
            match = new RubyMatchData(this.getRuntime());
        } else {
            match = (RubyMatchData)backref;
            if (this.getRuntime().getSafeLevel() >= 3) {
                match.setTaint(true);
            } else {
                match.setTaint(false);
            }
        }
        match.regs = matcher.getRegion();
        match.begin = matcher.getBegin();
        match.end = matcher.getEnd();
        match.str = (RubyString)str.strDup().freeze();
        match.pattern = this.pattern;
        frame.setBackRef(match);
        match.infectBy(this);
        match.infectBy(str);
        return match;
    }

    @JRubyMethod(name={"=~"}, required=1)
    public IRubyObject op_match(IRubyObject str) {
        if (str.isNil()) {
            this.getRuntime().getCurrentContext().getCurrentFrame().setBackRef(this.getRuntime().getNil());
            return str;
        }
        int start = this.search(str.convertToString(), 0, false);
        if (start < 0) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), start);
    }

    @JRubyMethod(name={"match"}, required=1)
    public IRubyObject match_m(IRubyObject str) {
        if (this.op_match(str).isNil()) {
            return this.getRuntime().getNil();
        }
        IRubyObject result = this.getRuntime().getCurrentContext().getCurrentFrame().getBackRef();
        if (result instanceof RubyMatchData) {
            ((RubyMatchData)result).use();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public RubyString regsub(RubyString str, RubyString src, Matcher matcher) {
        void p;
        Region regs = matcher.getRegion();
        int mbeg = matcher.getBegin();
        int mend = matcher.getEnd();
        int n = 0;
        int s = 0;
        int n2 = -1;
        ByteList no = str.getByteList();
        ByteList bs = src.getByteList();
        int srcbs = no.length();
        RubyString val = null;
        Encoding enc = this.kcode.getEncoding();
        block8: while (p < srcbs) {
            int e;
            char c;
            void var15_15 = p;
            if (enc.length((byte)(c = no.charAt((int)p++))) != 1) {
                p += enc.length((byte)c) - 1;
                continue;
            }
            if (c != '\\' || p == srcbs) continue;
            if (val == null) {
                val = RubyString.newString(this.getRuntime(), new ByteList((int)(var15_15 - s)));
            }
            val.cat(no.bytes, no.begin + s, (int)(var15_15 - s));
            c = no.charAt((int)p++);
            s = p;
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    e = c - 48;
                    break;
                }
                case '&': {
                    e = 0;
                    break;
                }
                case '`': {
                    int ss = regs == null ? mbeg : regs.beg[0];
                    val.cat(bs.bytes, bs.begin, ss);
                    continue block8;
                }
                case '\'': {
                    int c2 = regs == null ? mend : regs.end[0];
                    val.cat(bs.bytes, bs.begin + c2, src.getByteList().realSize - c2);
                    continue block8;
                }
                case '+': {
                    if (regs == null) {
                        if (mbeg != -1) break;
                        e = 0;
                        continue block8;
                    }
                    for (e = regs.numRegs - 1; regs.beg[e] == -1 && e > 0; --e) {
                    }
                    if (e != 0) break;
                    continue block8;
                }
                case '\\': {
                    val.cat(no.bytes, (int)(p - true), 1);
                    continue block8;
                }
                default: {
                    val.cat(no.bytes, (int)(p - 2), 2);
                    continue block8;
                }
            }
            if (regs != null) {
                if (e < 0 || e >= regs.numRegs || regs.beg[e] == -1) continue;
                val.cat(bs.bytes, bs.begin + regs.beg[e], regs.end[e] - regs.beg[e]);
                continue;
            }
            if (e != 0 || mbeg == -1) continue;
            val.cat(bs.bytes, bs.begin + mbeg, mend - mbeg);
        }
        if (s < srcbs) {
            if (val == null) {
                val = RubyString.newString(this.getRuntime(), no.makeShared(s, srcbs - s));
            } else {
                val.cat(no.bytes, no.begin + s, srcbs - s);
            }
        }
        if (val == null) {
            return str;
        }
        return val;
    }

    final int adjustStartPos(RubyString str, int pos, boolean reverse) {
        this.check();
        ByteList value = str.getByteList();
        return this.pattern.adjustStartPosition(value.bytes, value.begin, value.realSize, pos, reverse);
    }

    @JRubyMethod(name={"casefold?"})
    public IRubyObject casefold_p() {
        this.check();
        if ((this.pattern.getOptions() & 1) != 0) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"source"})
    public IRubyObject source() {
        this.check();
        RubyString str = RubyString.newStringShared(this.getRuntime(), this.str);
        if (this.isTaint()) {
            str.taint();
        }
        return str;
    }

    final int length() {
        return this.str.realSize;
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        this.check();
        return this.getRuntime().newString(ByteList.create(this.rb_reg_desc(this.str.bytes, this.str.begin, this.str.realSize, this.pattern.getOptions()).toString()));
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        RubyString ss = this.getRuntime().newString("(?");
        this.check();
        int options = this.pattern.getOptions();
        int p = this.str.begin;
        int l = this.str.realSize;
        byte[] _str = this.str.bytes;
        while (l >= 4 && _str[p] == 40 && _str[p + 1] == 63) {
            boolean err = true;
            p += 2;
            if ((l -= 2) > 0) {
                do {
                    if (_str[p] == 109) {
                        options |= 4;
                    } else if (_str[p] == 105) {
                        options |= 1;
                    } else {
                        if (_str[p] != 120) break;
                        options |= 2;
                    }
                    ++p;
                } while (--l > 0);
            }
            if (l > 1 && _str[p] == 45) {
                ++p;
                --l;
                do {
                    if (_str[p] == 109) {
                        options &= 0xFFFFFFFB;
                    } else if (_str[p] == 105) {
                        options &= 0xFFFFFFFE;
                    } else {
                        if (_str[p] != 120) break;
                        options &= 0xFFFFFFFD;
                    }
                    ++p;
                } while (--l > 0);
            }
            if (_str[p] == 41) {
                --l;
                ++p;
                continue;
            }
            if (_str[p] == 58 && _str[p + l - 1] == 41) {
                try {
                    Regex regex = new Regex(_str, ++p, l -= 2, 0, this.kcode.getEncoding(), Syntax.DEFAULT);
                    err = false;
                }
                catch (Exception e) {
                    err = true;
                }
            }
            if (!err) break;
            options = this.pattern.getOptions();
            p = this.str.begin;
            l = this.str.realSize;
            break;
        }
        if ((options & 4) != 0) {
            ss.cat(M_CHAR);
        }
        if ((options & 1) != 0) {
            ss.cat(I_CHAR);
        }
        if ((options & 2) != 0) {
            ss.cat(X_CHAR);
        }
        if ((options & 7) != 7) {
            ss.cat(DASH);
            if ((options & 4) == 0) {
                ss.cat(M_CHAR);
            }
            if ((options & 1) == 0) {
                ss.cat(I_CHAR);
            }
            if ((options & 2) == 0) {
                ss.cat(X_CHAR);
            }
        }
        ss.cat(COLON);
        this.rb_reg_expr_str(ss, p, l);
        ss.cat(R_PAREN);
        ss.infectBy(this);
        return ss;
    }

    private final boolean ISPRINT(byte c) {
        return this.ISPRINT((char)(c & 0xFF));
    }

    private final boolean ISPRINT(char c) {
        return ' ' == c || !Character.isWhitespace(c) && !Character.isISOControl(c);
    }

    private final void rb_reg_expr_str(RubyString ss, int s, int l) {
        int p;
        int pend = l;
        boolean need_escape = false;
        for (p = s; p < pend; p += this.kcode.getEncoding().length(this.str.bytes[p])) {
            if (this.str.bytes[p] != 47 && (this.ISPRINT(this.str.bytes[p]) || this.kcode.getEncoding().length(this.str.bytes[p]) != 1)) continue;
            need_escape = true;
            break;
        }
        if (!need_escape) {
            ss.cat(this.str.bytes, s, l);
        } else {
            p = s;
            while (p < pend) {
                if (this.str.bytes[p] == 92) {
                    int n = this.kcode.getEncoding().length(this.str.bytes[p + 1]) + 1;
                    ss.cat(this.str.bytes, p, n);
                    p += n;
                    continue;
                }
                if (this.str.bytes[p] == 47) {
                    int c = 92;
                    ss.cat((byte)c);
                    ss.cat(this.str.bytes, p, 1);
                } else {
                    if (this.kcode.getEncoding().length(this.str.bytes[p]) != 1) {
                        ss.cat(this.str.bytes, p, this.kcode.getEncoding().length(this.str.bytes[p]));
                        p += this.kcode.getEncoding().length(this.str.bytes[p]);
                        continue;
                    }
                    if (this.ISPRINT(this.str.bytes[p])) {
                        ss.cat(this.str.bytes, p, 1);
                    } else if (!Character.isWhitespace(this.str.bytes[p])) {
                        ss.cat(ByteList.create(Integer.toString(this.str.bytes[p] & 0xFF, 8)));
                    } else {
                        ss.cat(this.str.bytes, p, 1);
                    }
                }
                ++p;
            }
        }
    }

    @JRubyMethod(name={"quote", "escape"}, required=1, optional=1, meta=true)
    public static RubyString quote(IRubyObject recv, IRubyObject[] args) {
        IRubyObject kcode = null;
        if (Arity.checkArgumentCount(recv.getRuntime(), args, 1, 2) == 2) {
            kcode = args[1];
        }
        IRubyObject str = args[0];
        KCode code = recv.getRuntime().getKCode();
        if (kcode != null && !kcode.isNil()) {
            code = KCode.create(recv.getRuntime(), kcode.toString());
        }
        return RubyRegexp.quote(str.convertToString(), code);
    }

    /*
     * Unable to fully structure code
     */
    public static RubyString quote(RubyString str, KCode kcode) {
        block16: {
            if (null == kcode) {
                kcode = str.getRuntime().getKCode();
            }
            bs = str.getByteList();
            tix = 0;
            s = bs.begin;
            var5_5 = s + bs.length();
            send = kcode.getEncoding();
            while (s < var5_5) {
                block17: {
                    enc = (char)(bs.bytes[s] & 255);
                    if (send.length((byte)enc) == 1) break block17;
                    n = send.length((byte)enc);
                    while (n-- > 0 && s < c) {
                        ++s;
                    }
                    --s;
                    ** GOTO lbl-1000
                }
                switch (enc) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '#': 
                    case '$': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        break block16;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        ++s;
                        break;
                    }
                }
            }
            return str;
        }
        b1 = new ByteList((int)(c * 2));
        System.arraycopy(bs.bytes, bs.begin, b1.bytes, b1.begin, s - bs.begin);
        tix += s - bs.begin;
        while (s < c) {
            block19: {
                block18: {
                    enc = (char)(bs.bytes[s] & 255);
                    if (send.length((byte)enc) == 1) break block18;
                    n = send.length((byte)enc);
                    while (n-- > 0 && s < c) {
                        b1.bytes[tix++] = bs.bytes[s++];
                    }
                    --s;
                    break block19;
                }
                switch (enc) {
                    case '#': 
                    case '$': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        b1.bytes[tix++] = 92;
                        ** GOTO lbl64
                    }
                    case ' ': {
                        b1.bytes[tix++] = 92;
                        b1.bytes[tix++] = 32;
                        break;
                    }
                    case '\t': {
                        b1.bytes[tix++] = 92;
                        b1.bytes[tix++] = 116;
                        break;
                    }
                    case '\n': {
                        b1.bytes[tix++] = 92;
                        b1.bytes[tix++] = 110;
                        break;
                    }
                    case '\r': {
                        b1.bytes[tix++] = 92;
                        b1.bytes[tix++] = 114;
                        break;
                    }
                    case '\f': {
                        b1.bytes[tix++] = 92;
                        b1.bytes[tix++] = 102;
                        break;
                    }
lbl64:
                    // 2 sources

                    default: {
                        b1.bytes[tix++] = (byte)enc;
                    }
                }
            }
            ++s;
        }
        b1.realSize = tix;
        tmp = RubyString.newString(str.getRuntime(), b1);
        tmp.infectBy(str);
        return tmp;
    }

    public static IRubyObject nth_match(int nth, IRubyObject match) {
        int end;
        int start;
        if (match.isNil()) {
            return match;
        }
        RubyMatchData m = (RubyMatchData)match;
        if (m.regs == null) {
            if (nth >= 1) {
                return match.getRuntime().getNil();
            }
            if (nth < 0 && ++nth <= 0) {
                return match.getRuntime().getNil();
            }
            start = m.begin;
            end = m.end;
        } else {
            if (nth >= m.regs.numRegs) {
                return match.getRuntime().getNil();
            }
            if (nth < 0 && (nth += m.regs.numRegs) <= 0) {
                return match.getRuntime().getNil();
            }
            start = m.regs.beg[nth];
            end = m.regs.end[nth];
        }
        if (start == -1) {
            return match.getRuntime().getNil();
        }
        RubyString str = m.str.makeShared(start, end - start);
        str.infectBy(match);
        return str;
    }

    public static IRubyObject last_match(IRubyObject match) {
        return RubyRegexp.nth_match(0, match);
    }

    @JRubyMethod(name={"last_match"}, optional=1, meta=true)
    public static IRubyObject last_match_s(IRubyObject recv, IRubyObject[] args) {
        if (Arity.checkArgumentCount(recv.getRuntime(), args, 0, 1) == 1) {
            return RubyRegexp.nth_match(RubyNumeric.fix2int(args[0]), recv.getRuntime().getCurrentContext().getCurrentFrame().getBackRef());
        }
        IRubyObject result = recv.getRuntime().getCurrentContext().getCurrentFrame().getBackRef();
        if (result instanceof RubyMatchData) {
            ((RubyMatchData)result).use();
        }
        return result;
    }

    public static IRubyObject match_pre(IRubyObject match) {
        int beg;
        if (match.isNil()) {
            return match;
        }
        RubyMatchData m = (RubyMatchData)match;
        int n = beg = m.regs == null ? m.begin : m.regs.beg[0];
        if (beg == -1) {
            match.getRuntime().getNil();
        }
        RubyString str = m.str.makeShared(0, beg);
        str.infectBy(match);
        return str;
    }

    public static IRubyObject match_post(IRubyObject match) {
        int end;
        if (match.isNil()) {
            return match;
        }
        RubyMatchData m = (RubyMatchData)match;
        if (m.regs == null) {
            if (m.begin == -1) {
                return match.getRuntime().getNil();
            }
            end = m.end;
        } else {
            if (m.regs.beg[0] == -1) {
                return match.getRuntime().getNil();
            }
            end = m.regs.end[0];
        }
        RubyString str = m.str.makeShared(end, m.str.getByteList().realSize - end);
        str.infectBy(match);
        return str;
    }

    public static IRubyObject match_last(IRubyObject match) {
        int i;
        if (match.isNil()) {
            return match;
        }
        RubyMatchData m = (RubyMatchData)match;
        if (m.regs == null || m.regs.beg[0] == -1) {
            return match.getRuntime().getNil();
        }
        for (i = m.regs.numRegs - 1; m.regs.beg[i] == -1 && i > 0; --i) {
        }
        if (i == 0) {
            return match.getRuntime().getNil();
        }
        return RubyRegexp.nth_match(i, match);
    }

    @JRubyMethod(name={"union"}, rest=true, meta=true)
    public static IRubyObject union(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            return RubyRegexp.newRegexp(recv.getRuntime(), ByteList.create("(?!)"), 0);
        }
        if (args.length == 1) {
            IRubyObject v = TypeConverter.convertToTypeWithCheck(args[0], recv.getRuntime().getRegexp(), 0, "to_regexp");
            if (!v.isNil()) {
                return v;
            }
            return RubyRegexp.newRegexp(recv.getRuntime(), RubyRegexp.quote(recv, args).getByteList(), 0);
        }
        KCode kcode = null;
        IRubyObject kcode_re = recv.getRuntime().getNil();
        RubyString source = recv.getRuntime().newString("");
        IRubyObject[] _args = new IRubyObject[3];
        for (int i = 0; i < args.length; ++i) {
            IRubyObject v;
            if (0 < i) {
                source.cat(PIPE);
            }
            if (!(v = TypeConverter.convertToTypeWithCheck(args[i], recv.getRuntime().getRegexp(), 0, "to_regexp")).isNil()) {
                if (!((RubyRegexp)v).isKCodeDefault()) {
                    if (kcode == null) {
                        kcode_re = v;
                        kcode = ((RubyRegexp)v).kcode;
                    } else if (((RubyRegexp)v).kcode != kcode) {
                        IRubyObject str1 = kcode_re.inspect();
                        IRubyObject str2 = v.inspect();
                        throw recv.getRuntime().newArgumentError("mixed kcode " + str1 + " and " + str2);
                    }
                }
                v = ((RubyRegexp)v).to_s();
            } else {
                v = RubyRegexp.quote(recv, new IRubyObject[]{args[i]});
            }
            source.append(v);
        }
        _args[0] = source;
        _args[1] = recv.getRuntime().getNil();
        if (kcode == null) {
            _args[2] = recv.getRuntime().getNil();
        } else if (kcode == KCode.NONE) {
            _args[2] = recv.getRuntime().newString("n");
        } else if (kcode == KCode.EUC) {
            _args[2] = recv.getRuntime().newString("e");
        } else if (kcode == KCode.SJIS) {
            _args[2] = recv.getRuntime().newString("s");
        } else if (kcode == KCode.UTF8) {
            _args[2] = recv.getRuntime().newString("u");
        }
        return recv.callMethod(recv.getRuntime().getCurrentContext(), "new", _args);
    }

    public static RubyRegexp unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyRegexp result = RubyRegexp.newRegexp(input.getRuntime(), input.unmarshalString(), input.unmarshalInt());
        input.registerLinkTarget(result);
        return result;
    }

    public static void marshalTo(RubyRegexp regexp, MarshalStream output) throws IOException {
        output.registerLinkTarget(regexp);
        output.writeString(new String(regexp.str.bytes, regexp.str.begin, regexp.str.realSize));
        output.writeInt(regexp.pattern.getOptions() & 7);
    }
}

