/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.CompatVersion;
import org.jruby.Profile;
import org.jruby.Ruby;
import org.jruby.exceptions.MainExitException;
import org.jruby.runtime.Constants;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.JRubyFile;
import org.jruby.util.KCode;
import org.jruby.util.SafePropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyInstanceConfig {
    private InputStream input = System.in;
    private PrintStream output = System.out;
    private PrintStream error = System.err;
    private Profile profile = Profile.DEFAULT;
    private boolean objectSpaceEnabled = SafePropertyAccessor.getBoolean("jruby.objectspace.enabled", false);
    private CompileMode compileMode = CompileMode.JIT;
    private boolean runRubyInProcess = true;
    private String currentDirectory;
    private Map environment;
    private String[] argv = new String[0];
    private final boolean jitLogging;
    private final boolean jitLoggingVerbose;
    private final int jitThreshold;
    private final boolean samplingEnabled;
    private CompatVersion compatVersion;
    private final JRubyClassLoader defaultJRubyClassLoader;
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private List<String> loadPaths = new ArrayList<String>();
    private StringBuffer inlineScript = new StringBuffer();
    private boolean hasInlineScript = false;
    private String scriptFileName = null;
    private List<String> requiredLibraries = new ArrayList<String>();
    private boolean benchmarking = false;
    private boolean assumeLoop = false;
    private boolean assumePrinting = false;
    private boolean processLineEnds = false;
    private boolean split = false;
    private boolean verbose = false;
    private boolean debug = false;
    private boolean showVersion = false;
    private boolean endOfArguments = false;
    private boolean shouldRunInterpreter = true;
    private boolean shouldPrintUsage = false;
    private boolean shouldPrintProperties = false;
    private boolean yarv = false;
    private boolean rubinius = false;
    private boolean yarvCompile = false;
    private KCode kcode = KCode.NONE;
    public static final boolean FRAMELESS_COMPILE_ENABLED = SafePropertyAccessor.getBoolean("jruby.compile.frameless");
    public static final boolean POSITIONLESS_COMPILE_ENABLED = SafePropertyAccessor.getBoolean("jruby.compile.positionless");
    public static final boolean THREADLESS_COMPILE_ENABLED = SafePropertyAccessor.getBoolean("jruby.compile.threadless");
    public static final boolean INDEXED_METHODS = SafePropertyAccessor.getBoolean("jruby.indexed.methods");
    public static final boolean FORK_ENABLED = SafePropertyAccessor.getBoolean("jruby.fork.enabled");
    public static boolean nativeEnabled = true;
    public int characterIndex = 0;
    private LoadServiceCreator creator = LoadServiceCreator.DEFAULT;

    public RubyInstanceConfig() {
        this.currentDirectory = Ruby.isSecurityRestricted() ? "/" : JRubyFile.getFileProperty("user.dir");
        this.samplingEnabled = SafePropertyAccessor.getBoolean("jruby.sampling.enabled", false);
        String compatString = SafePropertyAccessor.getProperty("jruby.compat.version", "RUBY1_8");
        if (compatString.equalsIgnoreCase("RUBY1_8")) {
            this.compatVersion = CompatVersion.RUBY1_8;
        } else if (compatString.equalsIgnoreCase("RUBY1_9")) {
            this.compatVersion = CompatVersion.RUBY1_9;
        } else {
            System.err.println("Compatibility version `" + compatString + "' invalid; use RUBY1_8 or RUBY1_9. Using RUBY1_8.");
            this.compatVersion = CompatVersion.RUBY1_8;
        }
        if (Ruby.isSecurityRestricted()) {
            this.compileMode = CompileMode.OFF;
            this.jitLogging = false;
            this.jitLoggingVerbose = false;
            this.jitThreshold = -1;
        } else {
            boolean jitProperty;
            String threshold = SafePropertyAccessor.getProperty("jruby.jit.threshold");
            this.runRubyInProcess = SafePropertyAccessor.getBoolean("jruby.launch.inproc", true);
            boolean bl = jitProperty = SafePropertyAccessor.getProperty("jruby.jit.enabled") != null;
            if (jitProperty) {
                this.error.print("jruby.jit.enabled property is deprecated; use jruby.compile.mode=(OFF|JIT|FORCE) for -C, default, and +C flags");
                this.compileMode = SafePropertyAccessor.getBoolean("jruby.jit.enabled") ? CompileMode.JIT : CompileMode.OFF;
            } else {
                String jitModeProperty = SafePropertyAccessor.getProperty("jruby.compile.mode", "JIT");
                if (jitModeProperty.equals("OFF")) {
                    this.compileMode = CompileMode.OFF;
                } else if (jitModeProperty.equals("JIT")) {
                    this.compileMode = CompileMode.JIT;
                } else if (jitModeProperty.equals("FORCE")) {
                    this.compileMode = CompileMode.FORCE;
                } else {
                    this.error.print("jruby.compile.mode property must be OFF, JIT, FORCE, or unset; defaulting to JIT");
                    this.compileMode = CompileMode.JIT;
                }
            }
            this.jitLogging = SafePropertyAccessor.getBoolean("jruby.jit.logging");
            this.jitLoggingVerbose = SafePropertyAccessor.getBoolean("jruby.jit.logging.verbose");
            this.jitThreshold = threshold == null ? 20 : Integer.parseInt(threshold);
        }
        this.defaultJRubyClassLoader = null;
        if (FORK_ENABLED) {
            this.error.print("WARNING: fork is highly unlikely to be safe or stable on the JVM. Have fun!\n");
        }
    }

    public String getBasicUsageHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("Usage: jruby [switches] [--] [rubyfile.rb] [arguments]\n").append("    -e 'command'    one line of script. Several -e's allowed. Omit [programfile]\n").append("    -b              benchmark mode, times the script execution\n").append("    -Jjava option   pass an option on to the JVM (e.g. -J-Xmx512m)\n").append("    -Idirectory     specify $LOAD_PATH directory (may be used more than once)\n").append("    --              optional -- before rubyfile.rb for compatibility with ruby\n").append("    -d              set debugging flags (set $DEBUG to true)\n").append("    -v              print version number, then turn on verbose mode\n").append("    -O              run with ObjectSpace disabled (default; improves performance)\n").append("    +O              run with ObjectSpace enabled (reduces performance)\n").append("    -S cmd          run the specified command in JRuby's bin dir\n").append("    -C              disable all compilation\n").append("    +C              force compilation of all scripts before they are run (except eval)\n").append("    -y              read a YARV-compiled Ruby script and run that (EXPERIMENTAL)\n").append("    -Y              compile a Ruby script into YARV bytecodes and run this (EXPERIMENTAL)\n").append("    -R              read a Rubinius-compiled Ruby script and run that (EXPERIMENTAL)\n").append("    --properties    List all configuration properties (specify with -J-Dproperty=value)\n");
        return sb.toString();
    }

    public String getPropertyHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("These properties can be used to alter runtime behavior for perf or compatibility.\n").append("Specify them by passing -J-D<property>=<value>\n").append("\nCOMPILER SETTINGS:\n").append("    jruby.compile.mode=JIT|FORCE|OFF\n").append("       Set compilation mode. JIT is default; FORCE compiles all, OFF disables\n").append("    jruby.compile.boxed=true|false\n").append("       (EXPERIMENTAL) Use boxed variables; this can speed up some methods. Default is false\n").append("    jruby.compile.frameless=true|false\n").append("       (EXPERIMENTAL) Turn on frameless compilation where possible\n").append("    jruby.compile.positionless=true|false\n").append("       (EXPERIMENTAL) Turn on compilation that avoids updating Ruby position info. Default is false\n").append("    jruby.compile.threadless=true|false\n").append("       (EXPERIMENTAL) Turn on compilation without polling for \"unsafe\" thread events. Default is false\n").append("\nJIT SETTINGS:\n").append("    jruby.jit.threshold=<invocation count>\n").append("       Set the JIT threshold to the specified method invocation count. Default is 20\n").append("    jruby.jit.logging=true|false\n").append("       Enable JIT logging (reports successful compilation). Default is false\n").append("    jruby.jit.logging.verbose=true|false\n").append("       Enable verbose JIT logging (reports failed compilation). Default is false\n").append("    jruby.launch.inproc=true|false\n").append("       Set in-process launching of e.g. system('ruby ...'). Default is true\n").append("\nNATIVE SUPPORT:\n").append("    jruby.native.enabled=true|false\n").append("       Enable/disable native extensions (like JNA for non-Java APIs; Default is true\n").append("       (This affects all JRuby instances in a given JVM)\n").append("    jruby.native.verbose=true|false\n").append("       Enable verbose logging of native extension loading. Default is false.\n").append("    jruby.fork.enabled=true|false\n").append("       (EXPERIMENTAL, maybe dangerous) Enable fork(2) on platforms that support it.\n").append("\nMISCELLANY:\n").append("    jruby.compat.version=RUBY1_8|RUBY1_9\n").append("       Specify the major Ruby version to be compatible with; Default is RUBY1_8\n").append("    jruby.indexed.methods=true|false\n").append("       Generate \"invokers\" for core classes using a single indexed class\n").append("    jruby.objectspace.enabled=true|false\n").append("       Enable or disable ObjectSpace.each_object (default is disabled)\n");
        return sb.toString();
    }

    public String getVersionString() {
        StringBuffer buf = new StringBuffer("ruby ");
        switch (this.compatVersion) {
            case RUBY1_8: {
                buf.append(Constants.RUBY_VERSION);
                break;
            }
            case RUBY1_9: {
                buf.append(Constants.RUBY1_9_VERSION);
            }
        }
        buf.append(" (").append(Constants.COMPILE_DATE + " rev " + Constants.REVISION).append(") [").append(SafePropertyAccessor.getProperty("os.arch", "unknown") + "-jruby" + Constants.VERSION).append("]").append("\n");
        return buf.toString();
    }

    public void processArguments(String[] arguments) {
        new ArgumentProcessor(arguments).processArguments();
    }

    public LoadServiceCreator getLoadServiceCreator() {
        return this.creator;
    }

    public void setLoadServiceCreator(LoadServiceCreator creator) {
        this.creator = creator;
    }

    public LoadService createLoadService(Ruby runtime) {
        return this.creator.create(runtime);
    }

    public CompileMode getCompileMode() {
        return this.compileMode;
    }

    public void setCompileMode(CompileMode compileMode) {
        this.compileMode = compileMode;
    }

    public boolean isJitLogging() {
        return this.jitLogging;
    }

    public boolean isJitLoggingVerbose() {
        return this.jitLoggingVerbose;
    }

    public boolean isSamplingEnabled() {
        return this.samplingEnabled;
    }

    public int getJitThreshold() {
        return this.jitThreshold;
    }

    public boolean isRunRubyInProcess() {
        return this.runRubyInProcess;
    }

    public void setRunRubyInProcess(boolean flag) {
        this.runRubyInProcess = flag;
    }

    public void setInput(InputStream newInput) {
        this.input = newInput;
    }

    public InputStream getInput() {
        return this.input;
    }

    public CompatVersion getCompatVersion() {
        return this.compatVersion;
    }

    public void setOutput(PrintStream newOutput) {
        this.output = newOutput;
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public void setError(PrintStream newError) {
        this.error = newError;
    }

    public PrintStream getError() {
        return this.error;
    }

    public void setCurrentDirectory(String newCurrentDirectory) {
        this.currentDirectory = newCurrentDirectory;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setProfile(Profile newProfile) {
        this.profile = newProfile;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setObjectSpaceEnabled(boolean newObjectSpaceEnabled) {
        this.objectSpaceEnabled = newObjectSpaceEnabled;
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    public void setEnvironment(Map newEnvironment) {
        this.environment = newEnvironment;
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public JRubyClassLoader getJRubyClassLoader() {
        return this.defaultJRubyClassLoader;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public String[] getArgv() {
        return this.argv;
    }

    public void setArgv(String[] argv) {
        this.argv = argv;
    }

    public byte[] inlineScript() {
        try {
            return this.inlineScript.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return this.inlineScript.toString().getBytes();
        }
    }

    public List<String> requiredLibraries() {
        return this.requiredLibraries;
    }

    public List<String> loadPaths() {
        return this.loadPaths;
    }

    public boolean shouldRunInterpreter() {
        if (this.isShowVersion() && (this.hasInlineScript || this.scriptFileName != null)) {
            return true;
        }
        return this.isShouldRunInterpreter();
    }

    public boolean shouldPrintUsage() {
        return this.shouldPrintUsage;
    }

    public boolean shouldPrintProperties() {
        return this.shouldPrintProperties;
    }

    private boolean isSourceFromStdin() {
        return this.getScriptFileName() == null;
    }

    public boolean isInlineScript() {
        return this.hasInlineScript;
    }

    public InputStream getScriptSource() {
        try {
            if (this.hasInlineScript) {
                if (this.scriptFileName != null) {
                    JRubyFile file = JRubyFile.create(this.getCurrentDirectory(), this.getScriptFileName());
                    return new FileInputStream(file);
                }
                return new ByteArrayInputStream(this.inlineScript());
            }
            if (this.isSourceFromStdin()) {
                if (this.isShowVersion()) {
                    return null;
                }
                return this.getInput();
            }
            JRubyFile file = JRubyFile.create(this.getCurrentDirectory(), this.getScriptFileName());
            return new FileInputStream(file);
        }
        catch (IOException e) {
            throw new MainExitException(1, "Error opening script file: " + e.getMessage());
        }
    }

    public String displayedFileName() {
        if (this.hasInlineScript) {
            if (this.scriptFileName != null) {
                return this.scriptFileName;
            }
            return "-e";
        }
        if (this.isSourceFromStdin()) {
            return "-";
        }
        return this.getScriptFileName();
    }

    private void setScriptFileName(String scriptFileName) {
        this.scriptFileName = scriptFileName;
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    public boolean isBenchmarking() {
        return this.benchmarking;
    }

    public boolean isAssumeLoop() {
        return this.assumeLoop;
    }

    public boolean isAssumePrinting() {
        return this.assumePrinting;
    }

    public boolean isProcessLineEnds() {
        return this.processLineEnds;
    }

    public boolean isSplit() {
        return this.split;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isShowVersion() {
        return this.showVersion;
    }

    protected void setShowVersion(boolean showVersion) {
        this.showVersion = showVersion;
    }

    public boolean isShouldRunInterpreter() {
        return this.shouldRunInterpreter;
    }

    public boolean isYARVEnabled() {
        return this.yarv;
    }

    public boolean isRubiniusEnabled() {
        return this.rubinius;
    }

    public boolean isYARVCompileEnabled() {
        return this.yarvCompile;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    static /* synthetic */ String[] access$202(RubyInstanceConfig x0, String[] x1) {
        x0.argv = x1;
        return x1;
    }

    static {
        try {
            if (System.getProperty("jruby.native.enabled") != null) {
                nativeEnabled = Boolean.getBoolean("jruby.native.enabled");
            }
        }
        catch (SecurityException se) {
            nativeEnabled = false;
        }
    }

    private class ArgumentProcessor {
        private String[] arguments;
        private int argumentIndex = 0;

        public ArgumentProcessor(String[] arguments) {
            this.arguments = arguments;
        }

        public void processArguments() {
            while (this.argumentIndex < this.arguments.length && this.isInterpreterArgument(this.arguments[this.argumentIndex])) {
                this.processArgument();
                ++this.argumentIndex;
            }
            if (!RubyInstanceConfig.this.hasInlineScript && this.argumentIndex < this.arguments.length) {
                RubyInstanceConfig.this.setScriptFileName(this.arguments[this.argumentIndex]);
                ++this.argumentIndex;
            }
            RubyInstanceConfig.access$202(RubyInstanceConfig.this, new String[this.arguments.length - this.argumentIndex]);
            System.arraycopy(this.arguments, this.argumentIndex, RubyInstanceConfig.this.argv, 0, RubyInstanceConfig.this.argv.length);
        }

        private boolean isInterpreterArgument(String argument) {
            return (argument.charAt(0) == '-' || argument.charAt(0) == '+') && !RubyInstanceConfig.this.endOfArguments;
        }

        private void processArgument() {
            String argument = this.arguments[this.argumentIndex];
            RubyInstanceConfig.this.characterIndex = 1;
            block22: while (RubyInstanceConfig.this.characterIndex < argument.length()) {
                switch (argument.charAt(RubyInstanceConfig.this.characterIndex)) {
                    case 'h': {
                        RubyInstanceConfig.this.shouldPrintUsage = true;
                        RubyInstanceConfig.this.shouldRunInterpreter = false;
                        break;
                    }
                    case 'I': {
                        String s = this.grabValue(" -I must be followed by a directory name to add to lib path");
                        String[] ls = s.split(File.pathSeparator);
                        for (int i = 0; i < ls.length; ++i) {
                            RubyInstanceConfig.this.loadPaths.add(ls[i]);
                        }
                        break block22;
                    }
                    case 'r': {
                        RubyInstanceConfig.this.requiredLibraries.add(this.grabValue("-r must be followed by a package to require"));
                        break block22;
                    }
                    case 'e': {
                        RubyInstanceConfig.this.inlineScript.append(this.grabValue(" -e must be followed by an expression to evaluate"));
                        RubyInstanceConfig.this.inlineScript.append('\n');
                        RubyInstanceConfig.this.hasInlineScript = true;
                        break block22;
                    }
                    case 'b': {
                        RubyInstanceConfig.this.benchmarking = true;
                        break;
                    }
                    case 'p': {
                        RubyInstanceConfig.this.assumePrinting = true;
                        RubyInstanceConfig.this.assumeLoop = true;
                        break;
                    }
                    case 'O': {
                        if (argument.charAt(0) == '-') {
                            RubyInstanceConfig.this.objectSpaceEnabled = false;
                            break;
                        }
                        if (argument.charAt(0) != '+') break;
                        RubyInstanceConfig.this.objectSpaceEnabled = true;
                        break;
                    }
                    case 'C': {
                        if (argument.charAt(0) == '-') {
                            RubyInstanceConfig.this.compileMode = CompileMode.OFF;
                            break;
                        }
                        if (argument.charAt(0) != '+') break;
                        RubyInstanceConfig.this.compileMode = CompileMode.FORCE;
                        break;
                    }
                    case 'y': {
                        RubyInstanceConfig.this.yarv = true;
                        break;
                    }
                    case 'Y': {
                        RubyInstanceConfig.this.yarvCompile = true;
                        break;
                    }
                    case 'R': {
                        RubyInstanceConfig.this.rubinius = true;
                        break;
                    }
                    case 'n': {
                        RubyInstanceConfig.this.assumeLoop = true;
                        break;
                    }
                    case 'a': {
                        RubyInstanceConfig.this.split = true;
                        break;
                    }
                    case 'd': {
                        RubyInstanceConfig.this.debug = true;
                        RubyInstanceConfig.this.verbose = true;
                        break;
                    }
                    case 'l': {
                        RubyInstanceConfig.this.processLineEnds = true;
                        break;
                    }
                    case 'v': {
                        RubyInstanceConfig.this.verbose = true;
                        RubyInstanceConfig.this.setShowVersion(true);
                        break;
                    }
                    case 'w': {
                        RubyInstanceConfig.this.verbose = true;
                        break;
                    }
                    case 'K': {
                        String eArg = this.grabValue("provide a value for -K");
                        RubyInstanceConfig.this.kcode = KCode.create(null, eArg);
                        break;
                    }
                    case 'S': {
                        this.runBinScript();
                        break block22;
                    }
                    case '-': {
                        if (argument.equals("--version")) {
                            RubyInstanceConfig.this.setShowVersion(true);
                            break block22;
                        }
                        if (argument.equals("--debug")) {
                            RubyInstanceConfig.this.debug = true;
                            RubyInstanceConfig.this.verbose = true;
                            break;
                        }
                        if (argument.equals("--help")) {
                            RubyInstanceConfig.this.shouldPrintUsage = true;
                            RubyInstanceConfig.this.shouldRunInterpreter = false;
                            break;
                        }
                        if (argument.equals("--command") || argument.equals("--bin")) {
                            RubyInstanceConfig.this.characterIndex = argument.length();
                            this.runBinScript();
                            break;
                        }
                        if (argument.equals("--compat")) {
                            RubyInstanceConfig.this.characterIndex = argument.length();
                            RubyInstanceConfig.this.compatVersion = CompatVersion.getVersionFromString(this.grabValue("--compat must be RUBY1_8 or RUBY1_9"));
                            if (RubyInstanceConfig.this.compatVersion != null) break block22;
                            RubyInstanceConfig.this.compatVersion = CompatVersion.RUBY1_8;
                            break block22;
                        }
                        if (argument.equals("--properties")) {
                            RubyInstanceConfig.this.shouldPrintProperties = true;
                            RubyInstanceConfig.this.shouldRunInterpreter = false;
                            break;
                        }
                        if (argument.equals("--")) {
                            RubyInstanceConfig.this.endOfArguments = true;
                            break;
                        }
                    }
                    default: {
                        throw new MainExitException(1, "unknown option " + argument.charAt(RubyInstanceConfig.this.characterIndex));
                    }
                }
                ++RubyInstanceConfig.this.characterIndex;
            }
        }

        private void runBinScript() {
            RubyInstanceConfig.this.requiredLibraries.add("jruby/commands");
            RubyInstanceConfig.this.inlineScript.append("JRuby::Commands." + this.grabValue("provide a bin script to execute"));
            RubyInstanceConfig.this.inlineScript.append("\n");
            RubyInstanceConfig.this.hasInlineScript = true;
            RubyInstanceConfig.this.endOfArguments = true;
        }

        private String grabValue(String errorMessage) {
            ++RubyInstanceConfig.this.characterIndex;
            if (RubyInstanceConfig.this.characterIndex < this.arguments[this.argumentIndex].length()) {
                return this.arguments[this.argumentIndex].substring(RubyInstanceConfig.this.characterIndex);
            }
            ++this.argumentIndex;
            if (this.argumentIndex < this.arguments.length) {
                return this.arguments[this.argumentIndex];
            }
            MainExitException mee = new MainExitException(1, "invalid argument " + this.argumentIndex + "\n" + errorMessage);
            mee.setUsageError(true);
            throw mee;
        }
    }

    public static interface LoadServiceCreator {
        public static final LoadServiceCreator DEFAULT = new LoadServiceCreator(){

            public LoadService create(Ruby runtime) {
                return new LoadService(runtime);
            }
        };

        public LoadService create(Ruby var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompileMode {
        JIT,
        FORCE,
        OFF;


        public boolean shouldPrecompileCLI() {
            switch (this) {
                case JIT: 
                case FORCE: {
                    return true;
                }
            }
            return false;
        }

        public boolean shouldJIT() {
            switch (this) {
                case JIT: 
                case FORCE: {
                    return true;
                }
            }
            return false;
        }

        public boolean shouldPrecompileAll() {
            return this == FORCE;
        }
    }
}

