/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Convert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyFixnum
extends RubyInteger {
    private final long value;
    private static final int BIT_SIZE = 64;
    public static final long SIGN_BIT = Long.MIN_VALUE;
    public static final long MAX = Long.MAX_VALUE;
    public static final long MIN = Long.MIN_VALUE;
    public static final long MAX_MARSHAL_FIXNUM = 0x3FFFFFFFL;
    public static final long MIN_MARSHAL_FIXNUM = -1073741824L;

    public static RubyClass createFixnumClass(Ruby runtime) {
        RubyClass fixnum = runtime.defineClass("Fixnum", runtime.getInteger(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setFixnum(fixnum);
        fixnum.index = 1;
        fixnum.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyFixnum;
            }
        };
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyFixnum.class);
        fixnum.includeModule(runtime.getPrecision());
        fixnum.defineAnnotatedMethods(RubyFixnum.class);
        fixnum.dispatcher = callbackFactory.createDispatcher(fixnum);
        for (int i = 0; i < runtime.fixnumCache.length; ++i) {
            runtime.fixnumCache[i] = new RubyFixnum(runtime, fixnum, i - 128);
        }
        return fixnum;
    }

    public RubyFixnum(Ruby runtime) {
        this(runtime, 0L);
    }

    public RubyFixnum(Ruby runtime, long value) {
        super(runtime, runtime.getFixnum(), false);
        this.value = value;
    }

    private RubyFixnum(Ruby runtime, RubyClass klazz, long value) {
        super(runtime, klazz, false);
        this.value = value;
    }

    @Override
    public int getNativeTypeIndex() {
        return 1;
    }

    public final boolean eql(IRubyObject other) {
        return other instanceof RubyFixnum && this.value == ((RubyFixnum)other).value;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    @Override
    public Class<?> getJavaClass() {
        return Long.TYPE;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    public static RubyFixnum newFixnum(Ruby runtime, long value) {
        int offset = 128;
        if (value <= 127L && value >= -128L) {
            return runtime.fixnumCache[(int)value + 128];
        }
        return new RubyFixnum(runtime, value);
    }

    public RubyFixnum newFixnum(long newValue) {
        return RubyFixnum.newFixnum(this.getRuntime(), newValue);
    }

    public static RubyFixnum zero(Ruby runtime) {
        return RubyFixnum.newFixnum(runtime, 0L);
    }

    public static RubyFixnum one(Ruby runtime) {
        return RubyFixnum.newFixnum(runtime, 1L);
    }

    public static RubyFixnum minus_one(Ruby runtime) {
        return RubyFixnum.newFixnum(runtime, -1L);
    }

    @Override
    public RubyFixnum hash() {
        return this.newFixnum(this.hashCode());
    }

    @Override
    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RubyFixnum) {
            RubyFixnum num = (RubyFixnum)other;
            if (num.value == this.value) {
                return true;
            }
        }
        return false;
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public RubyString to_s(IRubyObject[] args) {
        int base;
        int n = base = args.length == 0 ? 10 : RubyFixnum.num2int(args[0]);
        if (base < 2 || base > 36) {
            throw this.getRuntime().newArgumentError("illegal radix " + base);
        }
        return this.getRuntime().newString(Convert.longToByteList(this.value, base));
    }

    @JRubyMethod(name={"id2name"})
    public IRubyObject id2name() {
        RubySymbol symbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        if (symbol != null) {
            return this.getRuntime().newString(symbol.asJavaString());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"to_sym"})
    public IRubyObject to_sym() {
        RubySymbol symbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        return symbol != null ? symbol : this.getRuntime().getNil();
    }

    @Override
    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        if (this.value == Long.MIN_VALUE) {
            return RubyBignum.newBignum(this.getRuntime(), BigInteger.valueOf(this.value).negate());
        }
        return RubyFixnum.newFixnum(this.getRuntime(), -this.value);
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long otherValue = ((RubyFixnum)other).value;
            long result = this.value + otherValue;
            if (((this.value ^ otherValue ^ 0xFFFFFFFFFFFFFFFFL) & (this.value ^ result) & Long.MIN_VALUE) != 0L) {
                return RubyBignum.newBignum(this.getRuntime(), this.value).op_plus(other);
            }
            return this.newFixnum(result);
        }
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_plus(this);
        }
        if (other instanceof RubyFloat) {
            return this.getRuntime().newFloat((double)this.value + ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin("+", other);
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long otherValue = ((RubyFixnum)other).value;
            long result = this.value - otherValue;
            if (((this.value ^ (otherValue ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL) & (this.value ^ result) & Long.MIN_VALUE) != 0L) {
                return RubyBignum.newBignum(this.getRuntime(), this.value).op_minus(other);
            }
            return this.newFixnum(result);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_minus(other);
        }
        if (other instanceof RubyFloat) {
            return this.getRuntime().newFloat((double)this.value - ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin("-", other);
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long otherValue = ((RubyFixnum)other).value;
            if (this.value == 0L) {
                return RubyFixnum.zero(this.getRuntime());
            }
            long result = this.value * otherValue;
            RubyFixnum r = RubyFixnum.newFixnum(this.getRuntime(), result);
            if (RubyNumeric.fix2long(r) != result || result / this.value != otherValue) {
                return (RubyNumeric)RubyBignum.newBignum(this.getRuntime(), this.value).op_mul(other);
            }
            return r;
        }
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_mul(this);
        }
        if (other instanceof RubyFloat) {
            return this.getRuntime().newFloat((double)this.value * ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin("*", other);
    }

    @JRubyMethod(name={"div"}, required=1)
    public IRubyObject div_div(IRubyObject other) {
        return this.idiv(other, "div");
    }

    @JRubyMethod(name={"/"}, required=1)
    public IRubyObject op_div(IRubyObject other) {
        return this.idiv(other, "/");
    }

    public IRubyObject idiv(IRubyObject other, String method) {
        if (other instanceof RubyFixnum) {
            long x = this.value;
            long y = ((RubyFixnum)other).value;
            if (y == 0L) {
                throw this.getRuntime().newZeroDivisionError();
            }
            long div = x / y;
            long mod = x % y;
            if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
                --div;
            }
            return this.getRuntime().newFixnum(div);
        }
        return this.coerceBin(method, other);
    }

    @JRubyMethod(name={"%", "modulo"}, required=1)
    public IRubyObject op_mod(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long x = this.value;
            long y = ((RubyFixnum)other).value;
            if (y == 0L) {
                throw this.getRuntime().newZeroDivisionError();
            }
            long mod = x % y;
            if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
                mod += y;
            }
            return this.getRuntime().newFixnum(mod);
        }
        return this.coerceBin("%", other);
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long x = this.value;
            long y = ((RubyFixnum)other).value;
            Ruby runtime = this.getRuntime();
            if (y == 0L) {
                throw runtime.newZeroDivisionError();
            }
            long div = x / y;
            long mod = x % y;
            if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
                --div;
                mod += y;
            }
            RubyFixnum fixDiv = RubyFixnum.newFixnum(this.getRuntime(), div);
            RubyFixnum fixMod = RubyFixnum.newFixnum(this.getRuntime(), mod);
            return RubyArray.newArray(runtime, fixDiv, fixMod);
        }
        return this.coerceBin("divmod", other);
    }

    @Override
    @JRubyMethod(name={"quo"}, required=1)
    public IRubyObject quo(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyFloat.newFloat(this.getRuntime(), (double)this.value / (double)((RubyFixnum)other).value);
        }
        return this.coerceBin("quo", other);
    }

    @JRubyMethod(name={"**"}, required=1)
    public IRubyObject op_pow(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long b = ((RubyFixnum)other).value;
            if (b == 0L) {
                return RubyFixnum.one(this.getRuntime());
            }
            if (b == 1L) {
                return this;
            }
            if (b > 0L) {
                return RubyBignum.newBignum(this.getRuntime(), this.value).op_pow(other);
            }
            return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.value, b));
        }
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.value, ((RubyFloat)other).getDoubleValue()));
        }
        return this.coerceBin("**", other);
    }

    @Override
    @JRubyMethod(name={"abs"})
    public IRubyObject abs() {
        if (this.value < 0L) {
            return RubyFixnum.newFixnum(this.getRuntime(), -this.value);
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value == ((RubyFixnum)other).value);
        }
        return super.op_equal(other);
    }

    @Override
    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long otherValue = ((RubyFixnum)other).value;
            if (this.value == otherValue) {
                return RubyFixnum.zero(this.getRuntime());
            }
            if (this.value > otherValue) {
                return RubyFixnum.one(this.getRuntime());
            }
            return RubyFixnum.minus_one(this.getRuntime());
        }
        return this.coerceCmp("<=>", other);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value > ((RubyFixnum)other).value);
        }
        return this.coerceRelOp(">", other);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value >= ((RubyFixnum)other).value);
        }
        return this.coerceRelOp(">=", other);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value < ((RubyFixnum)other).value);
        }
        return this.coerceRelOp("<", other);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value <= ((RubyFixnum)other).value);
        }
        return this.coerceRelOp("<=", other);
    }

    @JRubyMethod(name={"~"})
    public IRubyObject op_neg() {
        return this.newFixnum(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @JRubyMethod(name={"&"}, required=1)
    public IRubyObject op_and(IRubyObject other) {
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_and(this);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.value & RubyFixnum.num2long(other));
    }

    @JRubyMethod(name={"|"}, required=1)
    public IRubyObject op_or(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.newFixnum(this.value | ((RubyFixnum)other).value);
        }
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_or(this);
        }
        if (other instanceof RubyNumeric) {
            return this.newFixnum(this.value | ((RubyNumeric)other).getLongValue());
        }
        return this.op_or(RubyFixnum.newFixnum(this.getRuntime(), RubyFixnum.num2long(other)));
    }

    @JRubyMethod(name={"^"}, required=1)
    public IRubyObject op_xor(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.newFixnum(this.value ^ ((RubyFixnum)other).value);
        }
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_xor(this);
        }
        if (other instanceof RubyNumeric) {
            return this.newFixnum(this.value ^ ((RubyNumeric)other).getLongValue());
        }
        return this.op_xor(RubyFixnum.newFixnum(this.getRuntime(), RubyFixnum.num2long(other)));
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(IRubyObject other) {
        long l;
        if (other instanceof RubyBignum) {
            RubyBignum big = (RubyBignum)other;
            RubyInteger tryFix = RubyBignum.bignorm(this.getRuntime(), big.getValue());
            if (!(tryFix instanceof RubyFixnum)) {
                if (big.getValue().signum() == 0 || this.value >= 0L) {
                    return RubyFixnum.zero(this.getRuntime());
                }
                return RubyFixnum.one(this.getRuntime());
            }
        }
        if ((l = RubyFixnum.num2long(other)) < 0L) {
            return RubyFixnum.zero(this.getRuntime());
        }
        if (63L < l) {
            if (this.value < 0L) {
                return RubyFixnum.one(this.getRuntime());
            }
            return RubyFixnum.zero(this.getRuntime());
        }
        return (this.value & 1L << (int)l) == 0L ? RubyFixnum.zero(this.getRuntime()) : RubyFixnum.one(this.getRuntime());
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject op_lshift(IRubyObject other) {
        long width = RubyFixnum.num2long(other);
        if (width < 0L) {
            return this.op_rshift(RubyFixnum.newFixnum(this.getRuntime(), -width));
        }
        if (width == 0L) {
            return this;
        }
        if (width > 63L || (-1L << (int)(64L - width - 1L) & this.value) != 0L) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_lshift(other);
        }
        return this.newFixnum(this.value << (int)width);
    }

    @JRubyMethod(name={">>"}, required=1)
    public IRubyObject op_rshift(IRubyObject other) {
        long width = RubyFixnum.num2long(other);
        if (width < 0L) {
            return this.op_lshift(RubyFixnum.newFixnum(this.getRuntime(), -width));
        }
        if (width == 0L) {
            return this;
        }
        if (width >= 63L) {
            if (this.value < 0L) {
                return RubyFixnum.minus_one(this.getRuntime());
            }
            return RubyFixnum.zero(this.getRuntime());
        }
        return this.newFixnum(this.value >> (int)width);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.value);
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size() {
        return this.newFixnum(8L);
    }

    @Override
    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.value == 0L);
    }

    @Override
    @JRubyMethod(name={"id"})
    public IRubyObject id() {
        if (this.value <= 0x3FFFFFFFFFFFFFFFL && this.value >= -4611686018427387904L) {
            return this.newFixnum(2L * this.value + 1L);
        }
        return super.id();
    }

    @Override
    public IRubyObject taint() {
        return this;
    }

    @Override
    public IRubyObject freeze() {
        return this;
    }

    @Override
    public String asJavaString() {
        this.getRuntime().getWarnings().warn("do not use Fixnums as Symbols");
        RubySymbol symbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        if (symbol == null) {
            throw this.getRuntime().newArgumentError("" + this.value + " is not a symbol");
        }
        return symbol.asJavaString();
    }

    public static RubyFixnum unmarshalFrom(UnmarshalStream input) throws IOException {
        return input.getRuntime().newFixnum(input.unmarshalInt());
    }

    @JRubyMethod(name={"induced_from"}, required=1, meta=true)
    public static IRubyObject induced_from(IRubyObject recv, IRubyObject other) {
        return RubyNumeric.num2fix(other);
    }
}

